/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestVisibilityWithCheckAuths {
    private static final String TOPSECRET = "TOPSECRET";
    private static final String PUBLIC = "PUBLIC";
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] fam = Bytes.toBytes((String)"info");
    private static final byte[] qual = Bytes.toBytes((String)"qual");
    private static final byte[] value = Bytes.toBytes((String)"value");
    public static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;
    public static User USER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.setBoolean("hbase.security.visibility.mutations.checkauths", true);
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(2);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER = User.createUserForTesting((Configuration)conf, (String)"user", (String[])new String[0]);
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestVisibilityWithCheckAuths.addLabels();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public static void addLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestVisibilityWithCheckAuths.TOPSECRET};
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityClient.addLabels((Connection)conn, (String[])labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    @Test
    public void testVerifyAccessDeniedForInvalidUserAuths() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setAuths((Connection)conn, (String[])new String[]{TestVisibilityWithCheckAuths.TOPSECRET}, (String)USER.getShortName());
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable6) {
                    return null;
                }
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        Admin hBaseAdmin = TEST_UTIL.getAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable((TableDescriptor)desc);
        try {
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Put p = new Put(row1);
                        p.setCellVisibility(new CellVisibility("PUBLIC&TOPSECRET"));
                        p.addColumn(fam, qual, 125L, value);
                        table.put(p);
                        Assert.fail((String)"Testcase should fail with AccesDeniedException");
                    }
                    catch (Throwable t) {
                        Assert.assertTrue((boolean)t.getMessage().contains("AccessDeniedException"));
                    }
                    return null;
                }
            };
            USER.runAs((PrivilegedExceptionAction)actiona);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Test
    public void testLabelsWithAppend() throws Throwable {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setAuths((Connection)conn, (String[])new String[]{TestVisibilityWithCheckAuths.TOPSECRET}, (String)USER.getShortName());
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable6) {
                    return null;
                }
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TEST_UTIL.createTable(tableName, fam);){
            final byte[] row1 = Bytes.toBytes((String)"row1");
            final byte[] val = Bytes.toBytes((String)"a");
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Put put = new Put(row1);
                        put.addColumn(fam, qual, Long.MAX_VALUE, val);
                        put.setCellVisibility(new CellVisibility(TestVisibilityWithCheckAuths.TOPSECRET));
                        table.put(put);
                    }
                    return null;
                }
            };
            USER.runAs((PrivilegedExceptionAction)actiona);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Append append = new Append(row1);
                        append.addColumn(fam, qual, Bytes.toBytes((String)"b"));
                        table.append(append);
                    }
                    return null;
                }
            };
            USER.runAs((PrivilegedExceptionAction)actiona);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Append append = new Append(row1);
                        append.addColumn(fam, qual, Bytes.toBytes((String)"c"));
                        append.setCellVisibility(new CellVisibility(TestVisibilityWithCheckAuths.PUBLIC));
                        table.append(append);
                        Assert.fail((String)"Testcase should fail with AccesDeniedException");
                    }
                    catch (Throwable t) {
                        Assert.assertTrue((boolean)t.getMessage().contains("AccessDeniedException"));
                    }
                    return null;
                }
            };
            USER.runAs((PrivilegedExceptionAction)actiona);
        }
    }
}

