/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestByteBuffUtils {
    @Test
    public void testCopyAndCompare() throws Exception {
        ByteBuffer bb1 = ByteBuffer.allocate(50);
        ByteBuffer bb2 = ByteBuffer.allocate(50);
        MultiByteBuff src = new MultiByteBuff(new ByteBuffer[]{bb1, bb2});
        for (int i = 0; i < 7; ++i) {
            src.putLong(8L);
        }
        src.put((byte)1);
        src.put((byte)1);
        ByteBuffer bb3 = ByteBuffer.allocate(50);
        ByteBuffer bb4 = ByteBuffer.allocate(50);
        MultiByteBuff mbbDst = new MultiByteBuff(new ByteBuffer[]{bb3, bb4});
        mbbDst.put(0, (ByteBuff)src, 0, 100);
        int compareTo = ByteBuff.compareTo((ByteBuff)src, (int)0, (int)100, (ByteBuff)mbbDst, (int)0, (int)100);
        Assert.assertTrue((compareTo == 0 ? 1 : 0) != 0);
        bb3 = ByteBuffer.allocate(100);
        SingleByteBuff sbbDst = new SingleByteBuff(bb3);
        src.rewind();
        sbbDst.put(0, (ByteBuff)src, 0, 100);
        compareTo = ByteBuff.compareTo((ByteBuff)src, (int)0, (int)100, (ByteBuff)sbbDst, (int)0, (int)100);
        Assert.assertTrue((compareTo == 0 ? 1 : 0) != 0);
        bb3 = ByteBuffer.allocate(100);
        SingleByteBuff sbb = new SingleByteBuff(bb3);
        for (int i = 0; i < 7; ++i) {
            sbb.putLong(8L);
        }
        sbb.put((byte)1);
        sbb.put((byte)1);
        bb4 = ByteBuffer.allocate(100);
        sbbDst = new SingleByteBuff(bb4);
        sbbDst.put(0, (ByteBuff)sbb, 0, 100);
        compareTo = ByteBuff.compareTo((ByteBuff)sbb, (int)0, (int)100, (ByteBuff)sbbDst, (int)0, (int)100);
        Assert.assertTrue((compareTo == 0 ? 1 : 0) != 0);
        sbb.rewind();
        mbbDst = new MultiByteBuff(new ByteBuffer[]{bb3, bb4});
        mbbDst.rewind();
        mbbDst.put(0, (ByteBuff)sbb, 0, 100);
        compareTo = ByteBuff.compareTo((ByteBuff)sbb, (int)0, (int)100, (ByteBuff)mbbDst, (int)0, (int)100);
        Assert.assertTrue((compareTo == 0 ? 1 : 0) != 0);
    }
}

