/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.JSONMetricUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestJSONMetricUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TestJSONMetricUtil.class);

    @Test
    public void testBuildHashtable() {
        String[] keys = new String[]{"type", "name"};
        String[] emptyKey = new String[]{};
        String[] values = new String[]{"MemoryPool", "Par Eden Space"};
        String[] values2 = new String[]{"MemoryPool", "Par Eden Space", "Test"};
        String[] emptyValue = new String[]{};
        Hashtable properties = JSONMetricUtil.buldKeyValueTable((String[])keys, (String[])values);
        Assert.assertEquals((Object)values[0], properties.get("type"));
        Assert.assertEquals((Object)values[1], properties.get("name"));
        Assert.assertNull((Object)JSONMetricUtil.buldKeyValueTable((String[])keys, (String[])values2));
        Assert.assertNull((Object)JSONMetricUtil.buldKeyValueTable((String[])keys, (String[])emptyValue));
        Assert.assertNull((Object)JSONMetricUtil.buldKeyValueTable((String[])emptyKey, (String[])values2));
        Assert.assertNull((Object)JSONMetricUtil.buldKeyValueTable((String[])emptyKey, (String[])emptyValue));
    }

    @Test
    public void testSearchJson() throws JsonProcessingException, IOException {
        String jsonString = "{\"test\":[{\"data1\":100,\"data2\":\"hello\",\"data3\": [1 , 2 , 3]}, {\"data4\":0}]}";
        JsonNode node = JSONMetricUtil.mappStringToJsonNode((String)jsonString);
        JsonNode r1 = JSONMetricUtil.searchJson((JsonNode)node, (String)"data1");
        JsonNode r2 = JSONMetricUtil.searchJson((JsonNode)node, (String)"data2");
        JsonNode r3 = JSONMetricUtil.searchJson((JsonNode)node, (String)"data3");
        JsonNode r4 = JSONMetricUtil.searchJson((JsonNode)node, (String)"data4");
        Assert.assertEquals((long)100L, (long)r1.intValue());
        Assert.assertEquals((Object)"hello", (Object)r2.textValue());
        Assert.assertEquals((long)1L, (long)r3.get(0).intValue());
        Assert.assertEquals((long)0L, (long)r4.intValue());
    }

    @Test
    public void testBuildObjectName() throws MalformedObjectNameException {
        String[] keys = new String[]{"type", "name"};
        String[] values = new String[]{"MemoryPool", "Par Eden Space"};
        Hashtable properties = JSONMetricUtil.buldKeyValueTable((String[])keys, (String[])values);
        ObjectName testObject = JSONMetricUtil.buildObjectName((String)"java.lang", (Hashtable)properties);
        Assert.assertEquals((Object)testObject.getDomain(), (Object)"java.lang");
        Assert.assertEquals(testObject.getKeyPropertyList(), (Object)properties);
    }

    @Test
    public void testGetLastGCInfo() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean bean : gcBeans) {
            ObjectName on = bean.getObjectName();
            Object value = JSONMetricUtil.getValueFromMBean((ObjectName)on, (String)"LastGcInfo");
            LOG.info("Collector Info: " + value);
            if (value == null || !(value instanceof CompositeData)) continue;
            CompositeData cds = (CompositeData)value;
            Assert.assertNotNull((Object)cds.get("duration"));
        }
    }
}

