/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.TestMiniClusterLoadSequential;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MiscTests.class, LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestMiniClusterLoadParallel
extends TestMiniClusterLoadSequential {
    public TestMiniClusterLoadParallel(boolean isMultiPut, DataBlockEncoding encoding) {
        super(isMultiPut, encoding);
    }

    @Override
    @Test(timeout=180000L)
    public void loadTest() throws Exception {
        this.prepareForLoadTest();
        this.readerThreads.linkToWriter(this.writerThreads);
        this.writerThreads.start(0L, this.numKeys, 8);
        this.readerThreads.start(0L, this.numKeys, 8);
        this.writerThreads.waitForFinish();
        this.readerThreads.waitForFinish();
        Assert.assertEquals((long)0L, (long)this.writerThreads.getNumWriteFailures());
        Assert.assertEquals((long)0L, (long)this.readerThreads.getNumReadFailures());
        Assert.assertEquals((long)0L, (long)this.readerThreads.getNumReadErrors());
        Assert.assertEquals((long)this.numKeys, (long)this.readerThreads.getNumUniqueKeysVerified());
    }
}

