/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.SortedList;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestSortedList {
    @Test
    public void testSorting() throws Exception {
        SortedList list = new SortedList((Comparator)new StringComparator());
        list.add((Object)"c");
        list.add((Object)"d");
        list.add((Object)"a");
        list.add((Object)"b");
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])list.toArray((Object[])new String[4]));
        list.add((Object)"c");
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "c", "d"}, (Object[])list.toArray((Object[])new String[5]));
        list.remove((Object)"b");
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertArrayEquals((Object[])new String[]{"a", "c", "c", "d"}, (Object[])list.toArray((Object[])new String[4]));
        list.remove((Object)"c");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertArrayEquals((Object[])new String[]{"a", "c", "d"}, (Object[])list.toArray((Object[])new String[3]));
        list.remove((Object)"a");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertArrayEquals((Object[])new String[]{"c", "d"}, (Object[])list.toArray((Object[])new String[2]));
    }

    @Test
    public void testReadOnlyIterators() throws Exception {
        SortedList list = new SortedList((Collection)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"}), (Comparator)new StringComparator());
        Iterator i = list.iterator();
        i.next();
        try {
            i.remove();
            Assert.fail((String)"Iterator should have thrown an exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ListIterator li = list.listIterator();
        li.next();
        try {
            li.add("a");
            Assert.fail((String)"Iterator should have thrown an exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            li.set("b");
            Assert.fail((String)"Iterator should have thrown an exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            li.remove();
            Assert.fail((String)"Iterator should have thrown an exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testIteratorIsolation() throws Exception {
        String next;
        SortedList list = new SortedList((Collection)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"}), (Comparator)new StringComparator());
        Iterator iter = list.iterator();
        list.remove((Object)"c");
        boolean found = false;
        while (iter.hasNext() && !found) {
            found = "c".equals(iter.next());
        }
        Assert.assertTrue((boolean)found);
        iter = list.iterator();
        found = false;
        while (iter.hasNext() && !found) {
            found = "c".equals(iter.next());
        }
        Assert.assertFalse((boolean)found);
        iter = list.iterator();
        list.add((Object)"f");
        found = false;
        while (iter.hasNext() && !found) {
            next = (String)iter.next();
            found = "f".equals(next);
        }
        Assert.assertFalse((boolean)found);
        iter = list.iterator();
        list.addAll((Collection)Lists.newArrayList((Object[])new String[]{"g", "h", "i"}));
        found = false;
        while (iter.hasNext() && !found) {
            next = (String)iter.next();
            found = "g".equals(next) || "h".equals(next) || "i".equals(next);
        }
        Assert.assertFalse((boolean)found);
        iter = list.iterator();
        list.clear();
        Assert.assertEquals((long)0L, (long)list.size());
        int size = 0;
        while (iter.hasNext()) {
            iter.next();
            ++size;
        }
        Assert.assertTrue((size > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRandomAccessIsolation() throws Exception {
        SortedList list = new SortedList((Collection)Lists.newArrayList((Object[])new String[]{"a", "b", "c"}), (Comparator)new StringComparator());
        List innerList = list.get();
        Assert.assertEquals((Object)"a", innerList.get(0));
        Assert.assertEquals((Object)"b", innerList.get(1));
        list.clear();
        Assert.assertEquals((Object)"c", innerList.get(2));
    }

    static class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }
}

