/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.RegionGroupingProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALPerformanceEvaluation;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, LargeTests.class})
public class TestBoundedRegionGroupingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TestBoundedRegionGroupingStrategy.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration CONF;
    private static DistributedFileSystem FS;
    @Parameterized.Parameter
    public String walProvider;

    @Parameterized.Parameters(name="{index}: delegate-provider={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"defaultProvider"}, {"asyncfs"});
    }

    @Before
    public void setUp() throws Exception {
        CONF.set("hbase.wal.regiongrouping.delegate.provider", this.walProvider);
    }

    @After
    public void tearDown() throws Exception {
        FileStatus[] entries;
        for (FileStatus dir : entries = FS.listStatus(new Path("/"))) {
            FS.delete(dir.getPath(), true);
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CONF = TEST_UTIL.getConfiguration();
        CONF.setInt("dfs.blocksize", 0x100000);
        CONF.setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        CONF.setInt("dfs.heartbeat.interval", 1);
        CONF.setInt("dfs.client.socket-timeout", 5000);
        CONF.setInt("hbase.ipc.client.connect.max.retries", 1);
        CONF.setInt("dfs.client.block.recovery.retries", 1);
        CONF.setInt("hbase.ipc.client.connection.maxidletime", 500);
        CONF.setClass("hbase.wal.provider", RegionGroupingProvider.class, WALProvider.class);
        CONF.set("hbase.wal.regiongrouping.strategy", RegionGroupingProvider.Strategies.bounded.name());
        TEST_UTIL.startMiniDFSCluster(3);
        FS = TEST_UTIL.getDFSCluster().getFileSystem();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testConcurrentWrites() throws Exception {
        int errCode = WALPerformanceEvaluation.innerMain(new Configuration(CONF), new String[]{"-threads", "3", "-verify", "-noclosefs", "-iterations", "3000"});
        Assert.assertEquals((long)0L, (long)errCode);
    }

    @Test
    public void testMoreRegionsThanBound() throws Exception {
        String parallelism = Integer.toString(4);
        int errCode = WALPerformanceEvaluation.innerMain(new Configuration(CONF), new String[]{"-threads", parallelism, "-verify", "-noclosefs", "-iterations", "3000", "-regions", parallelism});
        Assert.assertEquals((long)0L, (long)errCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBoundsGreaterThanDefault() throws Exception {
        int temp = CONF.getInt("hbase.wal.regiongrouping.numgroups", 2);
        try {
            CONF.setInt("hbase.wal.regiongrouping.numgroups", temp * 4);
            String parallelism = Integer.toString(temp * 4);
            int errCode = WALPerformanceEvaluation.innerMain(new Configuration(CONF), new String[]{"-threads", parallelism, "-verify", "-noclosefs", "-iterations", "3000", "-regions", parallelism});
            Assert.assertEquals((long)0L, (long)errCode);
        }
        finally {
            CONF.setInt("hbase.wal.regiongrouping.numgroups", temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoreRegionsThanBoundWithBoundsGreaterThanDefault() throws Exception {
        int temp = CONF.getInt("hbase.wal.regiongrouping.numgroups", 2);
        try {
            CONF.setInt("hbase.wal.regiongrouping.numgroups", temp * 4);
            String parallelism = Integer.toString(temp * 4 * 2);
            int errCode = WALPerformanceEvaluation.innerMain(new Configuration(CONF), new String[]{"-threads", parallelism, "-verify", "-noclosefs", "-iterations", "3000", "-regions", parallelism});
            Assert.assertEquals((long)0L, (long)errCode);
        }
        finally {
            CONF.setInt("hbase.wal.regiongrouping.numgroups", temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setMembershipDedups() throws IOException {
        int temp = CONF.getInt("hbase.wal.regiongrouping.numgroups", 2);
        WALFactory wals = null;
        try {
            CONF.setInt("hbase.wal.regiongrouping.numgroups", temp * 4);
            FSUtils.setRootDir((Configuration)CONF, (Path)TEST_UTIL.getDataTestDirOnTestFS());
            wals = new WALFactory(CONF, null, "setMembershipDedups");
            HashSet<WAL> seen = new HashSet<WAL>(temp * 4);
            int count = 0;
            for (int i = 0; i < temp * 8; ++i) {
                WAL maybeNewWAL = wals.getWAL(RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)("Table-" + ThreadLocalRandom.current().nextInt()))).build());
                LOG.info("Iteration " + i + ", checking wal " + maybeNewWAL);
                if (!seen.add(maybeNewWAL)) continue;
                ++count;
            }
            Assert.assertEquals((String)"received back a different number of WALs that are not equal() to each other than the bound we placed.", (long)(temp * 4), (long)count);
        }
        finally {
            if (wals != null) {
                wals.close();
            }
            CONF.setInt("hbase.wal.regiongrouping.numgroups", temp);
        }
    }
}

