/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestWALRootDir {
    private static final Logger LOG = LoggerFactory.getLogger(TestWALRootDir.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static FileSystem fs;
    private static FileSystem walFs;
    private static final TableName tableName;
    private static final byte[] rowName;
    private static final byte[] family;
    private static Path walRootDir;
    private static Path rootDir;
    private static WALFactory wals;

    @Before
    public void setUp() throws Exception {
        TestWALRootDir.cleanup();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniDFSCluster(1);
        rootDir = TEST_UTIL.createRootDir();
        walRootDir = TEST_UTIL.createWALRootDir();
        fs = FSUtils.getRootDirFileSystem((Configuration)conf);
        walFs = FSUtils.getWALFileSystem((Configuration)conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestWALRootDir.cleanup();
        TEST_UTIL.shutdownMiniDFSCluster();
    }

    @Test
    public void testWALRootDir() throws Exception {
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        wals = new WALFactory(conf, null, "testWALRootDir");
        WAL log = wals.getWAL(regionInfo);
        Assert.assertEquals((long)1L, (long)this.getWALFiles(walFs, walRootDir).size());
        byte[] value = Bytes.toBytes((String)"value");
        WALEdit edit = new WALEdit();
        edit.add((Cell)new KeyValue(rowName, family, Bytes.toBytes((String)"1"), System.currentTimeMillis(), value));
        long txid = log.append(regionInfo, this.getWalKey(System.currentTimeMillis(), regionInfo, 0L), edit, true);
        log.sync(txid);
        Assert.assertEquals((String)"Expect 1 log have been created", (long)1L, (long)this.getWALFiles(walFs, walRootDir).size());
        log.rollWriter();
        Assert.assertEquals((long)2L, (long)this.getWALFiles(walFs, new Path(walRootDir, "WALs")).size());
        edit.add((Cell)new KeyValue(rowName, family, Bytes.toBytes((String)"2"), System.currentTimeMillis(), value));
        txid = log.append(regionInfo, this.getWalKey(System.currentTimeMillis(), regionInfo, 1L), edit, true);
        log.sync(txid);
        log.rollWriter();
        log.shutdown();
        Assert.assertEquals((String)"Expect 3 logs in WALs dir", (long)3L, (long)this.getWALFiles(walFs, new Path(walRootDir, "WALs")).size());
    }

    private WALKeyImpl getWalKey(long time, RegionInfo hri, long startPoint) {
        return new WALKeyImpl(hri.getEncodedNameAsBytes(), tableName, time, new MultiVersionConcurrencyControl(startPoint));
    }

    private List<FileStatus> getWALFiles(FileSystem fs, Path dir) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        LOG.debug("Scanning " + dir.toString() + " for WAL files");
        FileStatus[] files = fs.listStatus(dir);
        if (files == null) {
            return Collections.emptyList();
        }
        for (FileStatus file : files) {
            if (file.isDirectory()) {
                result.addAll(this.getWALFiles(fs, file.getPath()));
                continue;
            }
            String name = file.getPath().toString();
            if (name.startsWith(".")) continue;
            result.add(file);
        }
        return result;
    }

    private static void cleanup() throws Exception {
        walFs.delete(walRootDir, true);
        fs.delete(rootDir, true);
    }

    static {
        tableName = TableName.valueOf((String)"TestWALWALDir");
        rowName = Bytes.toBytes((String)"row");
        family = Bytes.toBytes((String)"column");
    }
}

