/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionServerTracker
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(RegionServerTracker.class);
    private NavigableMap<ServerName, HBaseProtos.RegionServerInfo> regionServers = new TreeMap<ServerName, HBaseProtos.RegionServerInfo>();
    private ServerManager serverManager;
    private MasterServices server;

    public RegionServerTracker(ZKWatcher watcher, MasterServices server, ServerManager serverManager) {
        super(watcher);
        this.server = server;
        this.serverManager = serverManager;
    }

    public void start() throws KeeperException, IOException {
        this.watcher.registerListener((ZKListener)this);
        List servers = ZKUtil.listChildrenAndWatchThem((ZKWatcher)this.watcher, (String)this.watcher.znodePaths.rsZNode);
        this.refresh(servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(List<String> servers) throws IOException {
        NavigableMap<ServerName, HBaseProtos.RegionServerInfo> navigableMap = this.regionServers;
        synchronized (navigableMap) {
            this.regionServers.clear();
            for (String n : servers) {
                ServerName sn = ServerName.parseServerName((String)ZKUtil.getNodeName((String)n));
                if (this.regionServers.get(sn) != null) continue;
                HBaseProtos.RegionServerInfo.Builder rsInfoBuilder = HBaseProtos.RegionServerInfo.newBuilder();
                try {
                    String nodePath = ZNodePaths.joinZNode((String)this.watcher.znodePaths.rsZNode, (String)n);
                    byte[] data = ZKUtil.getData((ZKWatcher)this.watcher, (String)nodePath);
                    if (data != null && data.length > 0 && ProtobufUtil.isPBMagicPrefix((byte[])data)) {
                        int magicLen = ProtobufUtil.lengthOfPBMagic();
                        ProtobufUtil.mergeFrom((Message.Builder)rsInfoBuilder, (byte[])data, (int)magicLen, (int)(data.length - magicLen));
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Added tracking of RS " + nodePath);
                    }
                }
                catch (KeeperException e) {
                    LOG.warn("Get Rs info port from ephemeral node", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.warn("Illegal data from ephemeral node", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                this.regionServers.put(sn, rsInfoBuilder.build());
            }
        }
        if (this.server.isInitialized()) {
            this.server.checkIfShouldMoveSystemRegionAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ServerName sn) {
        NavigableMap<ServerName, HBaseProtos.RegionServerInfo> navigableMap = this.regionServers;
        synchronized (navigableMap) {
            this.regionServers.remove(sn);
        }
    }

    public void nodeDeleted(String path) {
        if (path.startsWith(this.watcher.znodePaths.rsZNode)) {
            String serverName = ZKUtil.getNodeName((String)path);
            LOG.info("RegionServer ephemeral node deleted, processing expiration [" + serverName + "]");
            ServerName sn = ServerName.parseServerName((String)serverName);
            if (!this.serverManager.isServerOnline(sn)) {
                LOG.warn(serverName.toString() + " is not online or isn't known to the master.The latter could be caused by a DNS misconfiguration.");
                return;
            }
            this.remove(sn);
            this.serverManager.expireServer(sn);
        }
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.znodePaths.rsZNode) && !this.server.isAborted() && !this.server.isStopped()) {
            try {
                List servers = ZKUtil.listChildrenAndWatchThem((ZKWatcher)this.watcher, (String)this.watcher.znodePaths.rsZNode);
                this.refresh(servers);
            }
            catch (IOException e) {
                this.server.abort("Unexpected zk exception getting RS nodes", e);
            }
            catch (KeeperException e) {
                this.server.abort("Unexpected zk exception getting RS nodes", e);
            }
        }
    }

    public HBaseProtos.RegionServerInfo getRegionServerInfo(ServerName sn) {
        return (HBaseProtos.RegionServerInfo)this.regionServers.get(sn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerName> getOnlineServers() {
        NavigableMap<ServerName, HBaseProtos.RegionServerInfo> navigableMap = this.regionServers;
        synchronized (navigableMap) {
            return new ArrayList<ServerName>(this.regionServers.keySet());
        }
    }
}

