/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TableStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(TableStateManager.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final MasterServices master;

    public TableStateManager(MasterServices master) {
        this.master = master;
    }

    public void setTableState(TableName tableName, TableState.State newState) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.udpateMetaState(tableName, newState);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableState.State setTableStateIfInStates(TableName tableName, TableState.State newState, TableState.State ... states) throws IOException {
        this.lock.writeLock().lock();
        try {
            TableState currentState = this.readMetaState(tableName);
            if (currentState == null) {
                throw new TableNotFoundException(tableName);
            }
            if (currentState.inStates(states)) {
                this.udpateMetaState(tableName, newState);
                TableState.State state = null;
                return state;
            }
            TableState.State state = currentState.getState();
            return state;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean setTableStateIfNotInStates(TableName tableName, TableState.State newState, TableState.State ... states) throws IOException {
        TableState currentState = this.readMetaState(tableName);
        if (currentState == null) {
            throw new TableNotFoundException(tableName);
        }
        if (!currentState.inStates(states)) {
            this.udpateMetaState(tableName, newState);
            return true;
        }
        return false;
    }

    public boolean isTableState(TableName tableName, TableState.State ... states) {
        try {
            TableState.State tableState = this.getTableState(tableName);
            return TableState.isInStates((TableState.State)tableState, (TableState.State[])states);
        }
        catch (IOException e) {
            LOG.error("Unable to get table " + tableName + " state", (Throwable)e);
            return false;
        }
    }

    public void setDeletedTable(TableName tableName) throws IOException {
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            return;
        }
        MetaTableAccessor.deleteTableState((Connection)this.master.getConnection(), (TableName)tableName);
    }

    public boolean isTablePresent(TableName tableName) throws IOException {
        return this.readMetaState(tableName) != null;
    }

    public Set<TableName> getTablesInStates(final TableState.State ... states) throws IOException {
        final HashSet rv = Sets.newHashSet();
        MetaTableAccessor.fullScanTables((Connection)this.master.getConnection(), (MetaTableAccessor.Visitor)new MetaTableAccessor.Visitor(){

            public boolean visit(Result r) throws IOException {
                TableState tableState = MetaTableAccessor.getTableState((Result)r);
                if (tableState != null && tableState.inStates(states)) {
                    rv.add(tableState.getTableName());
                }
                return true;
            }
        });
        return rv;
    }

    @NonNull
    public TableState.State getTableState(TableName tableName) throws IOException {
        TableState currentState = this.readMetaState(tableName);
        if (currentState == null) {
            throw new TableNotFoundException(tableName);
        }
        return currentState.getState();
    }

    protected void udpateMetaState(TableName tableName, TableState.State newState) throws IOException {
        MetaTableAccessor.updateTableState((Connection)this.master.getConnection(), (TableName)tableName, (TableState.State)newState);
    }

    @Nullable
    protected TableState readMetaState(TableName tableName) throws IOException {
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            return new TableState(tableName, TableState.State.ENABLED);
        }
        return MetaTableAccessor.getTableState((Connection)this.master.getConnection(), (TableName)tableName);
    }

    public void start() throws IOException {
        TableDescriptors tableDescriptors = this.master.getTableDescriptors();
        Connection connection = this.master.getConnection();
        TableStateManager.fixTableStates(tableDescriptors, connection);
    }

    public static void fixTableStates(TableDescriptors tableDescriptors, Connection connection) throws IOException {
        Map<String, TableDescriptor> allDescriptors = tableDescriptors.getAllDescriptors();
        final HashMap states = new HashMap();
        MetaTableAccessor.fullScanTables((Connection)connection, (MetaTableAccessor.Visitor)new MetaTableAccessor.Visitor(){

            public boolean visit(Result r) throws IOException {
                TableState state = MetaTableAccessor.getTableState((Result)r);
                if (state != null) {
                    states.put(state.getTableName().getNameAsString(), state);
                }
                return true;
            }
        });
        for (Map.Entry<String, TableDescriptor> entry : allDescriptors.entrySet()) {
            String table = entry.getKey();
            if (table.equals(TableName.META_TABLE_NAME.getNameAsString()) || states.containsKey(table)) continue;
            LOG.warn("Found table with no state, assuming ENABLED");
            MetaTableAccessor.updateTableState((Connection)connection, (TableName)TableName.valueOf((String)table), (TableState.State)TableState.State.ENABLED);
        }
    }
}

