/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationMetaCleaner
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationMetaCleaner.class);
    private final Admin admin;
    private final MasterServices master;

    public ReplicationMetaCleaner(MasterServices master, Stoppable stoppable, int period) throws IOException {
        super("ReplicationMetaCleaner", stoppable, period);
        this.master = master;
        this.admin = master.getConnection().getAdmin();
    }

    protected void chore() {
        try {
            Map<String, TableDescriptor> tables = this.master.getTableDescriptors().getAllDescriptors();
            HashMap serialTables = new HashMap();
            for (Map.Entry<String, TableDescriptor> entry : tables.entrySet()) {
                boolean hasSerialScope = false;
                for (ColumnFamilyDescriptor column : entry.getValue().getColumnFamilies()) {
                    if (column.getScope() != 2) continue;
                    hasSerialScope = true;
                    break;
                }
                if (!hasSerialScope) continue;
                serialTables.put(entry.getValue().getTableName().getNameAsString(), new HashSet());
            }
            if (serialTables.isEmpty()) {
                return;
            }
            List peers = this.admin.listReplicationPeers();
            block22: for (ReplicationPeerDescription peerDesc : peers) {
                Map tableCFsMap = peerDesc.getPeerConfig().getTableCFsMap();
                if (tableCFsMap == null) continue;
                for (Map.Entry map : tableCFsMap.entrySet()) {
                    if (!serialTables.containsKey(((TableName)map.getKey()).getNameAsString())) continue;
                    ((Set)serialTables.get(((TableName)map.getKey()).getNameAsString())).add(peerDesc.getPeerId());
                    continue block22;
                }
            }
            Map map = MetaTableAccessor.getAllBarriers((Connection)this.master.getConnection());
            for (Map.Entry entry : map.entrySet()) {
                Object daughterRegions;
                String encodedName = (String)entry.getKey();
                byte[] encodedBytes = Bytes.toBytes((String)encodedName);
                boolean canClearRegion = false;
                Map posMap = MetaTableAccessor.getReplicationPositionForAllPeer((Connection)this.master.getConnection(), (byte[])encodedBytes);
                if (posMap.isEmpty()) continue;
                String tableName = MetaTableAccessor.getSerialReplicationTableName((Connection)this.master.getConnection(), (byte[])encodedBytes);
                Set confPeers = (Set)serialTables.get(tableName);
                if (confPeers == null) {
                    canClearRegion = true;
                } else {
                    if (!this.allPeersHavePosition(confPeers, posMap)) continue;
                    String daughterValue = MetaTableAccessor.getSerialReplicationDaughterRegion((Connection)this.master.getConnection(), (byte[])encodedBytes);
                    if (daughterValue != null) {
                        boolean allDaughterStart = true;
                        daughterRegions = daughterValue.split(",");
                        for (String daughter : daughterRegions) {
                            byte[] region = Bytes.toBytes((String)daughter);
                            if (MetaTableAccessor.getReplicationBarriers((Connection)this.master.getConnection(), (byte[])region).isEmpty() || this.allPeersHavePosition(confPeers, MetaTableAccessor.getReplicationPositionForAllPeer((Connection)this.master.getConnection(), (byte[])region))) continue;
                            allDaughterStart = false;
                            break;
                        }
                        if (allDaughterStart) {
                            canClearRegion = true;
                        }
                    }
                }
                if (canClearRegion) {
                    Delete delete = new Delete(encodedBytes);
                    delete.addFamily(HConstants.REPLICATION_POSITION_FAMILY);
                    delete.addFamily(HConstants.REPLICATION_BARRIER_FAMILY);
                    delete.addFamily(HConstants.REPLICATION_META_FAMILY);
                    Table metaTable = this.master.getConnection().getTable(TableName.META_TABLE_NAME);
                    daughterRegions = null;
                    try {
                        metaTable.delete(delete);
                        continue;
                    }
                    catch (Throwable throwable) {
                        daughterRegions = throwable;
                        throw throwable;
                    }
                    finally {
                        if (metaTable == null) continue;
                        if (daughterRegions != null) {
                            try {
                                metaTable.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)daughterRegions).addSuppressed(throwable);
                            }
                            continue;
                        }
                        metaTable.close();
                        continue;
                    }
                }
                long minPos = Long.MAX_VALUE;
                for (Map.Entry pos : posMap.entrySet()) {
                    minPos = Math.min(minPos, (Long)pos.getValue());
                }
                List barriers = (List)entry.getValue();
                int index = Collections.binarySearch(barriers, minPos);
                if (index < 0) {
                    index = -index - 1;
                }
                Delete delete = new Delete(encodedBytes);
                for (int i = 0; i < index - 1; ++i) {
                    delete.addColumn(HConstants.REPLICATION_BARRIER_FAMILY, Bytes.toBytes((long)((Long)barriers.get(i))));
                }
                Table metaTable = this.master.getConnection().getTable(TableName.META_TABLE_NAME);
                Throwable throwable = null;
                try {
                    metaTable.delete(delete);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (metaTable == null) continue;
                    if (throwable != null) {
                        try {
                            metaTable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    metaTable.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error("Exception during cleaning up.", (Throwable)e);
        }
    }

    private boolean allPeersHavePosition(Set<String> peers, Map<String, Long> posMap) throws IOException {
        for (String peer : peers) {
            if (posMap.containsKey(peer)) continue;
            return false;
        }
        return true;
    }
}

