/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.procedure.ProcedureManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class ProcedureManagerHost<E extends ProcedureManager> {
    public static final String REGIONSERVER_PROCEDURE_CONF_KEY = "hbase.procedure.regionserver.classes";
    public static final String MASTER_PROCEDURE_CONF_KEY = "hbase.procedure.master.classes";
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureManagerHost.class);
    protected Set<E> procedures = new HashSet();

    protected void loadUserProcedures(Configuration conf, String confKey) {
        Class<?> implClass = null;
        String[] defaultProcClasses = conf.getStrings(confKey);
        if (defaultProcClasses == null || defaultProcClasses.length == 0) {
            return;
        }
        ArrayList<E> configured = new ArrayList<E>();
        for (String className : defaultProcClasses) {
            className = className.trim();
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            try {
                implClass = cl.loadClass(className);
                configured.add(this.loadInstance(implClass));
                LOG.info("User procedure " + className + " was loaded successfully.");
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Class " + className + " cannot be found. " + e.getMessage());
            }
            catch (IOException e) {
                LOG.warn("Load procedure " + className + " failed. " + e.getMessage());
            }
        }
        this.procedures.addAll(configured);
    }

    public E loadInstance(Class<?> implClass) throws IOException {
        ProcedureManager impl;
        Object o = null;
        try {
            o = implClass.newInstance();
            impl = o;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        return (E)impl;
    }

    public void register(E obj) {
        this.procedures.add(obj);
    }

    public Set<E> getProcedureManagers() {
        HashSet<ProcedureManager> returnValue = new HashSet<ProcedureManager>();
        for (ProcedureManager e : this.procedures) {
            returnValue.add(e);
        }
        return returnValue;
    }

    public abstract void loadProcedures(Configuration var1);
}

