/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.FailedArchiveException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.InvalidHFileException;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ReversedStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableCollection;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.protobuf.ProtocolStringList;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HStore
implements Store,
HeapSize,
StoreConfigInformation,
PropagatingConfigurationObserver {
    public static final String MEMSTORE_CLASS_NAME = "hbase.regionserver.memstore.class";
    public static final String COMPACTCHECKER_INTERVAL_MULTIPLIER_KEY = "hbase.server.compactchecker.interval.multiplier";
    public static final String BLOCKING_STOREFILES_KEY = "hbase.hstore.blockingStoreFiles";
    public static final String BLOCK_STORAGE_POLICY_KEY = "hbase.hstore.block.storage.policy";
    public static final String DEFAULT_BLOCK_STORAGE_POLICY = "HOT";
    public static final int DEFAULT_COMPACTCHECKER_INTERVAL_MULTIPLIER = 1000;
    public static final int DEFAULT_BLOCKING_STOREFILE_COUNT = 16;
    private static final Logger LOG = LoggerFactory.getLogger(HStore.class);
    protected final MemStore memstore;
    protected final HRegion region;
    private final ColumnFamilyDescriptor family;
    private final HRegionFileSystem fs;
    protected Configuration conf;
    protected CacheConfig cacheConf;
    private long lastCompactSize = 0L;
    volatile boolean forceMajor = false;
    static int closeCheckInterval = 0;
    private volatile long storeSize = 0L;
    private volatile long totalUncompressedBytes = 0L;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final ReentrantLock archiveLock = new ReentrantLock();
    private final boolean verifyBulkLoads;
    private ScanInfo scanInfo;
    final List<HStoreFile> filesCompacting = Lists.newArrayList();
    private final Set<ChangedReadersObserver> changedReaderObservers = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final int blocksize;
    private HFileDataBlockEncoder dataBlockEncoder;
    protected ChecksumType checksumType;
    protected int bytesPerChecksum;
    protected final CellComparator comparator;
    final StoreEngine<?, ?, ?, ?> storeEngine;
    private static final AtomicBoolean offPeakCompactionTracker = new AtomicBoolean();
    private volatile OffPeakHours offPeakHours;
    private static final int DEFAULT_FLUSH_RETRIES_NUMBER = 10;
    private int flushRetriesNumber;
    private int pauseTime;
    private long blockingFileCount;
    private int compactionCheckMultiplier;
    protected Encryption.Context cryptoContext = Encryption.Context.NONE;
    private volatile long flushedCellsCount = 0L;
    private volatile long compactedCellsCount = 0L;
    private volatile long majorCompactedCellsCount = 0L;
    private volatile long flushedCellsSize = 0L;
    private volatile long flushedOutputFileSize = 0L;
    private volatile long compactedCellsSize = 0L;
    private volatile long majorCompactedCellsSize = 0L;
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 17 * ClassSize.REFERENCE + 88 + 20 + 2));
    public static final long DEEP_OVERHEAD = ClassSize.align((long)(FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)ClassSize.REENTRANT_LOCK + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)ClassSize.OBJECT + ScanInfo.FIXED_OVERHEAD));

    protected HStore(HRegion region, ColumnFamilyDescriptor family, Configuration confParam) throws IOException {
        String className;
        this.fs = region.getRegionFileSystem();
        this.fs.createStoreDir(family.getNameAsString());
        this.region = region;
        this.family = family;
        this.conf = new CompoundConfiguration().add(confParam).addBytesMap(region.getTableDescriptor().getValues()).addStringMap(family.getConfiguration()).addBytesMap(family.getValues());
        this.blocksize = family.getBlocksize();
        String policyName = family.getStoragePolicy();
        if (null == policyName) {
            policyName = this.conf.get(BLOCK_STORAGE_POLICY_KEY, DEFAULT_BLOCK_STORAGE_POLICY);
        }
        this.fs.setStoragePolicy(family.getNameAsString(), policyName.trim());
        this.dataBlockEncoder = new HFileDataBlockEncoderImpl(family.getDataBlockEncoding());
        this.comparator = region.getCellComparator();
        long timeToPurgeDeletes = Math.max(this.conf.getLong("hbase.hstore.time.to.purge.deletes", 0L), 0L);
        LOG.trace("Time to purge deletes set to {}ms in store {}", (Object)timeToPurgeDeletes, (Object)this);
        long ttl = HStore.determineTTLFromFamily(family);
        this.scanInfo = new ScanInfo(this.conf, family, ttl, timeToPurgeDeletes, this.comparator);
        MemoryCompactionPolicy inMemoryCompaction = null;
        inMemoryCompaction = this.getTableName().isSystemTable() ? MemoryCompactionPolicy.valueOf((String)this.conf.get("hbase.systemtables.compacting.memstore.type", "NONE")) : family.getInMemoryCompaction();
        if (inMemoryCompaction == null) {
            inMemoryCompaction = MemoryCompactionPolicy.valueOf((String)this.conf.get("hbase.hregion.compacting.memstore.type", CompactingMemStore.COMPACTING_MEMSTORE_TYPE_DEFAULT));
        }
        switch (inMemoryCompaction) {
            case NONE: {
                className = DefaultMemStore.class.getName();
                this.memstore = (MemStore)ReflectionUtils.newInstance(DefaultMemStore.class, (Object[])new Object[]{this.conf, this.comparator});
                break;
            }
            default: {
                Class clz = this.conf.getClass(MEMSTORE_CLASS_NAME, CompactingMemStore.class, CompactingMemStore.class);
                className = clz.getName();
                this.memstore = (MemStore)ReflectionUtils.newInstance((Class)clz, (Object[])new Object[]{this.conf, this.comparator, this, this.getHRegion().getRegionServicesForStores(), inMemoryCompaction});
            }
        }
        LOG.info("Memstore class name is {}", (Object)className);
        this.offPeakHours = OffPeakHours.getInstance(this.conf);
        this.createCacheConf(family);
        this.verifyBulkLoads = this.conf.getBoolean("hbase.hstore.bulkload.verify", false);
        this.blockingFileCount = this.conf.getInt(BLOCKING_STOREFILES_KEY, 16);
        this.compactionCheckMultiplier = this.conf.getInt(COMPACTCHECKER_INTERVAL_MULTIPLIER_KEY, 1000);
        if (this.compactionCheckMultiplier <= 0) {
            LOG.error("Compaction check period multiplier must be positive, setting default: {}", (Object)1000);
            this.compactionCheckMultiplier = 1000;
        }
        if (closeCheckInterval == 0) {
            closeCheckInterval = this.conf.getInt("hbase.hstore.close.check.interval", 10000000);
        }
        this.storeEngine = this.createStoreEngine(this, this.conf, this.comparator);
        this.storeEngine.getStoreFileManager().loadFiles(this.loadStoreFiles());
        this.checksumType = HStore.getChecksumType(this.conf);
        this.bytesPerChecksum = HStore.getBytesPerChecksum(this.conf);
        this.flushRetriesNumber = this.conf.getInt("hbase.hstore.flush.retries.number", 10);
        this.pauseTime = this.conf.getInt("hbase.server.pause", 1000);
        if (this.flushRetriesNumber <= 0) {
            throw new IllegalArgumentException("hbase.hstore.flush.retries.number must be > 0, not " + this.flushRetriesNumber);
        }
        this.cryptoContext = EncryptionUtil.createEncryptionContext((Configuration)this.conf, (ColumnFamilyDescriptor)family);
    }

    protected void createCacheConf(ColumnFamilyDescriptor family) {
        this.cacheConf = new CacheConfig(this.conf, family);
    }

    protected StoreEngine<?, ?, ?, ?> createStoreEngine(HStore store, Configuration conf, CellComparator kvComparator) throws IOException {
        return StoreEngine.create(store, conf, this.comparator);
    }

    public static long determineTTLFromFamily(ColumnFamilyDescriptor family) {
        long ttl = family.getTimeToLive();
        ttl = ttl == Integer.MAX_VALUE ? Long.MAX_VALUE : (ttl == -1L ? Long.MAX_VALUE : (ttl *= 1000L));
        return ttl;
    }

    @Override
    public String getColumnFamilyName() {
        return this.family.getNameAsString();
    }

    @Override
    public TableName getTableName() {
        return this.getRegionInfo().getTable();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs.getFileSystem();
    }

    public HRegionFileSystem getRegionFileSystem() {
        return this.fs;
    }

    @Override
    public long getStoreFileTtl() {
        return this.scanInfo.getMinVersions() == 0 ? this.scanInfo.getTtl() : Long.MAX_VALUE;
    }

    @Override
    public long getMemStoreFlushSize() {
        return this.region.memstoreFlushSize;
    }

    @Override
    public MemStoreSize getFlushableSize() {
        return this.memstore.getFlushableSize();
    }

    @Override
    public MemStoreSize getSnapshotSize() {
        return this.memstore.getSnapshotSize();
    }

    @Override
    public long getCompactionCheckMultiplier() {
        return this.compactionCheckMultiplier;
    }

    @Override
    public long getBlockingFileCount() {
        return this.blockingFileCount;
    }

    public static int getBytesPerChecksum(Configuration conf) {
        return conf.getInt("hbase.hstore.bytes.per.checksum", 16384);
    }

    public static ChecksumType getChecksumType(Configuration conf) {
        String checksumName = conf.get("hbase.hstore.checksum.algorithm");
        if (checksumName == null) {
            return ChecksumType.getDefaultChecksumType();
        }
        return ChecksumType.nameToType((String)checksumName);
    }

    public static int getCloseCheckInterval() {
        return closeCheckInterval;
    }

    @Override
    public ColumnFamilyDescriptor getColumnFamilyDescriptor() {
        return this.family;
    }

    @Override
    public OptionalLong getMaxSequenceId() {
        return StoreUtils.getMaxSequenceIdInList(this.getStorefiles());
    }

    @Override
    public OptionalLong getMaxMemStoreTS() {
        return StoreUtils.getMaxMemStoreTSInList(this.getStorefiles());
    }

    @Deprecated
    public static Path getStoreHomedir(Path tabledir, RegionInfo hri, byte[] family) {
        return HStore.getStoreHomedir(tabledir, hri.getEncodedName(), family);
    }

    @Deprecated
    public static Path getStoreHomedir(Path tabledir, String encodedName, byte[] family) {
        return new Path(tabledir, new Path(encodedName, Bytes.toString((byte[])family)));
    }

    public HFileDataBlockEncoder getDataBlockEncoder() {
        return this.dataBlockEncoder;
    }

    void setDataBlockEncoderInTest(HFileDataBlockEncoder blockEncoder) {
        this.dataBlockEncoder = blockEncoder;
    }

    private List<HStoreFile> loadStoreFiles() throws IOException {
        Collection<StoreFileInfo> files = this.fs.getStoreFiles(this.getColumnFamilyName());
        return this.openStoreFiles(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HStoreFile> openStoreFiles(Collection<StoreFileInfo> files) throws IOException {
        if (CollectionUtils.isEmpty(files)) {
            return Collections.emptyList();
        }
        ThreadPoolExecutor storeFileOpenerThreadPool = this.region.getStoreFileOpenAndCloseThreadPool("StoreFileOpenerThread-" + this.getColumnFamilyName());
        ExecutorCompletionService<HStoreFile> completionService = new ExecutorCompletionService<HStoreFile>(storeFileOpenerThreadPool);
        int totalValidStoreFile = 0;
        for (StoreFileInfo storeFileInfo : files) {
            completionService.submit(() -> this.createStoreFileAndReader(storeFileInfo));
            ++totalValidStoreFile;
        }
        ArrayList<HStoreFile> results = new ArrayList<HStoreFile>(files.size());
        IOException ioe = null;
        try {
            for (int i = 0; i < totalValidStoreFile; ++i) {
                try {
                    HStoreFile storeFile = (HStoreFile)completionService.take().get();
                    if (storeFile == null) continue;
                    long length = storeFile.getReader().length();
                    this.storeSize += length;
                    this.totalUncompressedBytes += storeFile.getReader().getTotalUncompressedBytes();
                    LOG.debug("loaded {}", (Object)storeFile);
                    results.add(storeFile);
                    continue;
                }
                catch (InterruptedException e) {
                    if (ioe != null) continue;
                    ioe = new InterruptedIOException(e.getMessage());
                    continue;
                }
                catch (ExecutionException e) {
                    if (ioe != null) continue;
                    ioe = new IOException(e.getCause());
                }
            }
        }
        finally {
            storeFileOpenerThreadPool.shutdownNow();
        }
        if (ioe != null) {
            boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
            for (HStoreFile file : results) {
                try {
                    if (file == null) continue;
                    file.closeStoreFile(evictOnClose);
                }
                catch (IOException e) {
                    LOG.warn("Could not close store file", (Throwable)e);
                }
            }
            throw ioe;
        }
        return results;
    }

    @Override
    public void refreshStoreFiles() throws IOException {
        Collection<StoreFileInfo> newFiles = this.fs.getStoreFiles(this.getColumnFamilyName());
        this.refreshStoreFilesInternal(newFiles);
    }

    public void refreshStoreFiles(Collection<String> newFiles) throws IOException {
        ArrayList<StoreFileInfo> storeFiles = new ArrayList<StoreFileInfo>(newFiles.size());
        for (String file : newFiles) {
            storeFiles.add(this.fs.getStoreFileInfo(this.getColumnFamilyName(), file));
        }
        this.refreshStoreFilesInternal(storeFiles);
    }

    private void refreshStoreFilesInternal(Collection<StoreFileInfo> newFiles) throws IOException {
        StoreFileManager sfm = this.storeEngine.getStoreFileManager();
        Collection<HStoreFile> currentFiles = sfm.getStorefiles();
        Collection<HStoreFile> compactedFiles = sfm.getCompactedfiles();
        if (currentFiles == null) {
            currentFiles = Collections.emptySet();
        }
        if (newFiles == null) {
            newFiles = Collections.emptySet();
        }
        if (compactedFiles == null) {
            compactedFiles = Collections.emptySet();
        }
        HashMap<StoreFileInfo, HStoreFile> currentFilesSet = new HashMap<StoreFileInfo, HStoreFile>(currentFiles.size());
        for (HStoreFile hStoreFile : currentFiles) {
            currentFilesSet.put(hStoreFile.getFileInfo(), hStoreFile);
        }
        HashMap<StoreFileInfo, HStoreFile> compactedFilesSet = new HashMap<StoreFileInfo, HStoreFile>(compactedFiles.size());
        for (HStoreFile sf : compactedFiles) {
            compactedFilesSet.put(sf.getFileInfo(), sf);
        }
        HashSet<StoreFileInfo> hashSet = new HashSet<StoreFileInfo>(newFiles);
        Sets.SetView setView = Sets.difference(hashSet, compactedFilesSet.keySet());
        Sets.SetView toBeAddedFiles = Sets.difference((Set)setView, currentFilesSet.keySet());
        Sets.SetView toBeRemovedFiles = Sets.difference(currentFilesSet.keySet(), (Set)setView);
        if (toBeAddedFiles.isEmpty() && toBeRemovedFiles.isEmpty()) {
            return;
        }
        LOG.info("Refreshing store files for region " + this.getRegionInfo().getRegionNameAsString() + " files to add: " + toBeAddedFiles + " files to remove: " + toBeRemovedFiles);
        HashSet<HStoreFile> toBeRemovedStoreFiles = new HashSet<HStoreFile>(toBeRemovedFiles.size());
        for (StoreFileInfo sfi : toBeRemovedFiles) {
            toBeRemovedStoreFiles.add((HStoreFile)currentFilesSet.get(sfi));
        }
        List<HStoreFile> openedFiles = this.openStoreFiles((Collection<StoreFileInfo>)toBeAddedFiles);
        this.replaceStoreFiles(toBeRemovedStoreFiles, openedFiles);
        if (!toBeAddedFiles.isEmpty()) {
            this.region.getMVCC().advanceTo(this.getMaxSequenceId().getAsLong());
        }
        this.completeCompaction(toBeRemovedStoreFiles);
    }

    @VisibleForTesting
    protected HStoreFile createStoreFileAndReader(Path p) throws IOException {
        StoreFileInfo info = new StoreFileInfo(this.conf, this.getFileSystem(), p);
        return this.createStoreFileAndReader(info);
    }

    private HStoreFile createStoreFileAndReader(StoreFileInfo info) throws IOException {
        info.setRegionCoprocessorHost(this.region.getCoprocessorHost());
        HStoreFile storeFile = new HStoreFile(this.getFileSystem(), info, this.conf, this.cacheConf, this.family.getBloomFilterType(), this.isPrimaryReplicaStore());
        storeFile.initReader();
        return storeFile;
    }

    public void startReplayingFromWAL() {
        this.memstore.startReplayingFromWAL();
    }

    public void stopReplayingFromWAL() {
        this.memstore.stopReplayingFromWAL();
    }

    public void add(Cell cell, MemStoreSizing memstoreSizing) {
        this.lock.readLock().lock();
        try {
            this.memstore.add(cell, memstoreSizing);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void add(Iterable<Cell> cells, MemStoreSizing memstoreSizing) {
        this.lock.readLock().lock();
        try {
            this.memstore.add(cells, memstoreSizing);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public long timeOfOldestEdit() {
        return this.memstore.timeOfOldestEdit();
    }

    public Collection<HStoreFile> getStorefiles() {
        return this.storeEngine.getStoreFileManager().getStorefiles();
    }

    public Collection<HStoreFile> getCompactedFiles() {
        return this.storeEngine.getStoreFileManager().getCompactedfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertBulkLoadHFileOk(Path srcPath) throws IOException {
        try (Closeable reader = null;){
            LOG.info("Validating hfile at " + srcPath + " for inclusion in store " + this + " region " + this.getRegionInfo().getRegionNameAsString());
            reader = HFile.createReader(srcPath.getFileSystem(this.conf), srcPath, this.cacheConf, this.isPrimaryReplicaStore(), this.conf);
            reader.loadFileInfo();
            Optional<byte[]> firstKey = reader.getFirstRowKey();
            Preconditions.checkState((boolean)firstKey.isPresent(), (Object)"First key can not be null");
            Optional<Cell> lk = reader.getLastKey();
            Preconditions.checkState((boolean)lk.isPresent(), (Object)"Last key can not be null");
            byte[] lastKey = CellUtil.cloneRow((Cell)lk.get());
            if (LOG.isDebugEnabled()) {
                LOG.debug("HFile bounds: first=" + Bytes.toStringBinary((byte[])firstKey.get()) + " last=" + Bytes.toStringBinary((byte[])lastKey));
                LOG.debug("Region bounds: first=" + Bytes.toStringBinary((byte[])this.getRegionInfo().getStartKey()) + " last=" + Bytes.toStringBinary((byte[])this.getRegionInfo().getEndKey()));
            }
            if (!this.getRegionInfo().containsRange(firstKey.get(), lastKey)) {
                throw new WrongRegionException("Bulk load file " + srcPath.toString() + " does not fit inside region " + this.getRegionInfo().getRegionNameAsString());
            }
            if (reader.length() > this.conf.getLong("hbase.hregion.max.filesize", 0x280000000L)) {
                LOG.warn("Trying to bulk load hfile " + srcPath + " with size: " + reader.length() + " bytes can be problematic as it may lead to oversplitting.");
            }
            if (this.verifyBulkLoads) {
                long verificationStartTime = EnvironmentEdgeManager.currentTime();
                LOG.info("Full verification started for bulk load hfile: {}", (Object)srcPath);
                Cell prevCell = null;
                HFileScanner scanner = reader.getScanner(false, false, false);
                scanner.seekTo();
                do {
                    Cell cell = scanner.getCell();
                    if (prevCell != null) {
                        if (this.comparator.compareRows(prevCell, cell) > 0) {
                            throw new InvalidHFileException("Previous row is greater than current row: path=" + srcPath + " previous=" + CellUtil.getCellKeyAsString((Cell)prevCell) + " current=" + CellUtil.getCellKeyAsString((Cell)cell));
                        }
                        if (CellComparator.getInstance().compareFamilies(prevCell, cell) != 0) {
                            throw new InvalidHFileException("Previous key had different family compared to current key: path=" + srcPath + " previous=" + Bytes.toStringBinary((byte[])prevCell.getFamilyArray(), (int)prevCell.getFamilyOffset(), (int)prevCell.getFamilyLength()) + " current=" + Bytes.toStringBinary((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()));
                        }
                    }
                    prevCell = cell;
                } while (scanner.next());
                LOG.info("Full verification complete for bulk load hfile: " + srcPath.toString() + " took " + (EnvironmentEdgeManager.currentTime() - verificationStartTime) + " ms");
            }
        }
    }

    public Pair<Path, Path> preBulkLoadHFile(String srcPathStr, long seqNum) throws IOException {
        Path srcPath = new Path(srcPathStr);
        return this.fs.bulkLoadStoreFile(this.getColumnFamilyName(), srcPath, seqNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path bulkLoadHFile(byte[] family, String srcPathStr, Path dstPath) throws IOException {
        Path srcPath = new Path(srcPathStr);
        try {
            this.fs.commitStoreFile(srcPath, dstPath);
        }
        finally {
            if (this.getCoprocessorHost() != null) {
                this.getCoprocessorHost().postCommitStoreFile(family, srcPath, dstPath);
            }
        }
        LOG.info("Loaded HFile " + srcPath + " into store '" + this.getColumnFamilyName() + "' as " + dstPath + " - updating store file list.");
        HStoreFile sf = this.createStoreFileAndReader(dstPath);
        this.bulkLoadHFile(sf);
        LOG.info("Successfully loaded store file {} into store {} (new location: {})", new Object[]{srcPath, this, dstPath});
        return dstPath;
    }

    public void bulkLoadHFile(StoreFileInfo fileInfo) throws IOException {
        HStoreFile sf = this.createStoreFileAndReader(fileInfo);
        this.bulkLoadHFile(sf);
    }

    private void bulkLoadHFile(HStoreFile sf) throws IOException {
        StoreFileReader r = sf.getReader();
        this.storeSize += r.length();
        this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().insertNewFiles(Lists.newArrayList((Object[])new HStoreFile[]{sf}));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        LOG.info("Loaded HFile " + sf.getFileInfo() + " into store '" + this.getColumnFamilyName());
        if (LOG.isTraceEnabled()) {
            String traceMessage = "BULK LOAD time,size,store size,store files [" + EnvironmentEdgeManager.currentTime() + "," + r.length() + "," + this.storeSize + "," + this.storeEngine.getStoreFileManager().getStorefileCount() + "]";
            LOG.trace(traceMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableCollection<HStoreFile> close() throws IOException {
        this.archiveLock.lock();
        this.lock.writeLock().lock();
        try {
            ImmutableCollection<HStoreFile> result = this.storeEngine.getStoreFileManager().clearFiles();
            Collection<HStoreFile> compactedfiles = this.storeEngine.getStoreFileManager().clearCompactedFiles();
            if (CollectionUtils.isNotEmpty(compactedfiles)) {
                this.removeCompactedfiles(compactedfiles);
            }
            if (!result.isEmpty()) {
                ThreadPoolExecutor storeFileCloserThreadPool = this.region.getStoreFileOpenAndCloseThreadPool("StoreFileCloserThread-" + this.getColumnFamilyName());
                ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(storeFileCloserThreadPool);
                for (final HStoreFile f : result) {
                    completionService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws IOException {
                            boolean evictOnClose = HStore.this.cacheConf != null ? HStore.this.cacheConf.shouldEvictOnClose() : true;
                            f.closeStoreFile(evictOnClose);
                            return null;
                        }
                    });
                }
                IOException ioe = null;
                try {
                    for (int i = 0; i < result.size(); ++i) {
                        try {
                            Future future = completionService.take();
                            future.get();
                            continue;
                        }
                        catch (InterruptedException e) {
                            if (ioe != null) continue;
                            ioe = new InterruptedIOException();
                            ioe.initCause(e);
                            continue;
                        }
                        catch (ExecutionException e) {
                            if (ioe != null) continue;
                            ioe = new IOException(e.getCause());
                        }
                    }
                }
                finally {
                    storeFileCloserThreadPool.shutdownNow();
                }
                if (ioe != null) {
                    throw ioe;
                }
            }
            LOG.info("Closed {}", (Object)this);
            ImmutableCollection<HStoreFile> immutableCollection = result;
            return immutableCollection;
        }
        finally {
            this.lock.writeLock().unlock();
            this.archiveLock.unlock();
        }
    }

    void snapshot() {
        this.lock.writeLock().lock();
        try {
            this.memstore.snapshot();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected List<Path> flushCache(long logCacheFlushId, MemStoreSnapshot snapshot, MonitoredTask status, ThroughputController throughputController, FlushLifeCycleTracker tracker) throws IOException {
        StoreFlusher flusher = this.storeEngine.getStoreFlusher();
        IOException lastException = null;
        for (int i = 0; i < this.flushRetriesNumber; ++i) {
            try {
                List<Path> pathNames = flusher.flushSnapshot(snapshot, logCacheFlushId, status, throughputController, tracker);
                Path lastPathName = null;
                try {
                    Iterator<Path> iterator = pathNames.iterator();
                    while (iterator.hasNext()) {
                        Path pathName;
                        lastPathName = pathName = iterator.next();
                        this.validateStoreFile(pathName);
                    }
                    return pathNames;
                }
                catch (Exception e) {
                    LOG.warn("Failed validating store file {}, retrying num={}", new Object[]{lastPathName, i, e});
                    lastException = e instanceof IOException ? (IOException)e : new IOException(e);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed flushing store file, retrying num={}", (Object)i, (Object)e);
                lastException = e;
            }
            if (lastException == null || i >= this.flushRetriesNumber - 1) continue;
            try {
                Thread.sleep(this.pauseTime);
                continue;
            }
            catch (InterruptedException e) {
                InterruptedIOException iie = new InterruptedIOException();
                iie.initCause(e);
                throw iie;
            }
        }
        throw lastException;
    }

    private HStoreFile commitFile(Path path, long logCacheFlushId, MonitoredTask status) throws IOException {
        Path dstPath = this.fs.commitStoreFile(this.getColumnFamilyName(), path);
        status.setStatus("Flushing " + this + ": reopening flushed file");
        HStoreFile sf = this.createStoreFileAndReader(dstPath);
        StoreFileReader r = sf.getReader();
        this.storeSize += r.length();
        this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        if (LOG.isInfoEnabled()) {
            LOG.info("Added " + sf + ", entries=" + r.getEntries() + ", sequenceid=" + logCacheFlushId + ", filesize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)r.length(), (String)"", (int)1));
        }
        return sf;
    }

    public StoreFileWriter createWriterInTmp(long maxKeyCount, Compression.Algorithm compression, boolean isCompaction, boolean includeMVCCReadpoint, boolean includesTag, boolean shouldDropBehind) throws IOException {
        CacheConfig writerCacheConf;
        if (isCompaction) {
            writerCacheConf = new CacheConfig(this.cacheConf);
            writerCacheConf.setCacheDataOnWrite(false);
        } else {
            writerCacheConf = this.cacheConf;
        }
        InetSocketAddress[] favoredNodes = null;
        if (this.region.getRegionServerServices() != null) {
            favoredNodes = this.region.getRegionServerServices().getFavoredNodesForRegion(this.region.getRegionInfo().getEncodedName());
        }
        HFileContext hFileContext = this.createFileContext(compression, includeMVCCReadpoint, includesTag, this.cryptoContext);
        Path familyTempDir = new Path(this.fs.getTempDir(), this.family.getNameAsString());
        StoreFileWriter.Builder builder = new StoreFileWriter.Builder(this.conf, writerCacheConf, this.getFileSystem()).withOutputDir(familyTempDir).withComparator(this.comparator).withBloomType(this.family.getBloomFilterType()).withMaxKeyCount(maxKeyCount).withFavoredNodes(favoredNodes).withFileContext(hFileContext).withShouldDropCacheBehind(shouldDropBehind);
        return builder.build();
    }

    private HFileContext createFileContext(Compression.Algorithm compression, boolean includeMVCCReadpoint, boolean includesTag, Encryption.Context cryptoContext) {
        if (compression == null) {
            compression = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        HFileContext hFileContext = new HFileContextBuilder().withIncludesMvcc(includeMVCCReadpoint).withIncludesTags(includesTag).withCompression(compression).withCompressTags(this.family.isCompressTags()).withChecksumType(this.checksumType).withBytesPerCheckSum(this.bytesPerChecksum).withBlockSize(this.blocksize).withHBaseCheckSum(true).withDataBlockEncoding(this.family.getDataBlockEncoding()).withEncryptionContext(cryptoContext).withCreateTime(EnvironmentEdgeManager.currentTime()).build();
        return hFileContext;
    }

    private long getTotalSize(Collection<HStoreFile> sfs) {
        return sfs.stream().mapToLong(sf -> sf.getReader().length()).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStorefiles(List<HStoreFile> sfs, long snapshotId) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().insertNewFiles(sfs);
            if (snapshotId > 0L) {
                this.memstore.clearSnapshot(snapshotId);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.notifyChangedReadersObservers(sfs);
        if (LOG.isTraceEnabled()) {
            long totalSize = this.getTotalSize(sfs);
            String traceMessage = "FLUSH time,count,size,store size,store files [" + EnvironmentEdgeManager.currentTime() + "," + sfs.size() + "," + totalSize + "," + this.storeSize + "," + this.storeEngine.getStoreFileManager().getStorefileCount() + "]";
            LOG.trace(traceMessage);
        }
        return this.needsCompaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChangedReadersObservers(List<HStoreFile> sfs) throws IOException {
        for (ChangedReadersObserver o : this.changedReaderObservers) {
            List<KeyValueScanner> memStoreScanners;
            this.lock.readLock().lock();
            try {
                memStoreScanners = this.memstore.getScanners(o.getReadPoint());
            }
            finally {
                this.lock.readLock().unlock();
            }
            o.updateReaders(sfs, memStoreScanners);
        }
    }

    public List<KeyValueScanner> getScanners(boolean cacheBlocks, boolean isGet, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, byte[] stopRow, long readPt) throws IOException {
        return this.getScanners(cacheBlocks, usePread, isCompaction, matcher, startRow, true, stopRow, false, readPt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValueScanner> getScanners(boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt) throws IOException {
        List<KeyValueScanner> memStoreScanners;
        Collection<HStoreFile> storeFilesToScan;
        this.lock.readLock().lock();
        try {
            storeFilesToScan = this.storeEngine.getStoreFileManager().getFilesForScan(startRow, includeStartRow, stopRow, includeStopRow);
            memStoreScanners = this.memstore.getScanners(readPt);
        }
        finally {
            this.lock.readLock().unlock();
        }
        List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(storeFilesToScan, cacheBlocks, usePread, isCompaction, false, matcher, readPt);
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(sfScanners.size() + 1);
        scanners.addAll(sfScanners);
        scanners.addAll(memStoreScanners);
        return scanners;
    }

    public List<KeyValueScanner> getScanners(List<HStoreFile> files, boolean cacheBlocks, boolean isGet, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, byte[] stopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
        return this.getScanners(files, cacheBlocks, usePread, isCompaction, matcher, startRow, true, stopRow, false, readPt, includeMemstoreScanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValueScanner> getScanners(List<HStoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
        List<KeyValueScanner> memStoreScanners = null;
        if (includeMemstoreScanner) {
            this.lock.readLock().lock();
            try {
                memStoreScanners = this.memstore.getScanners(readPt);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(files, cacheBlocks, usePread, isCompaction, false, matcher, readPt);
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(sfScanners.size() + 1);
        scanners.addAll(sfScanners);
        if (memStoreScanners != null) {
            scanners.addAll(memStoreScanners);
        }
        return scanners;
    }

    public void addChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.add(o);
    }

    public void deleteChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HStoreFile> compact(CompactionContext compaction, ThroughputController throughputController, User user) throws IOException {
        assert (compaction != null);
        Object sfs = null;
        CompactionRequestImpl cr = compaction.getRequest();
        try {
            long compactionStartTime = EnvironmentEdgeManager.currentTime();
            assert (compaction.hasSelection());
            Collection<HStoreFile> filesToCompact = cr.getFiles();
            assert (!filesToCompact.isEmpty());
            List<HStoreFile> list = this.filesCompacting;
            synchronized (list) {
                Preconditions.checkArgument((boolean)this.filesCompacting.containsAll(filesToCompact));
            }
            LOG.info("Starting compaction of " + filesToCompact + " into tmpdir=" + this.fs.getTempDir() + ", totalSize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)cr.getSize(), (String)"", (int)1));
            list = this.doCompaction(cr, filesToCompact, user, compactionStartTime, compaction.compact(throughputController, user));
            return list;
        }
        finally {
            this.finishCompactionRequest(cr);
        }
    }

    @VisibleForTesting
    protected List<HStoreFile> doCompaction(CompactionRequestImpl cr, Collection<HStoreFile> filesToCompact, User user, long compactionStartTime, List<Path> newFiles) throws IOException {
        List<HStoreFile> sfs = this.moveCompactedFilesIntoPlace(cr, newFiles, user);
        this.writeCompactionWalRecord(filesToCompact, sfs);
        this.replaceStoreFiles(filesToCompact, sfs);
        if (cr.isMajor()) {
            this.majorCompactedCellsCount += this.getCompactionProgress().totalCompactingKVs;
            this.majorCompactedCellsSize += this.getCompactionProgress().totalCompactedSize;
        } else {
            this.compactedCellsCount += this.getCompactionProgress().totalCompactingKVs;
            this.compactedCellsSize += this.getCompactionProgress().totalCompactedSize;
        }
        long outputBytes = this.getTotalSize(sfs);
        this.completeCompaction(filesToCompact);
        long now = EnvironmentEdgeManager.currentTime();
        if (this.region.getRegionServerServices() != null && this.region.getRegionServerServices().getMetrics() != null) {
            this.region.getRegionServerServices().getMetrics().updateCompaction(cr.isMajor(), now - compactionStartTime, cr.getFiles().size(), newFiles.size(), cr.getSize(), outputBytes);
        }
        this.logCompactionEndMessage(cr, sfs, now, compactionStartTime);
        return sfs;
    }

    private List<HStoreFile> moveCompactedFilesIntoPlace(CompactionRequestImpl cr, List<Path> newFiles, User user) throws IOException {
        ArrayList<HStoreFile> sfs = new ArrayList<HStoreFile>(newFiles.size());
        for (Path newFile : newFiles) {
            assert (newFile != null);
            HStoreFile sf = this.moveFileIntoPlace(newFile);
            if (this.getCoprocessorHost() != null) {
                this.getCoprocessorHost().postCompact(this, sf, cr.getTracker(), cr, user);
            }
            assert (sf != null);
            sfs.add(sf);
        }
        return sfs;
    }

    HStoreFile moveFileIntoPlace(Path newFile) throws IOException {
        this.validateStoreFile(newFile);
        Path destPath = this.fs.commitStoreFile(this.getColumnFamilyName(), newFile);
        return this.createStoreFileAndReader(destPath);
    }

    private void writeCompactionWalRecord(Collection<HStoreFile> filesCompacted, Collection<HStoreFile> newFiles) throws IOException {
        if (this.region.getWAL() == null) {
            return;
        }
        List inputPaths = filesCompacted.stream().map(HStoreFile::getPath).collect(Collectors.toList());
        List outputPaths = newFiles.stream().map(HStoreFile::getPath).collect(Collectors.toList());
        RegionInfo info = this.region.getRegionInfo();
        WALProtos.CompactionDescriptor compactionDescriptor = ProtobufUtil.toCompactionDescriptor((RegionInfo)info, (byte[])this.family.getName(), inputPaths, outputPaths, (Path)this.fs.getStoreDir(this.getColumnFamilyDescriptor().getNameAsString()));
        WALUtil.writeCompactionMarker(this.region.getWAL(), this.region.getReplicationScope(), this.region.getRegionInfo(), compactionDescriptor, this.region.getMVCC());
    }

    @VisibleForTesting
    void replaceStoreFiles(Collection<HStoreFile> compactedFiles, Collection<HStoreFile> result) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().addCompactionResults(compactedFiles, result);
            this.filesCompacting.removeAll(compactedFiles);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void logCompactionEndMessage(CompactionRequestImpl cr, List<HStoreFile> sfs, long now, long compactionStartTime) {
        StringBuilder message = new StringBuilder("Completed" + (cr.isMajor() ? " major" : "") + " compaction of " + cr.getFiles().size() + (cr.isAllFiles() ? " (all)" : "") + " file(s) in " + this + " of " + this.getRegionInfo().getShortNameToLog() + " into ");
        if (sfs.isEmpty()) {
            message.append("none, ");
        } else {
            for (HStoreFile sf : sfs) {
                message.append(sf.getPath().getName());
                message.append("(size=");
                message.append(StringUtils.TraditionalBinaryPrefix.long2String((long)sf.getReader().length(), (String)"", (int)1));
                message.append("), ");
            }
        }
        message.append("total size for store is ").append(StringUtils.TraditionalBinaryPrefix.long2String((long)this.storeSize, (String)"", (int)1)).append(". This selection was in queue for ").append(StringUtils.formatTimeDiff((long)compactionStartTime, (long)cr.getSelectionTime())).append(", and took ").append(StringUtils.formatTimeDiff((long)now, (long)compactionStartTime)).append(" to execute.");
        LOG.info(message.toString());
        if (LOG.isTraceEnabled()) {
            int fileCount = this.storeEngine.getStoreFileManager().getStorefileCount();
            long resultSize = this.getTotalSize(sfs);
            String traceMessage = "COMPACTION start,end,size out,files in,files out,store size,store files [" + compactionStartTime + "," + now + "," + resultSize + "," + cr.getFiles().size() + "," + sfs.size() + "," + this.storeSize + "," + fileCount + "]";
            LOG.trace(traceMessage);
        }
    }

    public void replayCompactionMarker(WALProtos.CompactionDescriptor compaction, boolean pickCompactionFiles, boolean removeFiles) throws IOException {
        LOG.debug("Completing compaction from the WAL marker");
        ProtocolStringList compactionInputs = compaction.getCompactionInputList();
        ArrayList compactionOutputs = Lists.newArrayList((Iterable)compaction.getCompactionOutputList());
        String familyName = this.getColumnFamilyName();
        HashSet<String> inputFiles = new HashSet<String>();
        for (Object compactionInput : compactionInputs) {
            Path inputPath = this.fs.getStoreFilePath(familyName, (String)compactionInput);
            inputFiles.add(inputPath.getName());
        }
        ArrayList<HStoreFile> inputStoreFiles = new ArrayList<HStoreFile>(compactionInputs.size());
        for (HStoreFile sf : this.getStorefiles()) {
            if (!inputFiles.contains(sf.getPath().getName())) continue;
            inputStoreFiles.add(sf);
        }
        ArrayList<HStoreFile> outputStoreFiles = new ArrayList<HStoreFile>(compactionOutputs.size());
        if (pickCompactionFiles) {
            for (HStoreFile sf : this.getStorefiles()) {
                compactionOutputs.remove(sf.getPath().getName());
            }
            for (String compactionOutput : compactionOutputs) {
                StoreFileInfo storeFileInfo = this.fs.getStoreFileInfo(this.getColumnFamilyName(), compactionOutput);
                HStoreFile storeFile = this.createStoreFileAndReader(storeFileInfo);
                outputStoreFiles.add(storeFile);
            }
        }
        if (!inputStoreFiles.isEmpty() || !outputStoreFiles.isEmpty()) {
            LOG.info("Replaying compaction marker, replacing input files: " + inputStoreFiles + " with output files : " + outputStoreFiles);
            this.replaceStoreFiles(inputStoreFiles, outputStoreFiles);
            this.completeCompaction(inputStoreFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void compactRecentForTestingAssumingDefaultPolicy(int N) throws IOException {
        boolean isMajor;
        List<HStoreFile> filesToCompact;
        List<HStoreFile> list;
        this.lock.readLock().lock();
        try {
            list = this.filesCompacting;
            synchronized (list) {
                int count;
                filesToCompact = Lists.newArrayList(this.storeEngine.getStoreFileManager().getStorefiles());
                if (!this.filesCompacting.isEmpty()) {
                    HStoreFile last = this.filesCompacting.get(this.filesCompacting.size() - 1);
                    int idx = filesToCompact.indexOf(last);
                    Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0);
                    filesToCompact.subList(0, idx + 1).clear();
                }
                if (N > (count = filesToCompact.size())) {
                    throw new RuntimeException("Not enough files");
                }
                isMajor = (filesToCompact = filesToCompact.subList(count - N, count)).size() == this.storeEngine.getStoreFileManager().getStorefileCount();
                this.filesCompacting.addAll(filesToCompact);
                Collections.sort(this.filesCompacting, this.storeEngine.getStoreFileManager().getStoreFileComparator());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            List<Path> newFiles = ((DefaultCompactor)this.storeEngine.getCompactor()).compactForTesting(filesToCompact, isMajor);
            for (Path newFile : newFiles) {
                HStoreFile sf = this.moveFileIntoPlace(newFile);
                if (this.getCoprocessorHost() != null) {
                    this.getCoprocessorHost().postCompact(this, sf, null, null, null);
                }
                this.replaceStoreFiles(filesToCompact, Collections.singletonList(sf));
                this.completeCompaction(filesToCompact);
            }
        }
        finally {
            list = this.filesCompacting;
            synchronized (list) {
                this.filesCompacting.removeAll(filesToCompact);
            }
        }
    }

    @Override
    public boolean hasReferences() {
        return StoreUtils.hasReferences(this.storeEngine.getStoreFileManager().getStorefiles());
    }

    public CompactionProgress getCompactionProgress() {
        return this.storeEngine.getCompactor().getProgress();
    }

    @Override
    public boolean shouldPerformMajorCompaction() throws IOException {
        for (HStoreFile sf : this.storeEngine.getStoreFileManager().getStorefiles()) {
            if (sf.getReader() != null) continue;
            LOG.debug("StoreFile {} has null Reader", (Object)sf);
            return false;
        }
        return this.storeEngine.getCompactionPolicy().shouldPerformMajorCompaction(this.storeEngine.getStoreFileManager().getStorefiles());
    }

    public Optional<CompactionContext> requestCompaction() throws IOException {
        return this.requestCompaction(Integer.MIN_VALUE, CompactionLifeCycleTracker.DUMMY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<CompactionContext> requestCompaction(int priority, CompactionLifeCycleTracker tracker, User user) throws IOException {
        if (!this.areWritesEnabled()) {
            return Optional.empty();
        }
        this.removeUnneededFiles();
        CompactionContext compaction = this.storeEngine.createCompaction();
        CompactionRequestImpl request = null;
        this.lock.readLock().lock();
        try {
            List<HStoreFile> list = this.filesCompacting;
            synchronized (list) {
                Collection<HStoreFile> selectedFiles;
                block19: {
                    if (this.getCoprocessorHost() != null) {
                        List<HStoreFile> candidatesForCoproc = compaction.preSelect(this.filesCompacting);
                        boolean override = this.getCoprocessorHost().preCompactSelection(this, candidatesForCoproc, tracker, user);
                        if (override) {
                            compaction.forceSelect(new CompactionRequestImpl(candidatesForCoproc));
                        }
                    }
                    if (!compaction.hasSelection()) {
                        boolean isUserCompaction = priority == 1;
                        boolean mayUseOffPeak = this.offPeakHours.isOffPeakHour() && offPeakCompactionTracker.compareAndSet(false, true);
                        try {
                            compaction.select(this.filesCompacting, isUserCompaction, mayUseOffPeak, this.forceMajor && this.filesCompacting.isEmpty());
                        }
                        catch (IOException e) {
                            if (mayUseOffPeak) {
                                offPeakCompactionTracker.set(false);
                            }
                            throw e;
                        }
                        assert (compaction.hasSelection());
                        if (mayUseOffPeak && !compaction.getRequest().isOffPeak()) {
                            offPeakCompactionTracker.set(false);
                        }
                    }
                    if (this.getCoprocessorHost() != null) {
                        this.getCoprocessorHost().postCompactSelection(this, (List<HStoreFile>)ImmutableList.copyOf(compaction.getRequest().getFiles()), tracker, compaction.getRequest(), user);
                    }
                    if (!(selectedFiles = (request = compaction.getRequest()).getFiles()).isEmpty()) break block19;
                    Optional<CompactionContext> optional = Optional.empty();
                    return optional;
                }
                this.addToCompactingFiles(selectedFiles);
                this.forceMajor = this.forceMajor && !request.isMajor();
                request.setPriority(priority != Integer.MIN_VALUE ? priority : this.getCompactPriority());
                request.setDescription(this.getRegionInfo().getRegionNameAsString(), this.getColumnFamilyName());
                request.setTracker(tracker);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getRegionInfo().getEncodedName() + " - " + this.getColumnFamilyName() + ": Initiating " + (request.isMajor() ? "major" : "minor") + " compaction" + (request.isAllFiles() ? " (all files)" : ""));
        }
        this.region.reportCompactionRequestStart(request.isMajor());
        return Optional.of(compaction);
    }

    private void addToCompactingFiles(Collection<HStoreFile> filesToAdd) {
        if (CollectionUtils.isEmpty(filesToAdd)) {
            return;
        }
        if (!Collections.disjoint(this.filesCompacting, filesToAdd)) {
            Preconditions.checkArgument((boolean)false, (String)"%s overlaps with %s", filesToAdd, this.filesCompacting);
        }
        this.filesCompacting.addAll(filesToAdd);
        Collections.sort(this.filesCompacting, this.storeEngine.getStoreFileManager().getStoreFileComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnneededFiles() throws IOException {
        if (!this.conf.getBoolean("hbase.store.delete.expired.storefile", true)) {
            return;
        }
        if (this.getColumnFamilyDescriptor().getMinVersions() > 0) {
            LOG.debug("Skipping expired store file removal due to min version being {}", (Object)this.getColumnFamilyDescriptor().getMinVersions());
            return;
        }
        this.lock.readLock().lock();
        Collection<HStoreFile> delSfs = null;
        try {
            List<HStoreFile> list = this.filesCompacting;
            synchronized (list) {
                long cfTtl = this.getStoreFileTtl();
                if (cfTtl != Long.MAX_VALUE) {
                    delSfs = this.storeEngine.getStoreFileManager().getUnneededFiles(EnvironmentEdgeManager.currentTime() - cfTtl, this.filesCompacting);
                    this.addToCompactingFiles(delSfs);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (CollectionUtils.isEmpty(delSfs)) {
            return;
        }
        List<HStoreFile> newFiles = Collections.emptyList();
        this.writeCompactionWalRecord(delSfs, newFiles);
        this.replaceStoreFiles(delSfs, newFiles);
        this.completeCompaction(delSfs);
        LOG.info("Completed removal of " + delSfs.size() + " unnecessary (expired) file(s) in " + this + " of " + this.getRegionInfo().getRegionNameAsString() + "; total size for store is " + StringUtils.TraditionalBinaryPrefix.long2String((long)this.storeSize, (String)"", (int)1));
    }

    public void cancelRequestedCompaction(CompactionContext compaction) {
        this.finishCompactionRequest(compaction.getRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCompactionRequest(CompactionRequestImpl cr) {
        this.region.reportCompactionRequestEnd(cr.isMajor(), cr.getFiles().size(), cr.getSize());
        if (cr.isOffPeak()) {
            offPeakCompactionTracker.set(false);
            cr.setOffPeak(false);
        }
        List<HStoreFile> list = this.filesCompacting;
        synchronized (list) {
            this.filesCompacting.removeAll(cr.getFiles());
        }
    }

    private void validateStoreFile(Path path) throws IOException {
        HStoreFile storeFile = null;
        try {
            storeFile = this.createStoreFileAndReader(path);
        }
        catch (IOException e) {
            LOG.error("Failed to open store file : {}, keeping it in tmp location", (Object)path, (Object)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeStoreFile(false);
            }
        }
    }

    @VisibleForTesting
    protected void completeCompaction(Collection<HStoreFile> compactedFiles) throws IOException {
        this.storeSize = 0L;
        this.totalUncompressedBytes = 0L;
        for (HStoreFile hsf : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFileReader r = hsf.getReader();
            if (r == null) {
                LOG.warn("StoreFile {} has a null Reader", (Object)hsf);
                continue;
            }
            this.storeSize += r.length();
            this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        }
    }

    int versionsToReturn(int wantedVersions) {
        if (wantedVersions <= 0) {
            throw new IllegalArgumentException("Number of versions must be > 0");
        }
        int maxVersions = this.family.getMaxVersions();
        return wantedVersions > maxVersions ? maxVersions : wantedVersions;
    }

    @Override
    public boolean canSplit() {
        this.lock.readLock().lock();
        try {
            boolean result;
            boolean bl = result = !this.hasReferences();
            if (!result) {
                LOG.trace("Not splittable; has references: {}", (Object)this);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<byte[]> getSplitPoint() {
        this.lock.readLock().lock();
        try {
            assert (!this.getRegionInfo().isMetaRegion());
            if (this.hasReferences()) {
                LOG.trace("Not splittable; has references: {}", (Object)this);
                Optional<byte[]> optional = Optional.empty();
                return optional;
            }
            Optional<byte[]> optional = this.storeEngine.getStoreFileManager().getSplitPoint();
            return optional;
        }
        catch (IOException e) {
            LOG.warn("Failed getting store size for {}", (Object)this, (Object)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Optional.empty();
    }

    @Override
    public long getLastCompactSize() {
        return this.lastCompactSize;
    }

    @Override
    public long getSize() {
        return this.storeSize;
    }

    public void triggerMajorCompaction() {
        this.forceMajor = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValueScanner getScanner(Scan scan, NavigableSet<byte[]> targetCols, long readPt) throws IOException {
        this.lock.readLock().lock();
        try {
            ScanInfo scanInfo = this.getCoprocessorHost() != null ? this.getCoprocessorHost().preStoreScannerOpen(this) : this.getScanInfo();
            KeyValueScanner keyValueScanner = this.createScanner(scan, scanInfo, targetCols, readPt);
            return keyValueScanner;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected KeyValueScanner createScanner(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> targetCols, long readPt) throws IOException {
        return scan.isReversed() ? new ReversedStoreScanner(this, scanInfo, scan, targetCols, readPt) : new StoreScanner(this, scanInfo, scan, targetCols, readPt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValueScanner> recreateScanners(List<KeyValueScanner> currentFileScanners, boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
        this.lock.readLock().lock();
        try {
            Object object;
            HashMap<String, HStoreFile> name2File = new HashMap<String, HStoreFile>(this.getStorefilesCount() + this.getCompactedFilesCount());
            for (HStoreFile hStoreFile : this.getStorefiles()) {
                name2File.put(hStoreFile.getFileInfo().getActiveFileName(), hStoreFile);
            }
            Collection<HStoreFile> compactedFiles = this.getCompactedFiles();
            for (HStoreFile file : IterableUtils.emptyIfNull(compactedFiles)) {
                name2File.put(file.getFileInfo().getActiveFileName(), file);
            }
            ArrayList<HStoreFile> arrayList = new ArrayList<HStoreFile>();
            for (KeyValueScanner kvs : currentFileScanners) {
                assert (kvs.isFileScanner());
                if (kvs.peek() == null) continue;
                arrayList.add((HStoreFile)name2File.get(kvs.getFilePath().getName()));
            }
            if (arrayList.isEmpty()) {
                object = null;
                return object;
            }
            object = this.getScanners(arrayList, cacheBlocks, false, false, matcher, startRow, includeStartRow, stopRow, includeStopRow, readPt, false);
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.getColumnFamilyName();
    }

    @Override
    public int getStorefilesCount() {
        return this.storeEngine.getStoreFileManager().getStorefileCount();
    }

    @Override
    public int getCompactedFilesCount() {
        return this.storeEngine.getStoreFileManager().getCompactedFilesCount();
    }

    private LongStream getStoreFileAgeStream() {
        return this.storeEngine.getStoreFileManager().getStorefiles().stream().filter(sf -> {
            if (sf.getReader() == null) {
                LOG.warn("StoreFile {} has a null Reader", sf);
                return false;
            }
            return true;
        }).filter(HStoreFile::isHFile).mapToLong(sf -> sf.getFileInfo().getCreatedTimestamp()).map(t -> EnvironmentEdgeManager.currentTime() - t);
    }

    @Override
    public OptionalLong getMaxStoreFileAge() {
        return this.getStoreFileAgeStream().max();
    }

    @Override
    public OptionalLong getMinStoreFileAge() {
        return this.getStoreFileAgeStream().min();
    }

    @Override
    public OptionalDouble getAvgStoreFileAge() {
        return this.getStoreFileAgeStream().average();
    }

    @Override
    public long getNumReferenceFiles() {
        return this.storeEngine.getStoreFileManager().getStorefiles().stream().filter(HStoreFile::isReference).count();
    }

    @Override
    public long getNumHFiles() {
        return this.storeEngine.getStoreFileManager().getStorefiles().stream().filter(HStoreFile::isHFile).count();
    }

    @Override
    public long getStoreSizeUncompressed() {
        return this.totalUncompressedBytes;
    }

    @Override
    public long getStorefilesSize() {
        return this.getStorefilesSize(storeFile -> true);
    }

    @Override
    public long getHFilesSize() {
        return this.getStorefilesSize(storeFile -> storeFile.isHFile());
    }

    private long getStorefilesSize(Predicate<HStoreFile> predicate) {
        return this.storeEngine.getStoreFileManager().getStorefiles().stream().filter(sf -> {
            if (sf.getReader() == null) {
                LOG.warn("StoreFile {} has a null Reader", sf);
                return false;
            }
            return true;
        }).filter(predicate).mapToLong(sf -> sf.getReader().length()).sum();
    }

    private long getStoreFileFieldSize(ToLongFunction<StoreFileReader> f) {
        return this.storeEngine.getStoreFileManager().getStorefiles().stream().filter(sf -> {
            if (sf.getReader() == null) {
                LOG.warn("StoreFile {} has a null Reader", sf);
                return false;
            }
            return true;
        }).map(HStoreFile::getReader).mapToLong(f).sum();
    }

    @Override
    public long getStorefilesRootLevelIndexSize() {
        return this.getStoreFileFieldSize(StoreFileReader::indexSize);
    }

    @Override
    public long getTotalStaticIndexSize() {
        return this.getStoreFileFieldSize(StoreFileReader::getUncompressedDataIndexSize);
    }

    @Override
    public long getTotalStaticBloomSize() {
        return this.getStoreFileFieldSize(StoreFileReader::getTotalBloomSize);
    }

    @Override
    public MemStoreSize getMemStoreSize() {
        return this.memstore.size();
    }

    @Override
    public int getCompactPriority() {
        int priority = this.storeEngine.getStoreFileManager().getStoreCompactionPriority();
        if (priority == 1) {
            LOG.warn("Compaction priority is USER despite there being no user compaction");
        }
        return priority;
    }

    public boolean throttleCompaction(long compactionSize) {
        return this.storeEngine.getCompactionPolicy().throttleCompaction(compactionSize);
    }

    public HRegion getHRegion() {
        return this.region;
    }

    public RegionCoprocessorHost getCoprocessorHost() {
        return this.region.getCoprocessorHost();
    }

    @Override
    public RegionInfo getRegionInfo() {
        return this.fs.getRegionInfo();
    }

    @Override
    public boolean areWritesEnabled() {
        return this.region.areWritesEnabled();
    }

    @Override
    public long getSmallestReadPoint() {
        return this.region.getSmallestReadPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsert(Iterable<Cell> cells, long readpoint, MemStoreSizing memstoreSizing) throws IOException {
        this.lock.readLock().lock();
        try {
            this.memstore.upsert(cells, readpoint, memstoreSizing);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public StoreFlushContext createFlushContext(long cacheFlushId, FlushLifeCycleTracker tracker) {
        return new StoreFlusherImpl(cacheFlushId, tracker);
    }

    @Override
    public boolean needsCompaction() {
        return this.storeEngine.needsCompaction(this.filesCompacting);
    }

    @VisibleForTesting
    public CacheConfig getCacheConfig() {
        return this.cacheConf;
    }

    public long heapSize() {
        MemStoreSize memstoreSize = this.memstore.size();
        return DEEP_OVERHEAD + memstoreSize.getHeapSize();
    }

    @Override
    public CellComparator getComparator() {
        return this.comparator;
    }

    public ScanInfo getScanInfo() {
        return this.scanInfo;
    }

    void setScanInfo(ScanInfo scanInfo) {
        this.scanInfo = scanInfo;
    }

    @Override
    public boolean hasTooManyStoreFiles() {
        return (long)this.getStorefilesCount() > this.blockingFileCount;
    }

    @Override
    public long getFlushedCellsCount() {
        return this.flushedCellsCount;
    }

    @Override
    public long getFlushedCellsSize() {
        return this.flushedCellsSize;
    }

    @Override
    public long getFlushedOutputFileSize() {
        return this.flushedOutputFileSize;
    }

    @Override
    public long getCompactedCellsCount() {
        return this.compactedCellsCount;
    }

    @Override
    public long getCompactedCellsSize() {
        return this.compactedCellsSize;
    }

    @Override
    public long getMajorCompactedCellsCount() {
        return this.majorCompactedCellsCount;
    }

    @Override
    public long getMajorCompactedCellsSize() {
        return this.majorCompactedCellsSize;
    }

    @VisibleForTesting
    public StoreEngine<?, ?, ?, ?> getStoreEngine() {
        return this.storeEngine;
    }

    protected OffPeakHours getOffPeakHours() {
        return this.offPeakHours;
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.conf = new CompoundConfiguration().add(conf).addBytesMap(this.family.getValues());
        ((CompactionPolicy)this.storeEngine.compactionPolicy).setConf(conf);
        this.offPeakHours = OffPeakHours.getInstance(conf);
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
    }

    @Override
    public double getCompactionPressure() {
        return this.storeEngine.getStoreFileManager().getCompactionPressure();
    }

    @Override
    public boolean isPrimaryReplicaStore() {
        return this.getRegionInfo().getReplicaId() == 0;
    }

    public void preSnapshotOperation() {
        this.archiveLock.lock();
    }

    public void postSnapshotOperation() {
        this.archiveLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeAndArchiveCompactedFiles() throws IOException {
        this.archiveLock.lock();
        try {
            this.lock.readLock().lock();
            ArrayList<HStoreFile> copyCompactedfiles = null;
            try {
                Collection<HStoreFile> compactedfiles = this.getStoreEngine().getStoreFileManager().getCompactedfiles();
                if (CollectionUtils.isNotEmpty(compactedfiles)) {
                    copyCompactedfiles = new ArrayList<HStoreFile>(compactedfiles);
                } else {
                    LOG.trace("No compacted files to archive");
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (CollectionUtils.isNotEmpty(copyCompactedfiles)) {
                this.removeCompactedfiles(copyCompactedfiles);
            }
        }
        finally {
            this.archiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCompactedfiles(Collection<HStoreFile> compactedfiles) throws IOException {
        ArrayList<HStoreFile> filesToRemove = new ArrayList<HStoreFile>(compactedfiles.size());
        Iterator<HStoreFile> iterator = compactedfiles.iterator();
        while (iterator.hasNext()) {
            HStoreFile file;
            HStoreFile hStoreFile = file = iterator.next();
            synchronized (hStoreFile) {
                try {
                    StoreFileReader r = file.getReader();
                    if (r == null) {
                        LOG.debug("The file {} was closed but still not archived", (Object)file);
                        filesToRemove.add(file);
                        continue;
                    }
                    if (file.isCompactedAway() && !file.isReferencedInReads()) {
                        LOG.trace("Closing and archiving the file {}", (Object)file);
                        r.close(true);
                        filesToRemove.add(file);
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception while trying to close the compacted store file {}", (Object)file.getPath(), (Object)e);
                }
            }
        }
        if (this.isPrimaryReplicaStore() && !filesToRemove.isEmpty()) {
            LOG.debug("Moving the files {} to archive", filesToRemove);
            try {
                this.fs.removeStoreFiles(this.getColumnFamilyDescriptor().getNameAsString(), filesToRemove);
            }
            catch (FailedArchiveException fae) {
                Collection<Path> failedFiles = fae.getFailedFiles();
                Iterator iter = filesToRemove.iterator();
                while (iter.hasNext()) {
                    if (!failedFiles.contains(((HStoreFile)iter.next()).getPath())) continue;
                    iter.remove();
                }
                if (!filesToRemove.isEmpty()) {
                    this.clearCompactedfiles(filesToRemove);
                }
                throw fae;
            }
        }
        if (!filesToRemove.isEmpty()) {
            this.clearCompactedfiles(filesToRemove);
        }
    }

    public Long preFlushSeqIDEstimation() {
        return this.memstore.preFlushSeqIDEstimation();
    }

    @Override
    public boolean isSloppyMemStore() {
        return this.memstore.isSloppy();
    }

    private void clearCompactedfiles(List<HStoreFile> filesToRemove) throws IOException {
        LOG.trace("Clearing the compacted file {} from this store", filesToRemove);
        try {
            this.lock.writeLock().lock();
            this.getStoreEngine().getStoreFileManager().removeCompactedFiles(filesToRemove);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private final class StoreFlusherImpl
    implements StoreFlushContext {
        private final FlushLifeCycleTracker tracker;
        private final long cacheFlushSeqNum;
        private MemStoreSnapshot snapshot;
        private List<Path> tempFiles;
        private List<Path> committedFiles;
        private long cacheFlushCount;
        private long cacheFlushSize;
        private long outputFileSize;

        private StoreFlusherImpl(long cacheFlushSeqNum, FlushLifeCycleTracker tracker) {
            this.cacheFlushSeqNum = cacheFlushSeqNum;
            this.tracker = tracker;
        }

        @Override
        public MemStoreSize prepare() {
            this.snapshot = HStore.this.memstore.snapshot();
            this.cacheFlushCount = this.snapshot.getCellsCount();
            this.cacheFlushSize = this.snapshot.getDataSize();
            this.committedFiles = new ArrayList<Path>(1);
            return new MemStoreSize(this.snapshot.getDataSize(), this.snapshot.getHeapSize());
        }

        @Override
        public void flushCache(MonitoredTask status) throws IOException {
            RegionServerServices rsService = HStore.this.region.getRegionServerServices();
            ThroughputController throughputController = rsService == null ? null : rsService.getFlushThroughputController();
            this.tempFiles = HStore.this.flushCache(this.cacheFlushSeqNum, this.snapshot, status, throughputController, this.tracker);
        }

        @Override
        public boolean commit(MonitoredTask status) throws IOException {
            if (CollectionUtils.isEmpty(this.tempFiles)) {
                return false;
            }
            ArrayList<HStoreFile> storeFiles = new ArrayList<HStoreFile>(this.tempFiles.size());
            for (Path storeFilePath : this.tempFiles) {
                try {
                    HStoreFile sf = HStore.this.commitFile(storeFilePath, this.cacheFlushSeqNum, status);
                    this.outputFileSize += sf.getReader().length();
                    storeFiles.add(sf);
                }
                catch (IOException ex) {
                    LOG.error("Failed to commit store file {}", (Object)storeFilePath, (Object)ex);
                    for (HStoreFile sf : storeFiles) {
                        Path pathToDelete = sf.getPath();
                        try {
                            sf.deleteStoreFile();
                        }
                        catch (IOException deleteEx) {
                            LOG.error(HBaseMarkers.FATAL, "Failed to delete store file we committed, halting {}", (Object)pathToDelete, (Object)ex);
                            Runtime.getRuntime().halt(1);
                        }
                    }
                    throw new IOException("Failed to commit the flush", ex);
                }
            }
            for (HStoreFile sf : storeFiles) {
                if (HStore.this.getCoprocessorHost() != null) {
                    HStore.this.getCoprocessorHost().postFlush(HStore.this, sf, this.tracker);
                }
                this.committedFiles.add(sf.getPath());
            }
            Object object = HStore.this;
            ((HStore)object).flushedCellsCount = ((HStore)object).flushedCellsCount + this.cacheFlushCount;
            object = HStore.this;
            ((HStore)object).flushedCellsSize = ((HStore)object).flushedCellsSize + this.cacheFlushSize;
            object = HStore.this;
            ((HStore)object).flushedOutputFileSize = ((HStore)object).flushedOutputFileSize + this.outputFileSize;
            return HStore.this.updateStorefiles(storeFiles, this.snapshot.getId());
        }

        @Override
        public long getOutputFileSize() {
            return this.outputFileSize;
        }

        @Override
        public List<Path> getCommittedFiles() {
            return this.committedFiles;
        }

        @Override
        public void replayFlush(List<String> fileNames, boolean dropMemstoreSnapshot) throws IOException {
            ArrayList<HStoreFile> storeFiles = new ArrayList<HStoreFile>(fileNames.size());
            for (String file : fileNames) {
                StoreFileInfo storeFileInfo = HStore.this.fs.getStoreFileInfo(HStore.this.getColumnFamilyName(), file);
                HStoreFile storeFile = HStore.this.createStoreFileAndReader(storeFileInfo);
                storeFiles.add(storeFile);
                HStore hStore = HStore.this;
                hStore.storeSize = hStore.storeSize + storeFile.getReader().length();
                hStore = HStore.this;
                hStore.totalUncompressedBytes = hStore.totalUncompressedBytes + storeFile.getReader().getTotalUncompressedBytes();
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Region: " + HStore.this.getRegionInfo().getEncodedName() + " added " + storeFile + ", entries=" + storeFile.getReader().getEntries() + ", sequenceid=" + storeFile.getReader().getSequenceID() + ", filesize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)storeFile.getReader().length(), (String)"", (int)1));
            }
            long snapshotId = -1L;
            if (dropMemstoreSnapshot && this.snapshot != null) {
                snapshotId = this.snapshot.getId();
            }
            HStore.this.updateStorefiles(storeFiles, snapshotId);
        }

        @Override
        public void abort() throws IOException {
            if (this.snapshot != null) {
                HStore.this.updateStorefiles(Collections.emptyList(), this.snapshot.getId());
            }
        }
    }
}

