/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.MemoryType;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.FlushType;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServerAccounting {
    private final LongAdder globalMemstoreDataSize = new LongAdder();
    private final LongAdder globalMemstoreHeapSize = new LongAdder();
    private final ConcurrentMap<byte[], MemStoreSizing> replayEditsPerRegion = new ConcurrentSkipListMap<byte[], MemStoreSizing>(Bytes.BYTES_COMPARATOR);
    private long globalMemStoreLimit;
    private final float globalMemStoreLimitLowMarkPercent;
    private long globalMemStoreLimitLowMark;
    private final MemoryType memType;
    private long globalOnHeapMemstoreLimit;
    private long globalOnHeapMemstoreLimitLowMark;

    public RegionServerAccounting(Configuration conf) {
        Pair<Long, MemoryType> globalMemstoreSizePair = MemorySizeUtil.getGlobalMemStoreSize(conf);
        this.globalMemStoreLimit = (Long)globalMemstoreSizePair.getFirst();
        this.memType = (MemoryType)((Object)globalMemstoreSizePair.getSecond());
        this.globalMemStoreLimitLowMarkPercent = MemorySizeUtil.getGlobalMemStoreHeapLowerMark(conf, this.memType == MemoryType.HEAP);
        this.globalMemStoreLimitLowMark = (long)((float)this.globalMemStoreLimit * this.globalMemStoreLimitLowMarkPercent);
        this.globalOnHeapMemstoreLimit = MemorySizeUtil.getOnheapGlobalMemStoreSize(conf);
        this.globalOnHeapMemstoreLimitLowMark = (long)((float)this.globalOnHeapMemstoreLimit * this.globalMemStoreLimitLowMarkPercent);
    }

    long getGlobalMemStoreLimit() {
        return this.globalMemStoreLimit;
    }

    long getGlobalOnHeapMemStoreLimit() {
        return this.globalOnHeapMemstoreLimit;
    }

    void setGlobalMemStoreLimits(long newGlobalMemstoreLimit) {
        if (this.memType == MemoryType.HEAP) {
            this.globalMemStoreLimit = newGlobalMemstoreLimit;
            this.globalMemStoreLimitLowMark = (long)((float)this.globalMemStoreLimit * this.globalMemStoreLimitLowMarkPercent);
        } else {
            this.globalOnHeapMemstoreLimit = newGlobalMemstoreLimit;
            this.globalOnHeapMemstoreLimitLowMark = (long)((float)this.globalOnHeapMemstoreLimit * this.globalMemStoreLimitLowMarkPercent);
        }
    }

    boolean isOffheap() {
        return this.memType == MemoryType.NON_HEAP;
    }

    long getGlobalMemStoreLimitLowMark() {
        return this.globalMemStoreLimitLowMark;
    }

    float getGlobalMemStoreLimitLowMarkPercent() {
        return this.globalMemStoreLimitLowMarkPercent;
    }

    public long getGlobalMemStoreDataSize() {
        return this.globalMemstoreDataSize.sum();
    }

    public long getGlobalMemStoreHeapSize() {
        return this.globalMemstoreHeapSize.sum();
    }

    public void incGlobalMemStoreSize(MemStoreSize memStoreSize) {
        this.globalMemstoreDataSize.add(memStoreSize.getDataSize());
        this.globalMemstoreHeapSize.add(memStoreSize.getHeapSize());
    }

    public void decGlobalMemStoreSize(MemStoreSize memStoreSize) {
        this.globalMemstoreDataSize.add(-memStoreSize.getDataSize());
        this.globalMemstoreHeapSize.add(-memStoreSize.getHeapSize());
    }

    public FlushType isAboveHighWaterMark() {
        if (this.memType == MemoryType.HEAP) {
            if (this.getGlobalMemStoreHeapSize() >= this.globalMemStoreLimit) {
                return FlushType.ABOVE_ONHEAP_HIGHER_MARK;
            }
        } else {
            if (this.getGlobalMemStoreDataSize() >= this.globalMemStoreLimit) {
                return FlushType.ABOVE_OFFHEAP_HIGHER_MARK;
            }
            if (this.getGlobalMemStoreHeapSize() >= this.globalOnHeapMemstoreLimit) {
                return FlushType.ABOVE_ONHEAP_HIGHER_MARK;
            }
        }
        return FlushType.NORMAL;
    }

    public FlushType isAboveLowWaterMark() {
        if (this.memType == MemoryType.HEAP) {
            if (this.getGlobalMemStoreHeapSize() >= this.globalMemStoreLimitLowMark) {
                return FlushType.ABOVE_ONHEAP_LOWER_MARK;
            }
        } else {
            if (this.getGlobalMemStoreDataSize() >= this.globalMemStoreLimitLowMark) {
                return FlushType.ABOVE_OFFHEAP_LOWER_MARK;
            }
            if (this.getGlobalMemStoreHeapSize() >= this.globalOnHeapMemstoreLimitLowMark) {
                return FlushType.ABOVE_ONHEAP_LOWER_MARK;
            }
        }
        return FlushType.NORMAL;
    }

    public double getFlushPressure() {
        if (this.memType == MemoryType.HEAP) {
            return (double)this.getGlobalMemStoreHeapSize() * 1.0 / (double)this.globalMemStoreLimitLowMark;
        }
        return Math.max((double)this.getGlobalMemStoreDataSize() * 1.0 / (double)this.globalMemStoreLimitLowMark, (double)this.getGlobalMemStoreHeapSize() * 1.0 / (double)this.globalOnHeapMemstoreLimitLowMark);
    }

    public void addRegionReplayEditsSize(byte[] regionName, MemStoreSize memStoreSize) {
        MemStoreSizing replayEdistsSize = (MemStoreSizing)this.replayEditsPerRegion.get(regionName);
        if (replayEdistsSize == null) {
            replayEdistsSize = new MemStoreSizing();
            this.replayEditsPerRegion.put(regionName, replayEdistsSize);
        }
        replayEdistsSize.incMemStoreSize(memStoreSize);
    }

    public void rollbackRegionReplayEditsSize(byte[] regionName) {
        MemStoreSize replayEditsSize = (MemStoreSize)this.replayEditsPerRegion.get(regionName);
        if (replayEditsSize != null) {
            this.clearRegionReplayEditsSize(regionName);
            this.decGlobalMemStoreSize(replayEditsSize);
        }
    }

    public void clearRegionReplayEditsSize(byte[] regionName) {
        this.replayEditsPerRegion.remove(regionName);
    }
}

