/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ReplicationPeerConfigUpgrader
extends ReplicationStateZKBase {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationPeerConfigUpgrader.class);

    public ReplicationPeerConfigUpgrader(ZKWatcher zookeeper, Configuration conf, Abortable abortable) {
        super(zookeeper, conf, abortable);
    }

    public void upgrade() throws Exception {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);){
            Admin admin = conn.getAdmin();
            admin.listReplicationPeers().forEach(peerDesc -> {
                String peerId = peerDesc.getPeerId();
                ReplicationPeerConfig peerConfig = peerDesc.getPeerConfig();
                if (peerConfig.getNamespaces() != null && !peerConfig.getNamespaces().isEmpty() || peerConfig.getTableCFsMap() != null && !peerConfig.getTableCFsMap().isEmpty()) {
                    peerConfig.setReplicateAllUserTables(false);
                    try {
                        admin.updateReplicationPeerConfig(peerId, peerConfig);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to upgrade replication peer config for peerId=" + peerId, (Throwable)e);
                    }
                }
            });
        }
    }

    public void copyTableCFs() {
        List znodes = null;
        try {
            znodes = ZKUtil.listChildrenNoWatch((ZKWatcher)this.zookeeper, (String)this.peersZNode);
        }
        catch (KeeperException e) {
            LOG.error("Failed to get peers znode", (Throwable)e);
        }
        if (znodes != null) {
            for (String peerId : znodes) {
                if (this.copyTableCFs(peerId)) continue;
                LOG.error("upgrade tableCFs failed for peerId=" + peerId);
            }
        }
    }

    public boolean copyTableCFs(String peerId) {
        String tableCFsNode = this.getTableCFsNode(peerId);
        try {
            if (ZKUtil.checkExists((ZKWatcher)this.zookeeper, (String)tableCFsNode) != -1) {
                String peerNode = this.getPeerNode(peerId);
                ReplicationPeerConfig rpc = this.getReplicationPeerConig(peerNode);
                if (rpc.getTableCFsMap() == null || rpc.getTableCFsMap().isEmpty()) {
                    LOG.info("copy tableCFs into peerNode:" + peerId);
                    ReplicationProtos.TableCF[] tableCFs = ReplicationPeerConfigUtil.parseTableCFs((byte[])ZKUtil.getData((ZKWatcher)this.zookeeper, (String)tableCFsNode));
                    if (tableCFs != null && tableCFs.length > 0) {
                        rpc.setTableCFsMap(ReplicationPeerConfigUtil.convert2Map((ReplicationProtos.TableCF[])tableCFs));
                        ZKUtil.setData((ZKWatcher)this.zookeeper, (String)peerNode, (byte[])ReplicationPeerConfigUtil.toByteArray((ReplicationPeerConfig)rpc));
                    }
                } else {
                    LOG.info("No tableCFs in peerNode:" + peerId);
                }
            }
        }
        catch (KeeperException e) {
            LOG.warn("NOTICE!! Update peerId failed, peerId=" + peerId, (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn("NOTICE!! Update peerId failed, peerId=" + peerId, (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOG.warn("NOTICE!! Update peerId failed, peerId=" + peerId, (Throwable)e);
            return false;
        }
        return true;
    }

    private ReplicationPeerConfig getReplicationPeerConig(String peerNode) throws KeeperException, InterruptedException {
        byte[] data = null;
        data = ZKUtil.getData((ZKWatcher)this.zookeeper, (String)peerNode);
        if (data == null) {
            LOG.error("Could not get configuration for peer because it doesn't exist. peer=" + peerNode);
            return null;
        }
        try {
            return ReplicationPeerConfigUtil.parsePeerFrom((byte[])data);
        }
        catch (DeserializationException e) {
            LOG.warn("Failed to parse cluster key from peer=" + peerNode);
            return null;
        }
    }

    private static void printUsageAndExit() {
        System.err.printf("Usage: hbase org.apache.hadoop.hbase.replication.master.ReplicationPeerConfigUpgrader [options]", new Object[0]);
        System.err.println(" where [options] are:");
        System.err.println("  -h|-help      Show this help and exit.");
        System.err.println("  copyTableCFs  Copy table-cfs to replication peer config");
        System.err.println("  upgrade           Upgrade replication peer config to new format");
        System.err.println();
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            ReplicationPeerConfigUpgrader.printUsageAndExit();
        }
        if (args[0].equals("-help") || args[0].equals("-h")) {
            ReplicationPeerConfigUpgrader.printUsageAndExit();
        } else if (args[0].equals("copyTableCFs")) {
            Configuration conf = HBaseConfiguration.create();
            try (ZKWatcher zkw = new ZKWatcher(conf, "ReplicationPeerConfigUpgrader", null);){
                ReplicationPeerConfigUpgrader tableCFsUpdater = new ReplicationPeerConfigUpgrader(zkw, conf, null);
                tableCFsUpdater.copyTableCFs();
            }
        } else if (args[0].equals("upgrade")) {
            Configuration conf = HBaseConfiguration.create();
            ZKWatcher zkw = new ZKWatcher(conf, "ReplicationPeerConfigUpgrader", null);
            ReplicationPeerConfigUpgrader upgrader = new ReplicationPeerConfigUpgrader(zkw, conf, null);
            upgrader.upgrade();
        } else {
            ReplicationPeerConfigUpgrader.printUsageAndExit();
        }
    }
}

