/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface WAL
extends Closeable,
WALFileLengthProvider {
    public void registerWALActionsListener(WALActionsListener var1);

    public boolean unregisterWALActionsListener(WALActionsListener var1);

    public byte[][] rollWriter() throws FailedLogCloseException, IOException;

    public byte[][] rollWriter(boolean var1) throws FailedLogCloseException, IOException;

    public void shutdown() throws IOException;

    @Override
    public void close() throws IOException;

    public long append(RegionInfo var1, WALKeyImpl var2, WALEdit var3, boolean var4) throws IOException;

    public void updateStore(byte[] var1, byte[] var2, Long var3, boolean var4);

    public void sync() throws IOException;

    public void sync(long var1) throws IOException;

    public Long startCacheFlush(byte[] var1, Set<byte[]> var2);

    public Long startCacheFlush(byte[] var1, Map<byte[], Long> var2);

    public void completeCacheFlush(byte[] var1);

    public void abortCacheFlush(byte[] var1);

    public WALCoprocessorHost getCoprocessorHost();

    @Deprecated
    @VisibleForTesting
    public long getEarliestMemStoreSeqNum(byte[] var1);

    public long getEarliestMemStoreSeqNum(byte[] var1, byte[] var2);

    public String toString();

    public static class Entry {
        private final WALEdit edit;
        private final WALKeyImpl key;

        public Entry() {
            this(new WALKeyImpl(), new WALEdit());
        }

        public Entry(WALKeyImpl key, WALEdit edit) {
            this.key = key;
            this.edit = edit;
        }

        public WALEdit getEdit() {
            return this.edit;
        }

        public WALKeyImpl getKey() {
            return this.key;
        }

        public void setCompressionContext(CompressionContext compressionContext) {
            this.key.setCompressionContext(compressionContext);
        }

        public boolean hasSerialReplicationScope() {
            if (this.getKey().getReplicationScopes() == null || this.getKey().getReplicationScopes().isEmpty()) {
                return false;
            }
            for (Map.Entry e : this.getKey().getReplicationScopes().entrySet()) {
                if ((Integer)e.getValue() != 2) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.edit;
        }
    }

    public static interface Reader
    extends Closeable {
        public Entry next() throws IOException;

        public Entry next(Entry var1) throws IOException;

        public void seek(long var1) throws IOException;

        public long getPosition() throws IOException;

        public void reset() throws IOException;
    }
}

