/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ColumnCountOnRowFilter
extends FilterBase {
    private final int limit;
    private int count = 0;

    public ColumnCountOnRowFilter(int limit) {
        this.limit = limit;
    }

    public Filter.ReturnCode filterCell(Cell c) {
        ++this.count;
        return this.count > this.limit ? Filter.ReturnCode.NEXT_ROW : Filter.ReturnCode.INCLUDE;
    }

    public void reset() throws IOException {
        this.count = 0;
    }

    public byte[] toByteArray() throws IOException {
        return Bytes.toBytes((int)this.limit);
    }

    public static ColumnCountOnRowFilter parseFrom(byte[] bytes) throws DeserializationException {
        return new ColumnCountOnRowFilter(Bytes.toInt((byte[])bytes));
    }
}

