/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncReplicationAdminApi
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncReplicationAdminApi.class);
    private final String ID_ONE = "1";
    private final String KEY_ONE = "127.0.0.1:2181:/hbase";
    private final String ID_SECOND = "2";
    private final String KEY_SECOND = "127.0.0.1:2181:/hbase2";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
        TEST_UTIL.startMiniCluster();
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @After
    public void cleanupPeer() {
        try {
            this.admin.removeReplicationPeer("1").join();
        }
        catch (Exception e) {
            LOG.debug("Replication peer 1 may already be removed");
        }
        try {
            this.admin.removeReplicationPeer("2").join();
        }
        catch (Exception e) {
            LOG.debug("Replication peer 2 may already be removed");
        }
    }

    @Test
    public void testAddRemovePeer() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        ReplicationPeerConfig rpc2 = new ReplicationPeerConfig();
        rpc2.setClusterKey("127.0.0.1:2181:/hbase2");
        this.admin.addReplicationPeer("1", rpc1).join();
        try {
            this.admin.addReplicationPeer("1", rpc1).join();
            Assert.fail((String)"Test case should fail as adding a same peer.");
        }
        catch (CompletionException completionException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)((List)this.admin.listReplicationPeers().get()).size());
        try {
            this.admin.removeReplicationPeer("2").join();
            Assert.fail((String)"Test case should fail as removing a inexisting peer.");
        }
        catch (CompletionException completionException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)((List)this.admin.listReplicationPeers().get()).size());
        this.admin.addReplicationPeer("2", rpc2).join();
        Assert.assertEquals((long)2L, (long)((List)this.admin.listReplicationPeers().get()).size());
        this.admin.removeReplicationPeer("1").join();
        Assert.assertEquals((long)1L, (long)((List)this.admin.listReplicationPeers().get()).size());
        this.admin.removeReplicationPeer("2").join();
        Assert.assertEquals((long)0L, (long)((List)this.admin.listReplicationPeers().get()).size());
    }

    @Test
    public void testPeerConfig() throws Exception {
        ReplicationPeerConfig config = new ReplicationPeerConfig();
        config.setClusterKey("127.0.0.1:2181:/hbase");
        config.getConfiguration().put("key1", "value1");
        config.getConfiguration().put("key2", "value2");
        this.admin.addReplicationPeer("1", config).join();
        List peers = (List)this.admin.listReplicationPeers().get();
        Assert.assertEquals((long)1L, (long)peers.size());
        ReplicationPeerDescription peerOne = (ReplicationPeerDescription)peers.get(0);
        Assert.assertNotNull((Object)peerOne);
        Assert.assertEquals((Object)"value1", peerOne.getPeerConfig().getConfiguration().get("key1"));
        Assert.assertEquals((Object)"value2", peerOne.getPeerConfig().getConfiguration().get("key2"));
        this.admin.removeReplicationPeer("1").join();
    }

    @Test
    public void testEnableDisablePeer() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        this.admin.addReplicationPeer("1", rpc1).join();
        List peers = (List)this.admin.listReplicationPeers().get();
        Assert.assertEquals((long)1L, (long)peers.size());
        Assert.assertTrue((boolean)((ReplicationPeerDescription)peers.get(0)).isEnabled());
        this.admin.disableReplicationPeer("1").join();
        peers = (List)this.admin.listReplicationPeers().get();
        Assert.assertEquals((long)1L, (long)peers.size());
        Assert.assertFalse((boolean)((ReplicationPeerDescription)peers.get(0)).isEnabled());
        this.admin.removeReplicationPeer("1").join();
    }

    @Test
    public void testAppendPeerTableCFs() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        TableName tableName1 = TableName.valueOf((String)(this.tableName.getNameAsString() + "t1"));
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "t2"));
        TableName tableName3 = TableName.valueOf((String)(this.tableName.getNameAsString() + "t3"));
        TableName tableName4 = TableName.valueOf((String)(this.tableName.getNameAsString() + "t4"));
        TableName tableName5 = TableName.valueOf((String)(this.tableName.getNameAsString() + "t5"));
        TableName tableName6 = TableName.valueOf((String)(this.tableName.getNameAsString() + "t6"));
        this.admin.addReplicationPeer("1", rpc1).join();
        rpc1.setReplicateAllUserTables(false);
        this.admin.updateReplicationPeerConfig("1", rpc1).join();
        HashMap tableCFs = new HashMap();
        tableCFs.put(tableName1, null);
        this.admin.appendReplicationPeerTableCFs("1", tableCFs).join();
        Map result = ((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)true, (Object)result.containsKey(tableName1));
        Assert.assertNull(result.get(tableName1));
        tableCFs.clear();
        tableCFs.put(tableName2, null);
        this.admin.appendReplicationPeerTableCFs("1", tableCFs).join();
        result = ((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertNull(result.get(tableName1));
        Assert.assertNull(result.get(tableName2));
        tableCFs.clear();
        tableCFs.put(tableName3, new ArrayList());
        ((List)tableCFs.get(tableName3)).add("f1");
        this.admin.appendReplicationPeerTableCFs("1", tableCFs).join();
        result = ((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertTrue((String)"Should contain t3", (boolean)result.containsKey(tableName3));
        Assert.assertNull(result.get(tableName1));
        Assert.assertNull(result.get(tableName2));
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName3)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tableName3)).get(0));
        tableCFs.clear();
        tableCFs.put(tableName4, new ArrayList());
        ((List)tableCFs.get(tableName4)).add("f1");
        ((List)tableCFs.get(tableName4)).add("f2");
        this.admin.appendReplicationPeerTableCFs("1", tableCFs).join();
        result = ((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap();
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertTrue((String)"Should contain t3", (boolean)result.containsKey(tableName3));
        Assert.assertTrue((String)"Should contain t4", (boolean)result.containsKey(tableName4));
        Assert.assertNull(result.get(tableName1));
        Assert.assertNull(result.get(tableName2));
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName3)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tableName3)).get(0));
        Assert.assertEquals((long)2L, (long)((List)result.get(tableName4)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tableName4)).get(0));
        Assert.assertEquals((Object)"f2", ((List)result.get(tableName4)).get(1));
        tableCFs.clear();
        tableCFs.put(tableName5, new ArrayList());
        this.admin.appendReplicationPeerTableCFs("1", tableCFs).join();
        tableCFs.clear();
        tableCFs.put(tableName5, new ArrayList());
        ((List)tableCFs.get(tableName5)).add("f1");
        this.admin.appendReplicationPeerTableCFs("1", tableCFs).join();
        result = ((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap();
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertTrue((String)"Should contain t5", (boolean)result.containsKey(tableName5));
        Assert.assertNull(result.get(tableName5));
        tableCFs.clear();
        tableCFs.put(tableName6, new ArrayList());
        ((List)tableCFs.get(tableName6)).add("f1");
        this.admin.appendReplicationPeerTableCFs("1", tableCFs).join();
        tableCFs.clear();
        tableCFs.put(tableName6, new ArrayList());
        this.admin.appendReplicationPeerTableCFs("1", tableCFs).join();
        result = ((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap();
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertTrue((String)"Should contain t6", (boolean)result.containsKey(tableName6));
        Assert.assertNull(result.get(tableName6));
        this.admin.removeReplicationPeer("1").join();
    }

    @Test
    public void testRemovePeerTableCFs() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        TableName tableName1 = TableName.valueOf((String)(this.tableName.getNameAsString() + "t1"));
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "t2"));
        TableName tableName3 = TableName.valueOf((String)(this.tableName.getNameAsString() + "t3"));
        TableName tableName4 = TableName.valueOf((String)(this.tableName.getNameAsString() + "t4"));
        this.admin.addReplicationPeer("1", rpc1).join();
        rpc1.setReplicateAllUserTables(false);
        this.admin.updateReplicationPeerConfig("1", rpc1).join();
        HashMap tableCFs = new HashMap();
        try {
            tableCFs.put(tableName3, null);
            this.admin.removeReplicationPeerTableCFs("1", tableCFs).join();
            Assert.fail((String)"Test case should fail as removing table-cfs from a peer whose table-cfs is null");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ReplicationException));
        }
        Assert.assertNull((Object)((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap());
        tableCFs.clear();
        tableCFs.put(tableName1, null);
        tableCFs.put(tableName2, new ArrayList());
        ((List)tableCFs.get(tableName2)).add("cf1");
        this.admin.appendReplicationPeerTableCFs("1", tableCFs).join();
        try {
            tableCFs.clear();
            tableCFs.put(tableName3, null);
            this.admin.removeReplicationPeerTableCFs("1", tableCFs).join();
            Assert.fail((String)"Test case should fail as removing table-cfs from a peer whose table-cfs didn't contain t3");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ReplicationException));
        }
        Map result = ((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertNull(result.get(tableName1));
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName2)).size());
        Assert.assertEquals((Object)"cf1", ((List)result.get(tableName2)).get(0));
        try {
            tableCFs.clear();
            tableCFs.put(tableName1, new ArrayList());
            ((List)tableCFs.get(tableName1)).add("cf1");
            this.admin.removeReplicationPeerTableCFs("1", tableCFs).join();
            Assert.fail((String)"Test case should fail, because table t1 didn't specify cfs in peer config");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ReplicationException));
        }
        tableCFs.clear();
        tableCFs.put(tableName1, null);
        this.admin.removeReplicationPeerTableCFs("1", tableCFs).join();
        result = ((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName2)).size());
        Assert.assertEquals((Object)"cf1", ((List)result.get(tableName2)).get(0));
        try {
            tableCFs.clear();
            tableCFs.put(tableName2, null);
            this.admin.removeReplicationPeerTableCFs("1", tableCFs).join();
            Assert.fail((String)"Test case should fail, because table t2 hase specified cfs in peer config");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ReplicationException));
        }
        tableCFs.clear();
        tableCFs.put(tableName2, new ArrayList());
        ((List)tableCFs.get(tableName2)).add("cf1");
        this.admin.removeReplicationPeerTableCFs("1", tableCFs).join();
        Assert.assertNull((Object)((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap());
        tableCFs.clear();
        tableCFs.put(tableName4, new ArrayList());
        this.admin.appendReplicationPeerTableCFs("1", tableCFs).join();
        this.admin.removeReplicationPeerTableCFs("1", tableCFs).join();
        Assert.assertNull((Object)((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getTableCFsMap());
        this.admin.removeReplicationPeer("1");
    }

    @Test
    public void testSetPeerNamespaces() throws Exception {
        String ns1 = "ns1";
        String ns2 = "ns2";
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        this.admin.addReplicationPeer("1", rpc).join();
        rpc.setReplicateAllUserTables(false);
        this.admin.updateReplicationPeerConfig("1", rpc).join();
        rpc = (ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get();
        Set<String> namespaces = new HashSet<String>();
        namespaces.add(ns1);
        namespaces.add(ns2);
        rpc.setNamespaces(namespaces);
        this.admin.updateReplicationPeerConfig("1", rpc).join();
        namespaces = ((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getNamespaces();
        Assert.assertEquals((long)2L, (long)namespaces.size());
        Assert.assertTrue((boolean)namespaces.contains(ns1));
        Assert.assertTrue((boolean)namespaces.contains(ns2));
        rpc = (ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get();
        namespaces = new HashSet();
        namespaces.add(ns1);
        rpc.setNamespaces(namespaces);
        this.admin.updateReplicationPeerConfig("1", rpc).join();
        namespaces = ((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get()).getNamespaces();
        Assert.assertEquals((long)1L, (long)namespaces.size());
        Assert.assertTrue((boolean)namespaces.contains(ns1));
        this.admin.removeReplicationPeer("1").join();
    }

    @Test
    public void testNamespacesAndTableCfsConfigConflict() throws Exception {
        String ns1 = "ns1";
        String ns2 = "ns2";
        TableName tableName1 = TableName.valueOf((String)(ns1 + ":" + this.tableName.getNameAsString() + "1"));
        TableName tableName2 = TableName.valueOf((String)(ns2 + ":" + this.tableName.getNameAsString() + "2"));
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        this.admin.addReplicationPeer("1", rpc).join();
        rpc.setReplicateAllUserTables(false);
        this.admin.updateReplicationPeerConfig("1", rpc).join();
        rpc = (ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get();
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(ns1);
        rpc.setNamespaces(namespaces);
        this.admin.updateReplicationPeerConfig("1", rpc).get();
        rpc = (ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get();
        HashMap tableCfs = new HashMap();
        tableCfs.put(tableName1, new ArrayList());
        rpc.setTableCFsMap(tableCfs);
        try {
            this.admin.updateReplicationPeerConfig("1", rpc).join();
            Assert.fail((String)("Test case should fail, because table " + tableName1 + " conflict with namespace " + ns1));
        }
        catch (CompletionException completionException) {
            // empty catch block
        }
        rpc = (ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get();
        tableCfs.clear();
        tableCfs.put(tableName2, new ArrayList());
        rpc.setTableCFsMap(tableCfs);
        this.admin.updateReplicationPeerConfig("1", rpc).get();
        rpc = (ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get();
        namespaces.clear();
        namespaces.add(ns2);
        rpc.setNamespaces(namespaces);
        try {
            this.admin.updateReplicationPeerConfig("1", rpc).join();
            Assert.fail((String)("Test case should fail, because namespace " + ns2 + " conflict with table " + tableName2));
        }
        catch (CompletionException completionException) {
            // empty catch block
        }
        this.admin.removeReplicationPeer("1").join();
    }

    @Test
    public void testPeerBandwidth() throws Exception {
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        this.admin.addReplicationPeer("1", rpc).join();
        rpc = (ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").get();
        Assert.assertEquals((long)0L, (long)rpc.getBandwidth());
        rpc.setBandwidth(0x200000L);
        this.admin.updateReplicationPeerConfig("1", rpc).join();
        Assert.assertEquals((long)0x200000L, (long)((ReplicationPeerConfig)this.admin.getReplicationPeerConfig("1").join()).getBandwidth());
        this.admin.removeReplicationPeer("1").join();
    }
}

