/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TestCloneSnapshotFromClient;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.snapshot.MobSnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class, ClientTests.class})
public class TestMobCloneSnapshotFromClient
extends TestCloneSnapshotFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobCloneSnapshotFromClient.class);
    private static boolean delayFlush = false;
    @Rule
    public TestName name = new TestName();

    protected static void setupConfiguration() {
        TestCloneSnapshotFromClient.setupConfiguration();
        TEST_UTIL.getConfiguration().setLong("hbase.master.hfilecleaner.ttl", 0L);
        TEST_UTIL.getConfiguration().setInt("hbase.mob.file.cache.size", 0);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestMobCloneSnapshotFromClient.setupConfiguration();
        TEST_UTIL.startMiniCluster(3);
    }

    @Override
    protected void createTableAndSnapshots() throws Exception {
        this.createMobTable(TEST_UTIL, this.tableName, SnapshotTestingUtils.getSplitKeys(), this.getNumReplicas(), new byte[][]{this.FAMILY});
        delayFlush = false;
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.emptySnapshot, this.tableName);
        Connection c = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        try (Table table = c.getTable(this.tableName);){
            this.admin.enableTable(this.tableName);
            SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 20, (byte[][])new byte[][]{this.FAMILY});
            this.snapshot0Rows = MobSnapshotTestingUtils.countMobRows(table, new byte[0][]);
            this.admin.disableTable(this.tableName);
            this.admin.snapshot(this.snapshotName0, this.tableName);
            this.admin.enableTable(this.tableName);
            SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 20, (byte[][])new byte[][]{this.FAMILY});
            this.snapshot1Rows = MobSnapshotTestingUtils.countMobRows(table, new byte[0][]);
            this.admin.disableTable(this.tableName);
            this.admin.snapshot(this.snapshotName1, this.tableName);
            this.admin.enableTable(this.tableName);
        }
    }

    @Override
    @Test
    public void testCloneLinksAfterDelete() throws IOException, InterruptedException {
        delayFlush = true;
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 20, (byte[][])new byte[][]{this.FAMILY});
        long tid = System.currentTimeMillis();
        byte[] snapshotName3 = Bytes.toBytes((String)("snaptb3-" + tid));
        TableName clonedTableName3 = TableName.valueOf((String)(this.name.getMethodName() + System.currentTimeMillis()));
        this.admin.snapshot(snapshotName3, this.tableName);
        delayFlush = false;
        int snapshot3Rows = -1;
        try (Table table = TEST_UTIL.getConnection().getTable(this.tableName);){
            snapshot3Rows = TEST_UTIL.countRows(table);
        }
        this.admin.cloneSnapshot(snapshotName3, clonedTableName3);
        this.admin.deleteSnapshot(snapshotName3);
        super.testCloneLinksAfterDelete();
        this.verifyRowCount(TEST_UTIL, clonedTableName3, snapshot3Rows);
        this.admin.disableTable(clonedTableName3);
        this.admin.deleteTable(clonedTableName3);
    }

    @Override
    protected void verifyRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        MobSnapshotTestingUtils.verifyMobRowCount(util, tableName, expectedRows);
    }

    private void createMobTable(HBaseTestingUtility util, TableName tableName, byte[][] splitKeys, int regionReplication, byte[] ... families) throws IOException, InterruptedException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.setRegionReplication(regionReplication);
        htd.addCoprocessor(DelayFlushCoprocessor.class.getName());
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setMobEnabled(true);
            hcd.setMobThreshold(0L);
            htd.addFamily(hcd);
        }
        util.getAdmin().createTable((TableDescriptor)htd, splitKeys);
        SnapshotTestingUtils.waitForTableToBeOnline(util, tableName);
        Assert.assertEquals((long)((splitKeys.length + 1) * regionReplication), (long)util.getAdmin().getTableRegions(tableName).size());
    }

    public static class DelayFlushCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e, FlushLifeCycleTracker tracker) throws IOException {
            if (delayFlush) {
                try {
                    if (Bytes.compareTo((byte[])((RegionCoprocessorEnvironment)e.getEnvironment()).getRegionInfo().getStartKey(), (byte[])HConstants.EMPTY_START_ROW) != 0) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e1) {
                    throw new InterruptedIOException(e1.getMessage());
                }
            }
        }
    }
}

