/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TestRestoreSnapshotFromClient;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Ignore
@Category(value={LargeTests.class, ClientTests.class})
public class TestRestoreSnapshotFromClientWithRegionReplicas
extends TestRestoreSnapshotFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRestoreSnapshotFromClientWithRegionReplicas.class);

    @Override
    protected int getNumReplicas() {
        return 3;
    }

    @Test
    public void testOnlineSnapshotAfterSplittingRegions() throws IOException, InterruptedException {
        List regionInfos = this.admin.getRegions(this.tableName);
        RegionReplicaUtil.removeNonDefaultRegions((Collection)regionInfos);
        this.splitRegion((RegionInfo)regionInfos.get(0));
        this.admin.snapshot(this.snapshotName1, this.tableName);
        TableName clonedTableName = TableName.valueOf((String)(this.name.getMethodName() + "-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(this.snapshotName1, clonedTableName);
        this.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot1Rows);
    }
}

