/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestPrefetch {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPrefetch.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    private static final int DATA_BLOCK_SIZE = 2048;
    private static final int NUM_KV = 1000;
    private static final Random RNG = new Random();
    private Configuration conf;
    private CacheConfig cacheConf;
    private FileSystem fs;

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setBoolean("hbase.rs.prefetchblocksonopen", true);
        this.fs = HFileSystem.get((Configuration)this.conf);
        CacheConfig.blockCacheDisabled = false;
        this.cacheConf = new CacheConfig(this.conf);
    }

    @Test
    public void testPrefetchSetInHCDWorks() {
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes((String)"f"));
        hcd.setPrefetchBlocksOnOpen(true);
        Configuration c = HBaseConfiguration.create();
        Assert.assertFalse((boolean)c.getBoolean("hbase.rs.prefetchblocksonopen", false));
        CacheConfig cc = new CacheConfig(c, (ColumnFamilyDescriptor)hcd);
        Assert.assertTrue((boolean)cc.shouldPrefetchOnOpen());
    }

    @Test
    public void testPrefetch() throws Exception {
        Path storeFile = this.writeStoreFile();
        this.readStoreFile(storeFile);
    }

    private void readStoreFile(Path storeFilePath) throws Exception {
        HFileBlock block;
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)storeFilePath, (CacheConfig)this.cacheConf, (boolean)true, (Configuration)this.conf);
        while (!reader.prefetchComplete()) {
            Thread.sleep(1000L);
        }
        BlockCache blockCache = this.cacheConf.getBlockCache();
        for (long offset = 0L; offset < reader.getTrailer().getLoadOnOpenDataOffset(); offset += (long)block.getOnDiskSizeWithHeader()) {
            boolean isCached;
            block = reader.readBlock(offset, -1L, false, true, false, true, null, null);
            BlockCacheKey blockCacheKey = new BlockCacheKey(reader.getName(), offset);
            boolean bl = isCached = blockCache.getBlock(blockCacheKey, true, false, true) != null;
            if (block.getBlockType() != BlockType.DATA && block.getBlockType() != BlockType.ROOT_INDEX && block.getBlockType() != BlockType.INTERMEDIATE_INDEX) continue;
            Assert.assertTrue((boolean)isCached);
        }
    }

    private Path writeStoreFile() throws IOException {
        Path storeFileParentDir = new Path(TEST_UTIL.getDataTestDir(), "TestPrefetch");
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFileWriter sfw = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withOutputDir(storeFileParentDir).withComparator((CellComparator)CellComparatorImpl.COMPARATOR).withFileContext(meta).build();
        int rowLen = 32;
        for (int i = 0; i < 1000; ++i) {
            byte[] k = RandomKeyValueUtil.randomOrderedKey(RNG, i);
            byte[] v = RandomKeyValueUtil.randomValue(RNG);
            int cfLen = RNG.nextInt(k.length - 32 + 1);
            KeyValue kv = new KeyValue(k, 0, 32, k, 32, cfLen, k, 32 + cfLen, k.length - 32 - cfLen, RNG.nextLong(), TestPrefetch.generateKeyType(RNG), v, 0, v.length);
            sfw.append((Cell)kv);
        }
        sfw.close();
        return sfw.getPath();
    }

    public static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }
}

