/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.AssignmentListener;
import org.apache.hadoop.hbase.master.DrainingServerTracker;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionServerTracker;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestAssignmentListener {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAssignmentListener.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAssignmentListener.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();
    private static final Abortable abortable = new Abortable(){

        public boolean isAborted() {
            return false;
        }

        public void abort(String why, Throwable e) {
        }
    };

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerListener() throws IOException, InterruptedException {
        ServerManager serverManager = TEST_UTIL.getHBaseCluster().getMaster().getServerManager();
        DummyServerListener listener = new DummyServerListener();
        serverManager.registerListener((ServerListener)listener);
        try {
            MiniHBaseCluster miniCluster = TEST_UTIL.getMiniHBaseCluster();
            miniCluster.startRegionServer();
            listener.awaitModifications(1);
            Assert.assertEquals((long)1L, (long)listener.getAddedCount());
            Assert.assertEquals((long)0L, (long)listener.getRemovedCount());
            listener.reset();
            miniCluster.startRegionServer();
            listener.awaitModifications(1);
            Assert.assertEquals((long)1L, (long)listener.getAddedCount());
            Assert.assertEquals((long)0L, (long)listener.getRemovedCount());
            int nrs = miniCluster.getRegionServerThreads().size();
            listener.reset();
            miniCluster.stopRegionServer(nrs - 1);
            listener.awaitModifications(1);
            Assert.assertEquals((long)0L, (long)listener.getAddedCount());
            Assert.assertEquals((long)1L, (long)listener.getRemovedCount());
            listener.reset();
            miniCluster.stopRegionServer(nrs - 2);
            listener.awaitModifications(1);
            Assert.assertEquals((long)0L, (long)listener.getAddedCount());
            Assert.assertEquals((long)1L, (long)listener.getRemovedCount());
        }
        finally {
            serverManager.unregisterListener((ServerListener)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignmentListener() throws IOException, InterruptedException {
        AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        Admin admin = TEST_UTIL.getAdmin();
        DummyAssignmentListener listener = new DummyAssignmentListener();
        am.registerListener((AssignmentListener)listener);
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            byte[] FAMILY = Bytes.toBytes((String)"cf");
            LOG.info("Create Table");
            TEST_UTIL.createTable(tableName, FAMILY);
            listener.awaitModifications(1);
            Assert.assertEquals((long)1L, (long)listener.getLoadCount());
            Assert.assertEquals((long)0L, (long)listener.getCloseCount());
            try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
                for (int i = 0; i < 10; ++i) {
                    byte[] key = Bytes.toBytes((String)("row-" + i));
                    Put put = new Put(key);
                    put.addColumn(FAMILY, null, key);
                    table.put(put);
                }
            }
            LOG.info("Split Table");
            listener.reset();
            admin.split(tableName, Bytes.toBytes((String)"row-3"));
            listener.awaitModifications(3);
            Assert.assertEquals((long)2L, (long)listener.getLoadCount());
            Assert.assertEquals((long)1L, (long)listener.getCloseCount());
            MiniHBaseCluster miniCluster = TEST_UTIL.getMiniHBaseCluster();
            int mergeable = 0;
            while (mergeable < 2) {
                Thread.sleep(100L);
                admin.majorCompact(tableName);
                mergeable = 0;
                for (JVMClusterUtil.RegionServerThread regionThread : miniCluster.getRegionServerThreads()) {
                    for (Region region : regionThread.getRegionServer().getRegions(tableName)) {
                        mergeable += ((HRegion)region).isMergeable() ? 1 : 0;
                    }
                }
            }
            LOG.info("Merge Regions");
            listener.reset();
            List regions = admin.getRegions(tableName);
            Assert.assertEquals((long)2L, (long)regions.size());
            boolean sameServer = this.areAllRegionsLocatedOnSameServer(tableName);
            int expectedModifications = sameServer ? 3 : 5;
            int expectedLoadCount = sameServer ? 1 : 2;
            int expectedCloseCount = sameServer ? 2 : 3;
            admin.mergeRegionsAsync(((RegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((RegionInfo)regions.get(1)).getEncodedNameAsBytes(), true);
            listener.awaitModifications(expectedModifications);
            Assert.assertEquals((long)1L, (long)admin.getTableRegions(tableName).size());
            Assert.assertEquals((long)expectedLoadCount, (long)listener.getLoadCount());
            Assert.assertEquals((long)expectedCloseCount, (long)listener.getCloseCount());
            LOG.info("Drop Table");
            listener.reset();
            TEST_UTIL.deleteTable(tableName);
            listener.awaitModifications(1);
            Assert.assertEquals((long)0L, (long)listener.getLoadCount());
            Assert.assertEquals((long)1L, (long)listener.getCloseCount());
        }
        finally {
            am.unregisterListener((AssignmentListener)listener);
        }
    }

    private boolean areAllRegionsLocatedOnSameServer(TableName TABLE_NAME) {
        MiniHBaseCluster miniCluster = TEST_UTIL.getMiniHBaseCluster();
        int serverCount = 0;
        for (JVMClusterUtil.RegionServerThread regionThread : miniCluster.getRegionServerThreads()) {
            if (!regionThread.getRegionServer().getRegions(TABLE_NAME).isEmpty()) {
                ++serverCount;
            }
            if (serverCount <= 1) continue;
            return false;
        }
        return serverCount == 1;
    }

    @Test
    public void testAddNewServerThatExistsInDraining() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ZKWatcher zooKeeper = new ZKWatcher(conf, "zkWatcher-NewServerDrainTest", abortable, true);
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String drainingZNode = ZNodePaths.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.draining.rs", "draining"));
        HMaster master = (HMaster)Mockito.mock(HMaster.class);
        Mockito.when((Object)master.getConfiguration()).thenReturn((Object)conf);
        ServerName SERVERNAME_A = ServerName.valueOf((String)"mockserverbulk_a.org", (int)1000, (long)8000L);
        ServerName SERVERNAME_B = ServerName.valueOf((String)"mockserverbulk_b.org", (int)1001, (long)8000L);
        ServerName SERVERNAME_C = ServerName.valueOf((String)"mockserverbulk_c.org", (int)1002, (long)8000L);
        ArrayList<ServerName> drainingServers = new ArrayList<ServerName>();
        drainingServers.add(SERVERNAME_A);
        drainingServers.add(SERVERNAME_B);
        HashMap<ServerName, ServerLoad> onlineServers = new HashMap<ServerName, ServerLoad>();
        onlineServers.put(SERVERNAME_A, new ServerLoad(ServerMetricsBuilder.of((ServerName)SERVERNAME_A)));
        onlineServers.put(SERVERNAME_C, new ServerLoad(ServerMetricsBuilder.of((ServerName)SERVERNAME_C)));
        for (ServerName sn : drainingServers) {
            String znode = ZNodePaths.joinZNode((String)drainingZNode, (String)sn.getServerName());
            ZKUtil.createAndFailSilent((ZKWatcher)zooKeeper, (String)znode);
        }
        ServerManager serverManager = new ServerManager((MasterServices)master);
        RegionServerTracker regionServerTracker = new RegionServerTracker(zooKeeper, (MasterServices)master, serverManager);
        regionServerTracker.start();
        DrainingServerTracker drainingServerTracker = new DrainingServerTracker(zooKeeper, (Abortable)master, serverManager);
        drainingServerTracker.start();
        Assert.assertEquals(new HashMap(), (Object)serverManager.getOnlineServers());
        Assert.assertEquals(new ArrayList(), (Object)serverManager.getDrainingServersList());
        ArrayList<ServerName> onlineDrainingServers = new ArrayList<ServerName>();
        for (ServerName sn : onlineServers.keySet()) {
            serverManager.checkAndRecordNewServer(sn, (ServerMetrics)onlineServers.get(sn));
            if (!drainingServers.contains(sn)) continue;
            onlineDrainingServers.add(sn);
        }
        Assert.assertEquals(onlineServers, (Object)serverManager.getOnlineServers());
        Assert.assertEquals(onlineDrainingServers, (Object)serverManager.getDrainingServersList());
    }

    static class DummyServerListener
    extends DummyListener
    implements ServerListener {
        private AtomicInteger removedCount = new AtomicInteger(0);
        private AtomicInteger addedCount = new AtomicInteger(0);

        public void serverAdded(ServerName serverName) {
            LOG.info("Server added " + serverName);
            this.addedCount.incrementAndGet();
            this.modified.incrementAndGet();
        }

        public void serverRemoved(ServerName serverName) {
            LOG.info("Server removed " + serverName);
            this.removedCount.incrementAndGet();
            this.modified.incrementAndGet();
        }

        public void reset() {
            this.addedCount.set(0);
            this.removedCount.set(0);
        }

        public int getAddedCount() {
            return this.addedCount.get();
        }

        public int getRemovedCount() {
            return this.removedCount.get();
        }
    }

    static class DummyAssignmentListener
    extends DummyListener
    implements AssignmentListener {
        private AtomicInteger closeCount = new AtomicInteger(0);
        private AtomicInteger openCount = new AtomicInteger(0);

        public void regionOpened(RegionInfo regionInfo, ServerName serverName) {
            LOG.info("Assignment open region=" + regionInfo + " server=" + serverName);
            this.openCount.incrementAndGet();
            this.modified.incrementAndGet();
        }

        public void regionClosed(RegionInfo regionInfo) {
            LOG.info("Assignment close region=" + regionInfo);
            this.closeCount.incrementAndGet();
            this.modified.incrementAndGet();
        }

        public void reset() {
            this.openCount.set(0);
            this.closeCount.set(0);
        }

        public int getLoadCount() {
            return this.openCount.get();
        }

        public int getCloseCount() {
            return this.closeCount.get();
        }
    }

    static class DummyListener {
        protected AtomicInteger modified = new AtomicInteger(0);

        DummyListener() {
        }

        public void awaitModifications(int count) throws InterruptedException {
            while (!this.modified.compareAndSet(count, 0)) {
                Thread.sleep(100L);
            }
        }
    }
}

