/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestHMasterRPCException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHMasterRPCException.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHMasterRPCException.class);
    private final HBaseTestingUtility testUtil = HBaseTestingUtility.createLocalHTU();
    private HMaster master;
    private RpcClient rpcClient;

    @Before
    public void setUp() throws Exception {
        Configuration conf = this.testUtil.getConfiguration();
        conf.set("hbase.master.port", "0");
        conf.setInt("zookeeper.session.timeout", 2000);
        this.testUtil.startMiniZKCluster();
        ZKWatcher watcher = this.testUtil.getZooKeeperWatcher();
        ZKUtil.createWithParents((ZKWatcher)watcher, (String)watcher.znodePaths.masterAddressZNode, (byte[])Bytes.toBytes((String)"fake:123"));
        this.master = new HMaster(conf);
        this.rpcClient = RpcClientFactory.createClient((Configuration)conf, (String)"default-cluster");
    }

    @After
    public void tearDown() throws IOException {
        if (this.rpcClient != null) {
            this.rpcClient.close();
        }
        if (this.master != null) {
            this.master.stopMaster();
        }
        this.testUtil.shutdownMiniZKCluster();
    }

    @Test
    public void testRPCException() throws IOException, InterruptedException, KeeperException {
        ServerName sm = this.master.getServerName();
        boolean fakeZNodeDelete = false;
        for (int i = 0; i < 20; ++i) {
            try {
                BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(sm, User.getCurrent(), 0);
                MasterProtos.MasterService.BlockingInterface stub = MasterProtos.MasterService.newBlockingStub((BlockingRpcChannel)channel);
                Assert.assertTrue((boolean)stub.isMasterRunning(null, MasterProtos.IsMasterRunningRequest.getDefaultInstance()).getIsMasterRunning());
                return;
            }
            catch (ServiceException ex) {
                IOException ie = ProtobufUtil.handleRemoteException((Exception)((Object)ex));
                Assert.assertTrue((boolean)ie.getMessage().startsWith("org.apache.hadoop.hbase.ipc.ServerNotRunningYetException: Server is not running yet"));
                LOG.info("Expected exception: ", (Throwable)ie);
                if (!fakeZNodeDelete) {
                    this.testUtil.getZooKeeperWatcher().getRecoverableZooKeeper().delete(this.testUtil.getZooKeeperWatcher().znodePaths.masterAddressZNode, -1);
                    fakeZNodeDelete = true;
                }
                Thread.sleep(1000L);
                continue;
            }
        }
    }
}

