/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.procedure.CloneSnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCloneSnapshotProcedure
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCloneSnapshotProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCloneSnapshotProcedure.class);
    protected final byte[] CF = Bytes.toBytes((String)"cf1");
    private static SnapshotProtos.SnapshotDescription snapshot = null;

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getAdmin());
        snapshot = null;
    }

    private SnapshotProtos.SnapshotDescription getSnapshot() throws Exception {
        if (snapshot == null) {
            TableName snapshotTableName = TableName.valueOf((String)"testCloneSnapshot");
            long tid = System.currentTimeMillis();
            byte[] snapshotName = Bytes.toBytes((String)("snapshot-" + tid));
            Admin admin = UTIL.getAdmin();
            SnapshotTestingUtils.createTable(UTIL, snapshotTableName, this.getNumReplicas(), (byte[][])new byte[][]{this.CF});
            SnapshotTestingUtils.loadData(UTIL, snapshotTableName, 500, (byte[][])new byte[][]{this.CF});
            admin.disableTable(snapshotTableName);
            admin.snapshot(snapshotName, snapshotTableName);
            admin.enableTable(snapshotTableName);
            List snapshotList = admin.listSnapshots();
            snapshot = ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)((SnapshotDescription)snapshotList.get(0)));
        }
        return snapshot;
    }

    private int getNumReplicas() {
        return 1;
    }

    public static HTableDescriptor createHTableDescriptor(TableName tableName, byte[] ... family) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (int i = 0; i < family.length; ++i) {
            htd.addFamily(new HColumnDescriptor(family[i]));
        }
        return htd;
    }

    @Test
    public void testCloneSnapshot() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TableName clonedTableName = TableName.valueOf((String)"testCloneSnapshot2");
        HTableDescriptor htd = TestCloneSnapshotProcedure.createHTableDescriptor(clonedTableName, new byte[][]{this.CF});
        SnapshotProtos.SnapshotDescription snapshotDesc = this.getSnapshot();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new CloneSnapshotProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd, snapshotDesc));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId));
        MasterProcedureTestingUtility.validateTableIsEnabled(UTIL.getHBaseCluster().getMaster(), clonedTableName);
    }

    @Test
    public void testCloneSnapshotToSameTable() throws Exception {
        SnapshotProtos.SnapshotDescription snapshotDesc = this.getSnapshot();
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TableName clonedTableName = TableName.valueOf((String)snapshotDesc.getTable());
        HTableDescriptor htd = TestCloneSnapshotProcedure.createHTableDescriptor(clonedTableName, new byte[][]{this.CF});
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new CloneSnapshotProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd, snapshotDesc));
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug("Clone snapshot failed with exception: " + result.getException());
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof TableExistsException));
    }

    @Test
    public void testRecoveryAndDoubleExecution() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TableName clonedTableName = TableName.valueOf((String)"testRecoveryAndDoubleExecution");
        HTableDescriptor htd = TestCloneSnapshotProcedure.createHTableDescriptor(clonedTableName, new byte[][]{this.CF});
        SnapshotProtos.SnapshotDescription snapshotDesc = this.getSnapshot();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new CloneSnapshotProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd, snapshotDesc));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        MasterProcedureTestingUtility.validateTableIsEnabled(UTIL.getHBaseCluster().getMaster(), clonedTableName);
    }

    @Test
    public void testRollbackAndDoubleExecution() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TableName clonedTableName = TableName.valueOf((String)"testRollbackAndDoubleExecution");
        HTableDescriptor htd = TestCloneSnapshotProcedure.createHTableDescriptor(clonedTableName, new byte[][]{this.CF});
        SnapshotProtos.SnapshotDescription snapshotDesc = this.getSnapshot();
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new CloneSnapshotProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd, snapshotDesc));
        int numberOfSteps = 0;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps);
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), clonedTableName);
    }
}

