/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ModifyTableProcedure;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestModifyTableProcedure
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestModifyTableProcedure.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testModifyTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf");
        UTIL.getAdmin().disableTable(tableName);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        long newMaxFileSize = htd.getMaxFileSize() * 2L;
        htd.setMaxFileSize(newMaxFileSize);
        htd.setRegionReplication(3);
        long procId1 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId1));
        HTableDescriptor currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)newMaxFileSize, (long)currentHtd.getMaxFileSize());
        boolean newReadOnlyOption = !htd.isReadOnly();
        long newMemStoreFlushSize = htd.getMemStoreFlushSize() * 2L;
        htd.setReadOnly(newReadOnlyOption);
        htd.setMemStoreFlushSize(newMemStoreFlushSize);
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId2));
        currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((Object)newReadOnlyOption, (Object)currentHtd.isReadOnly());
        Assert.assertEquals((long)newMemStoreFlushSize, (long)currentHtd.getMemStoreFlushSize());
    }

    @Test
    public void testModifyTableAddCF() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1");
        HTableDescriptor currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)1L, (long)currentHtd.getFamiliesKeys().size());
        String cf2 = "cf2";
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        htd.addFamily(new HColumnDescriptor(cf2));
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId));
        currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertTrue((boolean)currentHtd.hasFamily(Bytes.toBytes((String)cf2)));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        String cf3 = "cf3";
        HTableDescriptor htd2 = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        htd2.addFamily(new HColumnDescriptor(cf3));
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd2));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId2));
        currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertTrue((boolean)currentHtd.hasFamily(Bytes.toBytes((String)cf3)));
        Assert.assertEquals((long)3L, (long)currentHtd.getFamiliesKeys().size());
    }

    @Test
    public void testModifyTableDeleteCF() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf1 = "cf1";
        String cf2 = "cf2";
        String cf3 = "cf3";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1", "cf2", "cf3");
        HTableDescriptor currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)3L, (long)currentHtd.getFamiliesKeys().size());
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        htd.removeFamily(Bytes.toBytes((String)"cf2"));
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId));
        currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertFalse((boolean)currentHtd.hasFamily(Bytes.toBytes((String)"cf2")));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        HTableDescriptor htd2 = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        htd2.removeFamily(Bytes.toBytes((String)"cf3"));
        htd2.setConfiguration("hbase.table.sanity.checks", Boolean.FALSE.toString());
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd2));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId2));
        currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((long)1L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertFalse((boolean)currentHtd.hasFamily(Bytes.toBytes((String)"cf3")));
        HTableDescriptor htd3 = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        htd3.removeFamily(Bytes.toBytes((String)"cf1"));
        long procId3 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd3));
        Procedure result = procExec.getResult(procId3);
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        Throwable cause = ProcedureTestingUtility.getExceptionCause((Procedure)result);
        Assert.assertTrue((String)("expected DoNotRetryIOException, got " + cause), (boolean)(cause instanceof DoNotRetryIOException));
        Assert.assertEquals((long)1L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertTrue((boolean)currentHtd.hasFamily(Bytes.toBytes((String)"cf1")));
    }

    @Test
    public void testRecoveryAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf2 = "cf2";
        String cf3 = "cf3";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1", "cf3");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        boolean newCompactionEnableOption = !htd.isCompactionEnabled();
        htd.setCompactionEnabled(newCompactionEnableOption);
        htd.addFamily(new HColumnDescriptor("cf2"));
        htd.removeFamily(Bytes.toBytes((String)"cf3"));
        htd.setRegionReplication(3);
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        HTableDescriptor currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((Object)newCompactionEnableOption, (Object)currentHtd.isCompactionEnabled());
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, false, "cf1", "cf2");
    }

    @Test
    public void testRecoveryAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf2 = "cf2";
        String cf3 = "cf3";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1", "cf3");
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        boolean newCompactionEnableOption = !htd.isCompactionEnabled();
        htd.setCompactionEnabled(newCompactionEnableOption);
        htd.addFamily(new HColumnDescriptor("cf2"));
        htd.removeFamily(Bytes.toBytes((String)"cf3"));
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        HTableDescriptor currentHtd = UTIL.getAdmin().getTableDescriptor(tableName);
        Assert.assertEquals((Object)newCompactionEnableOption, (Object)currentHtd.isCompactionEnabled());
        Assert.assertEquals((long)2L, (long)currentHtd.getFamiliesKeys().size());
        Assert.assertTrue((boolean)currentHtd.hasFamily(Bytes.toBytes((String)"cf2")));
        Assert.assertFalse((boolean)currentHtd.hasFamily(Bytes.toBytes((String)"cf3")));
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "cf1", "cf2");
    }

    @Test
    public void testRollbackAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String familyName = "cf2";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1");
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        boolean newCompactionEnableOption = !htd.isCompactionEnabled();
        htd.setCompactionEnabled(newCompactionEnableOption);
        htd.addFamily(new HColumnDescriptor("cf2"));
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        int numberOfSteps = 0;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps);
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "cf1");
    }

    @Test
    public void testRollbackAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String familyName = "cf2";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        HTableDescriptor htd = new HTableDescriptor(UTIL.getAdmin().getTableDescriptor(tableName));
        boolean newCompactionEnableOption = !htd.isCompactionEnabled();
        htd.setCompactionEnabled(newCompactionEnableOption);
        htd.addFamily(new HColumnDescriptor("cf2"));
        htd.setRegionReplication(3);
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd));
        int numberOfSteps = 0;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps);
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "cf1");
    }
}

