/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileCache;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotFileCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotFileCache.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotFileCache.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static long sequenceId = 0L;
    private static FileSystem fs;
    private static Path rootDir;

    @BeforeClass
    public static void startCluster() throws Exception {
        UTIL.startMiniDFSCluster(1);
        fs = UTIL.getDFSCluster().getFileSystem();
        rootDir = UTIL.getDefaultRootDirPath();
    }

    @AfterClass
    public static void stopCluster() throws Exception {
        UTIL.shutdownMiniDFSCluster();
    }

    @After
    public void cleanupFiles() throws Exception {
        Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
        fs.delete(snapshotDir, true);
    }

    @Test
    public void testLoadAndDelete() throws IOException {
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot1a", false, true);
        this.createAndTestSnapshotV1(cache, "snapshot1b", true, true);
        this.createAndTestSnapshotV2(cache, "snapshot2a", false, true);
        this.createAndTestSnapshotV2(cache, "snapshot2b", true, true);
    }

    @Test
    public void testReloadModifiedDirectory() throws IOException {
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot1", false, true);
        this.createAndTestSnapshotV1(cache, "snapshot1", false, false);
        this.createAndTestSnapshotV2(cache, "snapshot2", false, true);
        this.createAndTestSnapshotV2(cache, "snapshot2", false, false);
    }

    @Test
    public void testSnapshotTempDirReload() throws IOException {
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot0v1", false, false);
        this.createAndTestSnapshotV1(cache, "snapshot0v2", false, false);
        this.createAndTestSnapshotV2(cache, "snapshot1", true, false);
        this.createAndTestSnapshotV2(cache, "snapshot2", true, false);
    }

    @Test
    public void testWeNeverCacheTmpDirAndLoadIt() throws Exception {
        final AtomicInteger count = new AtomicInteger(0);
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", new SnapshotFiles()){

            List<String> getSnapshotsInProgress(SnapshotManager snapshotManager) throws IOException {
                List result = super.getSnapshotsInProgress(snapshotManager);
                count.incrementAndGet();
                return result;
            }

            public void triggerCacheRefreshForTesting() {
                super.triggerCacheRefreshForTesting();
            }
        };
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder complete = this.createAndTestSnapshotV1(cache, "snapshot", false, false);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder inProgress = this.createAndTestSnapshotV1(cache, "snapshotInProgress", true, false);
        int countBeforeCheck = count.get();
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
        List<FileStatus> allStoreFiles = this.getStoreFilesForSnapshot(complete);
        Iterable deletableFiles = cache.getUnreferencedFiles(allStoreFiles, null);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)deletableFiles));
        Assert.assertEquals((long)0L, (long)(count.get() - countBeforeCheck));
        FileStatus randomFile = this.mockStoreFile(UUID.randomUUID().toString());
        allStoreFiles.add(randomFile);
        deletableFiles = cache.getUnreferencedFiles(allStoreFiles, null);
        Assert.assertEquals((Object)randomFile, (Object)Iterables.getOnlyElement((Iterable)deletableFiles));
        Assert.assertEquals((long)1L, (long)(count.get() - countBeforeCheck));
    }

    private List<FileStatus> getStoreFilesForSnapshot(SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder) throws IOException {
        final ArrayList allStoreFiles = Lists.newArrayList();
        SnapshotReferenceUtil.visitReferencedFiles((Configuration)UTIL.getConfiguration(), (FileSystem)fs, (Path)builder.getSnapshotsDir(), (SnapshotReferenceUtil.SnapshotVisitor)new SnapshotReferenceUtil.SnapshotVisitor(){

            public void storeFile(RegionInfo regionInfo, String familyName, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                FileStatus status = TestSnapshotFileCache.this.mockStoreFile(storeFile.getName());
                allStoreFiles.add(status);
            }
        });
        return allStoreFiles;
    }

    private FileStatus mockStoreFile(String storeFileName) {
        FileStatus status = (FileStatus)Mockito.mock(FileStatus.class);
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getName()).thenReturn((Object)storeFileName);
        Mockito.when((Object)status.getPath()).thenReturn((Object)path);
        return status;
    }

    private SnapshotTestingUtils.SnapshotMock.SnapshotBuilder createAndTestSnapshotV1(SnapshotFileCache cache, String name, boolean tmp, boolean removeOnExit) throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV1(name, name);
        this.createAndTestSnapshot(cache, builder, tmp, removeOnExit);
        return builder;
    }

    private void createAndTestSnapshotV2(SnapshotFileCache cache, String name, boolean tmp, boolean removeOnExit) throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(name, name);
        this.createAndTestSnapshot(cache, builder, tmp, removeOnExit);
    }

    private void createAndTestSnapshot(SnapshotFileCache cache, SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder, boolean tmp, boolean removeOnExit) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        for (int i = 0; i < 3; ++i) {
            for (Path filePath : builder.addRegion()) {
                String fileName = filePath.getName();
                if (tmp) {
                    FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
                    Iterable<FileStatus> nonSnapshot = this.getNonSnapshotFiles(cache, filePath);
                    Assert.assertFalse((String)("Cache didn't find " + fileName), (boolean)Iterables.contains(nonSnapshot, (Object)fileName));
                }
                files.add(filePath);
            }
        }
        if (!tmp) {
            builder.commit();
        }
        for (Path path : files) {
            Iterable<FileStatus> nonSnapshotFiles = this.getNonSnapshotFiles(cache, path);
            Assert.assertFalse((String)("Cache didn't find " + path.getName()), (boolean)Iterables.contains(nonSnapshotFiles, (Object)path.getName()));
        }
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
        if (removeOnExit) {
            LOG.debug("Deleting snapshot.");
            fs.delete(builder.getSnapshotsDir(), true);
            FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
            for (Path filePath : files) {
                Iterable<FileStatus> nonSnapshotFiles = this.getNonSnapshotFiles(cache, filePath);
                Assert.assertFalse((String)("Cache didn't find " + filePath.getName()), (boolean)Iterables.contains(nonSnapshotFiles, (Object)filePath.getName()));
            }
            cache.triggerCacheRefreshForTesting();
            for (Path filePath : files) {
                Iterable<FileStatus> nonSnapshotFiles = this.getNonSnapshotFiles(cache, filePath);
                Assert.assertTrue((String)("Cache found '" + filePath.getName() + "', but it shouldn't have."), (!Iterables.contains(nonSnapshotFiles, (Object)filePath.getName()) ? 1 : 0) != 0);
            }
        }
    }

    private Iterable<FileStatus> getNonSnapshotFiles(SnapshotFileCache cache, Path storeFile) throws IOException {
        return cache.getUnreferencedFiles(Arrays.asList(FSUtils.listStatus((FileSystem)fs, (Path)storeFile.getParent())), null);
    }

    class SnapshotFiles
    implements SnapshotFileCache.SnapshotFileInspector {
        SnapshotFiles() {
        }

        public Collection<String> filesUnderSnapshot(Path snapshotDir) throws IOException {
            HashSet<String> files = new HashSet<String>();
            files.addAll(SnapshotReferenceUtil.getHFileNames((Configuration)UTIL.getConfiguration(), (FileSystem)fs, (Path)snapshotDir));
            return files;
        }
    }
}

