/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestTaskMonitor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTaskMonitor.class);

    @Test
    public void testTaskMonitorBasics() {
        TaskMonitor tm = new TaskMonitor(new Configuration());
        Assert.assertTrue((String)"Task monitor should start empty", (boolean)tm.getTasks().isEmpty());
        MonitoredTask task = tm.createStatus("Test task");
        MonitoredTask taskFromTm = (MonitoredTask)tm.getTasks().get(0);
        Assert.assertEquals((Object)task.getDescription(), (Object)taskFromTm.getDescription());
        Assert.assertEquals((long)-1L, (long)taskFromTm.getCompletionTimestamp());
        Assert.assertEquals((Object)MonitoredTask.State.RUNNING, (Object)taskFromTm.getState());
        task.markComplete("Finished!");
        Assert.assertEquals((Object)MonitoredTask.State.COMPLETE, (Object)task.getState());
        Assert.assertEquals((long)1L, (long)tm.getTasks().size());
        task.expireNow();
        Assert.assertEquals((long)0L, (long)tm.getTasks().size());
        tm.shutdown();
    }

    @Test
    public void testTasksGetAbortedOnLeak() throws InterruptedException {
        final TaskMonitor tm = new TaskMonitor(new Configuration());
        Assert.assertTrue((String)"Task monitor should start empty", (boolean)tm.getTasks().isEmpty());
        final AtomicBoolean threadSuccess = new AtomicBoolean(false);
        Thread t = new Thread(){

            @Override
            public void run() {
                MonitoredTask task = tm.createStatus("Test task");
                Assert.assertEquals((Object)MonitoredTask.State.RUNNING, (Object)task.getState());
                threadSuccess.set(true);
            }
        };
        t.start();
        t.join();
        Assert.assertTrue((boolean)threadSuccess.get());
        System.gc();
        System.gc();
        System.gc();
        MonitoredTask taskFromTm = (MonitoredTask)tm.getTasks().get(0);
        Assert.assertEquals((Object)MonitoredTask.State.ABORTED, (Object)taskFromTm.getState());
        tm.shutdown();
    }

    @Test
    public void testTaskLimit() throws Exception {
        TaskMonitor tm = new TaskMonitor(new Configuration());
        for (int i = 0; i < 1010; ++i) {
            tm.createStatus("task " + i);
        }
        Assert.assertEquals((long)1000L, (long)tm.getTasks().size());
        Assert.assertEquals((Object)"task 10", (Object)((MonitoredTask)tm.getTasks().get(0)).getDescription());
        tm.shutdown();
    }

    @Test
    public void testDoNotPurgeRPCTask() throws Exception {
        int i;
        int RPCTaskNums = 10;
        TaskMonitor tm = TaskMonitor.get();
        for (i = 0; i < RPCTaskNums; ++i) {
            tm.createRPCStatus("PRCTask" + i);
        }
        for (i = 0; i < 1000; ++i) {
            tm.createStatus("otherTask" + i);
        }
        int remainRPCTask = 0;
        for (MonitoredTask task : tm.getTasks()) {
            if (!(task instanceof MonitoredRPCHandler)) continue;
            ++remainRPCTask;
        }
        Assert.assertEquals((String)"RPC Tasks have been purged!", (long)RPCTaskNums, (long)remainRPCTask);
        tm.shutdown();
    }

    @Test
    public void testWarnStuckTasks() throws Exception {
        int INTERVAL = 1000;
        Configuration conf = new Configuration();
        conf.setLong("hbase.taskmonitor.rpc.warn.time", 1000L);
        conf.setLong("hbase.taskmonitor.monitor.interval", 1000L);
        TaskMonitor tm = new TaskMonitor(conf);
        MonitoredRPCHandler t = tm.createRPCStatus("test task");
        long then = EnvironmentEdgeManager.currentTime();
        t.setRPC("testMethod", new Object[0], then);
        Thread.sleep(2000L);
        Assert.assertTrue((String)"We did not warn", (t.getWarnTime() > then ? 1 : 0) != 0);
        tm.shutdown();
    }

    @Test
    public void testGetTasksWithFilter() throws Exception {
        TaskMonitor tm = new TaskMonitor(new Configuration());
        Assert.assertTrue((String)"Task monitor should start empty", (boolean)tm.getTasks().isEmpty());
        tm.createStatus("General task1");
        tm.createStatus("General task2");
        tm.createStatus("General task3");
        tm.createStatus("General task4");
        tm.createStatus("General task5");
        int length = 5;
        ArrayList<MonitoredRPCHandler> rpcHandlers = new ArrayList<MonitoredRPCHandler>(length);
        for (int i = 0; i < length; ++i) {
            MonitoredRPCHandler rpcHandler = tm.createRPCStatus("Rpc task" + i);
            rpcHandlers.add(rpcHandler);
        }
        byte[] row = new byte[]{1};
        Put m = new Put(row);
        Scan q = new Scan();
        String notOperation = "for test";
        ((MonitoredRPCHandler)rpcHandlers.get(0)).setRPC("operations", new Object[]{m, q}, 3000L);
        ((MonitoredRPCHandler)rpcHandlers.get(1)).setRPC("operations", new Object[]{m, q}, 3000L);
        ((MonitoredRPCHandler)rpcHandlers.get(2)).setRPC("operations", new Object[]{m, q}, 3000L);
        ((MonitoredRPCHandler)rpcHandlers.get(3)).setRPC("operations", new Object[]{notOperation}, 3000L);
        ((MonitoredRPCHandler)rpcHandlers.get(4)).setRPC("operations", new Object[]{m, q}, 3000L);
        MonitoredRPCHandler completed = (MonitoredRPCHandler)rpcHandlers.get(4);
        completed.markComplete("Completed!");
        List generalTasks = tm.getTasks("general");
        Assert.assertEquals((long)5L, (long)generalTasks.size());
        List handlerTasks = tm.getTasks("handler");
        Assert.assertEquals((long)5L, (long)handlerTasks.size());
        List rpcTasks = tm.getTasks("rpc");
        Assert.assertEquals((long)4L, (long)rpcTasks.size());
        List operationTasks = tm.getTasks("operation");
        Assert.assertEquals((long)3L, (long)operationTasks.size());
        tm.shutdown();
    }
}

