/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaState;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.quotas.UserQuotaState;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestQuotaState {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaState.class);
    private static final TableName UNKNOWN_TABLE_NAME = TableName.valueOf((String)"unknownTable");
    @Rule
    public TestName name = new TestName();

    @Test
    public void testQuotaStateBypass() {
        QuotaState quotaInfo = new QuotaState();
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        this.assertNoopLimiter(quotaInfo.getGlobalLimiter());
        UserQuotaState userQuotaState = new UserQuotaState();
        Assert.assertTrue((boolean)userQuotaState.isBypass());
        this.assertNoopLimiter(userQuotaState.getTableLimiter(UNKNOWN_TABLE_NAME));
    }

    @Test
    public void testSimpleQuotaStateOperation() {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        int NUM_GLOBAL_THROTTLE = 3;
        int NUM_TABLE_THROTTLE = 2;
        UserQuotaState quotaInfo = new UserQuotaState();
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        quotaInfo.setQuotas(this.buildReqNumThrottle(3L));
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        quotaInfo.setQuotas(tableName, this.buildReqNumThrottle(2L));
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        Assert.assertTrue((quotaInfo.getGlobalLimiter() == quotaInfo.getTableLimiter(UNKNOWN_TABLE_NAME) ? 1 : 0) != 0);
        this.assertThrottleException(quotaInfo.getTableLimiter(UNKNOWN_TABLE_NAME), 3);
        this.assertThrottleException(quotaInfo.getTableLimiter(tableName), 2);
    }

    @Test
    public void testQuotaStateUpdateBypassThrottle() {
        long LAST_UPDATE = 10L;
        UserQuotaState quotaInfo = new UserQuotaState();
        Assert.assertEquals((long)0L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        UserQuotaState otherQuotaState = new UserQuotaState(10L);
        Assert.assertEquals((long)10L, (long)otherQuotaState.getLastUpdate());
        Assert.assertTrue((boolean)otherQuotaState.isBypass());
        quotaInfo.update((QuotaState)otherQuotaState);
        Assert.assertEquals((long)10L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        Assert.assertTrue((quotaInfo.getGlobalLimiter() == quotaInfo.getTableLimiter(UNKNOWN_TABLE_NAME) ? 1 : 0) != 0);
        this.assertNoopLimiter(quotaInfo.getTableLimiter(UNKNOWN_TABLE_NAME));
    }

    @Test
    public void testQuotaStateUpdateGlobalThrottle() {
        int NUM_GLOBAL_THROTTLE_1 = 3;
        int NUM_GLOBAL_THROTTLE_2 = 11;
        long LAST_UPDATE_1 = 10L;
        long LAST_UPDATE_2 = 20L;
        long LAST_UPDATE_3 = 30L;
        QuotaState quotaInfo = new QuotaState();
        Assert.assertEquals((long)0L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        QuotaState otherQuotaState = new QuotaState(10L);
        otherQuotaState.setQuotas(this.buildReqNumThrottle(3L));
        Assert.assertEquals((long)10L, (long)otherQuotaState.getLastUpdate());
        Assert.assertFalse((boolean)otherQuotaState.isBypass());
        quotaInfo.update(otherQuotaState);
        Assert.assertEquals((long)10L, (long)quotaInfo.getLastUpdate());
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        this.assertThrottleException(quotaInfo.getGlobalLimiter(), 3);
        otherQuotaState = new QuotaState(20L);
        otherQuotaState.setQuotas(this.buildReqNumThrottle(11L));
        Assert.assertEquals((long)20L, (long)otherQuotaState.getLastUpdate());
        Assert.assertFalse((boolean)otherQuotaState.isBypass());
        quotaInfo.update(otherQuotaState);
        Assert.assertEquals((long)20L, (long)quotaInfo.getLastUpdate());
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        this.assertThrottleException(quotaInfo.getGlobalLimiter(), 8);
        otherQuotaState = new QuotaState(30L);
        Assert.assertEquals((long)30L, (long)otherQuotaState.getLastUpdate());
        Assert.assertTrue((boolean)otherQuotaState.isBypass());
        quotaInfo.update(otherQuotaState);
        Assert.assertEquals((long)30L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        this.assertNoopLimiter(quotaInfo.getGlobalLimiter());
    }

    @Test
    public void testQuotaStateUpdateTableThrottle() {
        TableName tableNameA = TableName.valueOf((String)(this.name.getMethodName() + "A"));
        TableName tableNameB = TableName.valueOf((String)(this.name.getMethodName() + "B"));
        TableName tableNameC = TableName.valueOf((String)(this.name.getMethodName() + "C"));
        int TABLE_A_THROTTLE_1 = 3;
        int TABLE_A_THROTTLE_2 = 11;
        int TABLE_B_THROTTLE = 4;
        int TABLE_C_THROTTLE = 5;
        long LAST_UPDATE_1 = 10L;
        long LAST_UPDATE_2 = 20L;
        long LAST_UPDATE_3 = 30L;
        UserQuotaState quotaInfo = new UserQuotaState();
        Assert.assertEquals((long)0L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        UserQuotaState otherQuotaState = new UserQuotaState(10L);
        otherQuotaState.setQuotas(tableNameA, this.buildReqNumThrottle(3L));
        otherQuotaState.setQuotas(tableNameB, this.buildReqNumThrottle(4L));
        Assert.assertEquals((long)10L, (long)otherQuotaState.getLastUpdate());
        Assert.assertFalse((boolean)otherQuotaState.isBypass());
        quotaInfo.update((QuotaState)otherQuotaState);
        Assert.assertEquals((long)10L, (long)quotaInfo.getLastUpdate());
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        this.assertThrottleException(quotaInfo.getTableLimiter(tableNameA), 3);
        this.assertThrottleException(quotaInfo.getTableLimiter(tableNameB), 4);
        this.assertNoopLimiter(quotaInfo.getTableLimiter(tableNameC));
        otherQuotaState = new UserQuotaState(20L);
        otherQuotaState.setQuotas(tableNameA, this.buildReqNumThrottle(11L));
        otherQuotaState.setQuotas(tableNameC, this.buildReqNumThrottle(5L));
        Assert.assertEquals((long)20L, (long)otherQuotaState.getLastUpdate());
        Assert.assertFalse((boolean)otherQuotaState.isBypass());
        quotaInfo.update((QuotaState)otherQuotaState);
        Assert.assertEquals((long)20L, (long)quotaInfo.getLastUpdate());
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        this.assertThrottleException(quotaInfo.getTableLimiter(tableNameA), 8);
        this.assertThrottleException(quotaInfo.getTableLimiter(tableNameC), 5);
        this.assertNoopLimiter(quotaInfo.getTableLimiter(tableNameB));
        otherQuotaState = new UserQuotaState(30L);
        Assert.assertEquals((long)30L, (long)otherQuotaState.getLastUpdate());
        Assert.assertTrue((boolean)otherQuotaState.isBypass());
        quotaInfo.update((QuotaState)otherQuotaState);
        Assert.assertEquals((long)30L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        this.assertNoopLimiter(quotaInfo.getTableLimiter(UNKNOWN_TABLE_NAME));
    }

    @Test(timeout=60000L)
    public void testTableThrottleWithBatch() {
        TableName TABLE_A = TableName.valueOf((String)"TableA");
        int TABLE_A_THROTTLE_1 = 3;
        long LAST_UPDATE_1 = 10L;
        UserQuotaState quotaInfo = new UserQuotaState();
        Assert.assertEquals((long)0L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        UserQuotaState otherQuotaState = new UserQuotaState(10L);
        otherQuotaState.setQuotas(TABLE_A, this.buildReqNumThrottle(3L));
        Assert.assertEquals((long)10L, (long)otherQuotaState.getLastUpdate());
        Assert.assertFalse((boolean)otherQuotaState.isBypass());
        quotaInfo.update((QuotaState)otherQuotaState);
        Assert.assertEquals((long)10L, (long)quotaInfo.getLastUpdate());
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        QuotaLimiter limiter = quotaInfo.getTableLimiter(TABLE_A);
        try {
            limiter.checkQuota(4L, 4L, 0L, 0L);
            Assert.fail((String)"Should have thrown RpcThrottlingException");
        }
        catch (RpcThrottlingException rpcThrottlingException) {
            // empty catch block
        }
    }

    private QuotaProtos.Quotas buildReqNumThrottle(long limit) {
        return QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqNum(ProtobufUtil.toTimedQuota((long)limit, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.MACHINE)).build()).build();
    }

    private void assertThrottleException(QuotaLimiter limiter, int availReqs) {
        this.assertNoThrottleException(limiter, availReqs);
        try {
            limiter.checkQuota(1L, 1L, 0L, 0L);
            Assert.fail((String)"Should have thrown RpcThrottlingException");
        }
        catch (RpcThrottlingException rpcThrottlingException) {
            // empty catch block
        }
    }

    private void assertNoThrottleException(QuotaLimiter limiter, int availReqs) {
        for (int i = 0; i < availReqs; ++i) {
            try {
                limiter.checkQuota(1L, 1L, 0L, 0L);
            }
            catch (RpcThrottlingException e) {
                Assert.fail((String)("Unexpected RpcThrottlingException after " + i + " requests. limit=" + availReqs));
            }
            limiter.grabQuota(1L, 1L, 0L, 0L);
        }
    }

    private void assertNoopLimiter(QuotaLimiter limiter) {
        Assert.assertTrue((limiter == NoopQuotaLimiter.get() ? 1 : 0) != 0);
        this.assertNoThrottleException(limiter, 100);
    }
}

