/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.ActivePolicyEnforcement;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.SpaceLimitingException;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.MissingSnapshotViolationPolicyEnforcement;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestQuotaStatusRPCs {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaStatusRPCs.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestQuotaStatusRPCs.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setupForTest() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, COUNTER);
    }

    @Test
    public void testRegionSizesFromMaster() throws Exception {
        long tableSize = 10240L;
        int numRegions = 10;
        final TableName tn = this.helper.createTableWithRegions(10);
        this.helper.writeData(tn, 10240L);
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        final MasterQuotaManager quotaManager = master.getMasterQuotaManager();
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map regionSizes = quotaManager.snapshotRegionSizes();
                LOG.trace("Region sizes=" + regionSizes);
                return 10 == TestQuotaStatusRPCs.this.countRegionsForTable(tn, regionSizes) && 10240L <= (long)TestQuotaStatusRPCs.this.getTableSize(tn, regionSizes);
            }
        });
        Map sizes = QuotaTableUtil.getMasterReportedTableSizes((Connection)TEST_UTIL.getConnection());
        Long size = (Long)sizes.get(tn);
        Assert.assertNotNull((String)("No reported size for " + tn), (Object)size);
        Assert.assertTrue((String)("Reported table size was " + size), (size >= 10240L ? 1 : 0) != 0);
    }

    @Test
    public void testQuotaSnapshotsFromRS() throws Exception {
        long sizeLimit = 0x100000L;
        long tableSize = 10240L;
        int numRegions = 10;
        final TableName tn = this.helper.createTableWithRegions(10);
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x100000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        TEST_UTIL.getAdmin().setQuota(settings);
        this.helper.writeData(tn, 10240L);
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        final RegionServerSpaceQuotaManager manager = rs.getRegionServerSpaceQuotaManager();
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                SpaceQuotaSnapshot snapshot = (SpaceQuotaSnapshot)manager.copyQuotaSnapshots().get(tn);
                if (snapshot == null) {
                    return false;
                }
                return snapshot.getUsage() >= 10240L;
            }
        });
        Map snapshots = QuotaTableUtil.getRegionServerQuotaSnapshots((Connection)TEST_UTIL.getConnection(), (ServerName)rs.getServerName());
        SpaceQuotaSnapshot snapshot = (SpaceQuotaSnapshot)snapshots.get(tn);
        Assert.assertNotNull((String)("Did not find snapshot for " + tn), (Object)snapshot);
        Assert.assertTrue((String)("Observed table usage was " + snapshot.getUsage()), (snapshot.getUsage() >= 10240L ? 1 : 0) != 0);
        Assert.assertEquals((long)0x100000L, (long)snapshot.getLimit());
        SpaceQuotaSnapshot.SpaceQuotaStatus pbStatus = snapshot.getQuotaStatus();
        Assert.assertFalse((boolean)pbStatus.isInViolation());
    }

    @Test
    public void testQuotaEnforcementsFromRS() throws Exception {
        long sizeLimit = 8192L;
        long tableSize = 10240L;
        int numRegions = 10;
        final TableName tn = this.helper.createTableWithRegions(10);
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)8192L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        TEST_UTIL.getAdmin().setQuota(settings);
        try {
            this.helper.writeData(tn, 10240L);
        }
        catch (RetriesExhaustedWithDetailsException | SpaceLimitingException throwable) {
            // empty catch block
        }
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        final RegionServerSpaceQuotaManager manager = rs.getRegionServerSpaceQuotaManager();
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ActivePolicyEnforcement enforcements = manager.getActiveEnforcements();
                SpaceViolationPolicyEnforcement enforcement = enforcements.getPolicyEnforcement(tn);
                if (enforcement instanceof MissingSnapshotViolationPolicyEnforcement) {
                    return false;
                }
                return enforcement.getQuotaSnapshot().getQuotaStatus().isInViolation();
            }
        });
        Map snapshots = QuotaTableUtil.getRegionServerQuotaSnapshots((Connection)TEST_UTIL.getConnection(), (ServerName)rs.getServerName());
        SpaceQuotaSnapshot snapshot = (SpaceQuotaSnapshot)snapshots.get(tn);
        Assert.assertNotNull((String)("Did not find snapshot for " + tn), (Object)snapshot);
        Assert.assertTrue((boolean)snapshot.getQuotaStatus().isInViolation());
        Assert.assertEquals((Object)SpaceViolationPolicy.NO_INSERTS, (Object)snapshot.getQuotaStatus().getPolicy());
    }

    @Test
    public void testQuotaStatusFromMaster() throws Exception {
        long sizeLimit = 25600L;
        long tableSize = 1024L;
        long nsLimit = Long.MAX_VALUE;
        int numRegions = 10;
        final TableName tn = this.helper.createTableWithRegions(10);
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)25600L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        TEST_UTIL.getAdmin().setQuota(settings);
        QuotaSettings nsSettings = QuotaSettingsFactory.limitNamespaceSpace((String)tn.getNamespaceAsString(), (long)Long.MAX_VALUE, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        TEST_UTIL.getAdmin().setQuota(nsSettings);
        this.helper.writeData(tn, 1024L);
        final Connection conn = TEST_UTIL.getConnection();
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                SpaceQuotaSnapshot snapshot = QuotaTableUtil.getCurrentSnapshot((Connection)conn, (TableName)tn);
                LOG.info("Table snapshot after initial ingest: " + snapshot);
                if (snapshot == null) {
                    return false;
                }
                return snapshot.getLimit() == 25600L && snapshot.getUsage() > 0L;
            }
        });
        final AtomicReference nsUsage = new AtomicReference();
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                SpaceQuotaSnapshot snapshot = QuotaTableUtil.getCurrentSnapshot((Connection)conn, (String)tn.getNamespaceAsString());
                LOG.debug("Namespace snapshot after initial ingest: " + snapshot);
                if (snapshot == null) {
                    return false;
                }
                nsUsage.set(snapshot.getUsage());
                return snapshot.getLimit() == Long.MAX_VALUE && snapshot.getUsage() > 0L;
            }
        });
        SpaceQuotaSnapshot snapshot = QuotaTableUtil.getCurrentSnapshot((Connection)conn, (TableName)tn);
        Assert.assertTrue((String)("QuotaSnapshot for " + tn + " should be non-null and not in violation"), (snapshot != null && !snapshot.getQuotaStatus().isInViolation() ? 1 : 0) != 0);
        try {
            this.helper.writeData(tn, 2048L);
        }
        catch (RetriesExhaustedWithDetailsException | SpaceLimitingException throwable) {
            // empty catch block
        }
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                SpaceQuotaSnapshot snapshot = QuotaTableUtil.getCurrentSnapshot((Connection)conn, (TableName)tn);
                LOG.info("Table snapshot after second ingest: " + snapshot);
                if (snapshot == null) {
                    return false;
                }
                return snapshot.getQuotaStatus().isInViolation();
            }
        });
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                SpaceQuotaSnapshot snapshot = QuotaTableUtil.getCurrentSnapshot((Connection)conn, (String)tn.getNamespaceAsString());
                LOG.debug("Namespace snapshot after second ingest: " + snapshot);
                if (snapshot == null) {
                    return false;
                }
                return snapshot.getUsage() > (Long)nsUsage.get() && !snapshot.getQuotaStatus().isInViolation();
            }
        });
    }

    private int countRegionsForTable(TableName tn, Map<RegionInfo, Long> regionSizes) {
        int size = 0;
        for (RegionInfo regionInfo : regionSizes.keySet()) {
            if (!tn.equals((Object)regionInfo.getTable())) continue;
            ++size;
        }
        return size;
    }

    private int getTableSize(TableName tn, Map<RegionInfo, Long> regionSizes) {
        int tableSize = 0;
        for (Map.Entry<RegionInfo, Long> entry : regionSizes.entrySet()) {
            RegionInfo regionInfo = entry.getKey();
            long regionSize = entry.getValue();
            if (!tn.equals((Object)regionInfo.getTable())) continue;
            tableSize = (int)((long)tableSize + regionSize);
        }
        return tableSize;
    }
}

