/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.MockHStoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCompactionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TestCompactionPolicy.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected Configuration conf;
    protected HStore store;
    private static final String DIR = TEST_UTIL.getDataTestDir(TestCompactionPolicy.class.getSimpleName()).toString();
    protected static Path TEST_FILE;
    protected static final int minFiles = 3;
    protected static final int maxFiles = 5;
    protected static final long minSize = 10L;
    protected static final long maxSize = 2100L;
    private FSHLog hlog;
    private HRegion region;

    @Before
    public void setUp() throws Exception {
        this.config();
        this.initialize();
    }

    protected void config() {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setLong("hbase.hregion.majorcompaction", 0L);
        this.conf.setInt("hbase.hstore.compaction.min", 3);
        this.conf.setInt("hbase.hstore.compaction.max", 5);
        this.conf.setLong("hbase.hstore.compaction.min.size", 10L);
        this.conf.setLong("hbase.hstore.compaction.max.size", 2100L);
        this.conf.setFloat("hbase.hstore.compaction.ratio", 1.0f);
    }

    protected void initialize() throws IOException {
        Path basedir = new Path(DIR);
        String logName = "logs";
        Path logdir = new Path(DIR, logName);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes((String)"family"));
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.delete(logdir, true);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])Bytes.toBytes((String)"table")));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.hlog = new FSHLog(fs, basedir, logName, this.conf);
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
        this.region = HRegion.createHRegion((RegionInfo)info, (Path)basedir, (Configuration)this.conf, (TableDescriptor)htd, (WAL)this.hlog);
        this.region.close();
        Path tableDir = FSUtils.getTableDir((Path)basedir, (TableName)htd.getTableName());
        this.region = new HRegion(tableDir, (WAL)this.hlog, fs, this.conf, (RegionInfo)info, (TableDescriptor)htd, null);
        this.store = new HStore(this.region, (ColumnFamilyDescriptor)hcd, this.conf);
        TEST_FILE = this.region.getRegionFileSystem().createTempName();
        fs.createNewFile(TEST_FILE);
    }

    @After
    public void tearDown() throws IOException {
        IOException ex = null;
        try {
            this.region.close();
        }
        catch (IOException e) {
            LOG.warn("Caught Exception", (Throwable)e);
            ex = e;
        }
        try {
            this.hlog.close();
        }
        catch (IOException e) {
            LOG.warn("Caught Exception", (Throwable)e);
            ex = e;
        }
        if (ex != null) {
            throw ex;
        }
    }

    ArrayList<Long> toArrayList(long ... numbers) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (long i : numbers) {
            result.add(i);
        }
        return result;
    }

    List<HStoreFile> sfCreate(long ... sizes) throws IOException {
        ArrayList<Long> ageInDisk = new ArrayList<Long>();
        for (int i = 0; i < sizes.length; ++i) {
            ageInDisk.add(0L);
        }
        return this.sfCreate(this.toArrayList(sizes), ageInDisk);
    }

    List<HStoreFile> sfCreate(ArrayList<Long> sizes, ArrayList<Long> ageInDisk) throws IOException {
        return this.sfCreate(false, sizes, ageInDisk);
    }

    List<HStoreFile> sfCreate(boolean isReference, long ... sizes) throws IOException {
        ArrayList<Long> ageInDisk = new ArrayList<Long>(sizes.length);
        for (int i = 0; i < sizes.length; ++i) {
            ageInDisk.add(0L);
        }
        return this.sfCreate(isReference, this.toArrayList(sizes), ageInDisk);
    }

    List<HStoreFile> sfCreate(boolean isReference, ArrayList<Long> sizes, ArrayList<Long> ageInDisk) throws IOException {
        ArrayList ret = Lists.newArrayList();
        for (int i = 0; i < sizes.size(); ++i) {
            ret.add(new MockHStoreFile(TEST_UTIL, TEST_FILE, sizes.get(i), ageInDisk.get(i), isReference, i));
        }
        return ret;
    }

    long[] getSizes(List<HStoreFile> sfList) {
        long[] aNums = new long[sfList.size()];
        for (int i = 0; i < sfList.size(); ++i) {
            aNums[i] = sfList.get(i).getReader().length();
        }
        return aNums;
    }

    void compactEquals(List<HStoreFile> candidates, long ... expected) throws IOException {
        this.compactEquals(candidates, false, false, expected);
    }

    void compactEquals(List<HStoreFile> candidates, boolean forcemajor, long ... expected) throws IOException {
        this.compactEquals(candidates, forcemajor, false, expected);
    }

    void compactEquals(List<HStoreFile> candidates, boolean forcemajor, boolean isOffPeak, long ... expected) throws IOException {
        this.store.forceMajor = forcemajor;
        CompactionRequestImpl result = ((RatioBasedCompactionPolicy)this.store.storeEngine.getCompactionPolicy()).selectCompaction(candidates, new ArrayList(), false, isOffPeak, forcemajor);
        ArrayList<HStoreFile> actual = new ArrayList<HStoreFile>(result.getFiles());
        if (isOffPeak && !forcemajor) {
            Assert.assertTrue((boolean)result.isOffPeak());
        }
        Assert.assertEquals((Object)Arrays.toString(expected), (Object)Arrays.toString(this.getSizes(actual)));
        this.store.forceMajor = false;
    }
}

