/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.FlushRequestListener;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestWALReplay {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestWALReplay.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final EnvironmentEdge ee = EnvironmentEdgeManager.getDelegate();
    private Path hbaseRootDir = null;
    private String logName;
    private Path oldLogDir;
    private Path logDir;
    private FileSystem fs;
    private Configuration conf;
    private WALFactory wals;
    @Rule
    public final TestName currentTest = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("dfs.client.block.recovery.retries", 2);
        TEST_UTIL.startMiniCluster(3);
        Path hbaseRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbase"));
        LOG.info("hbase.rootdir=" + hbaseRootDir);
        FSUtils.setRootDir((Configuration)conf, (Path)hbaseRootDir);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.hbaseRootDir = FSUtils.getRootDir((Configuration)this.conf);
        this.oldLogDir = new Path(this.hbaseRootDir, "oldWALs");
        String serverName = ServerName.valueOf((String)(this.currentTest.getMethodName() + "-manual"), (int)16010, (long)System.currentTimeMillis()).toString();
        this.logName = AbstractFSWALProvider.getWALDirectoryName((String)serverName);
        this.logDir = new Path(this.hbaseRootDir, this.logName);
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        }
        this.wals = new WALFactory(this.conf, this.currentTest.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        this.wals.close();
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
    }

    private void deleteDir(Path p) throws IOException {
        if (this.fs.exists(p) && !this.fs.delete(p, true)) {
            throw new IOException("Failed remove of " + p);
        }
    }

    @Test
    public void testReplayEditsAfterRegionMovedWithMultiCF() throws Exception {
        int destServerNum;
        TableName tableName = TableName.valueOf((String)"testReplayEditsAfterRegionMovedWithMultiCF");
        byte[] family1 = Bytes.toBytes((String)"cf1");
        byte[] family2 = Bytes.toBytes((String)"cf2");
        byte[] qualifier = Bytes.toBytes((String)"q");
        byte[] value = Bytes.toBytes((String)"testV");
        byte[][] familys = new byte[][]{family1, family2};
        TEST_UTIL.createTable(tableName, (byte[][])familys);
        Table htable = TEST_UTIL.getConnection().getTable(tableName);
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.addColumn(family1, qualifier, value);
        htable.put(put);
        ResultScanner resultScanner = htable.getScanner(new Scan());
        int count = 0;
        while (resultScanner.next() != null) {
            ++count;
        }
        resultScanner.close();
        Assert.assertEquals((long)1L, (long)count);
        MiniHBaseCluster hbaseCluster = TEST_UTIL.getMiniHBaseCluster();
        List<HRegion> regions = hbaseCluster.getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        Region destRegion = (Region)regions.get(0);
        int originServerNum = hbaseCluster.getServerWith(destRegion.getRegionInfo().getRegionName());
        Assert.assertTrue((String)"Please start more than 1 regionserver", (hbaseCluster.getRegionServerThreads().size() > 1 ? 1 : 0) != 0);
        for (destServerNum = 0; destServerNum == originServerNum; ++destServerNum) {
        }
        HRegionServer originServer = hbaseCluster.getRegionServer(originServerNum);
        HRegionServer destServer = hbaseCluster.getRegionServer(destServerNum);
        TEST_UTIL.moveRegionAndWait(destRegion.getRegionInfo(), destServer.getServerName());
        Delete del = new Delete(Bytes.toBytes((String)"r1"));
        htable.delete(del);
        resultScanner = htable.getScanner(new Scan());
        count = 0;
        while (resultScanner.next() != null) {
            ++count;
        }
        resultScanner.close();
        Assert.assertEquals((long)0L, (long)count);
        HRegion region = destServer.getOnlineRegion(destRegion.getRegionInfo().getRegionName());
        region.flush(true);
        for (HStore store : region.getStores()) {
            store.triggerMajorCompaction();
        }
        region.compact(true);
        TEST_UTIL.moveRegionAndWait(destRegion.getRegionInfo(), originServer.getServerName());
        originServer.abort("testing");
        Result result = htable.get(new Get(Bytes.toBytes((String)"r1")));
        if (result != null) {
            Assert.assertTrue((String)("Row is deleted, but we get" + result.toString()), (result == null || result.isEmpty() ? 1 : 0) != 0);
        }
        resultScanner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2727() throws Exception {
        TableName tableName = TableName.valueOf((String)"test2727");
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, this.hbaseRootDir, this.conf, (TableDescriptor)htd);
        HBaseTestingUtility.closeRegionAndWAL((Region)region2);
        byte[] rowName = tableName.getName();
        WAL wal1 = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        int countPerFamily = 1000;
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getFamiliesKeys()) {
            scopes.put(fam, 0);
        }
        for (Object hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, rowName, hcd.getName(), 1000, this.ee, wal1, htd, mvcc, scopes);
        }
        wal1.shutdown();
        this.runWALSplit(this.conf);
        WAL wal2 = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, rowName, hcd.getName(), 1000, this.ee, wal2, htd, mvcc, scopes);
        }
        wal2.shutdown();
        this.runWALSplit(this.conf);
        try (WAL wal3 = this.createWAL(this.conf, this.hbaseRootDir, this.logName);){
            HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal3);
            long seqid = region.getOpenSeqNum();
            Assert.assertTrue((seqid > mvcc.getWritePoint() ? 1 : 0) != 0);
            Assert.assertEquals((long)(seqid - 1L), (long)mvcc.getWritePoint());
            LOG.debug("region.getOpenSeqNum(): " + region.getOpenSeqNum() + ", wal3.id: " + mvcc.getReadPoint());
            region.close();
        }
    }

    @Test
    public void testRegionMadeOfBulkLoadedFilesOnly() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testRegionMadeOfBulkLoadedFilesOnly");
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = new Path(this.hbaseRootDir, tableName.getNameAsString());
        this.deleteDir(basedir);
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, this.hbaseRootDir, this.conf, (TableDescriptor)htd);
        HBaseTestingUtility.closeRegionAndWAL((Region)region2);
        WAL wal = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        HRegion region = HRegion.openHRegion((RegionInfo)hri, (TableDescriptor)htd, (WAL)wal, (Configuration)this.conf);
        byte[] family = ((HColumnDescriptor)htd.getFamilies().iterator().next()).getName();
        Path f = new Path(basedir, "hfile");
        HFileTestUtil.createHFile(this.conf, this.fs, f, family, family, Bytes.toBytes((String)""), Bytes.toBytes((String)"z"), 10);
        ArrayList<Pair> hfs = new ArrayList<Pair>(1);
        hfs.add(Pair.newPair((Object)family, (Object)f.toString()));
        region.bulkLoadHFiles(hfs, true, null);
        byte[] row = tableName.getName();
        region.put(new Put(row).addColumn(family, family, family));
        wal.sync();
        int rowsInsertedCount = 11;
        Assert.assertEquals((long)11L, (long)this.getScannedCount((RegionScanner)region.getScanner(new Scan())));
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, tableName.getNameAsString());
        user.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                AbstractTestWALReplay.this.runWALSplit(newConf);
                WAL wal2 = AbstractTestWALReplay.this.createWAL(newConf, AbstractTestWALReplay.this.hbaseRootDir, AbstractTestWALReplay.this.logName);
                HRegion region2 = HRegion.openHRegion((Configuration)newConf, (FileSystem)FileSystem.get((Configuration)newConf), (Path)AbstractTestWALReplay.this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal2);
                long seqid2 = region2.getOpenSeqNum();
                Assert.assertTrue((seqid2 > -1L ? 1 : 0) != 0);
                Assert.assertEquals((long)11L, (long)AbstractTestWALReplay.this.getScannedCount((RegionScanner)region2.getScanner(new Scan())));
                region2.close();
                wal2.close();
                return null;
            }
        });
    }

    @Test
    public void testCompactedBulkLoadedFiles() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testCompactedBulkLoadedFiles");
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = new Path(this.hbaseRootDir, tableName.getNameAsString());
        this.deleteDir(basedir);
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, this.hbaseRootDir, this.conf, (TableDescriptor)htd);
        HBaseTestingUtility.closeRegionAndWAL(region2);
        WAL wal = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        HRegion region = HRegion.openHRegion((RegionInfo)hri, (TableDescriptor)htd, (WAL)wal, (Configuration)this.conf);
        byte[] row = tableName.getName();
        byte[] family = ((HColumnDescriptor)htd.getFamilies().iterator().next()).getName();
        region.put(new Put(row).addColumn(family, family, family));
        wal.sync();
        ArrayList<Pair> hfs = new ArrayList<Pair>(1);
        for (int i = 0; i < 3; ++i) {
            Path f = new Path(basedir, "hfile" + i);
            HFileTestUtil.createHFile(this.conf, this.fs, f, family, family, Bytes.toBytes((String)(i + "00")), Bytes.toBytes((String)(i + "50")), 10);
            hfs.add(Pair.newPair((Object)family, (Object)f.toString()));
        }
        region.bulkLoadHFiles(hfs, true, null);
        int rowsInsertedCount = 31;
        Assert.assertEquals((long)31L, (long)this.getScannedCount((RegionScanner)region.getScanner(new Scan())));
        region.compact(true);
        Assert.assertEquals((long)31L, (long)this.getScannedCount((RegionScanner)region.getScanner(new Scan())));
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, tableName.getNameAsString());
        user.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                AbstractTestWALReplay.this.runWALSplit(newConf);
                WAL wal2 = AbstractTestWALReplay.this.createWAL(newConf, AbstractTestWALReplay.this.hbaseRootDir, AbstractTestWALReplay.this.logName);
                HRegion region2 = HRegion.openHRegion((Configuration)newConf, (FileSystem)FileSystem.get((Configuration)newConf), (Path)AbstractTestWALReplay.this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal2);
                long seqid2 = region2.getOpenSeqNum();
                Assert.assertTrue((seqid2 > -1L ? 1 : 0) != 0);
                Assert.assertEquals((long)31L, (long)AbstractTestWALReplay.this.getScannedCount((RegionScanner)region2.getScanner(new Scan())));
                region2.close();
                wal2.close();
                return null;
            }
        });
    }

    @Test
    public void testReplayEditsWrittenViaHRegion() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenViaHRegion");
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        final Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region3 = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, this.hbaseRootDir, this.conf, (TableDescriptor)htd);
        HBaseTestingUtility.closeRegionAndWAL(region3);
        WAL wal = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal);
        long seqid = region.getOpenSeqNum();
        boolean first = true;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            AbstractTestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, this.ee, (Region)region, "x");
            if (!first) continue;
            region.flush(true);
            first = false;
        }
        final Get g = new Get(rowName);
        Result result = region.get(g);
        Assert.assertEquals((long)(10 * htd.getFamilies().size()), (long)result.size());
        region.close(true);
        wal.shutdown();
        this.runWALSplit(this.conf);
        WAL wal2 = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal2);
        long seqid2 = region2.getOpenSeqNum();
        Assert.assertTrue((seqid + (long)result.size() < seqid2 ? 1 : 0) != 0);
        Result result1b = region2.get(g);
        Assert.assertEquals((long)result.size(), (long)result1b.size());
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            AbstractTestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, this.ee, (Region)region2, "y");
        }
        final Result result2 = region2.get(g);
        Assert.assertEquals((long)(2 * result.size()), (long)result2.size());
        wal2.sync();
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, tableName.getNameAsString());
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                AbstractTestWALReplay.this.runWALSplit(newConf);
                FileSystem newFS = FileSystem.get((Configuration)newConf);
                WAL wal3 = AbstractTestWALReplay.this.createWAL(newConf, AbstractTestWALReplay.this.hbaseRootDir, AbstractTestWALReplay.this.logName);
                final AtomicInteger countOfRestoredEdits = new AtomicInteger(0);
                HRegion region3 = new HRegion(basedir, wal3, newFS, newConf, (RegionInfo)hri, (TableDescriptor)htd, null){

                    protected void restoreEdit(HStore s, Cell cell, MemStoreSizing memstoreSizing) {
                        super.restoreEdit(s, cell, memstoreSizing);
                        countOfRestoredEdits.incrementAndGet();
                    }
                };
                long seqid3 = region3.initialize();
                Result result3 = region3.get(g);
                Assert.assertEquals((long)result2.size(), (long)result3.size());
                Assert.assertEquals((long)(htd.getFamilies().size() * 10), (long)countOfRestoredEdits.get());
                region3.close();
                wal3.close();
                return null;
            }
        });
    }

    @Test
    public void testReplayEditsAfterPartialFlush() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenViaHRegion");
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region3 = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, this.hbaseRootDir, this.conf, (TableDescriptor)htd);
        HBaseTestingUtility.closeRegionAndWAL(region3);
        WAL wal = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal);
        long seqid = region.getOpenSeqNum();
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            AbstractTestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, this.ee, (Region)region, "x");
        }
        Get g = new Get(rowName);
        Result result = region.get(g);
        Assert.assertEquals((long)(10 * htd.getFamilies().size()), (long)result.size());
        region.flush(true);
        region.close(true);
        wal.shutdown();
        int cf_count = 0;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            if (++cf_count != 2) continue;
            region.getRegionFileSystem().deleteFamily(hcd.getNameAsString());
        }
        this.runWALSplit(this.conf);
        WAL wal2 = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal2);
        long seqid2 = region2.getOpenSeqNum();
        Assert.assertTrue((seqid + (long)result.size() < seqid2 ? 1 : 0) != 0);
        Result result1b = region2.get(g);
        Assert.assertEquals((long)result.size(), (long)result1b.size());
    }

    @Test
    public void testReplayEditsAfterAbortingFlush() throws IOException {
        TableName tableName = TableName.valueOf((String)"testReplayEditsAfterAbortingFlush");
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region3 = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, this.hbaseRootDir, this.conf, (TableDescriptor)htd);
        HBaseTestingUtility.closeRegionAndWAL(region3);
        WAL wal = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ((RegionServerServices)Mockito.doReturn((Object)false).when((Object)rsServices)).isAborted();
        Mockito.when((Object)rsServices.getServerName()).thenReturn((Object)ServerName.valueOf((String)"foo", (int)10, (long)10L));
        Configuration customConf = new Configuration(this.conf);
        customConf.set("hbase.hstore.defaultengine.storeflusher.class", CustomStoreFlusher.class.getName());
        HRegion region = HRegion.openHRegion((Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal, (Configuration)customConf, (RegionServerServices)rsServices, null);
        int writtenRowCount = 10;
        ArrayList families = new ArrayList(htd.getFamilies());
        for (int i = 0; i < writtenRowCount; ++i) {
            Put put = new Put(Bytes.toBytes((String)(tableName + Integer.toString(i))));
            put.addColumn(((HColumnDescriptor)families.get(i % families.size())).getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"val"));
            region.put(put);
        }
        HRegion.RegionScannerImpl scanner = region.getScanner(new Scan());
        Assert.assertEquals((long)writtenRowCount, (long)this.getScannedCount((RegionScanner)scanner));
        CustomStoreFlusher.throwExceptionWhenFlushing.set(true);
        try {
            region.flush(true);
            Assert.fail((String)"Injected exception hasn't been thrown");
        }
        catch (IOException e) {
            LOG.info("Expected simulated exception when flushing region, {}", (Object)e.getMessage());
            ((RegionServerServices)Mockito.doReturn((Object)true).when((Object)rsServices)).isAborted();
            region.setClosing(false);
        }
        int moreRow = 10;
        for (int i = writtenRowCount; i < writtenRowCount + moreRow; ++i) {
            Put put = new Put(Bytes.toBytes((String)(tableName + Integer.toString(i))));
            put.addColumn(((HColumnDescriptor)families.get(i % families.size())).getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"val"));
            region.put(put);
        }
        writtenRowCount += moreRow;
        CustomStoreFlusher.throwExceptionWhenFlushing.set(false);
        try {
            region.flush(true);
        }
        catch (IOException t) {
            LOG.info("Expected exception when flushing region because server is stopped," + t.getMessage());
        }
        region.close(true);
        wal.shutdown();
        this.runWALSplit(this.conf);
        WAL wal2 = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        ((RegionServerServices)Mockito.doReturn((Object)false).when((Object)rsServices)).isAborted();
        HRegion region2 = HRegion.openHRegion((Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal2, (Configuration)this.conf, (RegionServerServices)rsServices, null);
        scanner = region2.getScanner(new Scan());
        Assert.assertEquals((long)writtenRowCount, (long)this.getScannedCount((RegionScanner)scanner));
    }

    private int getScannedCount(RegionScanner scanner) throws IOException {
        int scannedCount = 0;
        ArrayList results = new ArrayList();
        while (true) {
            boolean existMore = scanner.next(results);
            if (!results.isEmpty()) {
                ++scannedCount;
            }
            if (!existMore) break;
            results.clear();
        }
        return scannedCount;
    }

    @Test
    public void testReplayEditsWrittenIntoWAL() throws Exception {
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenIntoWAL");
        final MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        final Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, this.hbaseRootDir, this.conf, (TableDescriptor)htd);
        HBaseTestingUtility.closeRegionAndWAL(region2);
        WAL wal = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        final byte[] rowName = tableName.getName();
        byte[] regionName = hri.getEncodedNameAsBytes();
        int countPerFamily = 1000;
        HashSet<byte[]> familyNames = new HashSet<byte[]>();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getFamiliesKeys()) {
            scopes.put(fam, 0);
        }
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, rowName, hcd.getName(), 1000, this.ee, wal, htd, mvcc, scopes);
            familyNames.add(hcd.getName());
        }
        wal.startCacheFlush(regionName, familyNames);
        wal.completeCacheFlush(regionName);
        WALEdit edit = new WALEdit();
        long now = this.ee.currentTime();
        edit.add((Cell)new KeyValue(rowName, Bytes.toBytes((String)"another family"), rowName, now, rowName));
        wal.append((RegionInfo)hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), tableName, now, mvcc, scopes), edit, true);
        edit = new WALEdit();
        now = this.ee.currentTime();
        edit.add((Cell)new KeyValue(rowName, Bytes.toBytes((String)"c"), null, now, KeyValue.Type.DeleteFamily));
        wal.append((RegionInfo)hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), tableName, now, mvcc, scopes), edit, true);
        wal.sync();
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, ".replay.wal.secondtime");
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                AbstractTestWALReplay.this.runWALSplit(newConf);
                FileSystem newFS = FileSystem.get((Configuration)newConf);
                newConf.setInt("hbase.hregion.memstore.flush.size", 102400);
                final AtomicInteger flushcount = new AtomicInteger(0);
                try (WAL newWal = AbstractTestWALReplay.this.createWAL(newConf, AbstractTestWALReplay.this.hbaseRootDir, AbstractTestWALReplay.this.logName);){
                    HRegion region = new HRegion(basedir, newWal, newFS, newConf, (RegionInfo)hri, (TableDescriptor)htd, null){

                        protected HRegion.FlushResultImpl internalFlushcache(WAL wal, long myseqid, Collection<HStore> storesToFlush, MonitoredTask status, boolean writeFlushWalMarker, FlushLifeCycleTracker tracker) throws IOException {
                            LOG.info("InternalFlushCache Invoked");
                            HRegion.FlushResultImpl fs = super.internalFlushcache(wal, myseqid, storesToFlush, (MonitoredTask)Mockito.mock(MonitoredTask.class), writeFlushWalMarker, tracker);
                            flushcount.incrementAndGet();
                            return fs;
                        }
                    };
                    long seqid = region.initialize();
                    long writePoint = mvcc.getWritePoint();
                    Assert.assertTrue((String)("Flushcount=" + flushcount.get()), (flushcount.get() > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((seqid - 1L == writePoint ? 1 : 0) != 0);
                    Get get = new Get(rowName);
                    Result result = region.get(get);
                    Assert.assertEquals((long)(1000 * (htd.getFamilies().size() - 1)), (long)result.size());
                    region.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testSequentialEditLogSeqNum() throws IOException {
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        HTableDescriptor htd = this.createBasic1FamilyHTD(tableName);
        MockWAL wal = this.createMockWAL();
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            AbstractTestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, this.ee, (Region)region, "x");
        }
        region.flush(true);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            AbstractTestWALReplay.addRegionEdits(rowName, hcd.getName(), 5, this.ee, (Region)region, "x");
        }
        long lastestSeqNumber = region.getReadPoint(null);
        wal.doCompleteCacheFlush = true;
        wal.completeCacheFlush(hri.getEncodedNameAsBytes());
        wal.shutdown();
        FileStatus[] listStatus = wal.getFiles();
        Assert.assertNotNull((Object)listStatus);
        Assert.assertTrue((listStatus.length > 0 ? 1 : 0) != 0);
        WALSplitter.splitLogFile((Path)this.hbaseRootDir, (FileStatus)listStatus[0], (FileSystem)this.fs, (Configuration)this.conf, null, null, null, (WALFactory)this.wals);
        FileStatus[] listStatus1 = this.fs.listStatus(new Path(FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName), new Path(hri.getEncodedName(), "recovered.edits")), new PathFilter(){

            public boolean accept(Path p) {
                return !WALSplitter.isSequenceIdFile((Path)p);
            }
        });
        int editCount = 0;
        for (FileStatus fileStatus : listStatus1) {
            editCount = Integer.parseInt(fileStatus.getPath().getName());
        }
        Assert.assertEquals((String)"The sequence number of the recoverd.edits and the current edit seq should be same", (long)lastestSeqNumber, (long)editCount);
    }

    @Test
    public void testDatalossWhenInputError() throws Exception {
        HRegion region2;
        TableName tableName = TableName.valueOf((String)"testDatalossWhenInputError");
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        HTableDescriptor htd = this.createBasic1FamilyHTD(tableName);
        HRegion region1 = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, this.hbaseRootDir, this.conf, (TableDescriptor)htd);
        Path regionDir = region1.getRegionFileSystem().getRegionDir();
        HBaseTestingUtility.closeRegionAndWAL(region1);
        WAL wal = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            AbstractTestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, this.ee, (Region)region, "x");
        }
        Get g = new Get(rowName);
        Result result = region.get(g);
        Assert.assertEquals((long)(10 * htd.getFamilies().size()), (long)result.size());
        region.close(true);
        wal.shutdown();
        this.runWALSplit(this.conf);
        Path editFile = (Path)WALSplitter.getSplitEditFilesSorted((FileSystem)this.fs, (Path)regionDir).first();
        FSDataInputStream stream = this.fs.open(editFile);
        stream.seek((long)ProtobufLogReader.PB_WAL_MAGIC.length);
        Class logReaderClass = this.conf.getClass("hbase.regionserver.hlog.reader.impl", ProtobufLogReader.class, AbstractFSWALProvider.Reader.class);
        AbstractFSWALProvider.Reader reader = (AbstractFSWALProvider.Reader)logReaderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reader.init(this.fs, editFile, this.conf, stream);
        final long headerLength = stream.getPos();
        reader.close();
        FileSystem spyFs = (FileSystem)Mockito.spy((Object)this.fs);
        ((FileSystem)Mockito.doAnswer((Answer)new Answer<FSDataInputStream>(){

            public FSDataInputStream answer(InvocationOnMock invocation) throws Throwable {
                FSDataInputStream stream = (FSDataInputStream)invocation.callRealMethod();
                Field field = FilterInputStream.class.getDeclaredField("in");
                field.setAccessible(true);
                final DFSInputStream in = (DFSInputStream)field.get(stream);
                DFSInputStream spyIn = (DFSInputStream)Mockito.spy((Object)in);
                ((DFSInputStream)Mockito.doAnswer((Answer)new Answer<Integer>(){
                    private long pos;

                    public Integer answer(InvocationOnMock invocation) throws Throwable {
                        if (this.pos >= headerLength) {
                            throw new IOException("read over limit");
                        }
                        int b = (Integer)invocation.callRealMethod();
                        if (b > 0) {
                            this.pos += (long)b;
                        }
                        return b;
                    }
                }).when((Object)spyIn)).read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
                ((DFSInputStream)Mockito.doAnswer((Answer)new Answer<Void>(){

                    public Void answer(InvocationOnMock invocation) throws Throwable {
                        invocation.callRealMethod();
                        in.close();
                        return null;
                    }
                }).when((Object)spyIn)).close();
                field.set(stream, spyIn);
                return stream;
            }
        }).when((Object)spyFs)).open((Path)ArgumentMatchers.eq((Object)editFile));
        WAL wal2 = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        try {
            region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)spyFs, (Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal2);
            Assert.assertEquals((long)result.size(), (long)region2.get(g).size());
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"read over limit", (Object)e.getMessage());
        }
        region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal2);
        Assert.assertEquals((long)result.size(), (long)region2.get(g).size());
    }

    private void testNameConflictWhenSplit(boolean largeFirst) throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        FileStatus second;
        FileStatus first;
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenIntoWAL");
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        HTableDescriptor htd = this.createBasic1FamilyHTD(tableName);
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getFamiliesKeys()) {
            scopes.put(fam, 0);
        }
        HRegion region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, this.hbaseRootDir, this.conf, (TableDescriptor)htd);
        HBaseTestingUtility.closeRegionAndWAL(region);
        byte[] family = htd.getColumnFamilies()[0].getName();
        byte[] rowName = tableName.getName();
        FSWALEntry entry1 = this.createFSWALEntry(htd, hri, 1L, rowName, family, this.ee, mvcc, 1, scopes);
        FSWALEntry entry2 = this.createFSWALEntry(htd, hri, 2L, rowName, family, this.ee, mvcc, 2, scopes);
        Path largeFile = new Path(this.logDir, "wal-1");
        Path smallFile = new Path(this.logDir, "wal-2");
        this.writerWALFile(largeFile, Arrays.asList(entry1, entry2));
        this.writerWALFile(smallFile, Arrays.asList(entry2));
        if (largeFirst) {
            first = this.fs.getFileStatus(largeFile);
            second = this.fs.getFileStatus(smallFile);
        } else {
            first = this.fs.getFileStatus(smallFile);
            second = this.fs.getFileStatus(largeFile);
        }
        WALSplitter.splitLogFile((Path)this.hbaseRootDir, (FileStatus)first, (FileSystem)this.fs, (Configuration)this.conf, null, null, null, (WALFactory)this.wals);
        WALSplitter.splitLogFile((Path)this.hbaseRootDir, (FileStatus)second, (FileSystem)this.fs, (Configuration)this.conf, null, null, null, (WALFactory)this.wals);
        WAL wal = this.createWAL(this.conf, this.hbaseRootDir, this.logName);
        region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal);
        Assert.assertTrue((region.getOpenSeqNum() > mvcc.getWritePoint() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)region.get(new Get(rowName)).size());
    }

    @Test
    public void testNameConflictWhenSplit0() throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.testNameConflictWhenSplit(true);
    }

    @Test
    public void testNameConflictWhenSplit1() throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.testNameConflictWhenSplit(false);
    }

    private HTableDescriptor createBasic1FamilyHTD(TableName tableName) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor a = new HColumnDescriptor(Bytes.toBytes((String)"a"));
        htd.addFamily(a);
        return htd;
    }

    private MockWAL createMockWAL() throws IOException {
        MockWAL wal = new MockWAL(this.fs, this.hbaseRootDir, this.logName, this.conf);
        HBaseTestingUtility.setMaxRecoveryErrorCount(wal.getOutputStream(), 1);
        return wal;
    }

    private WALKeyImpl createWALKey(TableName tableName, HRegionInfo hri, MultiVersionConcurrencyControl mvcc, NavigableMap<byte[], Integer> scopes) {
        return new WALKeyImpl(hri.getEncodedNameAsBytes(), tableName, 999L, mvcc, scopes);
    }

    private WALEdit createWALEdit(byte[] rowName, byte[] family, EnvironmentEdge ee, int index) {
        byte[] qualifierBytes = Bytes.toBytes((String)Integer.toString(index));
        byte[] columnBytes = Bytes.toBytes((String)(Bytes.toString((byte[])family) + ":" + Integer.toString(index)));
        WALEdit edit = new WALEdit();
        edit.add((Cell)new KeyValue(rowName, family, qualifierBytes, ee.currentTime(), columnBytes));
        return edit;
    }

    private FSWALEntry createFSWALEntry(HTableDescriptor htd, HRegionInfo hri, long sequence, byte[] rowName, byte[] family, EnvironmentEdge ee, MultiVersionConcurrencyControl mvcc, int index, NavigableMap<byte[], Integer> scopes) throws IOException {
        FSWALEntry entry = new FSWALEntry(sequence, this.createWALKey(htd.getTableName(), hri, mvcc, scopes), this.createWALEdit(rowName, family, ee, index), (RegionInfo)hri, true);
        entry.stampRegionSequenceId(mvcc.begin());
        return entry;
    }

    private void addWALEdits(TableName tableName, HRegionInfo hri, byte[] rowName, byte[] family, int count, EnvironmentEdge ee, WAL wal, HTableDescriptor htd, MultiVersionConcurrencyControl mvcc, NavigableMap<byte[], Integer> scopes) throws IOException {
        for (int j = 0; j < count; ++j) {
            wal.append((RegionInfo)hri, this.createWALKey(tableName, hri, mvcc, scopes), this.createWALEdit(rowName, family, ee, j), true);
        }
        wal.sync();
    }

    static List<Put> addRegionEdits(byte[] rowName, byte[] family, int count, EnvironmentEdge ee, Region r, String qualifierPrefix) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int j = 0; j < count; ++j) {
            byte[] qualifier = Bytes.toBytes((String)(qualifierPrefix + Integer.toString(j)));
            Put p = new Put(rowName);
            p.addColumn(family, qualifier, ee.currentTime(), rowName);
            r.put(p);
            puts.add(p);
        }
        return puts;
    }

    private HRegionInfo createBasic3FamilyHRegionInfo(TableName tableName) {
        return new HRegionInfo(tableName, null, null, false);
    }

    private Path runWALSplit(Configuration c) throws IOException {
        List splits = WALSplitter.split((Path)this.hbaseRootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)c), (Configuration)c, (WALFactory)this.wals);
        Assert.assertEquals((String)("splits=" + splits), (long)1L, (long)splits.size());
        Assert.assertTrue((boolean)this.fs.exists((Path)splits.get(0)));
        LOG.info("Split file=" + splits.get(0));
        return (Path)splits.get(0);
    }

    private HTableDescriptor createBasic3FamilyHTD(TableName tableName) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor a = new HColumnDescriptor(Bytes.toBytes((String)"a"));
        htd.addFamily(a);
        HColumnDescriptor b = new HColumnDescriptor(Bytes.toBytes((String)"b"));
        htd.addFamily(b);
        HColumnDescriptor c = new HColumnDescriptor(Bytes.toBytes((String)"c"));
        htd.addFamily(c);
        return htd;
    }

    private void writerWALFile(Path file, List<FSWALEntry> entries) throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.fs.mkdirs(file.getParent());
        ProtobufLogWriter writer = new ProtobufLogWriter();
        writer.init(this.fs, file, this.conf, true, WALUtil.getWALBlockSize((Configuration)this.conf, (FileSystem)this.fs, (Path)file));
        for (FSWALEntry entry : entries) {
            writer.append((WAL.Entry)entry);
        }
        writer.sync();
        writer.close();
    }

    protected abstract WAL createWAL(Configuration var1, Path var2, String var3) throws IOException;

    static class TestFlusher
    implements FlushRequester {
        private HRegion r;

        TestFlusher() {
        }

        public void requestFlush(HRegion region, boolean force, FlushLifeCycleTracker tracker) {
            try {
                this.r.flush(force);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception flushing", e);
            }
        }

        public void requestDelayedFlush(HRegion region, long when, boolean forceFlushAllStores) {
        }

        public void registerFlushRequestListener(FlushRequestListener listener) {
        }

        public boolean unregisterFlushRequestListener(FlushRequestListener listener) {
            return false;
        }

        public void setGlobalMemStoreLimit(long globalMemStoreSize) {
        }
    }

    static class MockWAL
    extends FSHLog {
        boolean doCompleteCacheFlush = false;

        public MockWAL(FileSystem fs, Path rootDir, String logName, Configuration conf) throws IOException {
            super(fs, rootDir, logName, "oldWALs", conf, null, true, null, null);
        }

        public void completeCacheFlush(byte[] encodedRegionName) {
            if (!this.doCompleteCacheFlush) {
                return;
            }
            super.completeCacheFlush(encodedRegionName);
        }
    }

    public static class CustomStoreFlusher
    extends DefaultStoreFlusher {
        static final AtomicBoolean throwExceptionWhenFlushing = new AtomicBoolean(false);

        public CustomStoreFlusher(Configuration conf, HStore store) {
            super(conf, store);
        }

        public List<Path> flushSnapshot(MemStoreSnapshot snapshot, long cacheFlushId, MonitoredTask status, ThroughputController throughputController, FlushLifeCycleTracker tracker) throws IOException {
            if (throwExceptionWhenFlushing.get()) {
                throw new IOException("Simulated exception by tests");
            }
            return super.flushSnapshot(snapshot, cacheFlushId, status, throughputController, tracker);
        }
    }
}

