/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestWALReplay;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestWALReplay
extends AbstractTestWALReplay {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALReplay.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = AbstractTestWALReplay.TEST_UTIL.getConfiguration();
        conf.set("hbase.wal.provider", "filesystem");
        AbstractTestWALReplay.setUpBeforeClass();
    }

    @Override
    protected WAL createWAL(Configuration c, Path hbaseRootDir, String logName) throws IOException {
        FSHLog wal = new FSHLog(FileSystem.get((Configuration)c), hbaseRootDir, logName, c);
        HBaseTestingUtility.setMaxRecoveryErrorCount(wal.getOutputStream(), 1);
        return wal;
    }
}

