/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationSmallTests
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSmallTests.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationSmallTests.class);
    private static final String PEER_ID = "2";

    @Before
    public void setUp() throws Exception {
        this.cleanUp();
    }

    @Test
    public void testDeleteTypes() throws Exception {
        Result res;
        int i;
        LOG.info("testDeleteTypes");
        byte[] v1 = Bytes.toBytes((String)"v1");
        byte[] v2 = Bytes.toBytes((String)"v2");
        byte[] v3 = Bytes.toBytes((String)"v3");
        htable1 = utility1.getConnection().getTable(tableName);
        long t = EnvironmentEdgeManager.currentTime();
        Put put = new Put(row);
        put.addColumn(famName, row, t, v1);
        htable1.put(put);
        put = new Put(row);
        put.addColumn(famName, row, t + 1L, v2);
        htable1.put(put);
        put = new Put(row);
        put.addColumn(famName, row, t + 2L, v3);
        htable1.put(put);
        Get get = new Get(row);
        get.readAllVersions();
        for (int i2 = 0; i2 < 10; ++i2) {
            Result res2;
            if (i2 == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res2 = htable2.get(get)).size() >= 3) {
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res2.rawCells()[0]), (byte[])v3);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res2.rawCells()[1]), (byte[])v2);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res2.rawCells()[2]), (byte[])v1);
                break;
            }
            LOG.info("Rows not available");
            Thread.sleep(500L);
        }
        Delete d = new Delete(row);
        d.addColumn(famName, row, t);
        htable1.delete(d);
        get = new Get(row);
        get.readAllVersions();
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() <= 2) {
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res.rawCells()[0]), (byte[])v3);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res.rawCells()[1]), (byte[])v2);
                break;
            }
            LOG.info("Version not deleted");
            Thread.sleep(500L);
        }
        d = new Delete(row);
        d.addColumns(famName, row, t + 2L);
        htable1.delete(d);
        get = new Get(row);
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = htable2.get(get)).size() < 1) break;
            LOG.info("Rows not deleted");
            Thread.sleep(500L);
        }
    }

    @Test
    public void testSimplePutDelete() throws Exception {
        LOG.info("testSimplePutDelete");
        TestReplicationSmallTests.runSimplePutDeleteTest();
    }

    @Test
    public void testSmallBatch() throws Exception {
        LOG.info("testSmallBatch");
        TestReplicationSmallTests.runSmallBatchTest();
    }

    @Test
    public void testDisableEnable() throws Exception {
        Result res;
        int i;
        hbaseAdmin.disableReplicationPeer(PEER_ID);
        byte[] rowkey = Bytes.toBytes((String)"disable enable");
        Put put = new Put(rowkey);
        put.addColumn(famName, row, row);
        htable1.put(put);
        Get get = new Get(rowkey);
        for (i = 0; i < 10; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Replication wasn't disabled");
                continue;
            }
            LOG.info("Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
        hbaseAdmin.enableReplicationPeer(PEER_ID);
        for (i = 0; i < 10; ++i) {
            res = htable2.get(get);
            if (!res.isEmpty()) {
                Assert.assertArrayEquals((byte[])row, (byte[])res.value());
                return;
            }
            LOG.info("Row not available");
            Thread.sleep(500L);
        }
        Assert.fail((String)"Waited too much time for put replication");
    }

    @Test
    public void testAddAndRemoveClusters() throws Exception {
        LOG.info("testAddAndRemoveClusters");
        hbaseAdmin.removeReplicationPeer(PEER_ID);
        Thread.sleep(500L);
        byte[] rowKey = Bytes.toBytes((String)"Won't be replicated");
        Put put = new Put(rowKey);
        put.addColumn(famName, row, row);
        htable1.put(put);
        Get get = new Get(rowKey);
        for (int i = 0; i < 10 && i != 9; ++i) {
            Result res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Not supposed to be replicated");
                continue;
            }
            LOG.info("Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(utility2.getClusterKey()).build();
        hbaseAdmin.addReplicationPeer(PEER_ID, rpc);
        Thread.sleep(500L);
        rowKey = Bytes.toBytes((String)"do rep");
        put = new Put(rowKey);
        put.addColumn(famName, row, row);
        LOG.info("Adding new row");
        htable1.put(put);
        get = new Get(rowKey);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if (!(res = htable2.get(get)).isEmpty()) {
                Assert.assertArrayEquals((byte[])row, (byte[])res.value());
                break;
            }
            LOG.info("Row not available");
            Thread.sleep(500L * (long)i);
        }
    }

    @Test
    public void testLoading() throws Exception {
        LOG.info("Writing out rows to table1 in testLoading");
        ArrayList<Put> puts = new ArrayList<Put>(1000);
        for (int i = 0; i < 1000; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.addColumn(famName, row, row);
            puts.add(put);
        }
        htable1.put(puts);
        Scan scan = new Scan();
        ResultScanner scanner = htable1.getScanner(scan);
        Result[] res = scanner.next(1000);
        scanner.close();
        Assert.assertEquals((long)1000L, (long)res.length);
        LOG.info("Looking in table2 for replicated rows in testLoading");
        long start = System.currentTimeMillis();
        long retries = 100L;
        int i = 0;
        while ((long)i < 100L) {
            scan = new Scan();
            scanner = htable2.getScanner(scan);
            res = scanner.next(1000);
            scanner.close();
            if (res.length == 1000) break;
            if ((long)i == 99L) {
                int lastRow = -1;
                for (Result result : res) {
                    int currentRow = Bytes.toInt((byte[])result.getRow());
                    for (int row = lastRow + 1; row < currentRow; ++row) {
                        LOG.error("Row missing: " + row);
                    }
                    lastRow = currentRow;
                }
                LOG.error("Last row: " + lastRow);
                Assert.fail((String)("Waited too much time for normal batch replication, " + res.length + " instead of " + 1000 + "; waited=" + (System.currentTimeMillis() - start) + "ms"));
            } else {
                LOG.info("Only got " + res.length + " rows... retrying");
                Thread.sleep(500L);
            }
            ++i;
        }
    }

    @Test
    public void testVerifyListReplicatedTable() throws Exception {
        int i;
        LOG.info("testVerifyListReplicatedTable");
        String tName = "VerifyListReplicated_";
        String colFam = "cf1";
        int numOfTables = 3;
        Admin hadmin = utility1.getAdmin();
        for (int i2 = 0; i2 < 3; ++i2) {
            hadmin.createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)("VerifyListReplicated_" + i2))).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf1")).setScope(1).build()).build());
        }
        List replicationColFams = hbaseAdmin.listReplicatedTableCFs();
        int[] match = new int[3];
        for (i = 0; i < replicationColFams.size(); ++i) {
            int m;
            TableCFs replicationEntry = (TableCFs)replicationColFams.get(i);
            String tn = replicationEntry.getTable().getNameAsString();
            if (!tn.startsWith("VerifyListReplicated_") || !replicationEntry.getColumnFamilyMap().containsKey("cf1")) continue;
            int n = m = Integer.parseInt(tn.substring(tn.length() - 1));
            match[n] = match[n] + 1;
        }
        for (i = 0; i < match.length; ++i) {
            Assert.assertTrue((String)("listReplicated() does not match table " + i), (match[i] == 1 ? 1 : 0) != 0);
        }
        for (i = 0; i < 3; ++i) {
            TableName tableName = TableName.valueOf((String)("VerifyListReplicated_" + i));
            hadmin.disableTable(tableName);
            hadmin.deleteTable(tableName);
        }
        hadmin.close();
    }

    @Test
    public void testReplicationInReplay() throws Exception {
        TableName tableName = htable1.getName();
        HRegion region = utility1.getMiniHBaseCluster().getRegions(tableName).get(0);
        RegionInfo hri = region.getRegionInfo();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htable1.getDescriptor().getColumnFamilyNames()) {
            scopes.put(fam, 1);
        }
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        int index = utility1.getMiniHBaseCluster().getServerWith(hri.getRegionName());
        WAL wal = utility1.getMiniHBaseCluster().getRegionServer(index).getWAL(region.getRegionInfo());
        byte[] rowName = Bytes.toBytes((String)"testReplicationInReplay");
        byte[] qualifier = Bytes.toBytes((String)"q");
        byte[] value = Bytes.toBytes((String)"v");
        WALEdit edit = new WALEdit(true);
        long now = EnvironmentEdgeManager.currentTime();
        edit.add((Cell)new KeyValue(rowName, famName, qualifier, now, value));
        WALKeyImpl walKey = new WALKeyImpl(hri.getEncodedNameAsBytes(), tableName, now, mvcc, scopes);
        wal.append(hri, walKey, edit, true);
        wal.sync();
        Get get = new Get(rowName);
        for (int i = 0; i < 10 && i != 9; ++i) {
            Result res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)("Not supposed to be replicated for " + Bytes.toString((byte[])res.getRow())));
                continue;
            }
            LOG.info("Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
    }
}

