/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationListener;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationTrackerZKImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationTrackerZKImpl.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationTrackerZKImpl.class);
    private static Configuration conf;
    private static HBaseTestingUtility utility;
    private ZKWatcher zkw;
    private ReplicationPeers rp;
    private ReplicationTracker rt;
    private AtomicInteger rsRemovedCount;
    private String rsRemovedData;
    private AtomicInteger plChangedCount;
    private List<String> plChangedData;
    private AtomicInteger peerRemovedCount;
    private String peerRemovedData;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        utility = new HBaseTestingUtility();
        utility.startMiniZKCluster();
        conf = utility.getConfiguration();
        ZKWatcher zk = HBaseTestingUtility.getZooKeeperWatcher((HBaseZKTestingUtility)utility);
        ZKUtil.createWithParents((ZKWatcher)zk, (String)zk.znodePaths.rsZNode);
    }

    @Before
    public void setUp() throws Exception {
        this.zkw = HBaseTestingUtility.getZooKeeperWatcher((HBaseZKTestingUtility)utility);
        String fakeRs1 = ZNodePaths.joinZNode((String)this.zkw.znodePaths.rsZNode, (String)"hostname1.example.org:1234");
        try {
            ZKClusterId.setClusterId((ZKWatcher)this.zkw, (ClusterId)new ClusterId());
            this.rp = ReplicationFactory.getReplicationPeers((ZKWatcher)this.zkw, (Configuration)conf, (Abortable)this.zkw);
            this.rp.init();
            this.rt = ReplicationFactory.getReplicationTracker((ZKWatcher)this.zkw, (ReplicationPeers)this.rp, (Configuration)conf, (Abortable)this.zkw, (Stoppable)new DummyServer(fakeRs1));
        }
        catch (Exception e) {
            Assert.fail((String)("Exception during test setup: " + e));
        }
        this.rsRemovedCount = new AtomicInteger(0);
        this.rsRemovedData = "";
        this.plChangedCount = new AtomicInteger(0);
        this.plChangedData = new ArrayList<String>();
        this.peerRemovedCount = new AtomicInteger(0);
        this.peerRemovedData = "";
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility.shutdownMiniZKCluster();
    }

    @Test
    public void testGetListOfRegionServers() throws Exception {
        Assert.assertEquals((long)0L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.createWithParents((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.znodePaths.rsZNode, (String)"hostname1.example.org:1234"));
        Assert.assertEquals((long)1L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.createWithParents((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.znodePaths.rsZNode, (String)"hostname2.example.org:1234"));
        Assert.assertEquals((long)2L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.deleteNode((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.znodePaths.rsZNode, (String)"hostname2.example.org:1234"));
        Assert.assertEquals((long)1L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.deleteNode((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.znodePaths.rsZNode, (String)"hostname1.example.org:1234"));
        Assert.assertEquals((long)0L, (long)this.rt.getListOfRegionServers().size());
    }

    @Test
    public void testRegionServerRemovedEvent() throws Exception {
        ZKUtil.createAndWatch((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.znodePaths.rsZNode, (String)"hostname2.example.org:1234"), (byte[])HConstants.EMPTY_BYTE_ARRAY);
        this.rt.registerListener((ReplicationListener)new DummyReplicationListener());
        ZKUtil.deleteNode((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.znodePaths.rsZNode, (String)"hostname2.example.org:1234"));
        while (this.rsRemovedCount.get() < 1) {
            Thread.sleep(5L);
        }
        Assert.assertEquals((Object)"hostname2.example.org:1234", (Object)this.rsRemovedData);
    }

    @Test
    public void testPeerRemovedEvent() throws Exception {
        this.rp.registerPeer("5", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()));
        this.rt.registerListener((ReplicationListener)new DummyReplicationListener());
        this.rp.unregisterPeer("5");
        while (this.peerRemovedCount.get() < 1) {
            Thread.sleep(5L);
        }
        Assert.assertEquals((Object)"5", (Object)this.peerRemovedData);
    }

    @Test
    public void testPeerListChangedEvent() throws Exception {
        this.rp.registerPeer("5", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()));
        this.zkw.getRecoverableZooKeeper().getZooKeeper().getChildren("/hbase/replication/peers/5", true);
        this.rt.registerListener((ReplicationListener)new DummyReplicationListener());
        this.rp.disablePeer("5");
        int tmp = this.plChangedCount.get();
        LOG.info("Peer count=" + tmp);
        ZKUtil.deleteNode((ZKWatcher)this.zkw, (String)"/hbase/replication/peers/5/peer-state");
        while (this.plChangedCount.get() <= tmp) {
            Thread.sleep(100L);
            LOG.info("Peer count=" + tmp);
        }
        Assert.assertEquals((long)1L, (long)this.plChangedData.size());
        Assert.assertTrue((boolean)this.plChangedData.contains("5"));
        this.rp.unregisterPeer("5");
    }

    @Test
    public void testPeerNameControl() throws Exception {
        int exists = 0;
        int hyphen = 0;
        this.rp.registerPeer("6", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()));
        try {
            this.rp.registerPeer("6", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()));
        }
        catch (IllegalArgumentException e) {
            ++exists;
        }
        try {
            this.rp.registerPeer("6-ec2", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()));
        }
        catch (IllegalArgumentException e) {
            ++hyphen;
        }
        Assert.assertEquals((long)1L, (long)exists);
        Assert.assertEquals((long)1L, (long)hyphen);
        this.rp.unregisterPeer("6");
    }

    private class DummyServer
    implements Server {
        private String serverName;
        private boolean isAborted = false;
        private boolean isStopped = false;

        public DummyServer(String serverName) {
            this.serverName = serverName;
        }

        public Configuration getConfiguration() {
            return conf;
        }

        public ZKWatcher getZooKeeper() {
            return TestReplicationTrackerZKImpl.this.zkw;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.serverName);
        }

        public void abort(String why, Throwable e) {
            LOG.info("Aborting " + this.serverName);
            this.isAborted = true;
        }

        public boolean isAborted() {
            return this.isAborted;
        }

        public void stop(String why) {
            this.isStopped = true;
        }

        public boolean isStopped() {
            return this.isStopped;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }

    private class DummyReplicationListener
    implements ReplicationListener {
        private DummyReplicationListener() {
        }

        public void regionServerRemoved(String regionServer) {
            TestReplicationTrackerZKImpl.this.rsRemovedData = regionServer;
            TestReplicationTrackerZKImpl.this.rsRemovedCount.getAndIncrement();
            LOG.debug("Received regionServerRemoved event: " + regionServer);
        }

        public void peerRemoved(String peerId) {
            TestReplicationTrackerZKImpl.this.peerRemovedData = peerId;
            TestReplicationTrackerZKImpl.this.peerRemovedCount.getAndIncrement();
            LOG.debug("Received peerDisconnected event: " + peerId);
        }

        public void peerListChanged(List<String> peerIds) {
            TestReplicationTrackerZKImpl.this.plChangedData.clear();
            TestReplicationTrackerZKImpl.this.plChangedData.addAll(peerIds);
            int count = TestReplicationTrackerZKImpl.this.plChangedCount.getAndIncrement();
            LOG.debug("Received peerListChanged event " + count);
        }
    }
}

