/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.tool.coprocessor.CoprocessorValidator;
import org.apache.hadoop.hbase.tool.coprocessor.CoprocessorViolation;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class CoprocessorValidatorTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(CoprocessorValidatorTest.class);
    private CoprocessorValidator validator = new CoprocessorValidator();

    private static ClassLoader getClassLoader() {
        return CoprocessorValidatorTest.class.getClassLoader();
    }

    private static String getFullClassName(String className) {
        return CoprocessorValidatorTest.class.getName() + "$" + className;
    }

    @Test
    public void testFilterObservers() throws Exception {
        String filterObservers = CoprocessorValidatorTest.getFullClassName("TestObserver");
        ArrayList classNames = Lists.newArrayList((Object[])new String[]{filterObservers, this.getClass().getName()});
        List filteredClassNames = this.validator.filterObservers(CoprocessorValidatorTest.getClassLoader(), (Iterable)classNames);
        Assert.assertEquals((long)1L, (long)filteredClassNames.size());
        Assert.assertEquals((Object)filterObservers, filteredClassNames.get(0));
    }

    private List<CoprocessorViolation> validate(String className) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return this.validate(classLoader, className);
    }

    private List<CoprocessorViolation> validate(ClassLoader classLoader, String className) {
        ArrayList classNames = Lists.newArrayList((Object[])new String[]{this.getClass().getName() + "$" + className});
        return this.validator.validate(classLoader, (List)classNames);
    }

    @Test
    public void testNoSuchClass() throws IOException {
        List<CoprocessorViolation> violations = this.validate("NoSuchClass");
        Assert.assertEquals((long)1L, (long)violations.size());
        CoprocessorViolation violation = violations.get(0);
        Assert.assertEquals((Object)CoprocessorViolation.Severity.ERROR, (Object)violation.getSeverity());
        Assert.assertTrue((boolean)violation.getMessage().contains("java.lang.ClassNotFoundException: org.apache.hadoop.hbase.tool.coprocessor.CoprocessorValidatorTest$NoSuchClass"));
    }

    @Test
    public void testMissingClass() throws IOException {
        MissingClassClassLoader missingClassClassLoader = new MissingClassClassLoader();
        List<CoprocessorViolation> violations = this.validate(missingClassClassLoader, "MissingClassObserver");
        Assert.assertEquals((long)1L, (long)violations.size());
        CoprocessorViolation violation = violations.get(0);
        Assert.assertEquals((Object)CoprocessorViolation.Severity.ERROR, (Object)violation.getSeverity());
        Assert.assertTrue((boolean)violation.getMessage().contains("java.lang.ClassNotFoundException: org.apache.hadoop.hbase.tool.coprocessor.CoprocessorValidatorTest$MissingClass"));
    }

    @Test
    public void testObsoleteMethod() throws IOException {
        List<CoprocessorViolation> violations = this.validate("ObsoleteMethodObserver");
        Assert.assertEquals((long)1L, (long)violations.size());
        CoprocessorViolation violation = violations.get(0);
        Assert.assertEquals((Object)CoprocessorViolation.Severity.WARNING, (Object)violation.getSeverity());
        Assert.assertTrue((boolean)violation.getMessage().contains("was removed from new coprocessor API"));
    }

    private static class ObsoleteMethodObserver {
        private ObsoleteMethodObserver() {
        }

        public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        }
    }

    private static class MissingClassClassLoader
    extends ClassLoader {
        public MissingClassClassLoader() {
            super(CoprocessorValidatorTest.getClassLoader());
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.equals(CoprocessorValidatorTest.getFullClassName("MissingClass"))) {
                throw new ClassNotFoundException(name);
            }
            return super.findClass(name);
        }
    }

    private static class MissingClassObserver {
        private MissingClassObserver() {
        }

        public void method(MissingClass missingClass) {
        }
    }

    private static class MissingClass {
        private MissingClass() {
        }
    }

    private static class TestObserver
    implements Coprocessor {
        private TestObserver() {
        }

        public void start(CoprocessorEnvironment env) throws IOException {
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }
    }
}

