/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer
implements Server {
    private static final Logger LOG = LoggerFactory.getLogger(MockServer.class);
    static final ServerName NAME = ServerName.valueOf((String)"MockServer", (int)123, (long)-1L);
    boolean stopped;
    boolean aborted;
    final ZKWatcher zk;
    final HBaseTestingUtility htu;

    public MockServer() throws ZooKeeperConnectionException, IOException {
        this(null);
    }

    public MockServer(HBaseTestingUtility htu) throws ZooKeeperConnectionException, IOException {
        this(htu, true);
    }

    public MockServer(HBaseTestingUtility htu, boolean zkw) throws ZooKeeperConnectionException, IOException {
        this.htu = htu;
        this.zk = zkw ? new ZKWatcher(htu.getConfiguration(), NAME.toString(), (Abortable)this, true) : null;
    }

    public void abort(String why, Throwable e) {
        LOG.error(HBaseMarkers.FATAL, "Abort why=" + why, e);
        this.stop(why);
        this.aborted = true;
    }

    public void stop(String why) {
        LOG.debug("Stop why=" + why);
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Configuration getConfiguration() {
        return this.htu.getConfiguration();
    }

    public ZKWatcher getZooKeeper() {
        return this.zk;
    }

    public CoordinatedStateManager getCoordinatedStateManager() {
        return null;
    }

    public ClusterConnection getConnection() {
        return null;
    }

    public MetaTableLocator getMetaTableLocator() {
        return null;
    }

    public ServerName getServerName() {
        return NAME;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public ChoreService getChoreService() {
        return null;
    }

    public ClusterConnection getClusterConnection() {
        return null;
    }

    public FileSystem getFileSystem() {
        return null;
    }

    public boolean isStopping() {
        return false;
    }

    public Connection createConnection(Configuration conf) throws IOException {
        return null;
    }
}

