/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.FileWriter;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.RegionMover;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRegionMover {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionMover.class);
    final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRegionMover");
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(tableName)) {
            TEST_UTIL.deleteTable(tableName);
        }
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        tableDesc.addFamily(fam1);
        try {
            admin.setBalancerRunning(false, true);
            String startKey = "a";
            String endKey = "z";
            admin.createTable((TableDescriptor)tableDesc, startKey.getBytes(), endKey.getBytes(), 9);
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
    }

    @Test
    public void testLoadWithAck() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getHostname();
        int port = regionServer.getServerName().getPort();
        int noRegions = regionServer.getNumberOfOnlineRegions();
        String rs = rsName + ":" + Integer.toString(port);
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rs).ack(true).maxthreads(8);
        RegionMover rm = rmBuilder.build();
        rm.setConf(TEST_UTIL.getConfiguration());
        this.LOG.info("Unloading " + rs);
        rm.unload();
        Assert.assertEquals((long)0L, (long)regionServer.getNumberOfOnlineRegions());
        this.LOG.info("Successfully Unloaded\nNow Loading");
        rm.load();
        Assert.assertEquals((long)noRegions, (long)regionServer.getNumberOfOnlineRegions());
    }

    @Test
    public void testLoadWithoutAck() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        final HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getHostname();
        int port = regionServer.getServerName().getPort();
        int noRegions = regionServer.getNumberOfOnlineRegions();
        String rs = rsName + ":" + Integer.toString(port);
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rs).ack(true);
        RegionMover rm = rmBuilder.build();
        rm.setConf(TEST_UTIL.getConfiguration());
        this.LOG.info("Unloading " + rs);
        rm.unload();
        Assert.assertEquals((long)0L, (long)regionServer.getNumberOfOnlineRegions());
        this.LOG.info("Successfully Unloaded\nNow Loading");
        rm = rmBuilder.ack(false).build();
        rm.setConf(TEST_UTIL.getConfiguration());
        rm.load();
        TEST_UTIL.waitFor(5000L, 500L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return regionServer.getNumberOfOnlineRegions() > 0;
            }
        });
    }

    @Test
    public void testUnloadWithoutAck() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        final HRegionServer regionServer = cluster.getRegionServer(0);
        final int noRegions = regionServer.getNumberOfOnlineRegions();
        String rsName = regionServer.getServerName().getHostname();
        int port = regionServer.getServerName().getPort();
        String rs = rsName + ":" + Integer.toString(port);
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rs).ack(false);
        RegionMover rm = rmBuilder.build();
        rm.setConf(TEST_UTIL.getConfiguration());
        this.LOG.info("Unloading " + rs);
        rm.unload();
        TEST_UTIL.waitFor(5000L, 500L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return regionServer.getNumberOfOnlineRegions() < noRegions;
            }
        });
    }

    @Test
    public void testUnloadWithAck() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getHostname();
        int port = regionServer.getServerName().getPort();
        String rs = rsName + ":" + Integer.toString(port);
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rs).ack(true);
        RegionMover rm = rmBuilder.build();
        rm.setConf(TEST_UTIL.getConfiguration());
        rm.unload();
        this.LOG.info("Unloading " + rs);
        Assert.assertEquals((long)0L, (long)regionServer.getNumberOfOnlineRegions());
    }

    @Test
    public void testRepeatedLoad() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getHostname();
        int port = regionServer.getServerName().getPort();
        String rs = rsName + ":" + Integer.toString(port);
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rs).ack(true);
        RegionMover rm = rmBuilder.build();
        rm.setConf(TEST_UTIL.getConfiguration());
        rm.unload();
        Assert.assertEquals((long)0L, (long)regionServer.getNumberOfOnlineRegions());
        rmBuilder = new RegionMover.RegionMoverBuilder(rs).ack(true);
        rm = rmBuilder.build();
        rm.setConf(TEST_UTIL.getConfiguration());
        rm.load();
        rm.load();
    }

    @Test
    public void testExclude() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        File excludeFile = new File(TEST_UTIL.getDataTestDir().toUri().getPath(), "exclude_file");
        FileWriter fos = new FileWriter(excludeFile);
        HRegionServer excludeServer = cluster.getRegionServer(1);
        String excludeHostname = excludeServer.getServerName().getHostname();
        int excludeServerPort = excludeServer.getServerName().getPort();
        int regionsExcludeServer = excludeServer.getNumberOfOnlineRegions();
        String excludeServerName = excludeHostname + ":" + Integer.toString(excludeServerPort);
        fos.write(excludeServerName);
        fos.close();
        HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getHostname();
        int port = regionServer.getServerName().getPort();
        String rs = rsName + ":" + Integer.toString(port);
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rs).ack(true).excludeFile(excludeFile.getCanonicalPath());
        RegionMover rm = rmBuilder.build();
        rm.setConf(TEST_UTIL.getConfiguration());
        rm.unload();
        this.LOG.info("Unloading " + rs);
        Assert.assertEquals((long)0L, (long)regionServer.getNumberOfOnlineRegions());
        Assert.assertEquals((long)regionsExcludeServer, (long)cluster.getRegionServer(1).getNumberOfOnlineRegions());
        this.LOG.info("Before:" + regionsExcludeServer + " After:" + cluster.getRegionServer(1).getNumberOfOnlineRegions());
    }
}

