/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MockRegionServerServices;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.trace.HBaseHTraceConfiguration;
import org.apache.hadoop.hbase.trace.SpanReceiverHost;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.ProbabilitySampler;
import org.apache.htrace.core.Sampler;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class WALPerformanceEvaluation
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(WALPerformanceEvaluation.class);
    private final MetricRegistry metrics = new MetricRegistry();
    private final Meter syncMeter = this.metrics.meter(MetricRegistry.name(WALPerformanceEvaluation.class, (String[])new String[]{"syncMeter", "syncs"}));
    private final Histogram syncHistogram = this.metrics.histogram(MetricRegistry.name(WALPerformanceEvaluation.class, (String[])new String[]{"syncHistogram", "nanos-between-syncs"}));
    private final Histogram syncCountHistogram = this.metrics.histogram(MetricRegistry.name(WALPerformanceEvaluation.class, (String[])new String[]{"syncCountHistogram", "countPerSync"}));
    private final Meter appendMeter = this.metrics.meter(MetricRegistry.name(WALPerformanceEvaluation.class, (String[])new String[]{"appendMeter", "bytes"}));
    private final Histogram latencyHistogram = this.metrics.histogram(MetricRegistry.name(WALPerformanceEvaluation.class, (String[])new String[]{"latencyHistogram", "nanos"}));
    private final MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
    private HBaseTestingUtility TEST_UTIL;
    static final String TABLE_NAME = "WALPerformanceEvaluation";
    static final String QUALIFIER_PREFIX = "q";
    static final String FAMILY_PREFIX = "cf";
    private int numQualifiers = 1;
    private int valueSize = 512;
    private int keySize = 16;
    private final Set<WAL> walsListenedTo = new HashSet<WAL>();

    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.TEST_UTIL = new HBaseTestingUtility(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Path rootRegionDir = null;
        int numThreads = 1;
        long numIterations = 1000000L;
        int numFamilies = 1;
        int syncInterval = 0;
        boolean noSync = false;
        boolean verify = false;
        boolean verbose = false;
        boolean cleanup = true;
        boolean noclosefs = false;
        long roll = Long.MAX_VALUE;
        boolean compress = false;
        String cipher = null;
        int numRegions = 1;
        String spanReceivers = this.getConf().get("hbase.trace.spanreceiver.classes");
        boolean trace = spanReceivers != null && !spanReceivers.isEmpty();
        double traceFreq = 1.0;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            try {
                if (cmd.equals("-threads")) {
                    numThreads = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-iterations")) {
                    numIterations = Long.parseLong(args[++i]);
                    continue;
                }
                if (cmd.equals("-path")) {
                    rootRegionDir = new Path(args[++i]);
                    continue;
                }
                if (cmd.equals("-families")) {
                    numFamilies = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-qualifiers")) {
                    this.numQualifiers = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-keySize")) {
                    this.keySize = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-valueSize")) {
                    this.valueSize = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-syncInterval")) {
                    syncInterval = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-nosync")) {
                    noSync = true;
                    continue;
                }
                if (cmd.equals("-verify")) {
                    verify = true;
                    continue;
                }
                if (cmd.equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (cmd.equals("-nocleanup")) {
                    cleanup = false;
                    continue;
                }
                if (cmd.equals("-noclosefs")) {
                    noclosefs = true;
                    continue;
                }
                if (cmd.equals("-roll")) {
                    roll = Long.parseLong(args[++i]);
                    continue;
                }
                if (cmd.equals("-compress")) {
                    compress = true;
                    continue;
                }
                if (cmd.equals("-encryption")) {
                    cipher = args[++i];
                    continue;
                }
                if (cmd.equals("-regions")) {
                    numRegions = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-traceFreq")) {
                    traceFreq = Double.parseDouble(args[++i]);
                    continue;
                }
                if (cmd.equals("-h")) {
                    this.printUsageAndExit();
                    continue;
                }
                if (cmd.equals("--help")) {
                    this.printUsageAndExit();
                    continue;
                }
                System.err.println("UNEXPECTED: " + cmd);
                this.printUsageAndExit();
                continue;
            }
            catch (Exception e) {
                this.printUsageAndExit();
            }
        }
        if (compress) {
            Configuration conf = this.getConf();
            conf.setBoolean("hbase.regionserver.wal.enablecompression", true);
        }
        if (cipher != null) {
            Configuration conf = this.getConf();
            conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
            conf.set("hbase.crypto.master.key.name", "hbase");
            conf.setClass("hbase.regionserver.hlog.reader.impl", SecureProtobufLogReader.class, WAL.Reader.class);
            conf.setClass("hbase.regionserver.hlog.writer.impl", SecureProtobufLogWriter.class, WALProvider.Writer.class);
            conf.setBoolean("hbase.regionserver.wal.encryption", true);
            conf.set("hbase.crypto.wal.algorithm", cipher);
        }
        if (numThreads < numRegions) {
            LOG.warn("Number of threads is less than the number of regions; some regions will sit idle.");
        }
        this.getConf().setInt("hbase.regionserver.handler.count", numThreads);
        FSUtils.setFsDefault((Configuration)this.getConf(), (Path)FSUtils.getRootDir((Configuration)this.getConf()));
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        LOG.info("FileSystem: " + fs);
        SpanReceiverHost receiverHost = trace ? SpanReceiverHost.getInstance((Configuration)this.getConf()) : null;
        Sampler sampler = trace ? Sampler.ALWAYS : Sampler.NEVER;
        TraceUtil.addSampler((Sampler)sampler);
        TraceScope scope = TraceUtil.createTrace((String)"WALPerfEval");
        try {
            if (rootRegionDir == null) {
                rootRegionDir = this.TEST_UTIL.getDataTestDirOnTestFS(TABLE_NAME);
            }
            rootRegionDir = rootRegionDir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.cleanRegionRootDir(fs, rootRegionDir);
            FSUtils.setRootDir((Configuration)this.getConf(), (Path)rootRegionDir);
            WALFactory wals = new WALFactory(this.getConf(), "wals");
            HRegion[] regions = new HRegion[numRegions];
            Runnable[] benchmarks = new Runnable[numRegions];
            MockRegionServerServices mockServices = new MockRegionServerServices(this.getConf());
            LogRoller roller = new LogRoller((Server)mockServices, (RegionServerServices)mockServices);
            Threads.setDaemonThreadRunning((Thread)roller.getThread(), (String)"WALPerfEval.logRoller");
            try {
                for (int i = 0; i < numRegions; ++i) {
                    TableDescriptor htd = WALPerformanceEvaluation.createHTableDescriptor(i, numFamilies);
                    regions[i] = this.openRegion(fs, rootRegionDir, htd, wals, roll, roller);
                    benchmarks[i] = TraceUtil.wrap((Runnable)new WALPutBenchmark(regions[i], htd, numIterations, noSync, syncInterval, traceFreq), (String)"");
                }
                ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)this.metrics).outputTo(System.out).convertRatesTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).build();
                reporter.start(30L, TimeUnit.SECONDS);
                long putTime = this.runBenchmark(benchmarks, numThreads);
                WALPerformanceEvaluation.logBenchmarkResult("Summary: threads=" + numThreads + ", iterations=" + numIterations + ", syncInterval=" + syncInterval, numIterations * (long)numThreads, putTime);
                for (int i = 0; i < numRegions; ++i) {
                    if (regions[i] == null) continue;
                    this.closeRegion(regions[i]);
                    regions[i] = null;
                }
                if (verify) {
                    LOG.info("verifying written log entries.");
                    Path dir = new Path(FSUtils.getRootDir((Configuration)this.getConf()), AbstractFSWALProvider.getWALDirectoryName((String)"wals"));
                    long editCount = 0L;
                    FileStatus[] fsss = fs.listStatus(dir);
                    if (fsss.length == 0) {
                        throw new IllegalStateException("No WAL found");
                    }
                    for (FileStatus fss : fsss) {
                        Path p = fss.getPath();
                        if (!fs.exists(p)) {
                            throw new IllegalStateException(p.toString());
                        }
                        editCount += this.verify(wals, p, verbose);
                    }
                    long expected = numIterations * (long)numThreads;
                    if (editCount != expected) {
                        throw new IllegalStateException("Counted=" + editCount + ", expected=" + expected);
                    }
                }
            }
            finally {
                mockServices.stop("test clean up.");
                for (int i = 0; i < numRegions; ++i) {
                    if (regions[i] == null) continue;
                    this.closeRegion(regions[i]);
                }
                if (null != roller) {
                    LOG.info("shutting down log roller.");
                    roller.close();
                }
                wals.shutdown();
                if (cleanup) {
                    this.cleanRegionRootDir(fs, rootRegionDir);
                }
            }
        }
        finally {
            if (!noclosefs) {
                fs.close();
            }
            if (scope != null) {
                scope.close();
            }
            if (receiverHost != null) {
                receiverHost.closeReceivers();
            }
        }
        return 0;
    }

    private static TableDescriptor createHTableDescriptor(int regionNum, int numFamilies) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)("WALPerformanceEvaluation:" + regionNum)));
        IntStream.range(0, numFamilies).mapToObj(i -> ColumnFamilyDescriptorBuilder.of((String)(FAMILY_PREFIX + i))).forEachOrdered(arg_0 -> ((TableDescriptorBuilder)builder).setColumnFamily(arg_0));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long verify(WALFactory wals, Path wal, boolean verbose) throws IOException {
        WAL.Reader reader = wals.createReader(wal.getFileSystem(this.getConf()), wal);
        long count = 0L;
        HashMap<String, Long> sequenceIds = new HashMap<String, Long>();
        try {
            while (true) {
                WAL.Entry e;
                if ((e = reader.next()) == null) {
                    LOG.debug("Read count=" + count + " from " + wal);
                    break;
                }
                ++count;
                long seqid = e.getKey().getSequenceId();
                if (sequenceIds.containsKey(Bytes.toString((byte[])e.getKey().getEncodedRegionName())) && (Long)sequenceIds.get(Bytes.toString((byte[])e.getKey().getEncodedRegionName())) >= seqid) {
                    throw new IllegalStateException("wal = " + wal.getName() + ", previous seqid = " + sequenceIds.get(Bytes.toString((byte[])e.getKey().getEncodedRegionName())) + ", current seqid = " + seqid);
                }
                sequenceIds.put(Bytes.toString((byte[])e.getKey().getEncodedRegionName()), seqid);
                if (!verbose) continue;
                LOG.info("seqid=" + seqid);
            }
        }
        finally {
            reader.close();
        }
        return count;
    }

    private static void logBenchmarkResult(String testName, long numTests, long totalTime) {
        float tsec = (float)totalTime / 1000.0f;
        LOG.info(String.format("%s took %.3fs %.3fops/s", testName, Float.valueOf(tsec), Float.valueOf((float)numTests / tsec)));
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: hbase %s [options]\n", ((Object)((Object)this)).getClass().getName());
        System.err.println(" where [options] are:");
        System.err.println("  -h|-help         Show this help and exit.");
        System.err.println("  -threads <N>     Number of threads writing on the WAL.");
        System.err.println("  -regions <N>     Number of regions to open in the WAL. Default: 1");
        System.err.println("  -iterations <N>  Number of iterations per thread.");
        System.err.println("  -path <PATH>     Path where region's root directory is created.");
        System.err.println("  -families <N>    Number of column families to write.");
        System.err.println("  -qualifiers <N>  Number of qualifiers to write.");
        System.err.println("  -keySize <N>     Row key size in byte.");
        System.err.println("  -valueSize <N>   Row/Col value size in byte.");
        System.err.println("  -nocleanup       Do NOT remove test data when done.");
        System.err.println("  -noclosefs       Do NOT close the filesystem when done.");
        System.err.println("  -nosync          Append without syncing");
        System.err.println("  -syncInterval <N> Append N edits and then sync. Default=0, i.e. sync every edit.");
        System.err.println("  -verify          Verify edits written in sequence");
        System.err.println("  -verbose         Output extra info; e.g. all edit seq ids when verifying");
        System.err.println("  -roll <N>        Roll the way every N appends");
        System.err.println("  -encryption <A>  Encrypt the WAL with algorithm A, e.g. AES");
        System.err.println("  -traceFreq <N>   Rate of trace sampling. Default: 1.0, only respected when tracing is enabled, ie -Dhbase.trace.spanreceiver.classes=...");
        System.err.println("");
        System.err.println("Examples:");
        System.err.println("");
        System.err.println(" To run 100 threads on hdfs with log rolling every 10k edits and verification afterward do:");
        System.err.println(" $ hbase org.apache.hadoop.hbase.wal.WALPerformanceEvaluation \\");
        System.err.println("    -conf ./core-site.xml -path hdfs://example.org:7000/tmp -threads 100 -roll 10000 -verify");
        System.exit(1);
    }

    private HRegion openRegion(FileSystem fs, Path dir, TableDescriptor htd, WALFactory wals, final long whenToRoll, LogRoller roller) throws IOException {
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        final WAL wal = wals.getWAL(regionInfo);
        if (this.walsListenedTo.add(wal)) {
            roller.addWAL(wal);
            wal.registerWALActionsListener(new WALActionsListener(){
                private int appends = 0;

                public void visitLogEntryBeforeWrite(WALKey logKey, WALEdit logEdit) {
                    ++this.appends;
                    if ((long)this.appends % whenToRoll == 0L) {
                        LOG.info("Rolling after " + this.appends + " edits");
                        AbstractFSWALProvider.requestLogRoll((WAL)wal);
                    }
                }

                public void postSync(long timeInNanos, int handlerSyncs) {
                    WALPerformanceEvaluation.this.syncMeter.mark();
                    WALPerformanceEvaluation.this.syncHistogram.update(timeInNanos);
                    WALPerformanceEvaluation.this.syncCountHistogram.update(handlerSyncs);
                }

                public void postAppend(long size, long elapsedTime, WALKey logkey, WALEdit logEdit) {
                    WALPerformanceEvaluation.this.appendMeter.mark(size);
                }
            });
        }
        return HRegion.createHRegion((RegionInfo)regionInfo, (Path)dir, (Configuration)this.getConf(), (TableDescriptor)htd, (WAL)wal);
    }

    private void closeRegion(HRegion region) throws IOException {
        if (region != null) {
            region.close();
            WAL wal = region.getWAL();
            if (wal != null) {
                wal.shutdown();
            }
        }
    }

    private void cleanRegionRootDir(FileSystem fs, Path dir) throws IOException {
        if (fs.exists(dir)) {
            fs.delete(dir, true);
        }
    }

    private Put setupPut(Random rand, byte[] key, byte[] value, int numFamilies) {
        rand.nextBytes(key);
        Put put = new Put(key);
        for (int cf = 0; cf < numFamilies; ++cf) {
            for (int q = 0; q < this.numQualifiers; ++q) {
                rand.nextBytes(value);
                put.addColumn(Bytes.toBytes((String)(FAMILY_PREFIX + cf)), Bytes.toBytes((String)(QUALIFIER_PREFIX + q)), value);
            }
        }
        return put;
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<Cell>> familyMap, WALEdit walEdit) {
        for (List<Cell> edits : familyMap.values()) {
            for (Cell cell : edits) {
                walEdit.add(cell);
            }
        }
    }

    private long runBenchmark(Runnable[] runnable, int numThreads) throws InterruptedException {
        Thread[] threads = new Thread[numThreads];
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(runnable[i % runnable.length], "t" + i + ",r" + i % runnable.length);
            threads[i].start();
        }
        for (Thread t : threads) {
            t.join();
        }
        long endTime = System.currentTimeMillis();
        return endTime - startTime;
    }

    static int innerMain(Configuration c, String[] args) throws Exception {
        return ToolRunner.run((Configuration)c, (Tool)new WALPerformanceEvaluation(), (String[])args);
    }

    public static void main(String[] args) throws Exception {
        System.exit(WALPerformanceEvaluation.innerMain(HBaseConfiguration.create(), args));
    }

    class WALPutBenchmark
    implements Runnable {
        private final long numIterations;
        private final int numFamilies;
        private final boolean noSync;
        private final HRegion region;
        private final int syncInterval;
        private final Sampler loopSampler;
        private final NavigableMap<byte[], Integer> scopes;

        WALPutBenchmark(HRegion region, TableDescriptor htd, long numIterations, boolean noSync, int syncInterval, double traceFreq) {
            this.numIterations = numIterations;
            this.noSync = noSync;
            this.syncInterval = syncInterval;
            this.numFamilies = htd.getColumnFamilyCount();
            this.region = region;
            this.scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            for (byte[] fam : htd.getColumnFamilyNames()) {
                this.scopes.put(fam, 0);
            }
            String spanReceivers = WALPerformanceEvaluation.this.getConf().get("hbase.trace.spanreceiver.classes");
            if (spanReceivers == null || spanReceivers.isEmpty()) {
                this.loopSampler = Sampler.NEVER;
            } else if (traceFreq <= 0.0) {
                LOG.warn("Tracing enabled but traceFreq=0.");
                this.loopSampler = Sampler.NEVER;
            } else if (traceFreq >= 1.0) {
                this.loopSampler = Sampler.ALWAYS;
                if (numIterations > 1000L) {
                    LOG.warn("Full tracing of all iterations will produce a lot of data. Be sure your SpanReceiver can keep up.");
                }
            } else {
                WALPerformanceEvaluation.this.getConf().setDouble("hbase.sampler.fraction", traceFreq);
                this.loopSampler = new ProbabilitySampler((HTraceConfiguration)new HBaseHTraceConfiguration(WALPerformanceEvaluation.this.getConf()));
            }
        }

        @Override
        public void run() {
            byte[] key = new byte[WALPerformanceEvaluation.this.keySize];
            byte[] value = new byte[WALPerformanceEvaluation.this.valueSize];
            Random rand = new Random(Thread.currentThread().getId());
            WAL wal = this.region.getWAL();
            try (TraceScope threadScope = TraceUtil.createTrace((String)("WALPerfEval." + Thread.currentThread().getName()));){
                long startTime = System.currentTimeMillis();
                int lastSync = 0;
                TraceUtil.addSampler((Sampler)this.loopSampler);
                int i = 0;
                while ((long)i < this.numIterations) {
                    assert (Tracer.getCurrentSpan() == threadScope.getSpan()) : "Span leak detected.";
                    try (TraceScope loopScope = TraceUtil.createTrace((String)("runLoopIter" + i));){
                        long now = System.nanoTime();
                        Put put = WALPerformanceEvaluation.this.setupPut(rand, key, value, this.numFamilies);
                        WALEdit walEdit = new WALEdit();
                        WALPerformanceEvaluation.this.addFamilyMapToWALEdit(put.getFamilyCellMap(), walEdit);
                        RegionInfo hri = this.region.getRegionInfo();
                        WALKeyImpl logkey = new WALKeyImpl(hri.getEncodedNameAsBytes(), hri.getTable(), now, WALPerformanceEvaluation.this.mvcc, this.scopes);
                        wal.append(hri, logkey, walEdit, true);
                        if (!this.noSync && ++lastSync >= this.syncInterval) {
                            wal.sync();
                            lastSync = 0;
                        }
                        WALPerformanceEvaluation.this.latencyHistogram.update(System.nanoTime() - now);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                LOG.error(this.getClass().getSimpleName() + " Thread failed", (Throwable)e);
            }
        }
    }
}

