/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterAnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterRpcServices
extends RSRpcServices
implements MasterProtos.MasterService.BlockingInterface,
RegionServerStatusProtos.RegionServerStatusService.BlockingInterface,
LockServiceProtos.LockService.BlockingInterface {
    private static final Logger LOG = LoggerFactory.getLogger((String)MasterRpcServices.class.getName());
    private final HMaster master;

    private RegionServerStatusProtos.RegionServerStartupResponse.Builder createConfigurationSubset() {
        RegionServerStatusProtos.RegionServerStartupResponse.Builder resp = this.addConfig(RegionServerStatusProtos.RegionServerStartupResponse.newBuilder(), "hbase.rootdir");
        resp = this.addConfig(resp, "fs.defaultFS");
        return this.addConfig(resp, "hbase.master.info.port");
    }

    private RegionServerStatusProtos.RegionServerStartupResponse.Builder addConfig(RegionServerStatusProtos.RegionServerStartupResponse.Builder resp, String key) {
        HBaseProtos.NameStringPair.Builder entry = HBaseProtos.NameStringPair.newBuilder().setName(key).setValue(this.master.getConfiguration().get(key));
        resp.addMapEntries(entry.build());
        return resp;
    }

    public MasterRpcServices(HMaster m) throws IOException {
        super(m);
        this.master = m;
    }

    @Override
    protected RpcServerInterface createRpcServer(Server server, Configuration conf, RpcSchedulerFactory rpcSchedulerFactory, InetSocketAddress bindAddress, String name) throws IOException {
        boolean reservoirEnabled = conf.getBoolean("hbase.ipc.server.reservoir.enabled", LoadBalancer.isTablesOnMaster(conf) && !LoadBalancer.isSystemTablesOnlyOnMaster(conf));
        try {
            return RpcServerFactory.createRpcServer(server, name, this.getServices(), bindAddress, conf, rpcSchedulerFactory.create(conf, this, server), reservoirEnabled);
        }
        catch (BindException be) {
            throw new IOException(be.getMessage() + ". To switch ports use the '" + "hbase.master.port" + "' configuration property.", be.getCause() != null ? be.getCause() : be);
        }
    }

    @Override
    protected PriorityFunction createPriority() {
        return new MasterAnnotationReadingPriorityFunction(this);
    }

    private void rpcPreCheck(String requestName) throws ServiceException {
        try {
            this.master.checkInitialized();
            this.requirePermission(requestName, Permission.Action.ADMIN);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean switchBalancer(boolean b, BalanceSwitchMode mode) throws IOException {
        boolean oldValue = this.master.loadBalancerTracker.isBalancerOn();
        boolean newValue = b;
        try {
            block10: {
                if (this.master.cpHost != null) {
                    this.master.cpHost.preBalanceSwitch(newValue);
                }
                try {
                    if (mode == BalanceSwitchMode.SYNC) {
                        LoadBalancer loadBalancer = this.master.getLoadBalancer();
                        synchronized (loadBalancer) {
                            this.master.loadBalancerTracker.setBalancerOn(newValue);
                            break block10;
                        }
                    }
                    this.master.loadBalancerTracker.setBalancerOn(newValue);
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
            }
            LOG.info(this.master.getClientIdAuditPrefix() + " set balanceSwitch=" + newValue);
            if (this.master.cpHost != null) {
                this.master.cpHost.postBalanceSwitch(oldValue, newValue);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Error flipping balance switch", (Throwable)ioe);
        }
        return oldValue;
    }

    boolean synchronousBalanceSwitch(boolean b) throws IOException {
        return this.switchBalancer(b, BalanceSwitchMode.SYNC);
    }

    @Override
    protected List<RpcServer.BlockingServiceAndInterface> getServices() {
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>(5);
        bssi.add(new RpcServer.BlockingServiceAndInterface(MasterProtos.MasterService.newReflectiveBlockingService((MasterProtos.MasterService.BlockingInterface)this), MasterProtos.MasterService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(RegionServerStatusProtos.RegionServerStatusService.newReflectiveBlockingService((RegionServerStatusProtos.RegionServerStatusService.BlockingInterface)this), RegionServerStatusProtos.RegionServerStatusService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(LockServiceProtos.LockService.newReflectiveBlockingService((LockServiceProtos.LockService.BlockingInterface)this), LockServiceProtos.LockService.BlockingInterface.class));
        bssi.addAll(super.getServices());
        return bssi;
    }

    @QosPriority(priority=100)
    public RegionServerStatusProtos.GetLastFlushedSequenceIdResponse getLastFlushedSequenceId(RpcController controller, RegionServerStatusProtos.GetLastFlushedSequenceIdRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        byte[] encodedRegionName = request.getRegionName().toByteArray();
        ClusterStatusProtos.RegionStoreSequenceIds ids = this.master.getServerManager().getLastFlushedSequenceId(encodedRegionName);
        return ResponseConverter.buildGetLastFlushedSequenceIdResponse((ClusterStatusProtos.RegionStoreSequenceIds)ids);
    }

    public RegionServerStatusProtos.RegionServerReportResponse regionServerReport(RpcController controller, RegionServerStatusProtos.RegionServerReportRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            int version = VersionInfoUtil.getCurrentClientVersionNumber();
            ClusterStatusProtos.ServerLoad sl = request.getLoad();
            ServerName serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getServer());
            ServerMetrics oldLoad = this.master.getServerManager().getLoad(serverName);
            ServerMetrics newLoad = ServerMetricsBuilder.toServerMetrics((ServerName)serverName, (int)version, (ClusterStatusProtos.ServerLoad)sl);
            this.master.getServerManager().regionServerReport(serverName, newLoad);
            this.master.getAssignmentManager().reportOnlineRegions(serverName, newLoad.getRegionMetrics().keySet());
            if (sl != null && this.master.metricsMaster != null) {
                this.master.metricsMaster.incrementRequests(sl.getTotalNumberOfRequests() - (oldLoad != null ? oldLoad.getRequestCount() : 0L));
            }
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return RegionServerStatusProtos.RegionServerReportResponse.newBuilder().build();
    }

    public RegionServerStatusProtos.RegionServerStartupResponse regionServerStartup(RpcController controller, RegionServerStatusProtos.RegionServerStartupRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            int version = VersionInfoUtil.getCurrentClientVersionNumber();
            InetAddress ia = this.master.getRemoteInetAddress(request.getPort(), request.getServerStartCode());
            ServerName rs = this.master.getServerManager().regionServerStartup(request, version, ia);
            RegionServerStatusProtos.RegionServerStartupResponse.Builder resp = this.createConfigurationSubset();
            HBaseProtos.NameStringPair.Builder entry = HBaseProtos.NameStringPair.newBuilder().setName("hbase.regionserver.hostname.seen.by.master").setValue(rs.getHostname());
            resp.addMapEntries(entry.build());
            return resp.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public RegionServerStatusProtos.ReportRSFatalErrorResponse reportRSFatalError(RpcController controller, RegionServerStatusProtos.ReportRSFatalErrorRequest request) throws ServiceException {
        String errorText = request.getErrorMessage();
        ServerName sn = ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getServer());
        String msg = "Region server " + sn + " reported a fatal error:\n" + errorText;
        LOG.error(msg);
        this.master.rsFatals.add(msg);
        return RegionServerStatusProtos.ReportRSFatalErrorResponse.newBuilder().build();
    }

    public MasterProtos.AddColumnResponse addColumn(RpcController controller, MasterProtos.AddColumnRequest req) throws ServiceException {
        try {
            long procId = this.master.addColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), ProtobufUtil.toColumnFamilyDescriptor((HBaseProtos.ColumnFamilySchema)req.getColumnFamilies()), req.getNonceGroup(), req.getNonce());
            if (procId == -1L) {
                return MasterProtos.AddColumnResponse.newBuilder().build();
            }
            return MasterProtos.AddColumnResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.AssignRegionResponse assignRegion(RpcController controller, MasterProtos.AssignRegionRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn("assignRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type);
            }
            byte[] regionName = req.getRegion().getValue().toByteArray();
            RegionInfo regionInfo = this.master.getAssignmentManager().getRegionInfo(regionName);
            if (regionInfo == null) {
                throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionName));
            }
            MasterProtos.AssignRegionResponse arr = MasterProtos.AssignRegionResponse.newBuilder().build();
            if (this.master.cpHost != null) {
                this.master.cpHost.preAssign(regionInfo);
            }
            LOG.info(this.master.getClientIdAuditPrefix() + " assign " + regionInfo.getRegionNameAsString());
            this.master.getAssignmentManager().assign(regionInfo);
            if (this.master.cpHost != null) {
                this.master.cpHost.postAssign(regionInfo);
            }
            return arr;
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.BalanceResponse balance(RpcController controller, MasterProtos.BalanceRequest request) throws ServiceException {
        try {
            return MasterProtos.BalanceResponse.newBuilder().setBalancerRan(this.master.balance(request.hasForce() ? request.getForce() : false)).build();
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    public MasterProtos.CreateNamespaceResponse createNamespace(RpcController controller, MasterProtos.CreateNamespaceRequest request) throws ServiceException {
        try {
            long procId = this.master.createNamespace(ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)request.getNamespaceDescriptor()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.CreateNamespaceResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.CreateTableResponse createTable(RpcController controller, MasterProtos.CreateTableRequest req) throws ServiceException {
        TableDescriptor tableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)req.getTableSchema());
        byte[][] splitKeys = ProtobufUtil.getSplitKeysArray((MasterProtos.CreateTableRequest)req);
        try {
            long procId = this.master.createTable(tableDescriptor, splitKeys, req.getNonceGroup(), req.getNonce());
            return MasterProtos.CreateTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterProtos.DeleteColumnRequest req) throws ServiceException {
        try {
            long procId = this.master.deleteColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), req.getColumnName().toByteArray(), req.getNonceGroup(), req.getNonce());
            if (procId == -1L) {
                return MasterProtos.DeleteColumnResponse.newBuilder().build();
            }
            return MasterProtos.DeleteColumnResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.DeleteNamespaceResponse deleteNamespace(RpcController controller, MasterProtos.DeleteNamespaceRequest request) throws ServiceException {
        try {
            long procId = this.master.deleteNamespace(request.getNamespaceName(), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DeleteNamespaceResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterProtos.DeleteSnapshotRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            this.master.snapshotManager.checkSnapshotSupport();
            LOG.info(this.master.getClientIdAuditPrefix() + " delete " + request.getSnapshot());
            this.master.snapshotManager.deleteSnapshot(request.getSnapshot());
            return MasterProtos.DeleteSnapshotResponse.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.DeleteTableResponse deleteTable(RpcController controller, MasterProtos.DeleteTableRequest request) throws ServiceException {
        try {
            long procId = this.master.deleteTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DeleteTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.TruncateTableResponse truncateTable(RpcController controller, MasterProtos.TruncateTableRequest request) throws ServiceException {
        try {
            long procId = this.master.truncateTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getPreserveSplits(), request.getNonceGroup(), request.getNonce());
            return MasterProtos.TruncateTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.DisableTableResponse disableTable(RpcController controller, MasterProtos.DisableTableRequest request) throws ServiceException {
        try {
            long procId = this.master.disableTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DisableTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController c, MasterProtos.EnableCatalogJanitorRequest req) throws ServiceException {
        this.rpcPreCheck("enableCatalogJanitor");
        return MasterProtos.EnableCatalogJanitorResponse.newBuilder().setPrevValue(this.master.catalogJanitorChore.setEnabled(req.getEnable())).build();
    }

    public MasterProtos.SetCleanerChoreRunningResponse setCleanerChoreRunning(RpcController c, MasterProtos.SetCleanerChoreRunningRequest req) throws ServiceException {
        this.rpcPreCheck("setCleanerChoreRunning");
        boolean prevValue = this.master.getLogCleaner().getEnabled() && this.master.getHFileCleaner().getEnabled();
        this.master.getLogCleaner().setEnabled(req.getOn());
        this.master.getHFileCleaner().setEnabled(req.getOn());
        return MasterProtos.SetCleanerChoreRunningResponse.newBuilder().setPrevValue(prevValue).build();
    }

    public MasterProtos.EnableTableResponse enableTable(RpcController controller, MasterProtos.EnableTableRequest request) throws ServiceException {
        try {
            long procId = this.master.enableTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.EnableTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.MergeTableRegionsResponse mergeTableRegions(RpcController c, MasterProtos.MergeTableRegionsRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        RegionStates regionStates = this.master.getAssignmentManager().getRegionStates();
        assert (request.getRegionCount() == 2);
        RegionInfo[] regionsToMerge = new RegionInfo[request.getRegionCount()];
        for (int i = 0; i < request.getRegionCount(); ++i) {
            RegionState regionState;
            byte[] encodedNameOfRegion = request.getRegion(i).getValue().toByteArray();
            if (request.getRegion(i).getType() != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME) {
                LOG.warn("MergeRegions specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME + " actual: region " + i + " =" + request.getRegion(i).getType());
            }
            if ((regionState = regionStates.getRegionState(Bytes.toString((byte[])encodedNameOfRegion))) == null) {
                throw new ServiceException((Throwable)new UnknownRegionException(Bytes.toStringBinary((byte[])encodedNameOfRegion)));
            }
            regionsToMerge[i] = regionState.getRegion();
        }
        try {
            long procId = this.master.mergeRegions(regionsToMerge, request.getForcible(), request.getNonceGroup(), request.getNonce());
            return MasterProtos.MergeTableRegionsResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.SplitTableRegionResponse splitRegion(RpcController controller, MasterProtos.SplitTableRegionRequest request) throws ServiceException {
        try {
            long procId = this.master.splitRegion(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)request.getRegionInfo()), request.hasSplitRow() ? request.getSplitRow().toByteArray() : null, request.getNonceGroup(), request.getNonce());
            return MasterProtos.SplitTableRegionResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        this.rpcPreCheck("execMasterService");
        try {
            ServerRpcController execController = new ServerRpcController();
            ClientProtos.CoprocessorServiceCall call = request.getCall();
            String serviceName = call.getServiceName();
            String methodName = call.getMethodName();
            if (!this.master.coprocessorServiceHandlers.containsKey(serviceName)) {
                throw new UnknownProtocolException(null, "No registered Master Coprocessor Endpoint found for " + serviceName + ". Has it been enabled?");
            }
            Service service = this.master.coprocessorServiceHandlers.get(serviceName);
            Descriptors.ServiceDescriptor serviceDesc = service.getDescriptorForType();
            Descriptors.MethodDescriptor methodDesc = CoprocessorRpcUtils.getMethodDescriptor((String)methodName, (Descriptors.ServiceDescriptor)serviceDesc);
            Message execRequest = CoprocessorRpcUtils.getRequest((Service)service, (Descriptors.MethodDescriptor)methodDesc, (ByteString)call.getRequest());
            Message.Builder responseBuilder = service.getResponsePrototype(methodDesc).newBuilderForType();
            service.callMethod(methodDesc, (com.google.protobuf.RpcController)execController, execRequest, message -> {
                if (message != null) {
                    responseBuilder.mergeFrom(message);
                }
            });
            Message execResult = responseBuilder.build();
            if (execController.getFailedOn() != null) {
                throw execController.getFailedOn();
            }
            return CoprocessorRpcUtils.getResponse((Message)execResult, (byte[])HConstants.EMPTY_BYTE_ARRAY);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public MasterProtos.ExecProcedureResponse execProcedure(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = this.master.getMasterProcedureManagerHost().getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException((Throwable)new DoNotRetryIOException("The procedure is not registered: " + desc.getSignature()));
            }
            LOG.info(this.master.getClientIdAuditPrefix() + " procedure request for: " + desc.getSignature());
            mpm.checkPermissions(desc, this.accessChecker, RpcServer.getRequestUser().orElse(null));
            mpm.execProcedure(desc);
            long waitTime = 300000L;
            return MasterProtos.ExecProcedureResponse.newBuilder().setExpectedTimeout(waitTime).build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ExecProcedureResponse execProcedureWithRet(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
        this.rpcPreCheck("execProcedureWithRet");
        try {
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = this.master.getMasterProcedureManagerHost().getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException("The procedure is not registered: " + desc.getSignature());
            }
            LOG.info(this.master.getClientIdAuditPrefix() + " procedure request for: " + desc.getSignature());
            byte[] data = mpm.execProcedureWithRet(desc);
            MasterProtos.ExecProcedureResponse.Builder builder = MasterProtos.ExecProcedureResponse.newBuilder();
            if (data != null) {
                builder.setReturnData(UnsafeByteOperations.unsafeWrap((byte[])data));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterProtos.GetClusterStatusRequest req) throws ServiceException {
        MasterProtos.GetClusterStatusResponse.Builder response = MasterProtos.GetClusterStatusResponse.newBuilder();
        try {
            this.master.checkInitialized();
            response.setClusterStatus(ClusterMetricsBuilder.toClusterStatus((ClusterMetrics)this.master.getClusterMetrics(ClusterMetricsBuilder.toOptions((List)req.getOptionsList()))));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.GetCompletedSnapshotsResponse getCompletedSnapshots(RpcController controller, MasterProtos.GetCompletedSnapshotsRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            MasterProtos.GetCompletedSnapshotsResponse.Builder builder = MasterProtos.GetCompletedSnapshotsResponse.newBuilder();
            List<SnapshotProtos.SnapshotDescription> snapshots = this.master.snapshotManager.getCompletedSnapshots();
            for (SnapshotProtos.SnapshotDescription snapshot : snapshots) {
                builder.addSnapshots(snapshot);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetNamespaceDescriptorResponse getNamespaceDescriptor(RpcController controller, MasterProtos.GetNamespaceDescriptorRequest request) throws ServiceException {
        try {
            return MasterProtos.GetNamespaceDescriptorResponse.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)this.master.getNamespace(request.getNamespaceName()))).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterProtos.GetSchemaAlterStatusRequest req) throws ServiceException {
        TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName());
        try {
            this.master.checkInitialized();
            Pair<Integer, Integer> pair = this.master.getAssignmentManager().getReopenStatus(tableName);
            MasterProtos.GetSchemaAlterStatusResponse.Builder ret = MasterProtos.GetSchemaAlterStatusResponse.newBuilder();
            ret.setYetToUpdateRegions(((Integer)pair.getFirst()).intValue());
            ret.setTotalRegions(((Integer)pair.getSecond()).intValue());
            return ret.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController c, MasterProtos.GetTableDescriptorsRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            String regex = req.hasRegex() ? req.getRegex() : null;
            String namespace = req.hasNamespace() ? req.getNamespace() : null;
            ArrayList<TableName> tableNameList = null;
            if (req.getTableNamesCount() > 0) {
                tableNameList = new ArrayList<TableName>(req.getTableNamesCount());
                for (HBaseProtos.TableName tableNamePB : req.getTableNamesList()) {
                    tableNameList.add(ProtobufUtil.toTableName((HBaseProtos.TableName)tableNamePB));
                }
            }
            List<TableDescriptor> descriptors = this.master.listTableDescriptors(namespace, regex, tableNameList, req.getIncludeSysTables());
            MasterProtos.GetTableDescriptorsResponse.Builder builder = MasterProtos.GetTableDescriptorsResponse.newBuilder();
            if (descriptors != null && descriptors.size() > 0) {
                for (TableDescriptor htd : descriptors) {
                    builder.addTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)htd));
                }
            }
            return builder.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.GetTableNamesResponse getTableNames(RpcController controller, MasterProtos.GetTableNamesRequest req) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            String regex = req.hasRegex() ? req.getRegex() : null;
            String namespace = req.hasNamespace() ? req.getNamespace() : null;
            List<TableName> tableNames = this.master.listTableNames(namespace, regex, req.getIncludeSysTables());
            MasterProtos.GetTableNamesResponse.Builder builder = MasterProtos.GetTableNamesResponse.newBuilder();
            if (tableNames != null && tableNames.size() > 0) {
                for (TableName table : tableNames) {
                    builder.addTableNames(ProtobufUtil.toProtoTableName((TableName)table));
                }
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetTableStateResponse getTableState(RpcController controller, MasterProtos.GetTableStateRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName());
            TableState ts = this.master.getTableStateManager().getTableState(tableName);
            MasterProtos.GetTableStateResponse.Builder builder = MasterProtos.GetTableStateResponse.newBuilder();
            builder.setTableState(ts.convert());
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController c, MasterProtos.IsCatalogJanitorEnabledRequest req) throws ServiceException {
        return MasterProtos.IsCatalogJanitorEnabledResponse.newBuilder().setValue(this.master.isCatalogJanitorEnabled()).build();
    }

    public MasterProtos.IsCleanerChoreEnabledResponse isCleanerChoreEnabled(RpcController c, MasterProtos.IsCleanerChoreEnabledRequest req) throws ServiceException {
        return MasterProtos.IsCleanerChoreEnabledResponse.newBuilder().setValue(this.master.isCleanerChoreEnabled()).build();
    }

    public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController c, MasterProtos.IsMasterRunningRequest req) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            return MasterProtos.IsMasterRunningResponse.newBuilder().setIsMasterRunning(!this.master.isStopped()).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsProcedureDoneResponse isProcedureDone(RpcController controller, MasterProtos.IsProcedureDoneRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = this.master.getMasterProcedureManagerHost().getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException("The procedure is not registered: " + desc.getSignature());
            }
            LOG.debug("Checking to see if procedure from request:" + desc.getSignature() + " is done");
            MasterProtos.IsProcedureDoneResponse.Builder builder = MasterProtos.IsProcedureDoneResponse.newBuilder();
            boolean done = mpm.isProcedureDone(desc);
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterProtos.IsSnapshotDoneRequest request) throws ServiceException {
        LOG.debug("Checking to see if snapshot from request:" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)request.getSnapshot()) + " is done");
        try {
            this.master.checkInitialized();
            MasterProtos.IsSnapshotDoneResponse.Builder builder = MasterProtos.IsSnapshotDoneResponse.newBuilder();
            boolean done = this.master.snapshotManager.isSnapshotDone(request.getSnapshot());
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetProcedureResultResponse getProcedureResult(RpcController controller, MasterProtos.GetProcedureResultRequest request) throws ServiceException {
        LOG.debug("Checking to see if procedure is done pid=" + request.getProcId());
        try {
            this.master.checkInitialized();
            MasterProtos.GetProcedureResultResponse.Builder builder = MasterProtos.GetProcedureResultResponse.newBuilder();
            long procId = request.getProcId();
            ProcedureExecutor<MasterProcedureEnv> executor = this.master.getMasterProcedureExecutor();
            Procedure result = executor.getResultOrProcedure(procId);
            if (result != null) {
                builder.setSubmittedTime(result.getSubmittedTime());
                builder.setLastUpdate(result.getLastUpdate());
                if (executor.isFinished(procId)) {
                    byte[] resultData;
                    builder.setState(MasterProtos.GetProcedureResultResponse.State.FINISHED);
                    if (result.isFailed()) {
                        IOException exception = result.getException().unwrapRemoteIOException();
                        builder.setException(ForeignExceptionUtil.toProtoForeignException((Throwable)exception));
                    }
                    if ((resultData = result.getResult()) != null) {
                        builder.setResult(UnsafeByteOperations.unsafeWrap((byte[])resultData));
                    }
                    this.master.getMasterProcedureExecutor().removeResult(request.getProcId());
                } else {
                    builder.setState(MasterProtos.GetProcedureResultResponse.State.RUNNING);
                }
            } else {
                builder.setState(MasterProtos.GetProcedureResultResponse.State.NOT_FOUND);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.AbortProcedureResponse abortProcedure(RpcController rpcController, MasterProtos.AbortProcedureRequest request) throws ServiceException {
        try {
            MasterProtos.AbortProcedureResponse.Builder response = MasterProtos.AbortProcedureResponse.newBuilder();
            boolean abortResult = this.master.abortProcedure(request.getProcId(), request.getMayInterruptIfRunning());
            response.setIsProcedureAborted(abortResult);
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListNamespaceDescriptorsResponse listNamespaceDescriptors(RpcController c, MasterProtos.ListNamespaceDescriptorsRequest request) throws ServiceException {
        try {
            MasterProtos.ListNamespaceDescriptorsResponse.Builder response = MasterProtos.ListNamespaceDescriptorsResponse.newBuilder();
            for (NamespaceDescriptor ns : this.master.getNamespaces()) {
                response.addNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)ns));
            }
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetProceduresResponse getProcedures(RpcController rpcController, MasterProtos.GetProceduresRequest request) throws ServiceException {
        try {
            MasterProtos.GetProceduresResponse.Builder response = MasterProtos.GetProceduresResponse.newBuilder();
            for (Procedure<?> p : this.master.getProcedures()) {
                response.addProcedure(ProcedureUtil.convertToProtoProcedure(p));
            }
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetLocksResponse getLocks(RpcController controller, MasterProtos.GetLocksRequest request) throws ServiceException {
        try {
            MasterProtos.GetLocksResponse.Builder builder = MasterProtos.GetLocksResponse.newBuilder();
            for (LockedResource lockedResource : this.master.getLocks()) {
                builder.addLock(ProcedureUtil.convertToProtoLockedResource((LockedResource)lockedResource));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListTableDescriptorsByNamespaceResponse listTableDescriptorsByNamespace(RpcController c, MasterProtos.ListTableDescriptorsByNamespaceRequest request) throws ServiceException {
        try {
            MasterProtos.ListTableDescriptorsByNamespaceResponse.Builder b = MasterProtos.ListTableDescriptorsByNamespaceResponse.newBuilder();
            for (TableDescriptor htd : this.master.listTableDescriptorsByNamespace(request.getNamespaceName())) {
                b.addTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)htd));
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListTableNamesByNamespaceResponse listTableNamesByNamespace(RpcController c, MasterProtos.ListTableNamesByNamespaceRequest request) throws ServiceException {
        try {
            MasterProtos.ListTableNamesByNamespaceResponse.Builder b = MasterProtos.ListTableNamesByNamespaceResponse.newBuilder();
            for (TableName tableName : this.master.listTableNamesByNamespace(request.getNamespaceName())) {
                b.addTableName(ProtobufUtil.toProtoTableName((TableName)tableName));
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterProtos.ModifyColumnRequest req) throws ServiceException {
        try {
            long procId = this.master.modifyColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), ProtobufUtil.toColumnFamilyDescriptor((HBaseProtos.ColumnFamilySchema)req.getColumnFamilies()), req.getNonceGroup(), req.getNonce());
            if (procId == -1L) {
                return MasterProtos.ModifyColumnResponse.newBuilder().build();
            }
            return MasterProtos.ModifyColumnResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.ModifyNamespaceResponse modifyNamespace(RpcController controller, MasterProtos.ModifyNamespaceRequest request) throws ServiceException {
        try {
            long procId = this.master.modifyNamespace(ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)request.getNamespaceDescriptor()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.ModifyNamespaceResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ModifyTableResponse modifyTable(RpcController controller, MasterProtos.ModifyTableRequest req) throws ServiceException {
        try {
            long procId = this.master.modifyTable(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)req.getTableSchema()), req.getNonceGroup(), req.getNonce());
            return MasterProtos.ModifyTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.MoveRegionResponse moveRegion(RpcController controller, MasterProtos.MoveRegionRequest req) throws ServiceException {
        byte[] encodedRegionName = req.getRegion().getValue().toByteArray();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
        byte[] destServerName = req.hasDestServerName() ? Bytes.toBytes((String)ProtobufUtil.toServerName((HBaseProtos.ServerName)req.getDestServerName()).getServerName()) : null;
        MasterProtos.MoveRegionResponse mrr = MasterProtos.MoveRegionResponse.newBuilder().build();
        if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME) {
            LOG.warn("moveRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME + " actual: " + type);
        }
        try {
            this.master.checkInitialized();
            this.master.move(encodedRegionName, destServerName);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return mrr;
    }

    public MasterProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterProtos.OfflineRegionRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = request.getRegion().getType();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn("moveRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type);
            }
            byte[] regionName = request.getRegion().getValue().toByteArray();
            RegionInfo hri = this.master.getAssignmentManager().getRegionInfo(regionName);
            if (hri == null) {
                throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionName));
            }
            if (this.master.cpHost != null) {
                this.master.cpHost.preRegionOffline(hri);
            }
            LOG.info(this.master.getClientIdAuditPrefix() + " offline " + hri.getRegionNameAsString());
            this.master.getAssignmentManager().offlineRegion(hri);
            if (this.master.cpHost != null) {
                this.master.cpHost.postRegionOffline(hri);
            }
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.OfflineRegionResponse.newBuilder().build();
    }

    public MasterProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterProtos.RestoreSnapshotRequest request) throws ServiceException {
        try {
            long procId = this.master.restoreSnapshot(request.getSnapshot(), request.getNonceGroup(), request.getNonce(), request.getRestoreACL());
            return MasterProtos.RestoreSnapshotResponse.newBuilder().setProcId(procId).build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.RunCatalogScanResponse runCatalogScan(RpcController c, MasterProtos.RunCatalogScanRequest req) throws ServiceException {
        this.rpcPreCheck("runCatalogScan");
        try {
            return ResponseConverter.buildRunCatalogScanResponse((int)this.master.catalogJanitorChore.scan());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.RunCleanerChoreResponse runCleanerChore(RpcController c, MasterProtos.RunCleanerChoreRequest req) throws ServiceException {
        this.rpcPreCheck("runCleanerChore");
        boolean result = this.master.getHFileCleaner().runCleaner() != false && this.master.getLogCleaner().runCleaner() != false;
        return ResponseConverter.buildRunCleanerChoreResponse((boolean)result);
    }

    public MasterProtos.SetBalancerRunningResponse setBalancerRunning(RpcController c, MasterProtos.SetBalancerRunningRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            boolean prevValue = req.getSynchronous() ? this.synchronousBalanceSwitch(req.getOn()) : this.master.balanceSwitch(req.getOn());
            return MasterProtos.SetBalancerRunningResponse.newBuilder().setPrevBalanceValue(prevValue).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.ShutdownResponse shutdown(RpcController controller, MasterProtos.ShutdownRequest request) throws ServiceException {
        LOG.info(this.master.getClientIdAuditPrefix() + " shutdown");
        try {
            this.master.shutdown();
        }
        catch (IOException e) {
            LOG.error("Exception occurred in HMaster.shutdown()", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        return MasterProtos.ShutdownResponse.newBuilder().build();
    }

    public MasterProtos.SnapshotResponse snapshot(RpcController controller, MasterProtos.SnapshotRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            this.master.snapshotManager.checkSnapshotSupport();
            LOG.info(this.master.getClientIdAuditPrefix() + " snapshot request for:" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)request.getSnapshot()));
            SnapshotProtos.SnapshotDescription snapshot = SnapshotDescriptionUtils.validate(request.getSnapshot(), this.master.getConfiguration());
            this.master.snapshotManager.takeSnapshot(snapshot);
            long waitTime = SnapshotDescriptionUtils.getMaxMasterTimeout(this.master.getConfiguration(), snapshot.getType(), 300000L);
            return MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout(waitTime).build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.StopMasterResponse stopMaster(RpcController controller, MasterProtos.StopMasterRequest request) throws ServiceException {
        LOG.info(this.master.getClientIdAuditPrefix() + " stop");
        try {
            this.master.stopMaster();
        }
        catch (IOException e) {
            LOG.error("Exception occurred while stopping master", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        return MasterProtos.StopMasterResponse.newBuilder().build();
    }

    public MasterProtos.IsInMaintenanceModeResponse isMasterInMaintenanceMode(RpcController controller, MasterProtos.IsInMaintenanceModeRequest request) throws ServiceException {
        MasterProtos.IsInMaintenanceModeResponse.Builder response = MasterProtos.IsInMaintenanceModeResponse.newBuilder();
        try {
            response.setInMaintenanceMode(this.master.isInMaintenanceMode());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterProtos.UnassignRegionRequest req) throws ServiceException {
        try {
            byte[] regionName = req.getRegion().getValue().toByteArray();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
            boolean force = req.getForce();
            MasterProtos.UnassignRegionResponse urr = MasterProtos.UnassignRegionResponse.newBuilder().build();
            this.master.checkInitialized();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn("unassignRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type);
            }
            Pair pair = MetaTableAccessor.getRegion((Connection)this.master.getConnection(), (byte[])regionName);
            if (Bytes.equals((byte[])RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName(), (byte[])regionName)) {
                pair = new Pair((Object)RegionInfoBuilder.FIRST_META_REGIONINFO, (Object)this.master.getMetaTableLocator().getMetaRegionLocation(this.master.getZooKeeper()));
            }
            if (pair == null) {
                throw new UnknownRegionException(Bytes.toString((byte[])regionName));
            }
            RegionInfo hri = (RegionInfo)pair.getFirst();
            if (this.master.cpHost != null) {
                this.master.cpHost.preUnassign(hri, force);
            }
            LOG.debug(this.master.getClientIdAuditPrefix() + " unassign " + hri.getRegionNameAsString() + " in current location if it is online and reassign.force=" + force);
            this.master.getAssignmentManager().unassign(hri);
            if (this.master.cpHost != null) {
                this.master.cpHost.postUnassign(hri, force);
            }
            return urr;
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RpcController c, RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            return this.master.getAssignmentManager().reportRegionStateTransition(req);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.SetQuotaResponse setQuota(RpcController c, MasterProtos.SetQuotaRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            return this.master.getMasterQuotaManager().setQuota(req);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestamp(RpcController controller, MasterProtos.MajorCompactionTimestampRequest request) throws ServiceException {
        MasterProtos.MajorCompactionTimestampResponse.Builder response = MasterProtos.MajorCompactionTimestampResponse.newBuilder();
        try {
            this.master.checkInitialized();
            response.setCompactionTimestamp(this.master.getLastMajorCompactionTimestamp(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName())));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestampForRegion(RpcController controller, MasterProtos.MajorCompactionTimestampForRegionRequest request) throws ServiceException {
        MasterProtos.MajorCompactionTimestampResponse.Builder response = MasterProtos.MajorCompactionTimestampResponse.newBuilder();
        try {
            this.master.checkInitialized();
            response.setCompactionTimestamp(this.master.getLastMajorCompactionTimestampForRegion(request.getRegion().getValue().toByteArray()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            byte[] regionName = request.getRegion().getValue().toByteArray();
            TableName tableName = RegionInfo.getTable((byte[])regionName);
            if (MobUtils.isMobRegionName(tableName, regionName)) {
                this.checkHFileFormatVersionForMob();
                return this.compactMob(request, tableName);
            }
            return super.compactRegion(controller, request);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    private void checkHFileFormatVersionForMob() throws IOException {
        if (HFile.getFormatVersion(this.master.getConfiguration()) < 3) {
            LOG.error("A minimum HFile version of 3 is required for MOB compaction. Compaction will not run.");
            throw new IOException("A minimum HFile version of 3 is required for MOB feature. Consider setting hfile.format.version accordingly.");
        }
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        byte[] regionName = request.getRegion().getValue().toByteArray();
        TableName tableName = RegionInfo.getTable((byte[])regionName);
        if (MobUtils.isMobRegionName(tableName, regionName)) {
            RegionInfo mobRegionInfo = MobUtils.getMobRegionInfo(tableName);
            AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
            builder.setRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)mobRegionInfo));
            if (request.hasCompactionState() && request.getCompactionState()) {
                builder.setCompactionState(this.master.getMobCompactionState(tableName));
            }
            return builder.build();
        }
        return super.getRegionInfo(controller, request);
    }

    private AdminProtos.CompactRegionResponse compactMob(AdminProtos.CompactRegionRequest request, TableName tableName) throws IOException {
        String familyLogMsg;
        if (!this.master.getTableStateManager().isTableState(tableName, TableState.State.ENABLED)) {
            throw new DoNotRetryIOException("Table " + tableName + " is not enabled");
        }
        boolean allFiles = false;
        ArrayList<ColumnFamilyDescriptor> compactedColumns = new ArrayList<ColumnFamilyDescriptor>();
        ColumnFamilyDescriptor[] hcds = this.master.getTableDescriptors().get(tableName).getColumnFamilies();
        byte[] family = null;
        if (request.hasFamily()) {
            family = request.getFamily().toByteArray();
            for (ColumnFamilyDescriptor hcd : hcds) {
                if (!Bytes.equals((byte[])family, (byte[])hcd.getName())) continue;
                if (!hcd.isMobEnabled()) {
                    LOG.error("Column family " + hcd.getNameAsString() + " is not a mob column family");
                    throw new DoNotRetryIOException("Column family " + hcd.getNameAsString() + " is not a mob column family");
                }
                compactedColumns.add(hcd);
            }
        } else {
            for (ColumnFamilyDescriptor hcd : hcds) {
                if (!hcd.isMobEnabled()) continue;
                compactedColumns.add(hcd);
            }
        }
        if (compactedColumns.isEmpty()) {
            LOG.error("No mob column families are assigned in the mob compaction");
            throw new DoNotRetryIOException("No mob column families are assigned in the mob compaction");
        }
        if (request.hasMajor() && request.getMajor()) {
            allFiles = true;
        }
        String string = familyLogMsg = family != null ? Bytes.toString((byte[])family) : "";
        if (LOG.isTraceEnabled()) {
            LOG.trace("User-triggered mob compaction requested for table: " + tableName.getNameAsString() + " for column family: " + familyLogMsg);
        }
        this.master.requestMobCompaction(tableName, compactedColumns, allFiles);
        return AdminProtos.CompactRegionResponse.newBuilder().build();
    }

    public MasterProtos.IsBalancerEnabledResponse isBalancerEnabled(RpcController controller, MasterProtos.IsBalancerEnabledRequest request) throws ServiceException {
        MasterProtos.IsBalancerEnabledResponse.Builder response = MasterProtos.IsBalancerEnabledResponse.newBuilder();
        response.setEnabled(this.master.isBalancerOn());
        return response.build();
    }

    public MasterProtos.SetSplitOrMergeEnabledResponse setSplitOrMergeEnabled(RpcController controller, MasterProtos.SetSplitOrMergeEnabledRequest request) throws ServiceException {
        MasterProtos.SetSplitOrMergeEnabledResponse.Builder response = MasterProtos.SetSplitOrMergeEnabledResponse.newBuilder();
        try {
            this.master.checkInitialized();
            boolean newValue = request.getEnabled();
            for (MasterProtos.MasterSwitchType masterSwitchType : request.getSwitchTypesList()) {
                MasterSwitchType switchType = this.convert(masterSwitchType);
                boolean oldValue = this.master.isSplitOrMergeEnabled(switchType);
                response.addPrevValue(oldValue);
                if (this.master.cpHost != null) {
                    this.master.cpHost.preSetSplitOrMergeEnabled(newValue, switchType);
                }
                this.master.getSplitOrMergeTracker().setSplitOrMergeEnabled(newValue, switchType);
                if (this.master.cpHost == null) continue;
                this.master.cpHost.postSetSplitOrMergeEnabled(newValue, switchType);
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (KeeperException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.IsSplitOrMergeEnabledResponse isSplitOrMergeEnabled(RpcController controller, MasterProtos.IsSplitOrMergeEnabledRequest request) throws ServiceException {
        MasterProtos.IsSplitOrMergeEnabledResponse.Builder response = MasterProtos.IsSplitOrMergeEnabledResponse.newBuilder();
        response.setEnabled(this.master.isSplitOrMergeEnabled(this.convert(request.getSwitchType())));
        return response.build();
    }

    public MasterProtos.NormalizeResponse normalize(RpcController controller, MasterProtos.NormalizeRequest request) throws ServiceException {
        this.rpcPreCheck("normalize");
        try {
            return MasterProtos.NormalizeResponse.newBuilder().setNormalizerRan(this.master.normalizeRegions()).build();
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    public MasterProtos.SetNormalizerRunningResponse setNormalizerRunning(RpcController controller, MasterProtos.SetNormalizerRunningRequest request) throws ServiceException {
        this.rpcPreCheck("setNormalizerRunning");
        boolean prevValue = this.master.getRegionNormalizerTracker().isNormalizerOn();
        boolean newValue = request.getOn();
        try {
            this.master.getRegionNormalizerTracker().setNormalizerOn(newValue);
        }
        catch (KeeperException ke) {
            LOG.warn("Error flipping normalizer switch", (Throwable)ke);
        }
        LOG.info("{} set normalizerSwitch={}", (Object)this.master.getClientIdAuditPrefix(), (Object)newValue);
        return MasterProtos.SetNormalizerRunningResponse.newBuilder().setPrevNormalizerValue(prevValue).build();
    }

    public MasterProtos.IsNormalizerEnabledResponse isNormalizerEnabled(RpcController controller, MasterProtos.IsNormalizerEnabledRequest request) throws ServiceException {
        MasterProtos.IsNormalizerEnabledResponse.Builder response = MasterProtos.IsNormalizerEnabledResponse.newBuilder();
        response.setEnabled(this.master.isNormalizerOn());
        return response.build();
    }

    public MasterProtos.SecurityCapabilitiesResponse getSecurityCapabilities(RpcController controller, MasterProtos.SecurityCapabilitiesRequest request) throws ServiceException {
        MasterProtos.SecurityCapabilitiesResponse.Builder response = MasterProtos.SecurityCapabilitiesResponse.newBuilder();
        try {
            this.master.checkInitialized();
            HashSet<MasterProtos.SecurityCapabilitiesResponse.Capability> capabilities = new HashSet<MasterProtos.SecurityCapabilitiesResponse.Capability>();
            if (User.isHBaseSecurityEnabled((Configuration)this.master.getConfiguration())) {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.SECURE_AUTHENTICATION);
            } else {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.SIMPLE_AUTHENTICATION);
            }
            if (this.master.cpHost != null && this.hasAccessControlServiceCoprocessor(this.master.cpHost)) {
                if (AccessChecker.isAuthorizationSupported(this.master.getConfiguration())) {
                    capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.AUTHORIZATION);
                }
                if (AccessController.isCellAuthorizationSupported(this.master.getConfiguration())) {
                    capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.CELL_AUTHORIZATION);
                }
            }
            if (this.master.cpHost != null && this.hasVisibilityLabelsServiceCoprocessor(this.master.cpHost) && VisibilityController.isCellAuthorizationSupported(this.master.getConfiguration())) {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.CELL_VISIBILITY);
            }
            response.addAllCapabilities(capabilities);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    boolean hasAccessControlServiceCoprocessor(MasterCoprocessorHost cpHost) {
        return this.checkCoprocessorWithService(cpHost.findCoprocessors(MasterCoprocessor.class), AccessControlProtos.AccessControlService.Interface.class);
    }

    boolean hasVisibilityLabelsServiceCoprocessor(MasterCoprocessorHost cpHost) {
        return this.checkCoprocessorWithService(cpHost.findCoprocessors(MasterCoprocessor.class), VisibilityLabelsProtos.VisibilityLabelsService.Interface.class);
    }

    boolean checkCoprocessorWithService(List<MasterCoprocessor> coprocessorsToCheck, Class<?> service) {
        if (coprocessorsToCheck == null || coprocessorsToCheck.isEmpty()) {
            return false;
        }
        for (MasterCoprocessor cp : coprocessorsToCheck) {
            if (!service.isAssignableFrom(cp.getClass())) continue;
            return true;
        }
        return false;
    }

    private MasterSwitchType convert(MasterProtos.MasterSwitchType switchType) {
        switch (switchType) {
            case SPLIT: {
                return MasterSwitchType.SPLIT;
            }
            case MERGE: {
                return MasterSwitchType.MERGE;
            }
        }
        return null;
    }

    public ReplicationProtos.AddReplicationPeerResponse addReplicationPeer(RpcController controller, ReplicationProtos.AddReplicationPeerRequest request) throws ServiceException {
        try {
            this.master.addReplicationPeer(request.getPeerId(), ReplicationPeerConfigUtil.convert((ReplicationProtos.ReplicationPeer)request.getPeerConfig()), request.getPeerState().getState().equals((Object)ReplicationProtos.ReplicationState.State.ENABLED));
            return ReplicationProtos.AddReplicationPeerResponse.newBuilder().build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.RemoveReplicationPeerResponse removeReplicationPeer(RpcController controller, ReplicationProtos.RemoveReplicationPeerRequest request) throws ServiceException {
        try {
            this.master.removeReplicationPeer(request.getPeerId());
            return ReplicationProtos.RemoveReplicationPeerResponse.newBuilder().build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.EnableReplicationPeerResponse enableReplicationPeer(RpcController controller, ReplicationProtos.EnableReplicationPeerRequest request) throws ServiceException {
        try {
            this.master.enableReplicationPeer(request.getPeerId());
            return ReplicationProtos.EnableReplicationPeerResponse.newBuilder().build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.DisableReplicationPeerResponse disableReplicationPeer(RpcController controller, ReplicationProtos.DisableReplicationPeerRequest request) throws ServiceException {
        try {
            this.master.disableReplicationPeer(request.getPeerId());
            return ReplicationProtos.DisableReplicationPeerResponse.newBuilder().build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.GetReplicationPeerConfigResponse getReplicationPeerConfig(RpcController controller, ReplicationProtos.GetReplicationPeerConfigRequest request) throws ServiceException {
        ReplicationProtos.GetReplicationPeerConfigResponse.Builder response = ReplicationProtos.GetReplicationPeerConfigResponse.newBuilder();
        try {
            String peerId = request.getPeerId();
            ReplicationPeerConfig peerConfig = this.master.getReplicationPeerConfig(peerId);
            response.setPeerId(peerId);
            response.setPeerConfig(ReplicationPeerConfigUtil.convert((ReplicationPeerConfig)peerConfig));
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    public ReplicationProtos.UpdateReplicationPeerConfigResponse updateReplicationPeerConfig(RpcController controller, ReplicationProtos.UpdateReplicationPeerConfigRequest request) throws ServiceException {
        try {
            this.master.updateReplicationPeerConfig(request.getPeerId(), ReplicationPeerConfigUtil.convert((ReplicationProtos.ReplicationPeer)request.getPeerConfig()));
            return ReplicationProtos.UpdateReplicationPeerConfigResponse.newBuilder().build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.ListReplicationPeersResponse listReplicationPeers(RpcController controller, ReplicationProtos.ListReplicationPeersRequest request) throws ServiceException {
        ReplicationProtos.ListReplicationPeersResponse.Builder response = ReplicationProtos.ListReplicationPeersResponse.newBuilder();
        try {
            List<ReplicationPeerDescription> peers = this.master.listReplicationPeers(request.hasRegex() ? request.getRegex() : null);
            for (ReplicationPeerDescription peer : peers) {
                response.addPeerDesc(ReplicationPeerConfigUtil.toProtoReplicationPeerDescription((ReplicationPeerDescription)peer));
            }
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    public MasterProtos.ListDecommissionedRegionServersResponse listDecommissionedRegionServers(RpcController controller, MasterProtos.ListDecommissionedRegionServersRequest request) throws ServiceException {
        MasterProtos.ListDecommissionedRegionServersResponse.Builder response = MasterProtos.ListDecommissionedRegionServersResponse.newBuilder();
        try {
            this.master.checkInitialized();
            if (this.master.cpHost != null) {
                this.master.cpHost.preListDecommissionedRegionServers();
            }
            List<ServerName> servers = this.master.listDecommissionedRegionServers();
            response.addAllServerName((Iterable)servers.stream().map(server -> ProtobufUtil.toServerName((ServerName)server)).collect(Collectors.toList()));
            if (this.master.cpHost != null) {
                this.master.cpHost.postListDecommissionedRegionServers();
            }
        }
        catch (IOException io) {
            throw new ServiceException((Throwable)io);
        }
        return response.build();
    }

    public MasterProtos.DecommissionRegionServersResponse decommissionRegionServers(RpcController controller, MasterProtos.DecommissionRegionServersRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            List<ServerName> servers = request.getServerNameList().stream().map(pbServer -> ProtobufUtil.toServerName((HBaseProtos.ServerName)pbServer)).collect(Collectors.toList());
            boolean offload = request.getOffload();
            if (this.master.cpHost != null) {
                this.master.cpHost.preDecommissionRegionServers(servers, offload);
            }
            this.master.decommissionRegionServers(servers, offload);
            if (this.master.cpHost != null) {
                this.master.cpHost.postDecommissionRegionServers(servers, offload);
            }
        }
        catch (IOException io) {
            throw new ServiceException((Throwable)io);
        }
        return MasterProtos.DecommissionRegionServersResponse.newBuilder().build();
    }

    public MasterProtos.RecommissionRegionServerResponse recommissionRegionServer(RpcController controller, MasterProtos.RecommissionRegionServerRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            ServerName server = ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getServerName());
            List<byte[]> encodedRegionNames = request.getRegionList().stream().map(regionSpecifier -> regionSpecifier.getValue().toByteArray()).collect(Collectors.toList());
            if (this.master.cpHost != null) {
                this.master.cpHost.preRecommissionRegionServer(server, encodedRegionNames);
            }
            this.master.recommissionRegionServer(server, encodedRegionNames);
            if (this.master.cpHost != null) {
                this.master.cpHost.postRecommissionRegionServer(server, encodedRegionNames);
            }
        }
        catch (IOException io) {
            throw new ServiceException((Throwable)io);
        }
        return MasterProtos.RecommissionRegionServerResponse.newBuilder().build();
    }

    public LockServiceProtos.LockResponse requestLock(RpcController controller, final LockServiceProtos.LockRequest request) throws ServiceException {
        try {
            MasterProcedureUtil.NonceProcedureRunnable npr;
            if (request.getDescription().isEmpty()) {
                throw new IllegalArgumentException("Empty description");
            }
            final LockType type = LockType.valueOf((String)request.getLockType().name());
            if (request.getRegionInfoCount() > 0) {
                final RegionInfo[] regionInfos = new RegionInfo[request.getRegionInfoCount()];
                for (int i = 0; i < request.getRegionInfoCount(); ++i) {
                    regionInfos[i] = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)request.getRegionInfo(i));
                }
                npr = new MasterProcedureUtil.NonceProcedureRunnable(this.master, request.getNonceGroup(), request.getNonce()){

                    @Override
                    protected void run() throws IOException {
                        this.setProcId(MasterRpcServices.this.master.getLockManager().remoteLocks().requestRegionsLock(regionInfos, request.getDescription(), this.getNonceKey()));
                    }

                    @Override
                    protected String getDescription() {
                        return "RequestLock";
                    }
                };
            } else if (request.hasTableName()) {
                final TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName());
                npr = new MasterProcedureUtil.NonceProcedureRunnable(this.master, request.getNonceGroup(), request.getNonce()){

                    @Override
                    protected void run() throws IOException {
                        this.setProcId(MasterRpcServices.this.master.getLockManager().remoteLocks().requestTableLock(tableName, type, request.getDescription(), this.getNonceKey()));
                    }

                    @Override
                    protected String getDescription() {
                        return "RequestLock";
                    }
                };
            } else if (request.hasNamespace()) {
                npr = new MasterProcedureUtil.NonceProcedureRunnable(this.master, request.getNonceGroup(), request.getNonce()){

                    @Override
                    protected void run() throws IOException {
                        this.setProcId(MasterRpcServices.this.master.getLockManager().remoteLocks().requestNamespaceLock(request.getNamespace(), type, request.getDescription(), this.getNonceKey()));
                    }

                    @Override
                    protected String getDescription() {
                        return "RequestLock";
                    }
                };
            } else {
                throw new IllegalArgumentException("one of table/namespace/region should be specified");
            }
            long procId = MasterProcedureUtil.submitProcedure(npr);
            return LockServiceProtos.LockResponse.newBuilder().setProcId(procId).build();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Exception when queuing lock", (Throwable)e);
            throw new ServiceException((Throwable)new DoNotRetryIOException((Throwable)e));
        }
        catch (IOException e) {
            LOG.warn("Exception when queuing lock", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public LockServiceProtos.LockHeartbeatResponse lockHeartbeat(RpcController controller, LockServiceProtos.LockHeartbeatRequest request) throws ServiceException {
        try {
            if (this.master.getLockManager().remoteLocks().lockHeartbeat(request.getProcId(), request.getKeepAlive())) {
                return LockServiceProtos.LockHeartbeatResponse.newBuilder().setTimeoutMs(this.master.getConfiguration().getInt("hbase.master.procedure.remote.locks.timeout.ms", 30000)).setLockStatus(LockServiceProtos.LockHeartbeatResponse.LockStatus.LOCKED).build();
            }
            return LockServiceProtos.LockHeartbeatResponse.newBuilder().setLockStatus(LockServiceProtos.LockHeartbeatResponse.LockStatus.UNLOCKED).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public RegionServerStatusProtos.RegionSpaceUseReportResponse reportRegionSpaceUse(RpcController controller, RegionServerStatusProtos.RegionSpaceUseReportRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            if (!QuotaUtil.isQuotaEnabled(this.master.getConfiguration())) {
                return RegionServerStatusProtos.RegionSpaceUseReportResponse.newBuilder().build();
            }
            MasterQuotaManager quotaManager = this.master.getMasterQuotaManager();
            long now = EnvironmentEdgeManager.currentTime();
            for (RegionServerStatusProtos.RegionSpaceUse report : request.getSpaceUseList()) {
                quotaManager.addRegionSize(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)report.getRegionInfo()), report.getRegionSize(), now);
            }
            return RegionServerStatusProtos.RegionSpaceUseReportResponse.newBuilder().build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public QuotaProtos.GetSpaceQuotaRegionSizesResponse getSpaceQuotaRegionSizes(RpcController controller, QuotaProtos.GetSpaceQuotaRegionSizesRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            MasterQuotaManager quotaManager = this.master.getMasterQuotaManager();
            QuotaProtos.GetSpaceQuotaRegionSizesResponse.Builder builder = QuotaProtos.GetSpaceQuotaRegionSizesResponse.newBuilder();
            if (quotaManager != null) {
                Map<RegionInfo, Long> regionSizes = quotaManager.snapshotRegionSizes();
                HashMap<TableName, Long> regionSizesByTable = new HashMap<TableName, Long>();
                for (Map.Entry<RegionInfo, Long> entry : regionSizes.entrySet()) {
                    TableName tableName = entry.getKey().getTable();
                    Long prevSize = (Long)regionSizesByTable.get(tableName);
                    if (prevSize == null) {
                        prevSize = 0L;
                    }
                    regionSizesByTable.put(tableName, prevSize + entry.getValue());
                }
                for (Map.Entry<Object, Long> entry : regionSizesByTable.entrySet()) {
                    builder.addSizes(QuotaProtos.GetSpaceQuotaRegionSizesResponse.RegionSizes.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)((TableName)entry.getKey()))).setSize(entry.getValue().longValue()).build());
                }
                return builder.build();
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public QuotaProtos.GetQuotaStatesResponse getQuotaStates(RpcController controller, QuotaProtos.GetQuotaStatesRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            QuotaObserverChore quotaChore = this.master.getQuotaObserverChore();
            QuotaProtos.GetQuotaStatesResponse.Builder builder = QuotaProtos.GetQuotaStatesResponse.newBuilder();
            if (quotaChore != null) {
                Map<TableName, SpaceQuotaSnapshot> tableSnapshots = quotaChore.getTableQuotaSnapshots();
                for (Map.Entry<TableName, SpaceQuotaSnapshot> entry : tableSnapshots.entrySet()) {
                    builder.addTableSnapshots(QuotaProtos.GetQuotaStatesResponse.TableQuotaSnapshot.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)entry.getKey())).setSnapshot(SpaceQuotaSnapshot.toProtoSnapshot((SpaceQuotaSnapshot)entry.getValue())).build());
                }
                Map<String, SpaceQuotaSnapshot> nsSnapshots = quotaChore.getNamespaceQuotaSnapshots();
                for (Map.Entry<String, SpaceQuotaSnapshot> entry : nsSnapshots.entrySet()) {
                    builder.addNsSnapshots(QuotaProtos.GetQuotaStatesResponse.NamespaceQuotaSnapshot.newBuilder().setNamespace(entry.getKey()).setSnapshot(SpaceQuotaSnapshot.toProtoSnapshot((SpaceQuotaSnapshot)entry.getValue())).build());
                }
                return builder.build();
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ClearDeadServersResponse clearDeadServers(RpcController controller, MasterProtos.ClearDeadServersRequest request) throws ServiceException {
        LOG.debug(this.master.getClientIdAuditPrefix() + " clear dead region servers.");
        MasterProtos.ClearDeadServersResponse.Builder response = MasterProtos.ClearDeadServersResponse.newBuilder();
        try {
            this.master.checkInitialized();
            if (this.master.cpHost != null) {
                this.master.cpHost.preClearDeadServers();
            }
            if (this.master.getServerManager().areDeadServersInProgress()) {
                LOG.debug("Some dead server is still under processing, won't clear the dead server list");
                response.addAllServerName((Iterable)request.getServerNameList());
            } else {
                for (HBaseProtos.ServerName pbServer : request.getServerNameList()) {
                    if (this.master.getServerManager().getDeadServers().removeDeadServer(ProtobufUtil.toServerName((HBaseProtos.ServerName)pbServer))) continue;
                    response.addServerName(pbServer);
                }
            }
            if (this.master.cpHost != null) {
                this.master.cpHost.postClearDeadServers(ProtobufUtil.toServerNameList((List)request.getServerNameList()), ProtobufUtil.toServerNameList((List)response.getServerNameList()));
            }
        }
        catch (IOException io) {
            throw new ServiceException((Throwable)io);
        }
        return response.build();
    }

    static enum BalanceSwitchMode {
        SYNC,
        ASYNC;

    }
}

