/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OpenRegionHandler
extends EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OpenRegionHandler.class);
    protected final RegionServerServices rsServices;
    private final RegionInfo regionInfo;
    private final TableDescriptor htd;
    private final long masterSystemTime;

    public OpenRegionHandler(Server server, RegionServerServices rsServices, RegionInfo regionInfo, TableDescriptor htd, long masterSystemTime) {
        this(server, rsServices, regionInfo, htd, masterSystemTime, EventType.M_RS_OPEN_REGION);
    }

    protected OpenRegionHandler(Server server, RegionServerServices rsServices, RegionInfo regionInfo, TableDescriptor htd, long masterSystemTime, EventType eventType) {
        super(server, eventType);
        this.rsServices = rsServices;
        this.regionInfo = regionInfo;
        this.htd = htd;
        this.masterSystemTime = masterSystemTime;
    }

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws IOException {
        HRegion region;
        String regionName;
        boolean openSuccessful;
        block53: {
            block51: {
                block52: {
                    block49: {
                        block50: {
                            block47: {
                                block48: {
                                    block45: {
                                        block46: {
                                            String encodedName;
                                            block43: {
                                                block44: {
                                                    block41: {
                                                        block42: {
                                                            openSuccessful = false;
                                                            regionName = this.regionInfo.getRegionNameAsString();
                                                            region = null;
                                                            try {
                                                                if (!this.server.isStopped() && !this.rsServices.isStopping()) break block41;
                                                                if (openSuccessful) break block42;
                                                            }
                                                            catch (Throwable throwable) {
                                                                if (!openSuccessful) {
                                                                    this.doCleanUpOnFailedOpen(region);
                                                                }
                                                                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                                if (openSuccessful) {
                                                                    if (current == null) {
                                                                        LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                                                    } else if (Boolean.FALSE.equals(current)) {
                                                                        LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that should be closed is now opened. Closing it now");
                                                                        this.cleanupFailedOpen(region);
                                                                    }
                                                                }
                                                                throw throwable;
                                                            }
                                                            this.doCleanUpOnFailedOpen(region);
                                                        }
                                                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                        if (openSuccessful) {
                                                            if (current == null) {
                                                                LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                                            } else if (Boolean.FALSE.equals(current)) {
                                                                LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that should be closed is now opened. Closing it now");
                                                                this.cleanupFailedOpen(region);
                                                            }
                                                        }
                                                        return;
                                                    }
                                                    encodedName = this.regionInfo.getEncodedName();
                                                    if (this.rsServices.getRegion(encodedName) == null) break block43;
                                                    LOG.error("Region " + encodedName + " was already online when we started processing the opening. Marking this new attempt as failed");
                                                    if (openSuccessful) break block44;
                                                    this.doCleanUpOnFailedOpen(region);
                                                }
                                                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                if (openSuccessful) {
                                                    if (current == null) {
                                                        LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                                    } else if (Boolean.FALSE.equals(current)) {
                                                        LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that should be closed is now opened. Closing it now");
                                                        this.cleanupFailedOpen(region);
                                                    }
                                                }
                                                return;
                                            }
                                            if (this.isRegionStillOpening()) break block45;
                                            LOG.error("Region " + encodedName + " opening cancelled");
                                            if (openSuccessful) break block46;
                                            this.doCleanUpOnFailedOpen(region);
                                        }
                                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                        if (openSuccessful) {
                                            if (current == null) {
                                                LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                            } else if (Boolean.FALSE.equals(current)) {
                                                LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that should be closed is now opened. Closing it now");
                                                this.cleanupFailedOpen(region);
                                            }
                                        }
                                        return;
                                    }
                                    region = this.openRegion();
                                    if (region != null) break block47;
                                    if (openSuccessful) break block48;
                                    this.doCleanUpOnFailedOpen(region);
                                }
                                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                if (openSuccessful) {
                                    if (current == null) {
                                        LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                    } else if (Boolean.FALSE.equals(current)) {
                                        LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that should be closed is now opened. Closing it now");
                                        this.cleanupFailedOpen(region);
                                    }
                                }
                                return;
                            }
                            if (this.updateMeta(region, this.masterSystemTime) && !this.server.isStopped() && !this.rsServices.isStopping()) break block49;
                            if (openSuccessful) break block50;
                            this.doCleanUpOnFailedOpen(region);
                        }
                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                        if (openSuccessful) {
                            if (current == null) {
                                LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                            } else if (Boolean.FALSE.equals(current)) {
                                LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that should be closed is now opened. Closing it now");
                                this.cleanupFailedOpen(region);
                            }
                        }
                        return;
                    }
                    if (this.isRegionStillOpening()) break block51;
                    if (openSuccessful) break block52;
                    this.doCleanUpOnFailedOpen(region);
                }
                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                if (openSuccessful) {
                    if (current == null) {
                        LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                    } else if (Boolean.FALSE.equals(current)) {
                        LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that should be closed is now opened. Closing it now");
                        this.cleanupFailedOpen(region);
                    }
                }
                return;
            }
            this.rsServices.addRegion(region);
            openSuccessful = true;
            LOG.debug("Opened " + regionName + " on " + this.server.getServerName());
            if (openSuccessful) break block53;
            this.doCleanUpOnFailedOpen(region);
        }
        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
        if (openSuccessful) {
            if (current == null) {
                LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
            } else if (Boolean.FALSE.equals(current)) {
                LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that should be closed is now opened. Closing it now");
                this.cleanupFailedOpen(region);
            }
        }
    }

    private void doCleanUpOnFailedOpen(HRegion region) throws IOException {
        try {
            if (region != null) {
                this.cleanupFailedOpen(region);
            }
        }
        catch (Throwable throwable) {
            this.rsServices.reportRegionStateTransition(new RegionServerServices.RegionStateTransitionContext(RegionServerStatusProtos.RegionStateTransition.TransitionCode.FAILED_OPEN, -1L, -1L, this.regionInfo));
            throw throwable;
        }
        this.rsServices.reportRegionStateTransition(new RegionServerServices.RegionStateTransitionContext(RegionServerStatusProtos.RegionStateTransition.TransitionCode.FAILED_OPEN, -1L, -1L, this.regionInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateMeta(HRegion r, long masterSystemTime) {
        if (this.server.isStopped() || this.rsServices.isStopping()) {
            return false;
        }
        AtomicBoolean signaller = new AtomicBoolean(false);
        PostOpenDeployTasksThread t = new PostOpenDeployTasksThread(r, this.server, this.rsServices, signaller, masterSystemTime);
        t.start();
        while (!signaller.get() && t.isAlive() && !this.server.isStopped() && !this.rsServices.isStopping() && this.isRegionStillOpening()) {
            AtomicBoolean atomicBoolean = signaller;
            synchronized (atomicBoolean) {
                try {
                    if (!signaller.get()) {
                        signaller.wait(10000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (t.isAlive()) {
            if (!signaller.get()) {
                LOG.debug("Interrupting thread " + t);
                t.interrupt();
            }
            try {
                t.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted joining " + r.getRegionInfo().getRegionNameAsString(), (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
        return !Thread.interrupted() && t.getException() == null;
    }

    HRegion openRegion() {
        HRegion region;
        block2: {
            region = null;
            try {
                region = HRegion.openHRegion(this.regionInfo, this.htd, this.rsServices.getWAL(this.regionInfo), this.server.getConfiguration(), this.rsServices, new CancelableProgressable(){

                    @Override
                    public boolean progress() {
                        if (!OpenRegionHandler.this.isRegionStillOpening()) {
                            LOG.warn("Open region aborted since it isn't opening any more");
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (Throwable t) {
                RegionServerAccounting rsAccounting;
                LOG.error("Failed open of region=" + this.regionInfo.getRegionNameAsString() + ", starting to roll back the global memstore size.", t);
                if (this.rsServices == null || (rsAccounting = this.rsServices.getRegionServerAccounting()) == null) break block2;
                rsAccounting.rollbackRegionReplayEditsSize(this.regionInfo.getRegionName());
            }
        }
        return region;
    }

    void cleanupFailedOpen(HRegion region) throws IOException {
        if (region != null) {
            this.rsServices.removeRegion(region, null);
            region.close();
        }
    }

    private static boolean isRegionStillOpening(RegionInfo regionInfo, RegionServerServices rsServices) {
        byte[] encodedName = regionInfo.getEncodedNameAsBytes();
        Boolean action = (Boolean)rsServices.getRegionsInTransitionInRS().get(encodedName);
        return Boolean.TRUE.equals(action);
    }

    private boolean isRegionStillOpening() {
        return OpenRegionHandler.isRegionStillOpening(this.regionInfo, this.rsServices);
    }

    static class PostOpenDeployTasksThread
    extends Thread {
        private Throwable exception = null;
        private final Server server;
        private final RegionServerServices services;
        private final HRegion region;
        private final AtomicBoolean signaller;
        private final long masterSystemTime;

        PostOpenDeployTasksThread(HRegion region, Server server, RegionServerServices services, AtomicBoolean signaller, long masterSystemTime) {
            super("PostOpenDeployTasks:" + region.getRegionInfo().getEncodedName());
            this.setDaemon(true);
            this.server = server;
            this.services = services;
            this.region = region;
            this.signaller = signaller;
            this.masterSystemTime = masterSystemTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.services.postOpenDeployTasks(new RegionServerServices.PostOpenDeployContext(this.region, this.masterSystemTime));
            }
            catch (Throwable e) {
                String msg = "Exception running postOpenDeployTasks; region=" + this.region.getRegionInfo().getEncodedName();
                this.exception = e;
                if (e instanceof IOException && OpenRegionHandler.isRegionStillOpening(this.region.getRegionInfo(), this.services)) {
                    this.server.abort(msg, e);
                }
                LOG.warn(msg, e);
            }
            this.signaller.set(true);
            AtomicBoolean atomicBoolean = this.signaller;
            synchronized (atomicBoolean) {
                this.signaller.notify();
            }
        }

        Throwable getException() {
            return this.exception;
        }
    }
}

