/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.BaseReplicationEndpoint;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class HBaseReplicationEndpoint
extends BaseReplicationEndpoint
implements Abortable {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseReplicationEndpoint.class);
    private ZKWatcher zkw = null;
    private List<ServerName> regionServers = new ArrayList<ServerName>(0);
    private long lastRegionServerUpdate;

    protected synchronized void disconnect() {
        if (this.zkw != null) {
            this.zkw.close();
        }
    }

    protected void reconnect(KeeperException ke) {
        if (ke instanceof KeeperException.ConnectionLossException || ke instanceof KeeperException.SessionExpiredException || ke instanceof KeeperException.AuthFailedException) {
            String clusterKey = this.ctx.getPeerConfig().getClusterKey();
            LOG.warn("Lost the ZooKeeper connection for peer " + clusterKey, (Throwable)ke);
            try {
                this.reloadZkWatcher();
            }
            catch (IOException io) {
                LOG.warn("Creation of ZookeeperWatcher failed for peer " + clusterKey, (Throwable)io);
            }
        }
    }

    @Override
    public void start() {
        this.startAsync();
    }

    @Override
    public void stop() {
        this.stopAsync();
    }

    protected void doStart() {
        try {
            this.reloadZkWatcher();
            this.notifyStarted();
        }
        catch (IOException e) {
            this.notifyFailed(e);
        }
    }

    protected void doStop() {
        this.disconnect();
        this.notifyStopped();
    }

    @Override
    public synchronized UUID getPeerUUID() {
        UUID peerUUID = null;
        try {
            peerUUID = ZKClusterId.getUUIDForCluster((ZKWatcher)this.zkw);
        }
        catch (KeeperException ke) {
            this.reconnect(ke);
        }
        return peerUUID;
    }

    protected synchronized ZKWatcher getZkw() {
        return this.zkw;
    }

    synchronized void reloadZkWatcher() throws IOException {
        if (this.zkw != null) {
            this.zkw.close();
        }
        this.zkw = new ZKWatcher(this.ctx.getConfiguration(), "connection to cluster: " + this.ctx.getPeerId(), (Abortable)this);
        this.getZkw().registerListener((ZKListener)new PeerRegionServerListener(this));
    }

    public void abort(String why, Throwable e) {
        LOG.error("The HBaseReplicationEndpoint corresponding to peer " + this.ctx.getPeerId() + " was aborted for the following reason(s):" + why, e);
    }

    public boolean isAborted() {
        return false;
    }

    protected static List<ServerName> fetchSlavesAddresses(ZKWatcher zkw) throws KeeperException {
        List children = ZKUtil.listChildrenAndWatchForNewChildren((ZKWatcher)zkw, (String)zkw.znodePaths.rsZNode);
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<ServerName> addresses = new ArrayList<ServerName>(children.size());
        for (String child : children) {
            addresses.add(ServerName.parseServerName((String)child));
        }
        return addresses;
    }

    public synchronized List<ServerName> getRegionServers() {
        try {
            this.setRegionServers(HBaseReplicationEndpoint.fetchSlavesAddresses(this.getZkw()));
        }
        catch (KeeperException ke) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetch slaves addresses failed", (Throwable)ke);
            }
            this.reconnect(ke);
        }
        return this.regionServers;
    }

    public synchronized void setRegionServers(List<ServerName> regionServers) {
        this.regionServers = regionServers;
        this.lastRegionServerUpdate = System.currentTimeMillis();
    }

    public long getLastRegionServerUpdate() {
        return this.lastRegionServerUpdate;
    }

    public static class PeerRegionServerListener
    extends ZKListener {
        private final HBaseReplicationEndpoint replicationEndpoint;
        private final String regionServerListNode;

        public PeerRegionServerListener(HBaseReplicationEndpoint replicationPeer) {
            super(replicationPeer.getZkw());
            this.replicationEndpoint = replicationPeer;
            this.regionServerListNode = this.replicationEndpoint.getZkw().znodePaths.rsZNode;
        }

        public synchronized void nodeChildrenChanged(String path) {
            if (path.equals(this.regionServerListNode)) {
                try {
                    LOG.info("Detected change to peer region servers, fetching updated list");
                    this.replicationEndpoint.setRegionServers(HBaseReplicationEndpoint.fetchSlavesAddresses(this.replicationEndpoint.getZkw()));
                }
                catch (KeeperException e) {
                    LOG.error("Error reading slave addresses", (Throwable)e);
                }
            }
        }
    }
}

