/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.BulkLoadCellFilter;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.WALCellFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.base.Predicate;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NamespaceTableCfWALEntryFilter
implements WALEntryFilter,
WALCellFilter {
    private static final Logger LOG = LoggerFactory.getLogger(NamespaceTableCfWALEntryFilter.class);
    private final ReplicationPeer peer;
    private BulkLoadCellFilter bulkLoadFilter = new BulkLoadCellFilter();

    public NamespaceTableCfWALEntryFilter(ReplicationPeer peer) {
        this.peer = peer;
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        TableName tabName = entry.getKey().getTableName();
        String namespace = tabName.getNamespaceAsString();
        ReplicationPeerConfig peerConfig = this.peer.getPeerConfig();
        if (peerConfig.replicateAllUserTables()) {
            Set excludeNamespaces = peerConfig.getExcludeNamespaces();
            if (excludeNamespaces != null && excludeNamespaces.contains(namespace)) {
                return null;
            }
            return entry;
        }
        Set namespaces = peerConfig.getNamespaces();
        Map tableCFs = peerConfig.getTableCFsMap();
        if (namespaces == null && tableCFs == null) {
            return null;
        }
        if (namespaces != null && namespaces.contains(namespace)) {
            return entry;
        }
        if (tableCFs == null || !tableCFs.containsKey(tabName)) {
            return null;
        }
        return entry;
    }

    @Override
    public Cell filterCell(WAL.Entry entry, Cell cell) {
        ReplicationPeerConfig peerConfig = this.peer.getPeerConfig();
        if (peerConfig.replicateAllUserTables()) {
            Map excludeTableCfs = peerConfig.getExcludeTableCFsMap();
            if (excludeTableCfs == null) {
                return cell;
            }
            if (CellUtil.matchingColumn((Cell)cell, (byte[])WALEdit.METAFAMILY, (byte[])WALEdit.BULK_LOAD)) {
                cell = this.bulkLoadFilter.filterCell(cell, (Predicate<byte[]>)((Predicate)fam -> this.filterByExcludeTableCfs(entry.getKey().getTableName(), Bytes.toString((byte[])fam), excludeTableCfs)));
            } else if (this.filterByExcludeTableCfs(entry.getKey().getTableName(), Bytes.toString((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()), excludeTableCfs)) {
                return null;
            }
            return cell;
        }
        Map tableCfs = peerConfig.getTableCFsMap();
        if (tableCfs == null) {
            return cell;
        }
        if (CellUtil.matchingColumn((Cell)cell, (byte[])WALEdit.METAFAMILY, (byte[])WALEdit.BULK_LOAD)) {
            cell = this.bulkLoadFilter.filterCell(cell, (Predicate<byte[]>)((Predicate)fam -> this.filterByTableCfs(entry.getKey().getTableName(), Bytes.toString((byte[])fam), tableCfs)));
        } else if (this.filterByTableCfs(entry.getKey().getTableName(), Bytes.toString((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()), tableCfs)) {
            return null;
        }
        return cell;
    }

    private boolean filterByExcludeTableCfs(TableName tableName, String family, Map<TableName, List<String>> excludeTableCfs) {
        List<String> excludeCfs = excludeTableCfs.get(tableName);
        if (excludeCfs != null) {
            if (excludeCfs.isEmpty()) {
                return true;
            }
            if (excludeCfs.contains(family)) {
                return true;
            }
        }
        return false;
    }

    private boolean filterByTableCfs(TableName tableName, String family, Map<TableName, List<String>> tableCfs) {
        List<String> cfs = tableCfs.get(tableName);
        return cfs != null && !cfs.contains(family);
    }
}

