/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncQuotaAdminApi
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncQuotaAdminApi.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 2000);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @Test
    public void testThrottleType() throws Exception {
        String userName = User.getCurrent().getShortName();
        this.admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES)).get();
        this.admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.WRITE_NUMBER, (long)12L, (TimeUnit)TimeUnit.MINUTES)).get();
        this.admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)true)).get();
        int countThrottle = 0;
        int countGlobalBypass = 0;
        block4: for (QuotaSettings settings : (List)this.admin.getQuota(null).get()) {
            switch (settings.getQuotaType()) {
                case THROTTLE: {
                    ++countThrottle;
                    continue block4;
                }
                case GLOBAL_BYPASS: {
                    ++countGlobalBypass;
                    continue block4;
                }
            }
            Assert.fail((String)("unexpected settings type: " + settings.getQuotaType()));
        }
        Assert.assertEquals((long)2L, (long)countThrottle);
        Assert.assertEquals((long)1L, (long)countGlobalBypass);
        this.admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName)).get();
        this.assertNumResults(1, null);
        this.admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)false)).get();
        this.assertNumResults(0, null);
    }

    @Test
    public void testQuotaRetrieverFilter() throws Exception {
        String[] users;
        TableName[] tables = new TableName[]{TableName.valueOf((String)"T0"), TableName.valueOf((String)"T01"), TableName.valueOf((String)"NS0:T2")};
        String[] namespaces = new String[]{"NS0", "NS01", "NS2"};
        for (String string : users = new String[]{"User0", "User01", "User2"}) {
            this.admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)1L, (TimeUnit)TimeUnit.MINUTES)).get();
            for (TableName tableName : tables) {
                this.admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (TableName)tableName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)2L, (TimeUnit)TimeUnit.MINUTES)).get();
            }
            for (String string2 : namespaces) {
                this.admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (String)string2, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)3L, (TimeUnit)TimeUnit.MINUTES)).get();
            }
        }
        this.assertNumResults(21, null);
        for (String string : tables) {
            this.admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)4L, (TimeUnit)TimeUnit.MINUTES)).get();
        }
        this.assertNumResults(24, null);
        for (String string : namespaces) {
            this.admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)5L, (TimeUnit)TimeUnit.MINUTES)).get();
        }
        this.assertNumResults(27, null);
        this.assertNumResults(7, new QuotaFilter().setUserFilter("User0"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User"));
        this.assertNumResults(21, new QuotaFilter().setUserFilter("User.*"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setTableFilter("T0"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setTableFilter("NS.*"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User.*").setTableFilter("T"));
        this.assertNumResults(6, new QuotaFilter().setUserFilter("User.*").setTableFilter("T.*"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS0"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS"));
        this.assertNumResults(9, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS.*"));
        this.assertNumResults(6, new QuotaFilter().setUserFilter("User.*").setTableFilter("T0").setNamespaceFilter("NS0"));
        this.assertNumResults(1, new QuotaFilter().setTableFilter("T0"));
        this.assertNumResults(0, new QuotaFilter().setTableFilter("T"));
        this.assertNumResults(2, new QuotaFilter().setTableFilter("T.*"));
        this.assertNumResults(3, new QuotaFilter().setTableFilter(".*T.*"));
        this.assertNumResults(1, new QuotaFilter().setNamespaceFilter("NS0"));
        this.assertNumResults(0, new QuotaFilter().setNamespaceFilter("NS"));
        this.assertNumResults(3, new QuotaFilter().setNamespaceFilter("NS.*"));
        for (String string : users) {
            this.admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string)).get();
            for (TableName tableName : tables) {
                this.admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string, (TableName)tableName)).get();
            }
            for (String string3 : namespaces) {
                this.admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string, (String)string3)).get();
            }
        }
        this.assertNumResults(6, null);
        for (String string : tables) {
            this.admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)string)).get();
        }
        this.assertNumResults(3, null);
        for (String string : namespaces) {
            this.admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)string)).get();
        }
        this.assertNumResults(0, null);
    }

    private void assertNumResults(int expected, QuotaFilter filter) throws Exception {
        Assert.assertEquals((long)expected, (long)this.countResults(filter));
    }

    private int countResults(QuotaFilter filter) throws Exception {
        int count = 0;
        for (QuotaSettings settings : (List)this.admin.getQuota(filter).get()) {
            LOG.debug(Objects.toString(settings));
            ++count;
        }
        return count;
    }
}

