/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ClientAsyncPrefetchScanner;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestScannersFromClientSide {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScannersFromClientSide.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestScannersFromClientSide.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE = Bytes.toBytes((String)"testValue");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.client.scanner.max.result.size", 0xA00000L);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testScanBatch() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, 8);
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        boolean toLog = true;
        Put put = new Put(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            KeyValue kv = new KeyValue(ROW, FAMILY, QUALIFIERS[i], (long)i, VALUE);
            put.add((Cell)kv);
        }
        ht.put(put);
        put = new Put(ROW);
        KeyValue kv = new KeyValue(ROW, FAMILY, QUALIFIERS[6], 2L, VALUE);
        put.add((Cell)kv);
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.addFamily(FAMILY, 3L);
        ht.delete(delete);
        Scan scan = new Scan().withStartRow(ROW);
        scan.setMaxVersions();
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Object> kvListExp = new ArrayList<Cell>();
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[4], 4L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[5], 5L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[6], 6L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[7], 7L, VALUE));
        Result result = scanner.next();
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing first batch of scan");
        scan = new Scan().withStartRow(ROW);
        scan.setMaxVersions();
        scan.setBatch(2);
        scanner = ht.getScanner(scan);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILY, QUALIFIERS[4], 4L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[5], 5L, VALUE));
        result = scanner.next();
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing first batch of scan");
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILY, QUALIFIERS[6], 6L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[7], 7L, VALUE));
        result = scanner.next();
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing second batch of scan");
    }

    @Test
    public void testMaxResultSizeIsSetToDefault() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        long expectedMaxResultSize = TEST_UTIL.getConfiguration().getLong("hbase.client.scanner.max.result.size", 0x200000L);
        int numRows = 5;
        byte[][] ROWS = HTestConst.makeNAscii(ROW, numRows);
        int numQualifiers = 10;
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, numQualifiers);
        int cellSize = (int)(expectedMaxResultSize / (long)(numQualifiers - 1));
        byte[] cellValue = Bytes.createMaxByteArray((int)cellSize);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int row = 0; row < ROWS.length; ++row) {
            Put put = new Put(ROWS[row]);
            for (int qual = 0; qual < QUALIFIERS.length; ++qual) {
                KeyValue kv = new KeyValue(ROWS[row], FAMILY, QUALIFIERS[qual], cellValue);
                put.add((Cell)kv);
            }
            puts.add(put);
        }
        ht.put(puts);
        Scan scan = new Scan();
        ResultScanner scanner = ht.getScanner(scan);
        Assert.assertTrue((boolean)(scanner instanceof ClientScanner));
        ClientScanner clientScanner = (ClientScanner)scanner;
        scanner.next();
        Assert.assertTrue((String)("The cache contains: " + clientScanner.getCacheSize() + " results"), (clientScanner.getCacheSize() <= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testScannerForNotExistingTable() {
        String[] tableNames;
        for (String tableName : tableNames = new String[]{"A", "Z", "A:A", "Z:Z"}) {
            try {
                Table table = TEST_UTIL.getConnection().getTable(TableName.valueOf((String)tableName));
                this.testSmallScan(table, true, 1, 5);
                Assert.fail((String)"TableNotFoundException was not thrown");
            }
            catch (TableNotFoundException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)tableName);
            }
            catch (Exception e) {
                Assert.fail((String)("Unexpected exception " + e.getMessage()));
            }
        }
    }

    @Test
    public void testSmallScan() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        int numRows = 10;
        byte[][] ROWS = HTestConst.makeNAscii(ROW, numRows);
        int numQualifiers = 10;
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, numQualifiers);
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int row = 0; row < ROWS.length; ++row) {
            Put put = new Put(ROWS[row]);
            for (int qual = 0; qual < QUALIFIERS.length; ++qual) {
                KeyValue kv = new KeyValue(ROWS[row], FAMILY, QUALIFIERS[qual], VALUE);
                put.add((Cell)kv);
            }
            puts.add(put);
        }
        ht.put(puts);
        int expectedRows = numRows;
        int expectedCols = numRows * numQualifiers;
        this.testSmallScan(ht, true, expectedRows, expectedCols);
        this.testSmallScan(ht, false, expectedRows, expectedCols);
    }

    private void testSmallScan(Table table, boolean reversed, int rows, int columns) throws Exception {
        Scan baseScan = new Scan();
        baseScan.setReversed(reversed);
        baseScan.setSmall(true);
        Scan scan = new Scan(baseScan);
        this.verifyExpectedCounts(table, scan, rows, columns);
        scan = new Scan(baseScan);
        scan.setMaxResultSize(1L);
        this.verifyExpectedCounts(table, scan, rows, columns);
        scan = new Scan(baseScan);
        scan.setMaxResultSize(1L);
        scan.setCaching(Integer.MAX_VALUE);
        this.verifyExpectedCounts(table, scan, rows, columns);
    }

    private void verifyExpectedCounts(Table table, Scan scan, int expectedRowCount, int expectedCellCount) throws Exception {
        ResultScanner scanner = table.getScanner(scan);
        int rowCount = 0;
        int cellCount = 0;
        Result r = null;
        while ((r = scanner.next()) != null) {
            ++rowCount;
            cellCount += r.rawCells().length;
        }
        Assert.assertTrue((String)("Expected row count: " + expectedRowCount + " Actual row count: " + rowCount), (expectedRowCount == rowCount ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected cell count: " + expectedCellCount + " Actual cell count: " + cellCount), (expectedCellCount == cellCount ? 1 : 0) != 0);
        scanner.close();
    }

    @Test
    public void testGetMaxResults() throws Exception {
        KeyValue kv;
        int i;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, 3);
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, 20);
        Table ht = TEST_UTIL.createTable(tableName, FAMILIES);
        boolean toLog = true;
        ArrayList<Object> kvListExp = new ArrayList<Cell>();
        Put put = new Put(ROW);
        for (i = 0; i < 10; ++i) {
            kv = new KeyValue(ROW, FAMILIES[0], QUALIFIERS[i], 1L, VALUE);
            put.add((Cell)kv);
            kvListExp.add((Cell)kv);
        }
        ht.put(put);
        Get get = new Get(ROW);
        Result result = ht.get(get);
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing without setting maxResults");
        get = new Get(ROW);
        get.setMaxResultsPerColumnFamily(2);
        result = ht.get(get);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[0], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[1], 1L, VALUE));
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing basic setMaxResults");
        get = new Get(ROW);
        get.setMaxResultsPerColumnFamily(5);
        get.setFilter((Filter)new ColumnRangeFilter(QUALIFIERS[2], true, QUALIFIERS[5], true));
        result = ht.get(get);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[2], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[3], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[4], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[5], 1L, VALUE));
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing single CF with CRF");
        put = new Put(ROW);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            kv = new KeyValue(ROW, FAMILIES[2], QUALIFIERS[i], 1L, VALUE);
            put.add((Cell)kv);
        }
        ht.put(put);
        put = new Put(ROW);
        for (i = 0; i < 10; ++i) {
            kv = new KeyValue(ROW, FAMILIES[1], QUALIFIERS[i], 1L, VALUE);
            put.add((Cell)kv);
        }
        ht.put(put);
        get = new Get(ROW);
        get.setMaxResultsPerColumnFamily(12);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        result = ht.get(get);
        kvListExp = new ArrayList();
        for (i = 0; i < 10; ++i) {
            kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[1], QUALIFIERS[i], 1L, VALUE));
        }
        for (i = 0; i < 2; ++i) {
            kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[i], 1L, VALUE));
        }
        for (i = 10; i < 20; ++i) {
            kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[i], 1L, VALUE));
        }
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing multiple CFs");
        get = new Get(ROW);
        get.setMaxResultsPerColumnFamily(3);
        get.setFilter((Filter)new ColumnRangeFilter(QUALIFIERS[2], true, null, true));
        result = ht.get(get);
        kvListExp = new ArrayList();
        for (i = 2; i < 5; ++i) {
            kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[i], 1L, VALUE));
        }
        for (i = 2; i < 5; ++i) {
            kvListExp.add(new KeyValue(ROW, FAMILIES[1], QUALIFIERS[i], 1L, VALUE));
        }
        for (i = 2; i < 5; ++i) {
            kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[i], 1L, VALUE));
        }
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing multiple CFs + CRF");
        get = new Get(ROW);
        get.setMaxResultsPerColumnFamily(7);
        get.setFilter((Filter)new ColumnPrefixFilter(QUALIFIERS[1]));
        result = ht.get(get);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[1], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[1], QUALIFIERS[1], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[1], 1L, VALUE));
        for (i = 10; i < 16; ++i) {
            kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[i], 1L, VALUE));
        }
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing multiple CFs + PFF");
    }

    @Test
    public void testScanMaxResults() throws Exception {
        Result result;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] ROWS = HTestConst.makeNAscii(ROW, 2);
        byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, 3);
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, 10);
        Table ht = TEST_UTIL.createTable(tableName, FAMILIES);
        boolean toLog = true;
        ArrayList<Cell> kvListExp = new ArrayList<Cell>();
        for (int r = 0; r < ROWS.length; ++r) {
            Put put = new Put(ROWS[r]);
            for (int c = 0; c < FAMILIES.length; ++c) {
                for (int q = 0; q < QUALIFIERS.length; ++q) {
                    KeyValue kv = new KeyValue(ROWS[r], FAMILIES[c], QUALIFIERS[q], 1L, VALUE);
                    put.add((Cell)kv);
                    if (q >= 4) continue;
                    kvListExp.add((Cell)kv);
                }
            }
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.setMaxResultsPerColumnFamily(4);
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> kvListScan = new ArrayList<Cell>();
        while ((result = scanner.next()) != null) {
            for (Cell kv : result.listCells()) {
                kvListScan.add(kv);
            }
        }
        result = Result.create(kvListScan);
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing scan with maxResults");
    }

    @Test
    public void testGetRowOffset() throws Exception {
        int i;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, 3);
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, 20);
        Table ht = TEST_UTIL.createTable(tableName, FAMILIES);
        boolean toLog = true;
        ArrayList<Object> kvListExp = new ArrayList<Cell>();
        Put put = new Put(ROW);
        for (i = 0; i < 10; ++i) {
            KeyValue kv = new KeyValue(ROW, FAMILIES[0], QUALIFIERS[i], 1L, VALUE);
            put.add((Cell)kv);
            if (i < 2) continue;
            kvListExp.add((Cell)kv);
        }
        ht.put(put);
        Get get = new Get(ROW);
        get.setRowOffsetPerColumnFamily(2);
        Result result = ht.get(get);
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing basic setRowOffset");
        get = new Get(ROW);
        get.setRowOffsetPerColumnFamily(20);
        result = ht.get(get);
        kvListExp = new ArrayList();
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing offset > #kvs");
        get = new Get(ROW);
        get.setRowOffsetPerColumnFamily(4);
        get.setMaxResultsPerColumnFamily(5);
        result = ht.get(get);
        kvListExp = new ArrayList();
        for (i = 4; i < 9; ++i) {
            kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[i], 1L, VALUE));
        }
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing offset + setMaxResultsPerCF");
        get = new Get(ROW);
        get.setRowOffsetPerColumnFamily(1);
        get.setFilter((Filter)new ColumnRangeFilter(QUALIFIERS[2], true, QUALIFIERS[5], true));
        result = ht.get(get);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[3], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[4], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[5], 1L, VALUE));
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing offset with CRF");
        for (int j = 2; j > 0; --j) {
            put = new Put(ROW);
            for (int i2 = 0; i2 < 10; ++i2) {
                KeyValue kv = new KeyValue(ROW, FAMILIES[j], QUALIFIERS[i2], 1L, VALUE);
                put.add((Cell)kv);
            }
            ht.put(put);
        }
        get = new Get(ROW);
        get.setRowOffsetPerColumnFamily(4);
        get.setMaxResultsPerColumnFamily(2);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        result = ht.get(get);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[1], QUALIFIERS[4], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[1], QUALIFIERS[5], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[4], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[5], 1L, VALUE));
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing offset + multiple CFs + maxResults");
    }

    @Test
    public void testScanOnReopenedRegion() throws Exception {
        HRegionLocation loc;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, 2);
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        boolean toLog = false;
        Put put = new Put(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            KeyValue kv = new KeyValue(ROW, FAMILY, QUALIFIERS[i], (long)i, VALUE);
            put.add((Cell)kv);
        }
        ht.put(put);
        Scan scan = new Scan().withStartRow(ROW);
        ResultScanner scanner = ht.getScanner(scan);
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            loc = locator.getRegionLocation(ROW);
        }
        HRegionInfo hri = loc.getRegionInfo();
        MiniHBaseCluster cluster = TEST_UTIL.getMiniHBaseCluster();
        byte[] regionName = hri.getRegionName();
        int i = cluster.getServerWith(regionName);
        HRegionServer rs = cluster.getRegionServer(i);
        LOG.info("Unassigning " + hri);
        TEST_UTIL.getAdmin().unassign(hri.getRegionName(), true);
        long startTime = EnvironmentEdgeManager.currentTime();
        long timeOut = 10000L;
        boolean offline = false;
        while (true) {
            if (rs.getOnlineRegion(regionName) == null) break;
            Assert.assertTrue((String)"Timed out in closing the testing region", (EnvironmentEdgeManager.currentTime() < startTime + timeOut ? 1 : 0) != 0);
        }
        offline = true;
        Assert.assertTrue((boolean)offline);
        LOG.info("Assigning " + hri);
        TEST_UTIL.getAdmin().assign(hri.getRegionName());
        startTime = EnvironmentEdgeManager.currentTime();
        while (true) {
            if ((rs = cluster.getRegionServer(cluster.getServerWith(regionName))) != null && rs.getOnlineRegion(regionName) != null) break;
            Assert.assertTrue((String)"Timed out in open the testing region", (EnvironmentEdgeManager.currentTime() < startTime + timeOut ? 1 : 0) != 0);
        }
        offline = false;
        Assert.assertFalse((boolean)offline);
        ArrayList<Cell> kvListExp = new ArrayList<Cell>();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILY, QUALIFIERS[0], 0L, VALUE));
        kvListExp.add((Cell)new KeyValue(ROW, FAMILY, QUALIFIERS[1], 1L, VALUE));
        Result result = scanner.next();
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing scan on re-opened region");
    }

    @Test
    public void testAsyncScannerWithSmallData() throws Exception {
        this.testAsyncScanner(TableName.valueOf((String)this.name.getMethodName()), 2, 3, 10, -1, null);
    }

    @Test
    public void testAsyncScannerWithManyRows() throws Exception {
        this.testAsyncScanner(TableName.valueOf((String)this.name.getMethodName()), 30000, 1, 1, -1, null);
    }

    @Test
    public void testAsyncScannerWithoutCaching() throws Exception {
        this.testAsyncScanner(TableName.valueOf((String)this.name.getMethodName()), 5, 1, 1, 1, b -> {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    private void testAsyncScanner(TableName table, int rowNumber, int familyNumber, int qualifierNumber, int caching, Consumer<Boolean> listener) throws Exception {
        assert (rowNumber > 0);
        assert (familyNumber > 0);
        assert (qualifierNumber > 0);
        byte[] row = Bytes.toBytes((String)"r");
        byte[] family = Bytes.toBytes((String)"f");
        byte[] qualifier = Bytes.toBytes((String)"q");
        byte[][] rows = TestScannersFromClientSide.makeNAsciiWithZeroPrefix(row, rowNumber);
        byte[][] families = TestScannersFromClientSide.makeNAsciiWithZeroPrefix(family, familyNumber);
        byte[][] qualifiers = TestScannersFromClientSide.makeNAsciiWithZeroPrefix(qualifier, qualifierNumber);
        Table ht = TEST_UTIL.createTable(table, families);
        boolean toLog = true;
        ArrayList<Cell> kvListExp = new ArrayList<Cell>();
        ArrayList<Put> puts = new ArrayList<Put>();
        for (byte[] r : rows) {
            Put put = new Put(r);
            for (byte[] f : families) {
                for (byte[] q : qualifiers) {
                    KeyValue kv = new KeyValue(r, f, q, 1L, VALUE);
                    put.add((Cell)kv);
                    kvListExp.add((Cell)kv);
                }
            }
            puts.add(put);
            if (puts.size() <= 1000) continue;
            ht.put(puts);
            puts.clear();
        }
        if (!puts.isEmpty()) {
            ht.put(puts);
            puts.clear();
        }
        Scan scan = new Scan();
        scan.setAsyncPrefetch(true);
        if (caching > 0) {
            scan.setCaching(caching);
        }
        try (ResultScanner scanner = ht.getScanner(scan);){
            Result result;
            Assert.assertTrue((String)"Not instance of async scanner", (boolean)(scanner instanceof ClientAsyncPrefetchScanner));
            ((ClientAsyncPrefetchScanner)scanner).setPrefetchListener(listener);
            ArrayList<Cell> kvListScan = new ArrayList<Cell>();
            boolean first = true;
            int actualRows = 0;
            while ((result = scanner.next()) != null) {
                ++actualRows;
                if (first) {
                    TimeUnit.SECONDS.sleep(1L);
                    first = false;
                }
                for (Cell kv : result.listCells()) {
                    kvListScan.add(kv);
                }
            }
            Assert.assertEquals((long)rowNumber, (long)actualRows);
            result = Result.create(kvListScan);
            TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing async scan");
        }
        TEST_UTIL.deleteTable(table);
    }

    private static byte[][] makeNAsciiWithZeroPrefix(byte[] base, int n) {
        int maxLength = Integer.toString(n).length();
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int length = Integer.toString(i).length();
            StringBuilder buf = new StringBuilder(Integer.toString(i));
            IntStream.range(0, maxLength - length).forEach(v -> buf.insert(0, "0"));
            byte[] tail = Bytes.toBytes((String)buf.toString());
            ret[i] = Bytes.add((byte[])base, (byte[])tail);
        }
        return ret;
    }

    static void verifyResult(Result result, List<Cell> expKvList, boolean toLog, String msg) {
        LOG.info(msg);
        LOG.info("Expected count: " + expKvList.size());
        LOG.info("Actual count: " + result.size());
        if (expKvList.isEmpty()) {
            return;
        }
        int i = 0;
        for (Cell kv : result.rawCells()) {
            if (i >= expKvList.size()) break;
            Cell kvExp = expKvList.get(i++);
            if (toLog) {
                LOG.info("get kv is: " + kv.toString());
                LOG.info("exp kv is: " + kvExp.toString());
            }
            Assert.assertTrue((String)"Not equal", (boolean)kvExp.equals(kv));
        }
        Assert.assertEquals((long)expKvList.size(), (long)result.size());
    }

    @Test
    public void testReadExpiredDataForRawScan() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        long ts = System.currentTimeMillis() - 10000L;
        byte[] value = Bytes.toBytes((String)"expired");
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY);){
            table.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, ts, value));
            Assert.assertArrayEquals((byte[])value, (byte[])table.get(new Get(ROW)).getValue(FAMILY, QUALIFIER));
            TEST_UTIL.getAdmin().modifyColumnFamily(tableName, (ColumnFamilyDescriptor)new HColumnDescriptor(FAMILY).setTimeToLive(5));
            try (ResultScanner scanner = table.getScanner(FAMILY);){
                Assert.assertNull((Object)scanner.next());
            }
            scanner = table.getScanner(new Scan().setRaw(true));
            var8_9 = null;
            try {
                Assert.assertArrayEquals((byte[])value, (byte[])scanner.next().getValue(FAMILY, QUALIFIER));
                Assert.assertNull((Object)scanner.next());
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (var8_9 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
    }

    @Test
    public void testScanWithColumnsAndFilterAndVersion() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY, 4);){
            for (int i = 0; i < 4; ++i) {
                Put put = new Put(ROW);
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                table.put(put);
            }
            Scan scan = new Scan();
            scan.addColumn(FAMILY, QUALIFIER);
            scan.setFilter((Filter)new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(QUALIFIER)));
            scan.readVersions(3);
            try (ResultScanner scanner = table.getScanner(scan);){
                Result result = scanner.next();
                Assert.assertEquals((long)3L, (long)result.size());
            }
        }
    }
}

