/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMaster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMaster.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Logger LOG = LoggerFactory.getLogger(TestMaster.class);
    private static final TableName TABLENAME = TableName.valueOf((String)"TestMaster");
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    private static Admin admin;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        TEST_UTIL.startMiniCluster(2);
        admin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMasterOpsWhileSplitting() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        try (Table ht = TEST_UTIL.createTable(TABLENAME, FAMILYNAME);){
            Assert.assertTrue((boolean)m.getTableStateManager().isTableState(TABLENAME, new TableState.State[]{TableState.State.ENABLED}));
            TEST_UTIL.loadTable(ht, FAMILYNAME, false);
        }
        List tableRegions = MetaTableAccessor.getTableRegionsAndLocations((Connection)m.getConnection(), (TableName)TABLENAME);
        LOG.info("Regions after load: " + Joiner.on((char)',').join((Iterable)tableRegions));
        Assert.assertEquals((long)1L, (long)tableRegions.size());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])((RegionInfo)((Pair)tableRegions.get(0)).getFirst()).getStartKey());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])((RegionInfo)((Pair)tableRegions.get(0)).getFirst()).getEndKey());
        LOG.info("Splitting table");
        TEST_UTIL.getAdmin().split(TABLENAME);
        LOG.info("Making sure we can call getTableRegions while opening");
        while (tableRegions.size() < 3) {
            tableRegions = MetaTableAccessor.getTableRegionsAndLocations((Connection)m.getConnection(), (TableName)TABLENAME, (boolean)false);
            Thread.sleep(100L);
        }
        LOG.info("Regions: " + Joiner.on((char)',').join((Iterable)tableRegions));
        Assert.assertEquals((long)3L, (long)tableRegions.size());
        LOG.info("Making sure we can call getTableRegionClosest while opening");
        Pair pair = m.getTableRegionForRow(TABLENAME, Bytes.toBytes((String)"cde"));
        LOG.info("Result is: " + pair);
        Pair tableRegionFromName = MetaTableAccessor.getRegion((Connection)m.getConnection(), (byte[])((RegionInfo)pair.getFirst()).getRegionName());
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(tableRegionFromName.getFirst(), pair.getFirst()) == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveRegionWhenNotInitialized() {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        try {
            m.setInitialized(false);
            RegionInfo meta = RegionInfoBuilder.FIRST_META_REGIONINFO;
            m.move(meta.getEncodedNameAsBytes(), null);
            Assert.fail((String)"Region should not be moved since master is not initialized");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof PleaseHoldException));
        }
        finally {
            m.setInitialized(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveThrowsUnknownRegionException() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        admin.createTable((TableDescriptor)htd, (byte[][])null);
        try {
            RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"A")).setEndKey(Bytes.toBytes((String)"Z")).build();
            admin.move(hri.getEncodedNameAsBytes(), null);
            Assert.fail((String)"Region should not be moved since it is fake");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof UnknownRegionException));
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveThrowsPleaseHoldException() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        admin.createTable((TableDescriptor)htd, (byte[][])null);
        try {
            List tableRegions = admin.getRegions(tableName);
            master.setInitialized(false);
            admin.move(((RegionInfo)tableRegions.get(0)).getEncodedNameAsBytes(), null);
            Assert.fail((String)"Region should not be moved since master is not initialized");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)StringUtils.stringifyException((Throwable)ioe).contains("PleaseHoldException"));
        }
        finally {
            master.setInitialized(true);
            TEST_UTIL.deleteTable(tableName);
        }
    }
}

