/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.NamespaceQuotaSnapshotStore;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestNamespaceQuotaViolationStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNamespaceQuotaViolationStore.class);
    private static final long ONE_MEGABYTE = 0x100000L;
    private Connection conn;
    private QuotaObserverChore chore;
    private Map<RegionInfo, Long> regionReports;
    private NamespaceQuotaSnapshotStore store;

    @Before
    public void setup() {
        this.conn = (Connection)Mockito.mock(Connection.class);
        this.chore = (QuotaObserverChore)Mockito.mock(QuotaObserverChore.class);
        this.regionReports = new HashMap<RegionInfo, Long>();
        this.store = new NamespaceQuotaSnapshotStore(this.conn, this.chore, this.regionReports);
    }

    @Test
    public void testGetSpaceQuota() throws Exception {
        NamespaceQuotaSnapshotStore mockStore = (NamespaceQuotaSnapshotStore)Mockito.mock(NamespaceQuotaSnapshotStore.class);
        Mockito.when((Object)mockStore.getSpaceQuota((String)Matchers.any())).thenCallRealMethod();
        QuotaProtos.Quotas quotaWithSpace = QuotaProtos.Quotas.newBuilder().setSpace(QuotaProtos.SpaceQuota.newBuilder().setSoftLimit(1024L).setViolationPolicy(QuotaProtos.SpaceViolationPolicy.DISABLE).build()).build();
        QuotaProtos.Quotas quotaWithoutSpace = QuotaProtos.Quotas.newBuilder().build();
        final AtomicReference<QuotaProtos.Quotas> quotaRef = new AtomicReference<QuotaProtos.Quotas>();
        Mockito.when((Object)mockStore.getQuotaForNamespace((String)Matchers.any())).then((Answer)new Answer<QuotaProtos.Quotas>(){

            public QuotaProtos.Quotas answer(InvocationOnMock invocation) throws Throwable {
                return (QuotaProtos.Quotas)quotaRef.get();
            }
        });
        quotaRef.set(quotaWithSpace);
        Assert.assertEquals((Object)quotaWithSpace.getSpace(), (Object)mockStore.getSpaceQuota("ns"));
        quotaRef.set(quotaWithoutSpace);
        Assert.assertNull((Object)mockStore.getSpaceQuota("ns"));
    }

    @Test
    public void testTargetViolationState() throws IOException {
        this.mockNoSnapshotSizes();
        String NS = "ns";
        TableName tn1 = TableName.valueOf((String)"ns", (String)"tn1");
        TableName tn2 = TableName.valueOf((String)"ns", (String)"tn2");
        TableName tn3 = TableName.valueOf((String)"tn3");
        QuotaProtos.SpaceQuota quota = QuotaProtos.SpaceQuota.newBuilder().setSoftLimit(0x100000L).setViolationPolicy(ProtobufUtil.toProtoViolationPolicy((SpaceViolationPolicy)SpaceViolationPolicy.DISABLE)).build();
        for (int i = 0; i < 3; ++i) {
            this.regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn3).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build(), 0x500000L);
        }
        this.regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn1).setStartKey(Bytes.toBytes((int)0)).setEndKey(Bytes.toBytes((int)1)).build(), 524288L);
        this.regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn1).setStartKey(Bytes.toBytes((int)1)).setEndKey(Bytes.toBytes((int)2)).build(), 262144L);
        Assert.assertEquals((Object)false, (Object)this.store.getTargetState("ns", quota).getQuotaStatus().isInViolation());
        this.regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn2).setStartKey(Bytes.toBytes((int)2)).setEndKey(Bytes.toBytes((int)3)).build(), 262144L);
        Assert.assertEquals((Object)false, (Object)this.store.getTargetState("ns", quota).getQuotaStatus().isInViolation());
        this.regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn2).setStartKey(Bytes.toBytes((int)3)).setEndKey(Bytes.toBytes((int)4)).build(), 1024L);
        Assert.assertEquals((Object)true, (Object)this.store.getTargetState("ns", quota).getQuotaStatus().isInViolation());
        Assert.assertEquals((Object)SpaceViolationPolicy.DISABLE, (Object)this.store.getTargetState("ns", quota).getQuotaStatus().getPolicy());
    }

    @Test
    public void testFilterRegionsByNamespace() {
        int i;
        TableName tn1 = TableName.valueOf((String)"foo");
        TableName tn2 = TableName.valueOf((String)"sn", (String)"bar");
        TableName tn3 = TableName.valueOf((String)"ns", (String)"foo");
        TableName tn4 = TableName.valueOf((String)"ns", (String)"bar");
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.store.filterBySubject("asdf")));
        for (i = 0; i < 5; ++i) {
            this.regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn1).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build(), 0L);
        }
        for (i = 0; i < 3; ++i) {
            this.regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn2).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build(), 0L);
        }
        for (i = 0; i < 10; ++i) {
            this.regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn3).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build(), 0L);
        }
        for (i = 0; i < 8; ++i) {
            this.regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn4).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build(), 0L);
        }
        Assert.assertEquals((long)26L, (long)this.regionReports.size());
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.store.filterBySubject(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR)));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.store.filterBySubject("sn")));
        Assert.assertEquals((long)18L, (long)Iterables.size((Iterable)this.store.filterBySubject("ns")));
    }

    void mockNoSnapshotSizes() throws IOException {
        Table quotaTable = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)this.conn.getTable(QuotaTableUtil.QUOTA_TABLE_NAME)).thenReturn((Object)quotaTable);
        Mockito.when((Object)quotaTable.get((Get)Matchers.any(Get.class))).thenReturn((Object)new Result());
    }
}

