/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.TestHRegion;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowRegionServerTests;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={VerySlowRegionServerTests.class, LargeTests.class})
public class TestHRegionWithInMemoryFlush
extends TestHRegion {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHRegionWithInMemoryFlush.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHRegionWithInMemoryFlush.class);

    @Override
    public HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, boolean isReadOnly, Durability durability, WAL wal, byte[] ... families) throws IOException {
        boolean[] inMemory = new boolean[families.length];
        for (int i = 0; i < inMemory.length; ++i) {
            inMemory[i] = true;
        }
        return TEST_UTIL.createLocalHRegionWithInMemoryFlags(tableName, startKey, stopKey, isReadOnly, durability, wal, inMemory, families);
    }
}

