/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.NewVersionBehaviorTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestNewVersionBehaviorTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNewVersionBehaviorTracker.class);
    private final byte[] col1 = Bytes.toBytes((String)"col1");
    private final byte[] col2 = Bytes.toBytes((String)"col2");
    private final byte[] row = Bytes.toBytes((String)"row");
    private final byte[] family = Bytes.toBytes((String)"family");
    private final byte[] value = Bytes.toBytes((String)"value");
    private final CellComparator comparator = CellComparatorImpl.COMPARATOR;

    @Test
    public void testMaxVersionMask() {
        NewVersionBehaviorTracker tracker = new NewVersionBehaviorTracker(null, this.comparator, 1, 3, 3, 10000L);
        KeyValue keyValue = new KeyValue(this.row, this.family, this.col1, 20000L, KeyValue.Type.Put, this.value);
        keyValue.setTimestamp(20000L);
        keyValue.setSequenceId(1000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        keyValue.setTimestamp(19999L);
        keyValue.setSequenceId(999L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        keyValue.setTimestamp(19999L);
        keyValue.setSequenceId(998L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_MASKED, (Object)tracker.isDeleted((Cell)keyValue));
        keyValue.setTimestamp(19998L);
        keyValue.setSequenceId(997L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        keyValue.setTimestamp(19997L);
        keyValue.setSequenceId(996L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_MASKED, (Object)tracker.isDeleted((Cell)keyValue));
        keyValue = new KeyValue(this.row, this.family, this.col2, 20000L, KeyValue.Type.Put, this.value);
        keyValue.setTimestamp(20000L);
        keyValue.setSequenceId(1000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        keyValue.setTimestamp(19999L);
        keyValue.setSequenceId(1002L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        keyValue.setTimestamp(19999L);
        keyValue.setSequenceId(1001L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_MASKED, (Object)tracker.isDeleted((Cell)keyValue));
        keyValue.setTimestamp(19998L);
        keyValue.setSequenceId(1003L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        keyValue.setTimestamp(19997L);
        keyValue.setSequenceId(1004L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_MASKED, (Object)tracker.isDeleted((Cell)keyValue));
    }

    @Test
    public void testVersionsDelete() {
        NewVersionBehaviorTracker tracker = new NewVersionBehaviorTracker(null, this.comparator, 1, 3, 3, 10000L);
        KeyValue put = new KeyValue(this.row, this.family, this.col1, 20000L, KeyValue.Type.Put, this.value);
        KeyValue delete = new KeyValue(this.row, this.family, this.col1, 20000L, KeyValue.Type.DeleteColumn, this.value);
        delete.setSequenceId(1000L);
        delete.setTimestamp(20000L);
        tracker.add((Cell)delete);
        put.setSequenceId(1001L);
        put.setTimestamp(19999L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(999L);
        put.setTimestamp(19998L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.COLUMN_DELETED, (Object)tracker.isDeleted((Cell)put));
        delete = new KeyValue(this.row, this.family, this.col2, 20000L, KeyValue.Type.DeleteColumn, this.value);
        delete.setSequenceId(1002L);
        delete.setTimestamp(20000L);
        tracker.add((Cell)delete);
        put = new KeyValue(this.row, this.family, this.col2, 20000L, KeyValue.Type.Put, this.value);
        put.setSequenceId(1001L);
        put.setTimestamp(19999L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.COLUMN_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(999L);
        put.setTimestamp(19998L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.COLUMN_DELETED, (Object)tracker.isDeleted((Cell)put));
    }

    @Test
    public void testVersionDelete() {
        NewVersionBehaviorTracker tracker = new NewVersionBehaviorTracker(null, this.comparator, 1, 3, 3, 10000L);
        KeyValue put = new KeyValue(this.row, this.family, this.col1, 20000L, KeyValue.Type.Put, this.value);
        KeyValue delete = new KeyValue(this.row, this.family, this.col1, 20000L, KeyValue.Type.Delete, this.value);
        delete.setSequenceId(1000L);
        delete.setTimestamp(20000L);
        tracker.add((Cell)delete);
        put.setSequenceId(1001L);
        put.setTimestamp(20000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(999L);
        put.setTimestamp(20000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_DELETED, (Object)tracker.isDeleted((Cell)put));
        delete = new KeyValue(this.row, this.family, this.col2, 20000L, KeyValue.Type.Delete, this.value);
        delete.setSequenceId(1002L);
        delete.setTimestamp(20000L);
        tracker.add((Cell)delete);
        put = new KeyValue(this.row, this.family, this.col2, 20000L, KeyValue.Type.Put, this.value);
        put.setSequenceId(1001L);
        put.setTimestamp(20000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(999L);
        put.setTimestamp(20000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(1002L);
        put.setTimestamp(19999L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(998L);
        put.setTimestamp(19999L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_MASKED, (Object)tracker.isDeleted((Cell)put));
    }

    @Test
    public void testFamilyVersionsDelete() {
        NewVersionBehaviorTracker tracker = new NewVersionBehaviorTracker(null, this.comparator, 1, 3, 3, 10000L);
        KeyValue delete = new KeyValue(this.row, this.family, null, 20000L, KeyValue.Type.DeleteFamily, this.value);
        delete.setSequenceId(1000L);
        delete.setTimestamp(20000L);
        KeyValue put = new KeyValue(this.row, this.family, this.col1, 20000L, KeyValue.Type.Put, this.value);
        tracker.add((Cell)delete);
        put.setSequenceId(1001L);
        put.setTimestamp(20000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(999L);
        put.setTimestamp(19998L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.COLUMN_DELETED, (Object)tracker.isDeleted((Cell)put));
        put = new KeyValue(this.row, this.family, this.col2, 20000L, KeyValue.Type.Put, this.value);
        put.setSequenceId(998L);
        put.setTimestamp(19999L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.COLUMN_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(999L);
        put.setTimestamp(19998L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.COLUMN_DELETED, (Object)tracker.isDeleted((Cell)put));
    }

    @Test
    public void testFamilyVersionDelete() {
        NewVersionBehaviorTracker tracker = new NewVersionBehaviorTracker(null, this.comparator, 1, 3, 3, 10000L);
        KeyValue delete = new KeyValue(this.row, this.family, null, 20000L, KeyValue.Type.DeleteFamilyVersion, this.value);
        delete.setSequenceId(1000L);
        delete.setTimestamp(20000L);
        tracker.add((Cell)delete);
        KeyValue put = new KeyValue(this.row, this.family, this.col1, 20000L, KeyValue.Type.Put, this.value);
        put.setSequenceId(1001L);
        put.setTimestamp(20000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(999L);
        put.setTimestamp(20000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_DELETED, (Object)tracker.isDeleted((Cell)put));
        put = new KeyValue(this.row, this.family, this.col2, 20000L, KeyValue.Type.Put, this.value);
        put.setSequenceId(1001L);
        put.setTimestamp(20000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(999L);
        put.setTimestamp(20000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(1002L);
        put.setTimestamp(19999L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)put));
        put.setSequenceId(998L);
        put.setTimestamp(19999L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_MASKED, (Object)tracker.isDeleted((Cell)put));
    }

    @Test
    public void testMinVersionsAndTTL() throws IOException {
        NewVersionBehaviorTracker tracker = new NewVersionBehaviorTracker(null, this.comparator, 1, 3, 3, 30000L);
        KeyValue keyValue = new KeyValue(this.row, this.family, this.col1, 20000L, KeyValue.Type.Put, this.value);
        keyValue.setTimestamp(20000L);
        keyValue.setSequenceId(1000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, (Object)tracker.checkVersions((Cell)keyValue, keyValue.getTimestamp(), keyValue.getTypeByte(), false));
        keyValue.setTimestamp(19999L);
        keyValue.setSequenceId(999L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, (Object)tracker.checkVersions((Cell)keyValue, keyValue.getTimestamp(), keyValue.getTypeByte(), false));
        keyValue.setTimestamp(19999L);
        keyValue.setSequenceId(998L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_MASKED, (Object)tracker.isDeleted((Cell)keyValue));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, (Object)tracker.checkVersions((Cell)keyValue, keyValue.getTimestamp(), keyValue.getTypeByte(), false));
        keyValue.setTimestamp(19998L);
        keyValue.setSequenceId(997L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, (Object)tracker.checkVersions((Cell)keyValue, keyValue.getTimestamp(), keyValue.getTypeByte(), false));
        keyValue.setTimestamp(19997L);
        keyValue.setSequenceId(996L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_MASKED, (Object)tracker.isDeleted((Cell)keyValue));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, (Object)tracker.checkVersions((Cell)keyValue, keyValue.getTimestamp(), keyValue.getTypeByte(), false));
        keyValue = new KeyValue(this.row, this.family, this.col2, 20000L, KeyValue.Type.Put, this.value);
        keyValue.setTimestamp(20000L);
        keyValue.setSequenceId(1000L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, (Object)tracker.checkVersions((Cell)keyValue, keyValue.getTimestamp(), keyValue.getTypeByte(), false));
        keyValue.setTimestamp(19999L);
        keyValue.setSequenceId(1002L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, (Object)tracker.checkVersions((Cell)keyValue, keyValue.getTimestamp(), keyValue.getTypeByte(), false));
        keyValue.setTimestamp(19999L);
        keyValue.setSequenceId(1001L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_MASKED, (Object)tracker.isDeleted((Cell)keyValue));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, (Object)tracker.checkVersions((Cell)keyValue, keyValue.getTimestamp(), keyValue.getTypeByte(), false));
        keyValue.setTimestamp(19998L);
        keyValue.setSequenceId(1003L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)tracker.isDeleted((Cell)keyValue));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, (Object)tracker.checkVersions((Cell)keyValue, keyValue.getTimestamp(), keyValue.getTypeByte(), false));
        keyValue.setTimestamp(19997L);
        keyValue.setSequenceId(1004L);
        Assert.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_MASKED, (Object)tracker.isDeleted((Cell)keyValue));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, (Object)tracker.checkVersions((Cell)keyValue, keyValue.getTimestamp(), keyValue.getTypeByte(), false));
    }
}

