/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReplicationBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationBase.class);
    protected static Configuration conf1 = HBaseConfiguration.create();
    protected static Configuration conf2;
    protected static Configuration CONF_WITH_LOCALFS;
    protected static ZKWatcher zkw1;
    protected static ZKWatcher zkw2;
    protected static ReplicationAdmin admin;
    protected static Admin hbaseAdmin;
    protected static Table htable1;
    protected static Table htable2;
    protected static NavigableMap<byte[], Integer> scopes;
    protected static HBaseTestingUtility utility1;
    protected static HBaseTestingUtility utility2;
    protected static final int NB_ROWS_IN_BATCH = 100;
    protected static final int NB_ROWS_IN_BIG_BATCH = 1000;
    protected static final long SLEEP_TIME = 500L;
    protected static final int NB_RETRIES = 50;
    protected static final TableName tableName;
    protected static final byte[] famName;
    protected static final byte[] row;
    protected static final byte[] noRepfamName;
    protected static final String PEER_ID2 = "2";

    protected boolean isSerialPeer() {
        return false;
    }

    protected final void cleanUp() throws IOException, InterruptedException {
        for (JVMClusterUtil.RegionServerThread r : utility1.getHBaseCluster().getRegionServerThreads()) {
            utility1.getAdmin().rollWALWriter(r.getRegionServer().getServerName());
        }
        int rowCount = utility1.countRows(tableName);
        utility1.deleteTableData(tableName);
        Scan scan = new Scan();
        int lastCount = 0;
        for (int i = 0; i < 50; ++i) {
            if (i == 49) {
                Assert.fail((String)"Waited too much time for truncate");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(rowCount);
            scanner.close();
            if (res.length == 0) break;
            if (res.length < lastCount) {
                --i;
            }
            lastCount = res.length;
            LOG.info("Still got " + res.length + " rows");
            Thread.sleep(500L);
        }
    }

    protected static void waitForReplication(int expectedRows, int retries) throws IOException, InterruptedException {
        for (int i = 0; i < retries; ++i) {
            Scan scan = new Scan();
            if (i == retries - 1) {
                Assert.fail((String)"Waited too much time for normal batch replication");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(expectedRows);
            scanner.close();
            if (res.length == expectedRows) break;
            LOG.info("Only got " + res.length + " rows");
            Thread.sleep(500L);
        }
    }

    protected static void loadData(String prefix, byte[] row) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(Bytes.toBytes((String)(prefix + Integer.toString(i))));
            put.addColumn(famName, row, row);
            puts.add(put);
        }
        htable1.put(puts);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("replication.source.size.capacity", 102400);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setInt("zookeeper.recovery.retry", 1);
        conf1.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setInt("replication.stats.thread.period.seconds", 5);
        conf1.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf1.setLong("replication.sleep.before.failover", 2000L);
        conf1.setInt("replication.source.maxretriesmultiplier", 10);
        conf1.setFloat("replication.source.ratio", 1.0f);
        conf1.setBoolean("replication.source.eof.autorecovery", true);
        conf1.setLong("hbase.serial.replication.waiting.ms", 100L);
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        conf1 = utility1.getConfiguration();
        zkw1 = new ZKWatcher(conf1, "cluster1", null, true);
        admin = new ReplicationAdmin(conf1);
        LOG.info("Setup first Zk");
        conf2 = HBaseConfiguration.create((Configuration)conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        conf2.setInt("hbase.client.retries.number", 6);
        conf2.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        zkw2 = new ZKWatcher(conf2, "cluster2", null, true);
        LOG.info("Setup second Zk");
        CONF_WITH_LOCALFS = HBaseConfiguration.create((Configuration)conf1);
        utility1.startMiniCluster(2);
        utility2.startMiniCluster(4);
        hbaseAdmin = ConnectionFactory.createConnection((Configuration)conf1).getAdmin();
        TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setMaxVersions(100).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])noRepfamName)).build();
        scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (ColumnFamilyDescriptor f : table.getColumnFamilies()) {
            scopes.put(f.getName(), f.getScope());
        }
        Connection connection1 = ConnectionFactory.createConnection((Configuration)conf1);
        Connection connection2 = ConnectionFactory.createConnection((Configuration)conf2);
        try (Admin admin1 = connection1.getAdmin();){
            admin1.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        }
        var5_7 = null;
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        }
        catch (Throwable throwable) {
            var5_7 = throwable;
            throw throwable;
        }
        utility1.waitUntilAllRegionsAssigned(tableName);
        utility2.waitUntilAllRegionsAssigned(tableName);
        htable1 = connection1.getTable(tableName);
        htable2 = connection2.getTable(tableName);
    }

    private boolean peerExist(String peerId) throws IOException {
        return hbaseAdmin.listReplicationPeers().stream().anyMatch(p -> peerId.equals(p.getPeerId()));
    }

    @Before
    public void setUpBase() throws Exception {
        if (!this.peerExist(PEER_ID2)) {
            ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(utility2.getClusterKey()).setSerial(this.isSerialPeer()).build();
            hbaseAdmin.addReplicationPeer(PEER_ID2, rpc);
        }
    }

    @After
    public void tearDownBase() throws Exception {
        if (this.peerExist(PEER_ID2)) {
            hbaseAdmin.removeReplicationPeer(PEER_ID2);
        }
    }

    protected static void runSimplePutDeleteTest() throws IOException, InterruptedException {
        Put put = new Put(row);
        put.addColumn(famName, row, row);
        htable1 = utility1.getConnection().getTable(tableName);
        htable1.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 50; ++i) {
            Result res;
            if (i == 49) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if (!(res = htable2.get(get)).isEmpty()) {
                Assert.assertArrayEquals((byte[])row, (byte[])res.value());
                break;
            }
            LOG.info("Row not available");
            Thread.sleep(500L);
        }
        Delete del = new Delete(row);
        htable1.delete(del);
        get = new Get(row);
        for (int i = 0; i < 50; ++i) {
            Result res;
            if (i == 49) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = htable2.get(get)).size() < 1) break;
            LOG.info("Row not deleted");
            Thread.sleep(500L);
        }
    }

    protected static void runSmallBatchTest() throws IOException, InterruptedException {
        TestReplicationBase.loadData("", row);
        Scan scan = new Scan();
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(100);
        scanner1.close();
        Assert.assertEquals((long)100L, (long)res1.length);
        TestReplicationBase.waitForReplication(100, 50);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        htable2.close();
        htable1.close();
        admin.close();
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    static {
        tableName = TableName.valueOf((String)"test");
        famName = Bytes.toBytes((String)"f");
        row = Bytes.toBytes((String)"row");
        noRepfamName = Bytes.toBytes((String)"norep");
    }
}

