/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationDisableInactivePeer
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationDisableInactivePeer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationDisableInactivePeer.class);

    @Test
    public void testDisableInactivePeer() throws Exception {
        Result res;
        int i;
        utility2.shutdownMiniHBaseCluster();
        byte[] rowkey = Bytes.toBytes((String)"disable inactive peer");
        Put put = new Put(rowkey);
        put.addColumn(famName, row, row);
        htable1.put(put);
        Thread.sleep(25000L);
        admin.disablePeer("2");
        utility2.startMiniHBaseCluster(1, 2);
        Get get = new Get(rowkey);
        for (i = 0; i < 50; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Replication wasn't disabled");
                continue;
            }
            LOG.info("Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
        admin.enablePeer("2");
        Thread.sleep(25000L);
        for (i = 0; i < 50; ++i) {
            res = htable2.get(get);
            if (!res.isEmpty()) {
                Assert.assertArrayEquals((byte[])row, (byte[])res.value());
                return;
            }
            LOG.info("Row not available");
            Thread.sleep(25000L);
        }
        Assert.fail((String)"Waited too much time for put replication");
    }
}

