/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationSourceDummy;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.ZKReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALActionListener;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, MediumTests.class})
public abstract class TestReplicationSourceManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSourceManager.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestReplicationSourceManager.class);
    protected static Configuration conf;
    protected static HBaseTestingUtility utility;
    protected static Replication replication;
    protected static ReplicationSourceManager manager;
    protected static ReplicationSourceManager managerOfCluster;
    protected static ZKWatcher zkw;
    protected static HTableDescriptor htd;
    protected static HRegionInfo hri;
    protected static final byte[] r1;
    protected static final byte[] r2;
    protected static final byte[] f1;
    protected static final byte[] f2;
    protected static final TableName test;
    protected static final String slaveId = "1";
    protected static FileSystem fs;
    protected static Path oldLogDir;
    protected static Path logDir;
    protected static CountDownLatch latch;
    protected static List<String> files;
    protected static NavigableMap<byte[], Integer> scopes;
    @Rule
    public TestName testName = new TestName();

    protected static void setupZkAndReplication() throws Exception {
        Assert.assertNotNull((Object)conf);
        zkw = new ZKWatcher(conf, "test", null);
        ZKUtil.createWithParents((ZKWatcher)zkw, (String)"/hbase/replication");
        ZKUtil.createWithParents((ZKWatcher)zkw, (String)"/hbase/replication/peers/1");
        ZKUtil.setData((ZKWatcher)zkw, (String)"/hbase/replication/peers/1", (byte[])Bytes.toBytes((String)(conf.get("hbase.zookeeper.quorum") + ":" + conf.get("hbase.zookeeper.property.clientPort") + ":/1")));
        ZKUtil.createWithParents((ZKWatcher)zkw, (String)"/hbase/replication/peers/1/peer-state");
        ZKUtil.setData((ZKWatcher)zkw, (String)"/hbase/replication/peers/1/peer-state", (byte[])ZKReplicationPeerStorage.ENABLED_ZNODE_BYTES);
        ZKUtil.createWithParents((ZKWatcher)zkw, (String)"/hbase/replication/state");
        ZKUtil.setData((ZKWatcher)zkw, (String)"/hbase/replication/state", (byte[])ZKReplicationPeerStorage.ENABLED_ZNODE_BYTES);
        ZKClusterId.setClusterId((ZKWatcher)zkw, (ClusterId)new ClusterId());
        FSUtils.setRootDir((Configuration)utility.getConfiguration(), (Path)utility.getDataTestDir());
        fs = FileSystem.get((Configuration)conf);
        oldLogDir = new Path(utility.getDataTestDir(), "oldWALs");
        logDir = new Path(utility.getDataTestDir(), "WALs");
        replication = new Replication();
        replication.initialize((Server)new DummyServer(), fs, logDir, oldLogDir, null);
        managerOfCluster = TestReplicationSourceManager.getManagerFromCluster();
        if (managerOfCluster != null) {
            managerOfCluster.addPeer(slaveId);
        }
        manager = replication.getReplicationManager();
        manager.addSource(slaveId);
        if (managerOfCluster != null) {
            TestReplicationSourceManager.waitPeer(slaveId, managerOfCluster, true);
        }
        TestReplicationSourceManager.waitPeer(slaveId, manager, true);
        htd = new HTableDescriptor(test);
        HColumnDescriptor col = new HColumnDescriptor(f1);
        col.setScope(1);
        htd.addFamily(col);
        col = new HColumnDescriptor(f2);
        col.setScope(0);
        htd.addFamily(col);
        scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getFamiliesKeys()) {
            scopes.put(fam, 0);
        }
        hri = new HRegionInfo(htd.getTableName(), r1, r2);
    }

    private static ReplicationSourceManager getManagerFromCluster() {
        if (utility.getMiniHBaseCluster() == null) {
            return null;
        }
        return utility.getMiniHBaseCluster().getRegionServerThreads().stream().map(JVMClusterUtil.RegionServerThread::getRegionServer).findAny().map(HRegionServer::getReplicationSourceService).map(r -> (Replication)r).map(Replication::getReplicationManager).get();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (manager != null) {
            manager.join();
        }
        utility.shutdownMiniCluster();
    }

    private void cleanLogDir() throws IOException {
        fs.delete(logDir, true);
        fs.delete(oldLogDir, true);
    }

    @Before
    public void setUp() throws Exception {
        LOG.info("Start " + this.testName.getMethodName());
        this.cleanLogDir();
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("End " + this.testName.getMethodName());
        this.cleanLogDir();
        List ids = manager.getSources().stream().map(ReplicationSourceInterface::getPeerId).collect(Collectors.toList());
        for (String id : ids) {
            if (slaveId.equals(id)) continue;
            this.removePeerAndWait(id);
        }
    }

    @Test
    public void testLogRoll() throws Exception {
        long baseline;
        long time = baseline = 1000L;
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        KeyValue kv = new KeyValue(r1, f1, r1);
        WALEdit edit = new WALEdit();
        edit.add((Cell)kv);
        WALFactory wals = new WALFactory(utility.getConfiguration(), URLEncoder.encode("regionserver:60020", "UTF8"));
        ReplicationSourceManager replicationManager = replication.getReplicationManager();
        wals.getWALProvider().addWALActionsListener((WALActionsListener)new ReplicationSourceWALActionListener(conf, replicationManager));
        WAL wal = wals.getWAL((RegionInfo)hri);
        manager.init();
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"tableame"));
        htd.addFamily(new HColumnDescriptor(f1));
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getFamiliesKeys()) {
            scopes.put(fam, 0);
        }
        for (long i = 1L; i < 101L; ++i) {
            if (i > 1L && i % 20L == 0L) {
                wal.rollWriter();
            }
            LOG.info(Long.toString(i));
            long txid = wal.append((RegionInfo)hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), test, System.currentTimeMillis(), mvcc, scopes), edit, true);
            wal.sync(txid);
        }
        LOG.info(baseline + " and " + time);
        time = baseline += 101L;
        LOG.info(baseline + " and " + time);
        for (int i = 0; i < 3; ++i) {
            wal.append((RegionInfo)hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), test, System.currentTimeMillis(), mvcc, scopes), edit, true);
        }
        wal.sync();
        int logNumber = 0;
        for (Map.Entry entry : ((Map)manager.getWALs().get(slaveId)).entrySet()) {
            logNumber += ((NavigableSet)entry.getValue()).size();
        }
        Assert.assertEquals((long)6L, (long)logNumber);
        wal.rollWriter();
        manager.logPositionAndCleanOldLogs(slaveId, false, new WALEntryBatch(0, ((ReplicationSourceInterface)manager.getSources().get(0)).getCurrentPath()));
        wal.append((RegionInfo)hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), test, System.currentTimeMillis(), mvcc, scopes), edit, true);
        wal.sync();
        Assert.assertEquals((long)1L, (long)manager.getWALs().size());
    }

    @Test
    public void testClaimQueues() throws Exception {
        DummyServer server = new DummyServer("hostname0.example.org");
        ReplicationQueueStorage rq = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)server.getZooKeeper(), (Configuration)server.getConfiguration());
        files.add("log1");
        files.add("log2");
        for (String file : files) {
            rq.addWAL(server.getServerName(), slaveId, file);
        }
        DummyServer s1 = new DummyServer("dummyserver1.example.org");
        DummyServer s2 = new DummyServer("dummyserver2.example.org");
        DummyServer s3 = new DummyServer("dummyserver3.example.org");
        DummyNodeFailoverWorker w1 = new DummyNodeFailoverWorker(server.getServerName(), s1);
        DummyNodeFailoverWorker w2 = new DummyNodeFailoverWorker(server.getServerName(), s2);
        DummyNodeFailoverWorker w3 = new DummyNodeFailoverWorker(server.getServerName(), s3);
        latch = new CountDownLatch(3);
        w1.start();
        w2.start();
        w3.start();
        int populatedMap = 0;
        latch.await();
        Assert.assertEquals((long)1L, (long)(populatedMap += w1.isLogZnodesMapPopulated() + w2.isLogZnodesMapPopulated() + w3.isLogZnodesMapPopulated()));
        server.abort("", null);
    }

    @Test
    public void testCleanupFailoverQueues() throws Exception {
        DummyServer server = new DummyServer("hostname1.example.org");
        ReplicationQueueStorage rq = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)server.getZooKeeper(), (Configuration)server.getConfiguration());
        TreeSet<String> files = new TreeSet<String>();
        String group = "testgroup";
        String file1 = group + ".log1";
        String file2 = group + ".log2";
        files.add(file1);
        files.add(file2);
        for (String file : files) {
            rq.addWAL(server.getServerName(), slaveId, file);
        }
        DummyServer s1 = new DummyServer("dummyserver1.example.org");
        ReplicationPeers rp1 = ReplicationFactory.getReplicationPeers((ZKWatcher)s1.getZooKeeper(), (Configuration)s1.getConfiguration());
        rp1.init();
        ReplicationSourceManager replicationSourceManager = manager;
        replicationSourceManager.getClass();
        ReplicationSourceManager.NodeFailoverWorker w1 = new ReplicationSourceManager.NodeFailoverWorker(replicationSourceManager, server.getServerName());
        w1.run();
        Assert.assertEquals((long)1L, (long)manager.getWalsByIdRecoveredQueues().size());
        String id = "1-" + server.getServerName().getServerName();
        Assert.assertEquals(files, ((Map)manager.getWalsByIdRecoveredQueues().get(id)).get(group));
        manager.cleanOldLogs(file2, false, id, true);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{file2}), ((Map)manager.getWalsByIdRecoveredQueues().get(id)).get(group));
    }

    @Test
    public void testCleanupUnknownPeerZNode() throws Exception {
        DummyServer server = new DummyServer("hostname2.example.org");
        ReplicationQueueStorage rq = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)server.getZooKeeper(), (Configuration)server.getConfiguration());
        String group = "testgroup";
        rq.addWAL(server.getServerName(), "2", group + ".log1");
        rq.addWAL(server.getServerName(), "2", group + ".log2");
        ReplicationSourceManager replicationSourceManager = manager;
        replicationSourceManager.getClass();
        ReplicationSourceManager.NodeFailoverWorker w1 = new ReplicationSourceManager.NodeFailoverWorker(replicationSourceManager, server.getServerName());
        w1.run();
        for (String peer : manager.getAllQueues()) {
            Assert.assertTrue((boolean)peer.startsWith(slaveId));
        }
    }

    @Test
    public void testCompactionWALEdits() throws Exception {
        TableName tableName = TableName.valueOf((String)"testCompactionWALEdits");
        WALProtos.CompactionDescriptor compactionDescriptor = WALProtos.CompactionDescriptor.getDefaultInstance();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).build();
        WALEdit edit = WALEdit.createCompaction((RegionInfo)hri, (WALProtos.CompactionDescriptor)compactionDescriptor);
        ReplicationSourceWALActionListener.scopeWALEdits((WALKey)new WALKeyImpl(), (WALEdit)edit, (Configuration)conf);
    }

    @Test
    public void testBulkLoadWALEditsWithoutBulkLoadReplicationEnabled() throws Exception {
        TreeMap<byte[], Integer> scope = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        WALEdit logEdit = this.getBulkLoadWALEdit(scope);
        WALKeyImpl logKey = new WALKeyImpl(scope);
        ReplicationSourceWALActionListener.scopeWALEdits((WALKey)logKey, (WALEdit)logEdit, (Configuration)conf);
        Assert.assertNull((String)"No bulk load entries scope should be added if bulk load replication is disabled.", (Object)logKey.getReplicationScopes());
    }

    @Test
    public void testBulkLoadWALEdits() throws Exception {
        TreeMap<byte[], Integer> scope = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        WALEdit logEdit = this.getBulkLoadWALEdit(scope);
        WALKeyImpl logKey = new WALKeyImpl(scope);
        Configuration bulkLoadConf = HBaseConfiguration.create((Configuration)conf);
        bulkLoadConf.setBoolean("hbase.replication.bulkload.enabled", true);
        ReplicationSourceWALActionListener.scopeWALEdits((WALKey)logKey, (WALEdit)logEdit, (Configuration)bulkLoadConf);
        NavigableMap scopes = logKey.getReplicationScopes();
        Assert.assertTrue((String)"This family scope is set to global, should be part of replication key scopes.", (boolean)scopes.containsKey(f1));
        Assert.assertFalse((String)"This family scope is set to local, should not be part of replication key scopes", (boolean)scopes.containsKey(f2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerRemovalCleanup() throws Exception {
        String replicationSourceImplName = conf.get("replication.replicationsource.implementation");
        String peerId = "FakePeer";
        ReplicationPeerConfig peerConfig = new ReplicationPeerConfig().setClusterKey("localhost:" + utility.getZkCluster().getClientPort() + ":/hbase");
        try {
            DummyServer server = new DummyServer();
            ReplicationQueueStorage rq = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)server.getZooKeeper(), (Configuration)server.getConfiguration());
            conf.set("replication.replicationsource.implementation", FailInitializeDummyReplicationSource.class.getName());
            ReplicationPeers rp = manager.getReplicationPeers();
            this.addPeerAndWait("FakePeer", peerConfig, false);
            Assert.assertNull((Object)manager.getSource("FakePeer"));
            rq.addWAL(server.getServerName(), "FakePeer", "FakeFile");
            this.removePeerAndWait("FakePeer");
            Assert.assertFalse((boolean)rq.getAllQueues(server.getServerName()).contains("FakePeer"));
        }
        finally {
            conf.set("replication.replicationsource.implementation", replicationSourceImplName);
            this.removePeerAndWait("FakePeer");
        }
    }

    private static MetricsReplicationSourceSource getGlobalSource() throws Exception {
        ReplicationSourceInterface source = manager.getSource(slaveId);
        Field f = MetricsSource.class.getDeclaredField("globalSourceSource");
        f.setAccessible(true);
        return (MetricsReplicationSourceSource)f.get(source.getSourceMetrics());
    }

    private static long getSizeOfLatestPath() {
        if (utility.getMiniHBaseCluster() == null) {
            return 0L;
        }
        return utility.getMiniHBaseCluster().getRegionServerThreads().stream().map(JVMClusterUtil.RegionServerThread::getRegionServer).map(HRegionServer::getReplicationSourceService).map(r -> (Replication)r).map(Replication::getReplicationManager).mapToLong(ReplicationSourceManager::getSizeOfLatestPath).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemovePeerMetricsCleanup() throws Exception {
        String peerId = "DummyPeer";
        ReplicationPeerConfig peerConfig = new ReplicationPeerConfig().setClusterKey("localhost:" + utility.getZkCluster().getClientPort() + ":/hbase");
        try {
            MetricsReplicationSourceSource globalSource = TestReplicationSourceManager.getGlobalSource();
            int globalLogQueueSizeInitial = globalSource.getSizeOfLogQueue();
            long sizeOfLatestPath = TestReplicationSourceManager.getSizeOfLatestPath();
            this.addPeerAndWait("DummyPeer", peerConfig, true);
            Assert.assertEquals((long)(sizeOfLatestPath + (long)globalLogQueueSizeInitial), (long)globalSource.getSizeOfLogQueue());
            ReplicationSourceInterface source = manager.getSource("DummyPeer");
            Assert.assertNotNull((Object)source);
            int sizeOfSingleLogQueue = source.getSourceMetrics().getSizeOfLogQueue();
            source.enqueueLog(new Path("abc"));
            Assert.assertEquals((long)(1 + sizeOfSingleLogQueue), (long)source.getSourceMetrics().getSizeOfLogQueue());
            Assert.assertEquals((long)(source.getSourceMetrics().getSizeOfLogQueue() + globalLogQueueSizeInitial), (long)globalSource.getSizeOfLogQueue());
            this.removePeerAndWait("DummyPeer");
            Assert.assertEquals((long)globalLogQueueSizeInitial, (long)globalSource.getSizeOfLogQueue());
            this.addPeerAndWait("DummyPeer", peerConfig, true);
            source = manager.getSource("DummyPeer");
            Assert.assertNotNull((Object)source);
            Assert.assertEquals((long)(source.getSourceMetrics().getSizeOfLogQueue() + globalLogQueueSizeInitial), (long)globalSource.getSizeOfLogQueue());
        }
        finally {
            this.removePeerAndWait("DummyPeer");
        }
    }

    private void addPeerAndWait(String peerId, ReplicationPeerConfig peerConfig, boolean waitForSource) throws Exception {
        ReplicationPeers rp = manager.getReplicationPeers();
        rp.getPeerStorage().addPeer(peerId, peerConfig, true);
        try {
            manager.addPeer(peerId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestReplicationSourceManager.waitPeer(peerId, manager, waitForSource);
        if (managerOfCluster != null) {
            managerOfCluster.addPeer(peerId);
            TestReplicationSourceManager.waitPeer(peerId, managerOfCluster, waitForSource);
        }
    }

    private static void waitPeer(String peerId, ReplicationSourceManager manager, boolean waitForSource) {
        ReplicationPeers rp = manager.getReplicationPeers();
        Waiter.waitFor((Configuration)conf, (long)20000L, () -> {
            if (waitForSource) {
                ReplicationSourceInterface rs = manager.getSource(peerId);
                if (rs == null) {
                    return false;
                }
                if (rs instanceof ReplicationSourceDummy) {
                    return ((ReplicationSourceDummy)rs).isStartup();
                }
                return true;
            }
            return rp.getPeer(peerId) != null;
        });
    }

    private void removePeerAndWait(final String peerId) throws Exception {
        final ReplicationPeers rp = manager.getReplicationPeers();
        if (rp.getPeerStorage().listPeerIds().contains(peerId)) {
            rp.getPeerStorage().removePeer(peerId);
            try {
                manager.removePeer(peerId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Waiter.waitFor((Configuration)conf, (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List peers = rp.getPeerStorage().listPeerIds();
                return !manager.getAllQueues().contains(peerId) && rp.getPeer(peerId) == null && !peers.contains(peerId) && manager.getSource(peerId) == null;
            }
        });
    }

    private WALEdit getBulkLoadWALEdit(NavigableMap<byte[], Integer> scope) {
        HashMap storeFiles = new HashMap(1);
        HashMap<String, Long> storeFilesSize = new HashMap<String, Long>(1);
        ArrayList<Path> p = new ArrayList<Path>(1);
        Path hfilePath1 = new Path(Bytes.toString((byte[])f1));
        p.add(hfilePath1);
        try {
            storeFilesSize.put(hfilePath1.getName(), fs.getFileStatus(hfilePath1).getLen());
        }
        catch (IOException e) {
            LOG.debug("Failed to calculate the size of hfile " + hfilePath1);
            storeFilesSize.put(hfilePath1.getName(), 0L);
        }
        storeFiles.put(f1, p);
        scope.put(f1, 1);
        p = new ArrayList(1);
        Path hfilePath2 = new Path(Bytes.toString((byte[])f2));
        p.add(hfilePath2);
        try {
            storeFilesSize.put(hfilePath2.getName(), fs.getFileStatus(hfilePath2).getLen());
        }
        catch (IOException e) {
            LOG.debug("Failed to calculate the size of hfile " + hfilePath2);
            storeFilesSize.put(hfilePath2.getName(), 0L);
        }
        storeFiles.put(f2, p);
        WALProtos.BulkLoadDescriptor desc = ProtobufUtil.toBulkLoadDescriptor((TableName)hri.getTable(), (ByteString)UnsafeByteOperations.unsafeWrap((byte[])hri.getEncodedNameAsBytes()), storeFiles, storeFilesSize, (long)1L);
        WALEdit logEdit = WALEdit.createBulkLoadEvent((RegionInfo)hri, (WALProtos.BulkLoadDescriptor)desc);
        return logEdit;
    }

    static {
        r1 = Bytes.toBytes((String)"r1");
        r2 = Bytes.toBytes((String)"r2");
        f1 = Bytes.toBytes((String)"f1");
        f2 = Bytes.toBytes((String)"f2");
        test = TableName.valueOf((String)"test");
        files = new ArrayList<String>();
    }

    static class DummyServer
    implements Server {
        String hostname;

        DummyServer() {
            this.hostname = "hostname.example.org";
        }

        DummyServer(String hostname) {
            this.hostname = hostname;
        }

        public Configuration getConfiguration() {
            return conf;
        }

        public ZKWatcher getZooKeeper() {
            return zkw;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.hostname, (int)1234, (long)1L);
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }

    static class FailInitializeDummyReplicationSource
    extends ReplicationSourceDummy {
        FailInitializeDummyReplicationSource() {
        }

        @Override
        public void init(Configuration conf, FileSystem fs, ReplicationSourceManager manager, ReplicationQueueStorage rq, ReplicationPeer rp, Server server, String peerClusterId, UUID clusterId, WALFileLengthProvider walFileLengthProvider, MetricsSource metrics) throws IOException {
            throw new IOException("Failing deliberately");
        }
    }

    static class DummyNodeFailoverWorker
    extends Thread {
        private Map<String, Set<String>> logZnodesMap;
        Server server;
        private ServerName deadRS;
        ReplicationQueueStorage rq;

        public DummyNodeFailoverWorker(ServerName deadRS, Server s) throws Exception {
            this.deadRS = deadRS;
            this.server = s;
            this.rq = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)this.server.getZooKeeper(), (Configuration)this.server.getConfiguration());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.logZnodesMap = new HashMap<String, Set<String>>();
                List queues = this.rq.getAllQueues(this.deadRS);
                for (String queue : queues) {
                    Pair pair = this.rq.claimQueue(this.deadRS, queue, this.server.getServerName());
                    if (pair == null) continue;
                    this.logZnodesMap.put((String)pair.getFirst(), (Set<String>)pair.getSecond());
                }
                this.server.abort("Done with testing", null);
            }
            catch (Exception e) {
                LOG.error("Got exception while running NodeFailoverWorker", (Throwable)e);
            }
            finally {
                latch.countDown();
            }
        }

        private int isLogZnodesMapPopulated() {
            Collection<Set<String>> sets = this.logZnodesMap.values();
            if (sets.size() > 1) {
                throw new RuntimeException("unexpected size of logZnodesMap: " + sets.size());
            }
            if (sets.size() == 1) {
                Set<String> s = sets.iterator().next();
                for (String file : files) {
                    if (s.contains(file)) continue;
                    return 0;
                }
                return 1;
            }
            return 0;
        }
    }
}

